/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.calc;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.calc.CalcCheckTask;
import kd.macc.cad.algox.calc.CalcTask;
import kd.macc.cad.algox.calc.ProgressTask;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.common.thread.TaskType;
import kd.macc.cad.common.thread.ThreadHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class TaskProgresssPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(TaskProgresssPlugin.class);
    private static final String CALC_PROGRESSBAR = "progressbar";
    private static final String CANCEL = "cancel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(CALC_PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
        Button cancelBtn = (Button)this.getView().getControl(CANCEL);
        cancelBtn.addClickListener((ClickListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (this.getView().getPageCache().get("CloseComfirm") == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5173\u95ed\u754c\u9762\u540e\u9700\u8981\u5728\u5377\u7b97\u62a5\u544a\u4e2d\u67e5\u8be2\u7ed3\u679c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaskProgresssPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("sca_calctaskrunning-close"));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("sca_calctaskrunning-close".equals(callBackId)) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes.getValue() == result.getValue()) {
                this.getView().getPageCache().put("CloseComfirm", "Yes");
                this.getView().close();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String paraJS = this.getView().getFormShowParameter().getCustomParam("calcParam").toString();
        StandCostCalcParam standCostCalcParam = this.buildCalcParam(paraJS);
        this.start(standCostCalcParam);
    }

    public void onProgress(ProgressEvent paramProgressEvent) {
        String startProgress = this.getPageCache().get("isStdCalcProgressStart");
        if (startProgress == null) {
            return;
        }
        if (StringUtils.isBlank((String)startProgress)) {
            paramProgressEvent.setProgress(0);
            paramProgressEvent.setText(ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"TaskProgresssPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        String text = ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d ...", (String)"TaskProgresssPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        int progress = this.getProgressPresent();
        if (progress >= 100) {
            text = ResManager.loadKDString((String)"\u5b8c\u6210", (String)"TaskProgresssPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            this.getView().getPageCache().put("CloseComfirm", "Yes");
            this.getView().close();
            String checkTaskIdStr = this.getPageCache().get("checkTaskId");
            Long checkTaskId = StringUtils.isEmpty((String)checkTaskIdStr) ? 0L : Long.parseLong(checkTaskIdStr);
            int[] failAndWarnCheckCount = this.getFailAndWarnCheckCount(checkTaskId);
            if ("2".equals(this.getPageCache().get("checkType"))) {
                BillShowParameter bill = new BillShowParameter();
                bill.setFormId("cad_calctaskrecord");
                OpenStyle style = new OpenStyle();
                style.setShowType(ShowType.MainNewTabPage);
                bill.setOpenStyle(style);
                bill.setStatus(OperationStatus.VIEW);
                bill.setPkId((Object)checkTaskId);
                bill.setHasRight(true);
                bill.setCaption(ResManager.loadKDString((String)"\u5377\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"TaskProgresssPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]).concat(ResManager.loadKDString((String)"\u62a5\u544a", (String)"TaskProgresssPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0])));
                this.getView().showForm((FormShowParameter)bill);
            } else {
                String costTypeIdStr = this.getPageCache().get("costTypeId");
                Long costTypeId = StringUtils.isEmpty((String)costTypeIdStr) ? 0L : Long.parseLong(costTypeIdStr);
                QFilter costtype = new QFilter("costtype.id", "=", (Object)costTypeId);
                String taskIdStr = this.getPageCache().get("taskId");
                Long taskId = StringUtils.isEmpty((String)taskIdStr) ? 0L : Long.parseLong(taskIdStr);
                costtype.and(new QFilter("task", "=", (Object)taskId));
                long successCount = 0L;
                long failMatCount = 0L;
                QFilter filter = new QFilter("id", "=", (Object)taskId);
                DynamicObject record = null;
                int count = 0;
                while (((record = QueryServiceHelper.queryOne((String)"cad_calctaskrecord", (String)"nextpagepara", (QFilter[])new QFilter[]{filter})) == null || CadEmptyUtils.isEmpty((String)record.getString("nextpagepara"))) && ++count <= 10) {
                }
                if (record != null && !CadEmptyUtils.isEmpty((String)record.getString("nextpagepara"))) {
                    String nextpagepara = record.getString("nextpagepara");
                    JSONObject jsonObject = JSONObject.fromObject((Object)nextpagepara);
                    successCount = jsonObject.getLong("successCount");
                    failMatCount = jsonObject.getLong("failMatCount");
                }
                FormShowParameter lsp = new FormShowParameter();
                lsp.setFormId("cad_stdcalcresult");
                lsp.setCustomParam("successCount", (Object)successCount);
                lsp.setCustomParam("failCheckCount", (Object)failAndWarnCheckCount[0]);
                lsp.setCustomParam("remaindCheckCount", (Object)failAndWarnCheckCount[1]);
                lsp.setCustomParam("failMatCount", (Object)failMatCount);
                lsp.setCustomParam("taskId", (Object)this.getPageCache().get("taskId"));
                lsp.setCustomParam("checkTaskId", (Object)this.getPageCache().get("checkTaskId"));
                lsp.setCustomParam("matIds", (Object)this.getPageCache().get("matIds"));
                lsp.setCustomParam("costTypeId", (Object)this.getPageCache().get("costTypeId"));
                lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                lsp.setHasRight(true);
                this.getView().showForm(lsp);
            }
        }
        if (startProgress.equals("false")) {
            text = ResManager.loadKDString((String)"\u5df2\u53d6\u6d88\u6267\u884c", (String)"TaskProgresssPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        }
        paramProgressEvent.setProgress(progress);
        paramProgressEvent.setText(text);
    }

    private long getCalcMatCount(String taskIdStr, String costTypeStr) {
        try {
            Long taskId = Long.valueOf(taskIdStr);
            QFilter taskIdFilter = new QFilter("calctask", "=", (Object)taskId);
            Object[] matExpandRecords = BusinessDataServiceHelper.load((String)"cad_calcmatexpandrecord", (String)"successmatexpandcount", (QFilter[])new QFilter[]{taskIdFilter});
            if (!CadEmptyUtils.isEmpty((Object[])matExpandRecords)) {
                Object matExpandRecord = matExpandRecords[0];
                return matExpandRecord.getLong("successmatexpandcount");
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u6210\u672c\u7c7b\u578b%s\u83b7\u53d6\u5377\u7b97\u7269\u6599\u603b\u6570\u91cf\u9519\u8bef", costTypeStr), (Throwable)e);
        }
        return 0L;
    }

    private int[] getFailAndWarnCheckCount(Long taskId) {
        int[] failAndWarnCheckCount = new int[]{0, 0};
        QFilter taskFilter = new QFilter("calctaskrecord.id", "=", (Object)taskId);
        QFilter resultFilter = new QFilter("checkresult", "in", (Object)new String[]{"1", "2"});
        Object[] checkResults = BusinessDataServiceHelper.load((String)"cad_calccheckresult", (String)"id,checkresult", (QFilter[])new QFilter[]{taskFilter, resultFilter});
        if (CadEmptyUtils.isEmpty((Object[])checkResults)) {
            return failAndWarnCheckCount;
        }
        int failCount = 0;
        int warnCount = 0;
        for (Object checkResult : checkResults) {
            String cs = checkResult.getString("checkresult");
            if ("1".equals(cs)) {
                ++warnCount;
                continue;
            }
            if (!"2".equals(cs)) continue;
            ++failCount;
        }
        failAndWarnCheckCount[0] = failCount;
        failAndWarnCheckCount[1] = warnCount;
        return failAndWarnCheckCount;
    }

    private void start(StandCostCalcParam standCostCalcParam) {
        Long costtypeId = standCostCalcParam.getCostTypeId();
        StdCalculateHelper.createReport((StandCostCalcParam)standCostCalcParam, (String)ResManager.loadKDString((String)"\u5377\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"TaskProgresssPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5377\u7b97", (String)"TaskProgresssPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        this.getPageCache().put("taskId", String.valueOf(standCostCalcParam.getTaskId()));
        this.getPageCache().put("checkTaskId", String.valueOf(standCostCalcParam.getCheckTaskId()));
        this.getPageCache().put("costTypeId", costtypeId.toString());
        this.getPageCache().put("checkType", String.valueOf(standCostCalcParam.getCheckType()));
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(CALC_PROGRESSBAR);
        progressBar.setPercent(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c ...", (String)"TaskProgresssPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        progressBar.start();
        this.getPageCache().put("isStdCalcProgressStart", "true");
        this.getPageCache().put("stdCalc_progress", "0");
        ProgressTask progressTask = new ProgressTask(RequestContext.get(), this.getView().getPageId(), standCostCalcParam);
        ThreadHelper.execute((Runnable)progressTask, (TaskType)TaskType.CAD_PROCESS);
        if (standCostCalcParam.getCheckType() == 1) {
            CalcTask calcTask = new CalcTask(RequestContext.get(), this.getView().getPageId(), standCostCalcParam);
            ThreadHelper.execute((Runnable)calcTask, (TaskType)TaskType.CAD_PROCESS);
        } else if (standCostCalcParam.getCheckType() == 2) {
            standCostCalcParam.setTaskId(standCostCalcParam.getCheckTaskId());
            CalcCheckTask checkTask = new CalcCheckTask(RequestContext.get(), this.getView().getPageId(), standCostCalcParam);
            ThreadHelper.execute((Runnable)checkTask, (TaskType)TaskType.CAD_PROCESS);
        }
    }

    private int getProgressPresent() {
        int progress = 0;
        String cacheProgress = this.getPageCache().get("stdCalc_progress");
        if (!StringUtils.isEmpty((String)cacheProgress)) {
            progress = Integer.parseInt(cacheProgress);
        }
        return progress;
    }

    private StandCostCalcParam buildCalcParam(String cparaJS) {
        JSONObject jsonObject = JSONObject.fromObject((Object)cparaJS);
        StandCostCalcParam standCostCalcParam = (StandCostCalcParam)SerializationUtils.fromJsonString((String)cparaJS, StandCostCalcParam.class);
        if (jsonObject.containsKey((Object)"matids")) {
            standCostCalcParam.setMatids(this.getMaterialGroupIds(jsonObject.getJSONArray("matids")));
        }
        return standCostCalcParam;
    }

    private List<Long> getMaterialGroupIds(JSONArray idArray) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        if (idArray == null || idArray.size() < 1) {
            return ids;
        }
        for (int index = 0; index < idArray.size(); ++index) {
            ids.add(idArray.getLong(index));
        }
        return ids;
    }
}

