/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.calc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.IgnoreOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.id.ID;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.macc.cad.algox.calc.helper.StdCalcEliminateVirtualMatHelper;
import kd.macc.cad.algox.function.DealStdCalcResultFunction;
import kd.macc.cad.algox.function.SaveTrackStdCalcResultFunction;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadUtils;

public class TrackStdcalcResultList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(TrackStdcalcResultList.class);

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        switch (e.getItemKey()) {
            case "trackresultupdate": {
                Object[] primaryKeyValues = rows.getPrimaryKeyValues();
                if (primaryKeyValues.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TrackStdcalcResultList_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.updateData(primaryKeyValues);
                break;
            }
        }
    }

    private void updateData(Object[] primaryKeyValues) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (Object primaryKeyValue : primaryKeyValues) {
            ids.add(Long.parseLong(String.valueOf(primaryKeyValue)));
        }
        Set<Long> costTypes = this.getCostTypes(ids);
        if (costTypes.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6570\u636e\u5b58\u5728\u591a\u4e2a\u6210\u672c\u7c7b\u578b\u7684\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5177\u4f53\u6210\u672c\u7c7b\u578b\u7684\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"TrackStdcalcResultList_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ids.size() > 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u9009100\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TrackStdcalcResultList_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("id", "in", (Object)primaryKeyValues);
        DynamicObjectCollection res = QueryServiceHelper.query((String)"cad_trackstdcalcresult", (String)"id,calcdate", (QFilter[])new QFilter[]{filter});
        HashMap<Date, List> dateIdMap = new HashMap<Date, List>(16);
        for (DynamicObject re : res) {
            dateIdMap.computeIfAbsent(re.getDate("calcdate"), p -> new ArrayList()).add(re.getLong("id"));
        }
        try (TXHandle tx = TX.required();){
            int priceprecision = this.getPriceprecision(ids);
            for (Map.Entry entry : dateIdMap.entrySet()) {
                Date date = (Date)entry.getKey();
                List dateIds = (List)entry.getValue();
                this.dealElimiVirtualMatResultForTrackCalc(new ArrayList<Long>(costTypes).get(0), dateIds, priceprecision, date);
                this.dealEffectResult(dateIds, priceprecision);
                this.updateDealData(dateIds);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u5b8c\u6210", (String)"TrackStdcalcResultList_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u5931\u8d25", (String)"TrackStdcalcResultList_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            logger.error("\u865a\u62df\u4ef6\u7ed3\u679c\u5254\u9664-\u6570\u636e\u4fee\u590d\u5931\u8d25", (Throwable)e);
        }
    }

    private void updateDealData(List<Long> idSubList) {
        DynamicObject[] results;
        QFilter filter = new QFilter("id", "in", idSubList);
        for (DynamicObject result : results = BusinessDataServiceHelper.load((String)"cad_trackstdcalcresult", (String)"ispubmat", (QFilter[])new QFilter[]{filter})) {
            result.set("ispubmat", (Object)1);
        }
        SaveServiceHelper.update((DynamicObject[])results);
    }

    public void dealElimiVirtualMatResultForTrackCalc(Long costTypeId, List<Long> primaryKeyValues, int priceprecision, Date calcDate) {
        this.deleteVirtualResultEntry(primaryKeyValues, costTypeId, calcDate);
        DataSet stdCalcResultDataSet = this.getStdCalcResultDataSet(primaryKeyValues);
        JobSession session = AlgoX.createSession((String)"dealElimiVirtualMatResultForTrackCalc");
        DataSetX stdCalcResultDataSetX = session.fromInput((Input)new DataSetInput(stdCalcResultDataSet));
        DataSetX dataSetX = stdCalcResultDataSetX.reduceGroup((GroupReduceFunction)new DealStdCalcResultFunction(stdCalcResultDataSetX.getRowMeta()));
        dataSetX = dataSetX.groupBy(new String[]{"pid", "id", "keycol", "materialattr", "entrymaterial1", "entrymatvers1", "entryauxproperty1", "entryconfiguredcode1", "entrytracknumber1", "entryproject1", "entrylot1", "entrykeycol1", "entrykeycolid1", "entrybomid1", "entryprocessrouteid1", "entryrootnode1", "entrytreepath1", "entryisleaf1", "entryismaindata1", "entryiscalccurlevel1", "entrylevel1", "entrymaterialattr1", "entrystdqty1", "resource1", "element1", "subelement1", "submaterial1", "submatvers1", "subauxproperty1", "sublot1", "subconfiguredcode1", "subtracknumber1", "subproject1", "subkeycol1", "subkeycolid1", "operation1", "operationdesc1", "workcenter1", "activity1", "calcbasis1", "resourcetype1", "datatype1", "pricerule1", "priceid1", "manuorg1", "processseq1", "operationno1"}).sum("qty1").sum("price1").sum("stdprice1");
        dataSetX = dataSetX.reduceGroup((GroupReduceFunction)new SaveTrackStdCalcResultFunction(dataSetX.getRowMeta(), costTypeId, priceprecision, calcDate));
        dataSetX.output((Output)new IgnoreOutput());
        session.commit(2, TimeUnit.HOURS);
    }

    private void deleteVirtualResultEntry(List<Long> primaryKeyValues, Long costTypeId, Date calcDate) {
        QFilter filter = new QFilter("id", "in", primaryKeyValues);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"deleteVirtualResultEntry", (String)"cad_trackstdcalcresult", (String)"entryentity.id entryid,entryentity.subentryentity.id subentryid", (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> entryIds = new HashSet<Long>(10);
        HashSet<Long> subEntryIds = new HashSet<Long>(10);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            entryIds.add(row.getLong("entryid"));
            subEntryIds.add(row.getLong("subentryid"));
        }
        if (!CadEmptyUtils.isEmpty(subEntryIds)) {
            try (TXHandle tx = TX.requiresNew();
                 ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_cad_trackcalcresut", (HintCondition[])new HintCondition[]{new HintCondition("fcosttypeid", "=", (Object)costTypeId), new HintCondition("fcalcdate", "=", (Object)calcDate)});){
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_cad_trackcalcentry where fentryid in " + CadUtils.setToSql(entryIds)));
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_cad_trackcalcsubentry where fdetailid in " + CadUtils.setToSql(subEntryIds)));
            }
            catch (Exception e) {
                logger.error("\u8ddf\u8e2a\u53f7\u7ed3\u679c\u8868\u5904\u7406\uff0c\u5220\u9664\u5206\u5f55\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private DataSet getStdCalcResultDataSet(List<Long> primaryKeyValues) {
        QFilter filter = new QFilter("id", "in", primaryKeyValues);
        return QueryServiceHelper.queryDataSet((String)"getStdCalcResultDataSet1", (String)"cad_trackstdcalcresult", (String)StdCalcEliminateVirtualMatHelper.getCalcTrackResultFields(), (QFilter[])new QFilter[]{filter}, null);
    }

    private int getPriceprecision(List<Long> primaryKeyValues) {
        QFilter filter = new QFilter("id", "in", primaryKeyValues);
        DynamicObject res = QueryServiceHelper.queryOne((String)"cad_trackstdcalcresult", (String)"costtype.currency.priceprecision priceprecision", (QFilter[])new QFilter[]{filter});
        if (res == null) {
            return 10;
        }
        return res.getInt("priceprecision");
    }

    private Set<Long> getCostTypes(List<Long> primaryKeyValues) {
        QFilter filter = new QFilter("id", "in", primaryKeyValues);
        DynamicObjectCollection res = QueryServiceHelper.query((String)"cad_trackstdcalcresult", (String)"costtype", (QFilter[])new QFilter[]{filter});
        return DynamicObjectHelper.getIdSet((DynamicObjectCollection)res, (String)"costtype");
    }

    private void dealEffectResult(List<Long> primaryKeyValues, int priceprecision) {
        QFilter filter = new QFilter("id", "in", primaryKeyValues);
        filter.and(new QFilter("effectdate", "is not null", null));
        filter.and(new QFilter("entryentity.entrylevel", "=", (Object)0));
        filter.and(new QFilter("entryentity.subentryentity.datatype", "=", (Object)"4"));
        String selectFields = "costtype,treepath,keycol,effectdate,expdate,entryentity.subentryentity.resource resource,entryentity.subentryentity.element element,entryentity.subentryentity.subelement subelement,entryentity.subentryentity.qty qty,entryentity.subentryentity.price price,entryentity.subentryentity.stdprice stdprice,entryentity.subentryentity.submaterial submaterial,entryentity.subentryentity.submatvers submatvers,entryentity.subentryentity.subauxproperty subauxproperty,entryentity.subentryentity.sublot sublot,entryentity.subentryentity.subconfiguredcode subconfiguredcode,entryentity.subentryentity.subtracknumber subtracknumber,entryentity.subentryentity.subproject subproject,entryentity.subentryentity.subkeycol subkeycol,entryentity.subentryentity.subkeycolid subkeycolid,entryentity.subentryentity.activity activity,entryentity.subentryentity.datatype datatype,entryentity.subentryentity.calcbasis calcbasis";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"dealEffectResult", (String)"cad_trackstdcalcresult", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        dataSet = dataSet.groupBy(new String[]{"costtype", "treepath", "keycol", "effectdate", "expdate", "resource", "element", "subelement", "submaterial", "submatvers", "subauxproperty", "sublot", "subconfiguredcode", "subtracknumber", "subproject", "subkeycol", "subkeycolid", "activity", "datatype", "calcbasis"}).sum("qty").sum("stdprice").finish();
        HashMap<Object, BigDecimal> matKeycolAmountMap = new HashMap<Object, BigDecimal>(16);
        HashMap<String, List<String>> matKeycolSubEntryFieldMap = new HashMap<String, List<String>>(16);
        HashSet<String> keycols = new HashSet<String>(10);
        Long costTypeId = 0L;
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (row == null) continue;
            if (CadEmptyUtils.isEmpty((Long)costTypeId)) {
                costTypeId = row.getLong("costtype");
            }
            String treepath = row.getString("treepath");
            String keycol = row.getString("keycol");
            String effectdate = row.getString("effectdate");
            String expdate = row.getString("expdate");
            String key = treepath + "@" + keycol + "@" + effectdate + "@" + expdate;
            String resource = row.getString("resource");
            String element = row.getString("element");
            String subelement = row.getString("subelement");
            String qty = row.getString("qty");
            String stdprice = row.getString("stdprice");
            String submaterial = row.getString("submaterial");
            String submatvers = row.getString("submatvers");
            String subauxproperty = row.getString("subauxproperty");
            String sublot = row.getString("sublot");
            String subconfiguredcode = row.getString("subconfiguredcode");
            String subtracknumber = row.getString("subtracknumber");
            String subproject = row.getString("subproject");
            String subkeycol = row.getString("subkeycol");
            String subkeycolid = row.getString("subkeycolid");
            String activity = row.getString("activity");
            String datatype = row.getString("datatype");
            String calcbasis = row.getString("calcbasis");
            String value = resource + "@" + element + "@" + subelement + "@" + qty + "@" + stdprice + "@" + submaterial + "@" + submatvers + "@" + subauxproperty + "@" + sublot + "@" + subconfiguredcode + "@" + subtracknumber + "@" + subproject + "@" + subkeycol + "@" + subkeycolid + "@" + activity + "@" + datatype + "@" + calcbasis;
            matKeycolSubEntryFieldMap.computeIfAbsent(key, p -> new ArrayList()).add(value);
            if (matKeycolAmountMap.containsKey(key)) {
                BigDecimal oldPrice = (BigDecimal)matKeycolAmountMap.get(key);
                BigDecimal newPrice = oldPrice.add(row.getBigDecimal("stdprice"));
                matKeycolAmountMap.put(key, newPrice);
            } else {
                matKeycolAmountMap.put(key, row.getBigDecimal("stdprice"));
            }
            keycols.add(keycol);
        }
        if (CadEmptyUtils.isEmpty(matKeycolSubEntryFieldMap)) {
            logger.info("matKeycolSubEntryFieldMap\u4e3a\u7a7a\uff0c\u4e0d\u5904\u7406\u751f\u6548\u7ed3\u679c\u8868");
            return;
        }
        List hsCostTypes = CostTypeHelper.getHsCostByMn((Long)costTypeId);
        QFilter qFilter = new QFilter("costtype", "in", (Object)hsCostTypes);
        qFilter.and(new QFilter("keycol", "in", keycols));
        qFilter.and(new QFilter("entryentity.datatype", "=", (Object)"4"));
        DynamicObjectCollection effectResults = QueryServiceHelper.query((String)"cad_calceffectiveresult", (String)"id,costtype,treepath,keycol,effectdate,expdate,entryentity.id entryid,entryentity.stdprice stdprice", (QFilter[])new QFilter[]{qFilter});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)effectResults)) {
            String isUpdate = CadBgParamUtils.getCadBgParamForString((String)"nodirecteffresultupdate", (String)"0");
            if ("1".equals(isUpdate)) {
                logger.info("\u6ca1\u6709\u76f4\u63a5\u4e0b\u7ea7\u7684\u751f\u6548\u7ed3\u679c\u8868\u6570\u636e\u5904\u7406\u3002");
                this.dealNoDirectEffResult(hsCostTypes, keycols, matKeycolSubEntryFieldMap, priceprecision);
            }
            logger.info("effectResults\u4e3a\u7a7a\uff0c\u4e0d\u5904\u7406\u751f\u6548\u7ed3\u679c\u8868");
            return;
        }
        HashMap<String, BigDecimal> effMatKeycolAmountMap = new HashMap<String, BigDecimal>(16);
        HashSet<Long> entryIds = new HashSet<Long>(10);
        for (Object effectResult : effectResults) {
            String treepath = effectResult.getString("treepath");
            String keycol = effectResult.getString("keycol");
            String effectdate = effectResult.getString("effectdate");
            String expdate = effectResult.getString("expdate");
            String key = treepath + "@" + keycol + "@" + effectdate + "@" + expdate;
            if (!matKeycolSubEntryFieldMap.containsKey(key)) continue;
            if (effMatKeycolAmountMap.containsKey(key)) {
                BigDecimal oldPrice = (BigDecimal)effMatKeycolAmountMap.get(key);
                BigDecimal newPrice = oldPrice.add(effectResult.getBigDecimal("stdprice"));
                effMatKeycolAmountMap.put(key, newPrice);
                continue;
            }
            effMatKeycolAmountMap.put(key, effectResult.getBigDecimal("stdprice"));
        }
        HashMap<String, Long> effMatKeycolIdMap = new HashMap<String, Long>(16);
        for (DynamicObject effectResult : effectResults) {
            String treepath = effectResult.getString("treepath");
            String keycol = effectResult.getString("keycol");
            String effectdate = effectResult.getString("effectdate");
            String expdate = effectResult.getString("expdate");
            String key = treepath + "@" + keycol + "@" + effectdate + "@" + expdate;
            if (!matKeycolSubEntryFieldMap.containsKey(key)) {
                logger.info("matKeycolSubEntryFieldMap\u4e0d\u5305\u542bkey\uff1a{}\uff0c\u4e0d\u5904\u7406\u751f\u6548\u7ed3\u679c\u8868", (Object)key);
                continue;
            }
            if (CadEmptyUtils.isEmpty((List)((List)matKeycolSubEntryFieldMap.get(key)))) {
                logger.info("matKeycolSubEntryFieldMap\u7684key\uff1a{}\uff0c\u5bf9\u5e94\u7684value\u4e3a\u7a7a\uff0c\u4e0d\u5904\u7406\u751f\u6548\u7ed3\u679c\u8868", (Object)key);
                continue;
            }
            BigDecimal price = (BigDecimal)matKeycolAmountMap.get(key);
            BigDecimal effPrice = (BigDecimal)effMatKeycolAmountMap.get(key);
            if (effPrice.compareTo(price) != 0) {
                logger.info("treepath\uff1a{}\uff0ckeycol\uff1a{}\uff0ceffectdate\uff1a{}\uff0cexpdate\uff1a{}\uff0c\u8ddf\u8e2a\u53f7\u7ed3\u679c\u8868\u4e0e\u751f\u6548\u7ed3\u679c\u8868\u7684\u76f4\u63a5\u4e0b\u7ea7\u4e0d\u76f8\u7b49->effPrice:{},price:{}\uff0c\u4e0d\u5904\u7406\u751f\u6548\u7ed3\u679c\u8868", new Object[]{treepath, keycol, effectdate, expdate, effPrice, price});
                continue;
            }
            entryIds.add(effectResult.getLong("entryid"));
            if (effMatKeycolIdMap.containsKey(key)) continue;
            effMatKeycolIdMap.put(key, effectResult.getLong("id"));
            logger.info("effMatKeycolIdMap--key:{},value:{}", (Object)key, (Object)effectResult.getLong("id"));
        }
        try (TXHandle tx = TX.requiresNew();){
            this.deleteEffectResultEntry(entryIds);
            this.insertEffectResultEntry(matKeycolSubEntryFieldMap, effMatKeycolIdMap, priceprecision);
        }
        catch (Exception e) {
            logger.error("\u751f\u6548\u7ed3\u679c\u8868\u6570\u636e\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
    }

    private void deleteEffectResultEntry(Set<Long> entryIds) {
        if (CadEmptyUtils.isEmpty(entryIds)) {
            return;
        }
        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_cad_calceffectrsentry where fentryid in " + CadUtils.setToSql(entryIds)));
    }

    private void insertEffectResultEntry(Map<String, List<String>> matKeycolSubEntryFieldMap, Map<String, Long> effMatKeycolIdMap, int priceprecision) {
        int size = 0;
        logger.info("\u5904\u7406\u63d2\u5165\u6570\u636e\uff0c\u5171{}\u5f20\u5355\u636e\u3002", (Object)matKeycolSubEntryFieldMap.size());
        for (Map.Entry<String, List<String>> matKeycolSubEntryField : matKeycolSubEntryFieldMap.entrySet()) {
            List<String> value = matKeycolSubEntryField.getValue();
            size += value.size();
        }
        long[] effEntryIds = ID.genLongIds((int)size);
        ArrayList<Object[]> params = new ArrayList<Object[]>(200);
        int count = 0;
        int billCount = 1;
        for (Map.Entry<String, List<String>> matKeycolSubEntryField : matKeycolSubEntryFieldMap.entrySet()) {
            String key = matKeycolSubEntryField.getKey();
            List<String> resStr = matKeycolSubEntryField.getValue();
            logger.info("\u5904\u7406\u63d2\u5165\u6570\u636e\uff0c\u7b2c{}\u5f20\u5355\u636e\u5904\u7406\uff0c\u5171{}\u6761\u5206\u5f55\u3002key:{}", new Object[]{billCount, resStr.size(), key});
            for (String value : resStr) {
                String[] valueStr = StringUtils.split((String)value, (boolean)false, (char[])new char[]{'@'});
                Object[] object = new Object[20];
                object[0] = effMatKeycolIdMap.get(key);
                object[1] = effEntryIds[count];
                object[2] = Long.parseLong(valueStr[0]);
                object[3] = Long.parseLong(valueStr[1]);
                object[4] = Long.parseLong(valueStr[2]);
                object[5] = new BigDecimal(valueStr[3]);
                object[6] = new BigDecimal(valueStr[4]);
                object[7] = Long.parseLong(valueStr[5]);
                object[8] = Long.parseLong(valueStr[6]);
                object[9] = Long.parseLong(valueStr[7]);
                object[10] = valueStr[8];
                object[11] = Long.parseLong(valueStr[9]);
                object[12] = Long.parseLong(valueStr[10]);
                object[13] = Long.parseLong(valueStr[11]);
                object[14] = valueStr[12];
                object[15] = Long.parseLong(valueStr[13]);
                object[16] = Long.parseLong(valueStr[14]);
                object[17] = valueStr[15];
                object[18] = valueStr[16];
                BigDecimal stdprice = new BigDecimal(valueStr[4]);
                BigDecimal qty = new BigDecimal(valueStr[3]);
                if (qty.compareTo(BigDecimal.ZERO) != 0) {
                    object[19] = stdprice.divide(qty, priceprecision, 4);
                }
                ++count;
                params.add(object);
                if (params.size() <= 5000) continue;
                String sql = "INSERT INTO t_cad_calceffectrsentry (fid, fentryid, fresourceid, felementid, fsubelementid, fqty, fstdprice, fsubmaterialid, fsubmatvers, fsubauxproperty, fsublot, fsubconfiguredcodeid, fsubtracknumberid, fsubprojectid, fsubkeycol, fsubkeycolid, factivityid, fdatatype, fcalcbasis, fprice) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                TrackStdcalcResultList.executeBatch(sql, params);
                logger.info("\u6570\u636e\u63d2\u5165\u5b8c\u6210\uff0c\u5171\u63d2\u5165{}\u5206\u5f55\u3002", (Object)params.size());
                params.clear();
            }
            ++billCount;
        }
        if (!params.isEmpty()) {
            String sql = "INSERT INTO t_cad_calceffectrsentry (fid, fentryid, fresourceid, felementid, fsubelementid, fqty, fstdprice, fsubmaterialid, fsubmatvers, fsubauxproperty, fsublot, fsubconfiguredcodeid, fsubtracknumberid, fsubprojectid, fsubkeycol, fsubkeycolid, factivityid, fdatatype, fcalcbasis, fprice) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)sql, params);
            logger.info("\u6570\u636e\u63d2\u5165\u5b8c\u6210\uff0c\u5171\u63d2\u5165{}\u5206\u5f55\u3002", (Object)params.size());
        }
    }

    private static void executeBatch(String sql, List<Object[]> params) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)sql, params);
    }

    private void dealNoDirectEffResult(List<Long> hsCostTypes, Set<String> keycols, Map<String, List<String>> matKeycolSubEntryFieldMap, int priceprecision) {
        QFilter qFilter = new QFilter("costtype", "in", hsCostTypes);
        qFilter.and(new QFilter("keycol", "in", keycols));
        DynamicObjectCollection effectResults = QueryServiceHelper.query((String)"cad_calceffectiveresult", (String)"id,costtype,treepath,keycol,effectdate,expdate", (QFilter[])new QFilter[]{qFilter});
        HashMap<String, Long> effMatKeycolIdMap = new HashMap<String, Long>(16);
        for (DynamicObject effectResult : effectResults) {
            String treepath = effectResult.getString("treepath");
            String keycol = effectResult.getString("keycol");
            String effectdate = effectResult.getString("effectdate");
            String expdate = effectResult.getString("expdate");
            String key = treepath + "@" + keycol + "@" + effectdate + "@" + expdate;
            if (!matKeycolSubEntryFieldMap.containsKey(key)) {
                logger.info("matKeycolSubEntryFieldMap\u4e0d\u5305\u542bkey\uff1a{}\uff0c\u4e0d\u5904\u7406\u751f\u6548\u7ed3\u679c\u8868", (Object)key);
                continue;
            }
            if (CadEmptyUtils.isEmpty(matKeycolSubEntryFieldMap.get(key))) {
                logger.info("matKeycolSubEntryFieldMap\u7684key\uff1a{}\uff0c\u5bf9\u5e94\u7684value\u4e3a\u7a7a\uff0c\u4e0d\u5904\u7406\u751f\u6548\u7ed3\u679c\u8868", (Object)key);
                continue;
            }
            if (effMatKeycolIdMap.containsKey(key)) continue;
            effMatKeycolIdMap.put(key, effectResult.getLong("id"));
            logger.info("effMatKeycolIdMap--key:{},value:{}", (Object)key, (Object)effectResult.getLong("id"));
        }
        try (TXHandle tx = TX.requiresNew();){
            this.insertEffectResultEntry(matKeycolSubEntryFieldMap, effMatKeycolIdMap, priceprecision);
        }
        catch (Exception e) {
            logger.error("\u751f\u6548\u7ed3\u679c\u8868\u6570\u636e\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
    }
}

