/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.common;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.utils.DateUtils;

public class CadTimelineCommonListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(CadTimelineCommonListPlugin.class);

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        Map<String, Date> dateMap = this.removeDateFilter(filters);
        boolean isCostType = this.isCostTypeMode(this.getCacheCostType());
        if (!isCostType) {
            this.setEffectDateFilter(filters, dateMap);
        }
    }

    private boolean isCostTypeMode(String costTypeId) {
        QFilter filter = QFilter.of((String)"type = '1' and id = ?", (Object[])new Object[]{Long.parseLong(costTypeId)});
        logger.info("\u6709\u6548\u671ffilter:{}", (Object)filter.toString());
        return QueryServiceHelper.exists((String)"cad_costtype", (QFilter[])new QFilter[]{filter});
    }

    private String getCacheCostType() {
        String id;
        String string = id = StringUtils.isNotEmpty((String)this.getPageCache().get("costtype")) ? this.getPageCache().get("costtype") : this.getPageCache().get("CostType");
        if (StringUtils.isEmpty((String)id)) {
            return "0";
        }
        return id;
    }

    protected Map<String, Date> removeDateFilter(List<QFilter> filters) {
        HashMap<String, Date> result = new HashMap<String, Date>(8);
        Iterator<QFilter> iter = filters.iterator();
        while (iter.hasNext()) {
            QFilter filter = iter.next();
            if (!"expdate".equals(filter.getProperty())) continue;
            Date startDate = (Date)filter.getValue();
            Date endDate = (Date)((QFilter.QFilterNest)filter.getNests(true).get(0)).getFilter().getValue();
            result.put("startDate", startDate);
            result.put("endDate", endDate);
            iter.remove();
        }
        return result;
    }

    protected void setEffectDateFilter(List<QFilter> filters, Map<String, Date> dateMap) {
        if (dateMap.isEmpty()) {
            return;
        }
        Date startDate = dateMap.get("startDate");
        Date endDate = DateUtils.getLastSecond((Date)dateMap.get("endDate"), (int)1);
        QFilter dateFilter1 = new QFilter("effectdate", "<", (Object)startDate).and(new QFilter("expdate", ">=", (Object)startDate));
        QFilter dateFilter2 = new QFilter("effectdate", "<=", (Object)startDate).and(new QFilter("expdate", ">", (Object)startDate));
        QFilter dateFilter3 = new QFilter("effectdate", ">=", (Object)startDate).and(new QFilter("effectdate", "<", (Object)endDate));
        QFilter dateFilter4 = new QFilter("effectdate", ">", (Object)startDate).and(new QFilter("effectdate", "<=", (Object)endDate));
        filters.add(dateFilter1.or(dateFilter2).or(dateFilter3).or(dateFilter4));
    }
}

