/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.common;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.macc.cad.common.dto.ProgressParamDto;
import kd.macc.cad.common.helper.ProgressHelper;

public class CommonProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String KEY_TOTAL = "total";
    private static final String KEY_COMPLETE = "complete";
    private static final String KEY_LBLOPCONTENT = "lblopcontent";
    private static final String KEY_EXPORTPANEL = "exportpanel";
    private static final String KEY_FLEXPANELAP_MESSAGE = "flexpanelap_message";
    private static final String KEY_LBLSUCCESS = "lblsuccess";
    private static final String KEY_LBLERROR = "lblerror";
    private static final String KEY_LBL_UNIT_TOTAL = "lbl_unit_total";
    private static final String KEY_LBL_UNIT_COMPLETE = "lbl_unit_complete";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
    }

    private String getProgressId() {
        FormShowParameter formParam = this.getView().getFormShowParameter();
        return (String)formParam.getCustomParam("progressId");
    }

    private void setOpContent(String opContent) {
        Label lblopcontent = (Label)this.getControl(KEY_LBLOPCONTENT);
        lblopcontent.setText(opContent);
    }

    private void setUnit(String unit) {
        Label lbl_unit_total = (Label)this.getControl(KEY_LBL_UNIT_TOTAL);
        lbl_unit_total.setText(unit);
        Label bl_unit_complete = (Label)this.getControl(KEY_LBL_UNIT_COMPLETE);
        bl_unit_complete.setText(unit);
    }

    private void close() {
        this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()).hideLoading();
        this.clearCache();
        if (this.hasCloseCallBack()) {
            this.getView().returnDataToParent((Object)"success");
        }
        this.getView().close();
    }

    private void success(ProgressParamDto paramDto, ProgressEvent event) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_EXPORTPANEL, KEY_LBLERROR});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_FLEXPANELAP_MESSAGE, KEY_LBLSUCCESS});
        Label lblSuccess = (Label)this.getControl(KEY_LBLSUCCESS);
        if (StringUtils.isEmpty((CharSequence)paramDto.getSuccess())) {
            lblSuccess.setText("success");
        } else {
            lblSuccess.setText(paramDto.getSuccess());
        }
        if (paramDto.getDurationTimes() == null) {
            event.setProgress(100);
            this.clearCache();
            this.getView().getParentView().hideLoading();
        } else {
            paramDto.setDurationTimes(Integer.valueOf(paramDto.getDurationTimes() - 1));
            if (paramDto.getDurationTimes() < 0) {
                paramDto.setColseFlag(true);
            }
        }
    }

    private void error(String sError, ProgressEvent event) {
        this.getView().getParentView().hideLoading();
        this.clearCache();
        if (this.hasCloseCallBack()) {
            this.getView().returnDataToParent((Object)sError);
            this.getView().close();
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_EXPORTPANEL, KEY_LBLSUCCESS});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_FLEXPANELAP_MESSAGE, KEY_LBLERROR});
            Label lblError = (Label)this.getControl(KEY_LBLERROR);
            lblError.setText(sError);
            event.setProgress(100);
        }
    }

    private void progressDeal(ProgressParamDto paramDto, ProgressEvent event) {
        if (paramDto.getTotal() == null) {
            return;
        }
        if (paramDto.getComplete() == null) {
            paramDto.setComplete(Integer.valueOf(0));
        }
        Label totalLabel = (Label)this.getControl(KEY_TOTAL);
        totalLabel.setText(String.valueOf(paramDto.getTotal()));
        Label completeLabel = (Label)this.getControl(KEY_COMPLETE);
        completeLabel.setText(String.valueOf(paramDto.getComplete()));
        if (paramDto.getComplete() >= paramDto.getTotal()) {
            if (paramDto.getDurationTimes() == null) {
                event.setProgress(100);
                this.clearCache();
            } else {
                paramDto.setDurationTimes(Integer.valueOf(paramDto.getDurationTimes() - 1));
                if (paramDto.getDurationTimes() < 0) {
                    paramDto.setColseFlag(true);
                }
                event.setProgress(99);
                ProgressHelper.setProgressParam((String)this.getProgressId(), (ProgressParamDto)paramDto);
            }
            return;
        }
        int progress = paramDto.getComplete() * 100 / paramDto.getTotal();
        if (progress >= 100) {
            progress = 100;
        }
        event.setProgress(progress);
    }

    public void onProgress(ProgressEvent event) {
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)this.getProgressId());
        if (paramDto == null) {
            this.error(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8fdb\u5ea6\u4fe1\u606f\u3002", (String)"CommonProgressPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), event);
            return;
        }
        this.setOpContent(paramDto.getOpContent());
        if (StringUtils.isNotBlank((CharSequence)paramDto.getUnit())) {
            this.setUnit(paramDto.getUnit());
        }
        if (paramDto.getColseFlag()) {
            this.close();
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)paramDto.getSuccess())) {
            this.success(paramDto, event);
            ProgressHelper.setProgressParam((String)this.getProgressId(), (ProgressParamDto)paramDto);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)paramDto.getError())) {
            this.error(paramDto.getError(), event);
            return;
        }
        this.progressDeal(paramDto, event);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_FLEXPANELAP_MESSAGE, KEY_LBLERROR, KEY_LBLSUCCESS});
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.start();
    }

    private void clearCache() {
        ProgressHelper.clearProgressParam((String)this.getProgressId());
    }

    private boolean hasCloseCallBack() {
        return this.getView().getFormShowParameter().getCloseCallBack() != null;
    }
}

