/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.common.Util;

public class SyncCostTypePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String MATTYPE = "001";
    private static final String MATCOST = "002";
    private static final Log logger = LogFactory.getLog(SyncCostTypePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"submit"});
        BasedataEdit edit = (BasedataEdit)this.getControl("costtype");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        if ("submit".equals(btn.getKey())) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            List pks = (List)fsp.getCustomParam("costtype");
            String entity = (String)fsp.getCustomParam("entityname");
            String planRatePublish = (String)fsp.getCustomParam("plan_rate_publish");
            if (StringUtils.isEmpty((CharSequence)entity)) {
                return;
            }
            DynamicObject costtype = (DynamicObject)this.getModel().getValue("costtype");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u4e3a\u7a7a", (String)"SyncCostTypePlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            if (CadEmptyUtils.equals((String)"1", (String)planRatePublish)) {
                HashMap<String, String> returnParam = new HashMap<String, String>(16);
                returnParam.put("publishcosttype", costtype.getLong("id") + "");
                this.getView().returnDataToParent(returnParam);
                this.getView().close();
                return;
            }
            DynamicObject type = BusinessDataServiceHelper.loadSingle((Object)costtype.getLong("id"), (String)costtype.getDataEntityType().getName());
            if (this.sameCurrency(entity, pks, type.getLong("currency.id")).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u6210\u672c\u7c7b\u578b\u4e0e\u5f53\u524d\u6210\u672c\u7c7b\u578b\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SyncCostTypePlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            switch (entity) {
                case "cad_bomsetting": 
                case "cad_routersetting": 
                case "cad_purprices": 
                case "cad_outsourceprice": 
                case "cad_resourcerate": 
                case "cad_resourceout": {
                    this.save(entity, pks, type);
                    break;
                }
            }
        }
    }

    private void save(String entityName, List<Object> pks, DynamicObject costtype) {
        OperationResult result;
        DynamicObject[] soureObject = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        CloneUtils utils = new CloneUtils(true, true);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Date date = TimeServiceHelper.now();
        String[] numberArr = this.getNumber(entityName, soureObject.length);
        ArrayList<DynamicObject> targetObject = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < soureObject.length; ++i) {
            DynamicObject clone = (DynamicObject)utils.clone((IDataEntityBase)soureObject[i]);
            clone.set("id", (Object)DBServiceHelper.genGlobalLongId());
            clone.set("costtype", (Object)costtype);
            clone.set("creator", (Object)userId);
            clone.set("creator_id", (Object)userId);
            clone.set("createtime", (Object)date);
            if (entityName.equals("cad_bomsetting") || entityName.equals("cad_routersetting")) {
                if (numberArr != null) {
                    clone.set("number", (Object)numberArr[i]);
                }
                clone.set("status", (Object)"A");
                clone.set("auditor", null);
            } else {
                if (numberArr != null) {
                    clone.set("billno", (Object)numberArr[i]);
                }
                clone.set("billstatus", (Object)"A");
                clone.set("auditor", null);
            }
            if ("cad_purprices".equals(entityName)) {
                clone.set("pricerule", (Object)PriceRuleConstants.PUR_MANUALLY_ID);
                clone.set("datasrc", (Object)"manual");
            }
            if ("cad_resourcerate".equals(entityName)) {
                clone.set("pricerule", (Object)PriceRuleConstants.SELFRES_MANUALLY_ID);
                clone.set("datasrc", (Object)"manual");
            }
            if ("cad_resourceout".equals(entityName)) {
                clone.set("pricerule", (Object)PriceRuleConstants.OUTRES_MANUALLY_ID);
                clone.set("datasrc", (Object)"manual");
            }
            if ("cad_outsourceprice".equals(entityName)) {
                clone.set("pricerule", (Object)PriceRuleConstants.OUTPRI_MANUALLY_ID);
            }
            clone.set("remark", null);
            clone.set("modifier", null);
            clone.set("modifytime", null);
            clone.set("auditdate", null);
            targetObject.add(clone);
        }
        if ("cad_purprices".equals(entityName)) {
            this.updateRate(targetObject.toArray(new DynamicObject[0]), userId, date);
        }
        if ((result = OperationServiceHelper.executeOperate((String)"save", (String)entityName, (DynamicObject[])targetObject.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create())).isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"SyncCostTypePlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showOperationResult(result);
        }
    }

    private String[] getNumber(String entityName, int length) {
        if (length == 0) {
            return null;
        }
        String[] numberArr = CodeRuleServiceHelper.getBatchNumber((String)entityName, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)entityName), (String)"", (int)length);
        return numberArr;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        List pks;
        String planRatePublish;
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        qFilters.add(new QFilter("type", "=", (Object)"1"));
        FormShowParameter formShowParameter1 = this.getView().getFormShowParameter();
        Object currentcosttype = formShowParameter1.getCustomParam("currentcosttype");
        if (currentcosttype != null) {
            qFilters.add(new QFilter("id", "!=", (Object)((Long)currentcosttype)));
        }
        if (CadEmptyUtils.equals((String)"1", (String)(planRatePublish = (String)formShowParameter1.getCustomParam("plan_rate_publish")))) {
            pks = (List)formShowParameter1.getCustomParam("publish_costtype");
            qFilters.add(new QFilter("id", "in", (Object)pks));
        } else {
            pks = (List)formShowParameter1.getCustomParam("costtype");
            if (!CadEmptyUtils.isEmpty((List)pks)) {
                String entity = (String)formShowParameter1.getCustomParam("entityname");
                if (CadEmptyUtils.isEmpty((String)entity)) {
                    return;
                }
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entity, (String)"costtype,costtype.currency currency", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
                if (dynamicObject == null) {
                    return;
                }
                qFilters.add(new QFilter("id", "!=", (Object)dynamicObject.getLong("costtype")));
                qFilters.add(new QFilter("currency", "=", (Object)dynamicObject.getLong("currency")));
            }
        }
        QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
        if (baseDataFilter != null) {
            qFilters.add(baseDataFilter);
        }
    }

    private Boolean sameCurrency(String entityName, List<Object> pks, Long currencyId) {
        DynamicObject[] soureObject = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        HashSet<Long> costType = new HashSet<Long>(16);
        for (DynamicObject soure : soureObject) {
            costType.add(soure.getLong("costtype.id"));
        }
        QFilter qfCostType = new QFilter("id", "in", (Object)costType.toArray());
        DynamicObjectCollection dyCostType = QueryServiceHelper.query((String)"cad_costtype", (String)"currency.id", (QFilter[])new QFilter[]{qfCostType});
        for (DynamicObject cost : dyCostType) {
            if (currencyId.equals(cost.getLong("currency.id"))) continue;
            return true;
        }
        return false;
    }

    private void updateRate(DynamicObject[] newPurPrice, Long userId, Date date) {
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        if (costType == null) {
            return;
        }
        HashMap<Long, BigDecimal> idAndSum = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject pur : newPurPrice) {
            DynamicObjectCollection entry = pur.getDynamicObjectCollection("entryentity");
            BigDecimal sum = BigDecimal.ZERO;
            for (DynamicObject en : entry) {
                if (!MATTYPE.equals(en.getString("subelement.type"))) continue;
                sum = sum.add(en.getBigDecimal("price"));
            }
            idAndSum.put(pur.getLong("id"), sum);
        }
        Map<Long, BigDecimal> rateSet = Util.getRateInfo(Long.valueOf(costType.getPkValue().toString()));
        for (DynamicObject pur : newPurPrice) {
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal sum = (BigDecimal)idAndSum.get(pur.getLong("id"));
            DynamicObjectCollection entry = pur.getDynamicObjectCollection("entryentity");
            Iterator entrys = entry.iterator();
            while (entrys.hasNext()) {
                DynamicObject en = (DynamicObject)entrys.next();
                if (MATCOST.equals(en.getString("subelement.type"))) {
                    Boolean supmaterialCount = en.getBoolean("subelement.supmaterielcount");
                    Long subElement = en.getLong("subelement.id");
                    BigDecimal rate = rateSet.get(subElement);
                    if (supmaterialCount.booleanValue() && !BigDecimal.ZERO.equals(rate)) {
                        if (rate == null || "0E-10".equals(rate.toString())) {
                            entrys.remove();
                            continue;
                        }
                        en.set("price", (Object)sum.multiply(rate).divide(new BigDecimal(100)));
                        en.set("rate", (Object)rate);
                    } else if (rate != null && !"0E-10".equals(rate.toString())) {
                        entrys.remove();
                        continue;
                    }
                }
                amount = amount.add(en.getBigDecimal("price"));
            }
            pur.set("amount", (Object)amount);
        }
    }
}

