/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costdriver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEdit;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.formula.FormulaEngine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CadFormulaEdit
extends FormulaEdit {
    private static final String ROOT_NODE_ID = "1";
    private static final int EXPRESSION_MAX_LENGTH = 2000;

    public void click(EventObject evt) {
        try {
            Control ctlSource = (Control)evt.getSource();
            if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
                String expression = (String)this.getModel().getValue("fexpression");
                String tranExpr = (String)this.getModel().getValue("ftranexpr");
                boolean isFidMax = this.checkFidLength(expression);
                if (isFidMax || expression.length() > 2000 || tranExpr.length() > 2000) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u516c\u5f0f\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc72000\u3002", (String)"CadFormulaEdit_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            super.click(evt);
        }
        catch (Throwable e) {
            String errorMessage = e.getMessage();
            if (StringUtils.isBlank((CharSequence)errorMessage)) {
                errorMessage = ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u5931\u8d25", (String)"CadFormulaEdit_1", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            }
            this.getView().showErrorNotification(errorMessage);
            return;
        }
    }

    private boolean checkFidLength(String expression) {
        if (StringUtils.isNotEmpty((CharSequence)expression)) {
            List<String> numbers = this.getNumbers(expression);
            QFilter numberFilter = new QFilter("number", "in", numbers);
            DynamicObjectCollection costDriverCollection = QueryServiceHelper.query((String)"cad_costdriver", (String)"id,number", (QFilter[])new QFilter[]{numberFilter});
            HashMap<String, String> driverNumFidMap = new HashMap<String, String>();
            for (DynamicObject driver : costDriverCollection) {
                driverNumFidMap.put(driver.getString("number"), driver.getString("id"));
            }
            for (String number : numbers) {
                expression = expression.replaceAll(number, (String)driverNumFidMap.get(number));
            }
            if (expression.length() > 2000) {
                return true;
            }
        }
        return false;
    }

    private List<String> getNumbers(String formula) {
        ArrayList<String> list = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)formula)) {
            String[] numbers = FormulaEngine.extractVariables((String)formula);
            return Arrays.asList(numbers);
        }
        return list;
    }

    protected String tranExpression(String expression) {
        if ("@autoCal".equalsIgnoreCase(expression)) {
            return ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u8ba1\u7b97", (String)"CadFormulaEdit_2", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        }
        return super.tranExpression(expression);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeID = e.getNodeId().toString();
        if (ROOT_NODE_ID.equals(nodeID)) {
            return;
        }
        FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)"tv_fields", (String)"fexpression", (String)nodeID);
    }

    public void afterBindData(EventObject e) {
        String json = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.fillTreeNodes(json);
        }
    }

    private void fillTreeNodes(String strJson) {
        TreeNode node = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl("tv_fields");
        tree.addNode(node);
        tree.expand(ROOT_NODE_ID);
    }
}

