/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costdriver;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.enums.CostDriverEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostDriverEditPlugin
extends AbstractBillPlugIn {
    private static final String MATNUM_NUM = "CD_ACA000018_sys";
    private static final String STANDARD_COST_ACA_NUM = "CD_ACA000020_sys";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"formulastr"});
        BasedataEdit costType = (BasedataEdit)this.getControl("costtype");
        costType.addBeforeF7SelectListener(evt -> {
            DynamicObject createOrg = this.getModel().getDataEntity().getDynamicObject("createorg");
            if (createOrg == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"CostDriverEditPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List costTypeIds = CostTypeHelper.getCostTypeIdsByOrg((long)createOrg.getLong("id"));
            QFilter idFilter = new QFilter("id", "in", (Object)costTypeIds);
            List qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
            qFilters.add(idFilter);
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String formula = (String)this.getModel().getValue("formula");
        formula = this.tranFidToNumber(formula);
        this.getModel().setValue("formula", (Object)formula);
    }

    public void afterBindData(EventObject e) {
        boolean showJoin;
        boolean hasSrcCostDriver;
        super.afterBindData(e);
        AppIdHelper.setAppIdWhenAddNew((IFormView)this.getView(), (IDataModel)this.getModel());
        this.getModel().beginInit();
        this.changeLinkResource((Boolean)this.getModel().getValue("islinkresource"));
        this.getModel().endInit();
        this.initEcaApp();
        String allocclass = String.valueOf(this.getModel().getValue("allocclass"));
        this.getView().setEnable(Boolean.valueOf(!"COSTOBJECT".equals(allocclass) && !"MATERIAL".equals(allocclass) && !"MATERIALGROUP".equals(allocclass)), new String[]{"isrelatedwork"});
        this.getView().setEnable(Boolean.valueOf(!"MATERIAL".equals(allocclass) && !"MATERIALGROUP".equals(allocclass)), new String[]{"islinkresource", "iscomplexcd"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"issys"});
        this.setCostTypeVisible(this.getModel().getDataEntity().getString("formula"));
        this.setIsMatGroupCal();
        BillShowParameter param = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        boolean bl = hasSrcCostDriver = param.getCustomParam("copyCostDriverId") != null;
        if (hasSrcCostDriver) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"allocclass", "isrelatedwork", "islinkresource", "iscomplexcd", "ismatgroupcal"});
        }
        boolean bl2 = showJoin = !CadEmptyUtils.isEmpty((Long)((Long)this.getModel().getValue("srccostdriver")));
        if (OperationStatus.ADDNEW.equals((Object)status) && hasSrcCostDriver) {
            this.getModel().setValue("srccostdriver", param.getCustomParam("copyCostDriverId"));
            showJoin = true;
        }
        this.getView().setVisible(Boolean.valueOf(showJoin), new String[]{"isjoin", "isweight", "issecond"});
        this.getModel().setDataChanged(false);
    }

    private void setIsMatGroupCal() {
        if (AppIdHelper.isSCA((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ismatgroupcal"});
        } else {
            String allocClass = (String)this.getModel().getValue("allocclass");
            boolean isMatGroup = "MATERIALGROUP".equals(allocClass);
            this.getModel().setValue("ismatgroupcal", (Object)isMatGroup);
            this.getView().setEnable(Boolean.valueOf(isMatGroup), new String[]{"ismatgroupcal"});
        }
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("formulastr".equals(control.getKey())) {
            String formulaStr = (String)this.getModel().getValue("formulastr");
            if (StringUtils.isBlank((String)formulaStr)) {
                this.getModel().setValue("formula", null);
            }
            this.showFormulaEdit();
        }
    }

    private void initEcaApp() {
        Boolean isEca = "eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()));
        ComboEdit allocClassCom = (ComboEdit)this.getControl("allocclass");
        HashMap<String, LocaleString> allocClassMap = new HashMap<String, LocaleString>(4);
        allocClassMap.put("COSTCENTER", new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3", (String)"CostDriverEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        allocClassMap.put("MATERIAL", new LocaleString(ResManager.loadKDString((String)"\u7269\u6599", (String)"CostDriverEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        allocClassMap.put("COSTOBJECT", new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61", (String)"CostDriverEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        allocClassMap.put("MATERIALGROUP", new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b", (String)"CostDriverEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(allocClassMap.size());
        for (Map.Entry entry : allocClassMap.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue((String)entry.getKey());
            item.setCaption((LocaleString)entry.getValue());
            if ("MATERIAL".equals(entry.getKey())) {
                item.setItemVisible(isEca == false);
            }
            comboItems.add(item);
        }
        allocClassCom.setComboItems(comboItems);
        this.getView().setVisible(Boolean.valueOf(isEca == false), new String[]{"isrelatedwork", "islinkresource"});
    }

    private void showFormulaEdit() {
        FormShowParameter formShowParameter = new FormShowParameter();
        String formula = (String)this.getModel().getValue("formula");
        formula = this.tranFidToNumber(formula);
        String json = this.buildLeftTree();
        CRFormula formulaObj = new CRFormula();
        formulaObj.setExpression(formula);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("cad_formula");
        formShowParameter.setCustomParam("treenodes", (Object)json);
        formShowParameter.setCustomParam("formula", (Object)SerializationUtils.toJsonString((Object)formulaObj));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fillFormula"));
        this.getView().showForm(formShowParameter);
    }

    private String tranFidToNumber(String formula) {
        String numberFormula = formula;
        boolean isNumber = true;
        String split = formula.replaceAll("\\s*", "");
        if (StringUtils.isNotEmpty((String)split)) {
            ArrayList<Long> ids = new ArrayList<Long>();
            String[] formulaArr = split.split("\\D");
            if (formulaArr != null) {
                for (String number : formulaArr) {
                    if (!CostDriverEditPlugin.isInteger(number)) continue;
                    Long id = Long.valueOf(number);
                    ids.add(id);
                }
            }
            QFilter numberFilter = new QFilter("id", "in", ids);
            DynamicObjectCollection costDriverCollection = QueryServiceHelper.query((String)"cad_costdriver", (String)"id,number", (QFilter[])new QFilter[]{numberFilter});
            block1: for (DynamicObject driver : costDriverCollection) {
                for (String fid : formulaArr) {
                    if (!fid.equals(driver.getString("id"))) continue;
                    String number = driver.getString("number");
                    formula = formula.replaceAll(fid, number);
                    isNumber = false;
                    continue block1;
                }
            }
        }
        if (isNumber) {
            return numberFormula;
        }
        return formula;
    }

    public static boolean isInteger(String str) {
        if (StringUtils.isBlank((String)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    private String buildLeftTree() {
        String rootText = ResManager.loadKDString((String)"\u6210\u672c\u52a8\u56e0", (String)"CostDriverEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        TreeNode root = new TreeNode(null, "1", rootText);
        ArrayList<TreeNode> childs = new ArrayList<TreeNode>();
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter statusFitler = new QFilter("status", "=", (Object)Character.valueOf('C'));
        QFilter appFilter = new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        DynamicObjectCollection costDrivers = QueryServiceHelper.query((String)"cad_costdriver", (String)"name,number", (QFilter[])new QFilter[]{enableFilter, statusFitler, appFilter});
        for (DynamicObject costDriver : costDrivers) {
            String number = costDriver.getString("number");
            String name = costDriver.getString("name");
            TreeNode treeNode = new TreeNode(root.getId(), number, name);
            childs.add(treeNode);
        }
        root.addChildren(childs);
        root.setExpend(true);
        String json = SerializationUtils.toJsonString((Object)root);
        return json;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        CRFormula formulaObj;
        String formulaJSON;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("fillFormula".equals(actionId) && StringUtils.isNotEmpty((String)(formulaJSON = (String)closedCallBackEvent.getReturnData())) && (formulaObj = (CRFormula)SerializationUtils.fromJsonString((String)formulaJSON, CRFormula.class)) != null && formulaObj.getExpression() != null) {
            List ids;
            DynamicObject createOrg;
            String expression = formulaObj.getExpression();
            this.setCostTypeVisible(expression);
            if (!StringUtils.isEmpty((String)expression) && (expression.contains(MATNUM_NUM) || expression.contains(STANDARD_COST_ACA_NUM)) && (createOrg = this.getModel().getDataEntity().getDynamicObject("createorg")) != null && (ids = CostTypeHelper.getCostTypeIdsByOrg((long)createOrg.getLong("id"))) != null && ids.size() == 1) {
                this.getModel().setValue("costtype", ids.get(0));
            }
            this.getModel().setValue("formula", (Object)expression);
            this.getModel().setValue("formulastr", (Object)formulaObj.getExprTran());
        }
    }

    private void setCostTypeVisible(String expression) {
        if (!StringUtils.isEmpty((String)expression) && (expression.contains(MATNUM_NUM) || expression.contains(STANDARD_COST_ACA_NUM))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"costtype"});
            BasedataEdit costType = (BasedataEdit)this.getControl("costtype");
            costType.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"costtype"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (name) {
            case "isrelatedwork": {
                Boolean isrelatedwork = (Boolean)newValue;
                boolean iscomplexcd = this.getModel().getDataEntity().getBoolean("iscomplexcd");
                if (isrelatedwork.booleanValue() && iscomplexcd) {
                    this.getModel().setValue("iscomplexcd", (Object)Boolean.FALSE);
                    this.getModel().setValue("formula", null);
                    this.getModel().setValue("formulastr", null);
                }
                if (!isrelatedwork.booleanValue()) {
                    this.getModel().setValue("workactivity", null);
                    break;
                }
                this.getModel().setValue("islinkresource", (Object)false);
                break;
            }
            case "iscomplexcd": {
                Boolean complexcd = (Boolean)newValue;
                if (complexcd.booleanValue()) {
                    this.getModel().setValue("isrelatedwork", (Object)Boolean.FALSE);
                    this.getModel().setValue("workactivity", null);
                    this.getModel().setValue("islinkresource", (Object)Boolean.FALSE);
                    String formula = this.getModel().getDataEntity().getString("formula");
                    if (CadEmptyUtils.isEmpty((String)formula) || !formula.contains(MATNUM_NUM)) break;
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"costtype"});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"costtype"});
                break;
            }
            case "appnum": {
                this.getModel().setDataChanged(false);
                break;
            }
            case "islinkresource": {
                this.changeLinkResource((Boolean)newValue);
                break;
            }
            case "matchpattern": {
                this.changeMatchPattern(String.valueOf(newValue));
                break;
            }
            case "isjoin": {
                if (((Boolean)newValue).booleanValue()) break;
                this.getModel().setValue("isweight", (Object)false);
                break;
            }
            case "isweight": {
                if (!((Boolean)newValue).booleanValue()) break;
                this.getModel().setValue("isjoin", (Object)true);
                break;
            }
            case "allocclass": {
                Boolean isrelatedwork1 = (Boolean)this.getModel().getValue("isrelatedwork");
                String newValueStr = String.valueOf(newValue);
                if (isrelatedwork1.booleanValue() && "COSTOBJECT".equals(newValueStr)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u914d\u5c42\u7ea7\u4e3a\u201c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201d\u65f6\u65e0\u6cd5\u5173\u8054\u4f5c\u4e1a\u6d3b\u52a8\uff0c\u8bf7\u5148\u5173\u95ed\u4f5c\u4e1a\u6d3b\u52a8\u5f00\u5173\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CostDriverEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    this.getModel().beginInit();
                    this.getModel().setValue("allocclass", oldValue);
                    this.getModel().endInit();
                    return;
                }
                boolean isMaterial = "MATERIAL".equals(newValueStr) || "MATERIALGROUP".equals(newValueStr);
                this.getView().setEnable(Boolean.valueOf(!"COSTOBJECT".equals(newValueStr) && !isMaterial), new String[]{"isrelatedwork"});
                this.getView().setEnable(Boolean.valueOf(!isMaterial), new String[]{"islinkresource", "iscomplexcd"});
                if (isMaterial) {
                    this.getModel().setValue("isrelatedwork", (Object)Boolean.FALSE);
                    this.getModel().setValue("islinkresource", (Object)Boolean.FALSE);
                    this.getModel().setValue("iscomplexcd", (Object)Boolean.FALSE);
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"costtype"});
                }
                this.setIsMatGroupCal();
                break;
            }
        }
    }

    private void changeMatchPattern(String newValueMatch) {
        this.setVisibleFileName(newValueMatch);
        this.setFileMustInputMul(CostDriverEnum.PATTERN_RESOURCE.getValue().equals(newValueMatch), "resource");
        this.setFileMustInput(CostDriverEnum.PATTERN_RESOURCETYPE.getValue().equals(newValueMatch), "resourcetype");
    }

    private void changeLinkResource(Boolean newValue) {
        this.setFileMustInput(newValue, "matchpattern");
        this.setFileMustInput(newValue, "matchreport");
        if (newValue.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"matchpattern", "matchreport"});
            Object matchpattern = this.getModel().getValue("matchpattern");
            if (matchpattern == null || "".equals(matchpattern)) {
                this.getModel().setValue("matchpattern", (Object)CostDriverEnum.PATTERN_RESOURCE.getValue());
            } else {
                this.setFileMustInputMul(CostDriverEnum.PATTERN_RESOURCE.getValue().equals(matchpattern), "resource");
                this.setFileMustInput(CostDriverEnum.PATTERN_RESOURCETYPE.getValue().equals(matchpattern), "resourcetype");
            }
            this.setVisibleFileName(String.valueOf(this.getModel().getValue("matchpattern")));
            this.getModel().setValue("isrelatedwork", (Object)false);
            this.getModel().setValue("iscomplexcd", (Object)false);
            this.getModel().setValue("formula", null);
            this.getModel().setValue("formulastr", null);
            this.getView().updateView("matchpattern");
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"matchpattern", "matchreport", "resource", "resourcetype"});
            this.getModel().beginInit();
            this.getModel().setValue("matchpattern", (Object)CostDriverEnum.PATTERN_RESOURCE.getValue());
            this.getModel().setValue("resource", null);
            this.getModel().setValue("resourcetype", null);
            this.getModel().setValue("matchreport", (Object)CostDriverEnum.MATCH_TOTAL.getValue());
            this.getModel().endInit();
            this.setFileMustInputMul(false, "resource");
            this.setFileMustInput(false, "resourcetype");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String formulaStr = (String)this.getModel().getValue("formulastr");
        if (StringUtils.isBlank((String)formulaStr)) {
            this.getModel().setValue("formula", null);
        }
        super.beforeDoOperation(args);
    }

    private void setFileMustInput(Boolean mustInput, String fileName) {
        ComboEdit matchpatternEdit = (ComboEdit)this.getView().getControl(fileName);
        if (matchpatternEdit != null) {
            matchpatternEdit.setMustInput(mustInput.booleanValue());
        }
    }

    private void setFileMustInputMul(Boolean mustInput, String fileName) {
        MulBasedataEdit matchpatternEdit = (MulBasedataEdit)this.getView().getControl(fileName);
        if (matchpatternEdit != null) {
            matchpatternEdit.setMustInput(mustInput.booleanValue());
        }
    }

    private void setVisibleFileName(String newValue) {
        if (CostDriverEnum.PATTERN_RESOURCE.getValue().equals(newValue)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"resource"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"resourcetype"});
            this.getModel().setValue("resourcetype", null);
        } else if (CostDriverEnum.PATTERN_RESOURCETYPE.getValue().equals(newValue)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"resource"});
            this.getModel().setValue("resource", null);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"resourcetype"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"resource", "resourcetype"});
            this.getModel().setValue("resource", null);
            this.getModel().setValue("resourcetype", null);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        sourceData.put("appnum", AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }
}

