/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costdriver;

import java.util.HashSet;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListColumn;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.utils.ListViewUtils;

public class CostDriverListPlugin
extends AbstractListPlugin {
    private static final String USE_ORG = "useorg.id";

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Object filterValue = args.getFilterValue(USE_ORG);
        if (filterValue != null) {
            this.getPageCache().put("useorg", String.valueOf(filterValue));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        List listColumns = o.getListColumns();
        if ("eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            HashSet<String> hiddenKeys = new HashSet<String>(3);
            hiddenKeys.clear();
            hiddenKeys.add("isrelatedwork");
            hiddenKeys.add("workactivity.name");
            hiddenKeys.add("islinkresource");
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)o, hiddenKeys);
        }
        for (IListColumn column : listColumns) {
            switch (column.toString()) {
                case "number": {
                    column.setFixed(true);
                    break;
                }
                case "name": {
                    column.setFixed(true);
                    break;
                }
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
        e.setOrderBy("issys desc,number");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String appId = this.getView().getFormShowParameter().getAppId();
        FormOperate source = (FormOperate)args.getSource();
        switch (source.getOperateKey()) {
            case "importdata": {
                if (this.permItemCheck("cad_costdriver", "4730fc9f000003ae", appId)) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u6210\u672c\u52a8\u56e0-\u5bfc\u5165\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"CostDriverListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "exportlist_expt": 
            case "exportlistbyselectfields": 
            case "exportlist": {
                if (this.permItemCheck("cad_costdriver", "4730fc9f000004ae", appId)) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u6210\u672c\u52a8\u56e0-\u5bfc\u51fa\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"CostDriverListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
        if (primaryKeyValues != null && primaryKeyValues.length == 1) {
            BillShowParameter bsp = e.getParameter();
            bsp.setCustomParam("copyCostDriverId", primaryKeyValues[0]);
        }
    }

    public boolean permItemCheck(String entityName, String permItemKey, String appId) {
        String org = this.getPageCache().get("useorg");
        if (StringUtils.isBlank((CharSequence)org)) {
            return true;
        }
        Long orgId = Long.valueOf(org);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityName, (String)permItemKey);
        if (rs.hasAllOrgPerm()) {
            return true;
        }
        return rs.getHasPermOrgs().contains(orgId);
    }
}

