/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costdriver;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.calc.InproAlloStdValListHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.formplugin.base.BaseOrgAndCostAccountListPlugin;

public class InproAlloStdValListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private static final Log logger = LogFactory.getLog(InproAlloStdValListPlugin.class);
    private static final String COSTACCOUNT = "costaccount";
    private static final String ORG = "org";
    private static final String PERIOD = "period";
    private static String CALLBACKKEY_DELETE = "callbackkey_delete";
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("calculate".equals(key)) {
            this.calculateData(true);
        }
    }

    private void calculateData(boolean isCheckExists) {
        boolean exists;
        Long currPeriod;
        String orgStr = this.getPageCache().get(ORG);
        String costaccountStr = this.getPageCache().get(COSTACCOUNT);
        String periodStr = this.getPageCache().get(PERIOD);
        if (StringUtils.isEmpty((String)orgStr) || StringUtils.isEmpty((String)costaccountStr) || StringUtils.isEmpty((String)periodStr)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7/\u6210\u672c\u8d26\u7c3f/\u6838\u7b97\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InproAlloStdValListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        Long org = null;
        List orgList = (List)SerializationUtils.fromJsonString((String)orgStr, List.class);
        if (orgList != null && !orgList.isEmpty()) {
            org = Long.valueOf((String)orgList.get(0));
        }
        Long costaccount = Long.valueOf(costaccountStr);
        Long period = Long.valueOf(periodStr);
        Long periodPageId = Long.valueOf(periodStr);
        if (!periodPageId.equals(currPeriod = CalcRptHelper.getCurrPeriod((Long)org, (Long)costaccount))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u671f\u95f4\u4e0d\u4e3a\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u80fd\u8ba1\u7b97\u3002", (String)"InproAlloStdValListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        if (isCheckExists && (exists = this.getIsHasImportData(org, costaccount, period))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97\u4f1a\u8986\u76d6\u5f53\u524d\u671f\u95f4\u4e0a\u6b21\u5f15\u5165\u6570\u636e\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u6267\u884c\u8ba1\u7b97\uff1f", (String)"InproAlloStdValListPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(CALLBACKKEY_DELETE, (IFormPlugin)this));
            return;
        }
        try {
            String infoMsg = InproAlloStdValListHelper.inproCal((Long)org, (Long)costaccount, (Long)period, (String)"1");
            this.getView().invokeOperation("refresh");
            this.getView().showMessage(infoMsg);
        }
        catch (Exception e) {
            logger.error("\u81ea\u5b9a\u4e49\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u503c\u8ba1\u7b97\u5931\u8d25", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u81ea\u5b9a\u4e49\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u503c\u201d\u8ba1\u7b97\u5931\u8d25\u3002", (String)"InproAlloStdValListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean getIsHasImportData(Long orgId, Long costaccountId, Long periodId) {
        QFilter filter = new QFilter(COSTACCOUNT, "=", (Object)costaccountId);
        filter.and(PERIOD, "=", (Object)periodId);
        filter.and(ORG, "=", (Object)orgId);
        return QueryServiceHelper.exists((String)"cad_inproallocstdval", (QFilter[])filter.toArray());
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        switch (callBackId) {
            case "callbackkey_delete": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.calculateData(false);
                break;
            }
        }
    }
}

