/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costestablished;

import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CostUpdateDiffImportPlugin
extends BatchImportPlugin {
    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        for (ImportBillData billdata : billdatas) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            JSONObject data = billdata.getData();
            JSONObject org = (JSONObject)data.get((Object)"org");
            long orgId = this.getOrgFielter(org, "t_ORG_ORG", DBRoute.basedata);
            filters.add(new QFilter("org", "=", (Object)orgId));
            JSONObject costaccountbook = (JSONObject)data.get((Object)"costaccountbook");
            long costAccBookId = this.getOrgFielter(costaccountbook, "t_cal_costaccount", DBRoute.of((String)"cal"));
            filters.add(new QFilter("entry.costaccount", "=", (Object)costAccBookId));
            DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])filters.toArray(new QFilter[0]));
            if (res == null) continue;
            String periodId = res.getString("currentperiod");
            JSONObject newJson = new JSONObject();
            newJson.put("importprop", (Object)"id");
            newJson.put("id", (Object)periodId);
            data.put("period", (Object)newJson);
            data.put("manbuild", (Object)Boolean.TRUE);
            billdata.setData(data);
        }
    }

    private long getOrgFielter(JSONObject obj, String tableName, DBRoute dbRoute) {
        String sql = "select fid from %s where fnumber=? ";
        Object[] paraObj = new Object[]{new SqlParameter(":fnumber", 12, obj.get((Object)"number"))};
        return (Long)DB.query((DBRoute)dbRoute, (String)String.format(sql, tableName), (Object[])paraObj, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet resultSet) throws Exception {
                long orgPkId = 0L;
                while (resultSet.next()) {
                    orgPkId = resultSet.getLong("fid");
                }
                return orgPkId;
            }
        });
    }
}

