/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costestablished;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostUpdateDiffList
extends AbstractListPlugin {
    private FilterContainerInitArgs filterContainerInitArgs = null;
    private Boolean isCostAccountDef = Boolean.FALSE;

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List<Object> orgIdList = this.getOrgCache();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.startsWith(String.format("%s.", "org"))) {
                this.resetOrg(commonFilterColumn, orgIdList);
            }
            if (!fieldName.startsWith("costaccountbook.")) continue;
            this.resetCostAccount(commonFilterColumn, orgIdList);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        if (customfilter == null || customfilter.isEmpty()) {
            return;
        }
        for (int i = 0; i < customfilter.size(); ++i) {
            List vals;
            Map map = (Map)customfilter.get(i);
            List names = (List)map.get("FieldName");
            if (String.format("%s.id", "org").equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (CadEmptyUtils.isEmpty((List)vals)) continue;
                this.putOrgCache(vals);
                this.filterContainerInit(this.filterContainerInitArgs);
            }
            if (!"costaccountbook.id".equals(String.valueOf(names.get(0))) || (vals = (List)map.get("Value")) == null || vals.isEmpty()) continue;
            this.getPageCache().put("costaccountbook", String.valueOf(vals.get(0)));
        }
    }

    private void resetCostAccount(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        List<ComboItem> comboItems = this.getCostAccountComboItemListBy(orgIdList);
        if (CollectionUtils.isEmpty(comboItems)) {
            return;
        }
        commonFilterColumn.setComboItems(comboItems);
        ComboItem item = comboItems.get(0);
        String defVal = this.isCostAccountDef != false ? "" : item.getValue();
        commonFilterColumn.setDefaultValue(defVal);
        this.getPageCache().put("costaccountbook", defVal);
    }

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    private void resetOrg(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        List acctOrgs = OrgHelper.getOrgComboItems((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (CadEmptyUtils.isEmpty((List)acctOrgs)) {
            return;
        }
        String defOrgId = null;
        commonFilterColumn.setComboItems(acctOrgs);
        ComboItem item = (ComboItem)acctOrgs.get(0);
        String string = defOrgId = StringUtils.isEmpty(defOrgId) ? item.getValue() : defOrgId;
        if (CadEmptyUtils.isEmpty(orgIdList)) {
            orgIdList = Collections.singletonList(defOrgId);
        }
        commonFilterColumn.setDefaultValues(orgIdList);
        this.putOrgCache(orgIdList);
    }

    private List<Object> getOrgCache() {
        String orgId = this.getPageCache().get("org");
        if (StringUtils.isNotEmpty((String)orgId)) {
            return (List)SerializationUtils.fromJsonString((String)orgId, List.class);
        }
        return null;
    }

    private void putOrgCache(List<Object> vals) {
        this.getPageCache().put("org", SerializationUtils.toJsonString(vals));
        this.getPageCache().remove("costaccountbook");
    }

    private List<ComboItem> getCostAccountComboItemListBy(List<Object> orgId) {
        if (!CadEmptyUtils.isEmpty(orgId)) {
            Long id = Long.valueOf(orgId.get(0).toString());
            return StartCostHelper.getCostAccountItems((Long)id, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
        }
        return new ArrayList<ComboItem>();
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter bsp = e.getParameter();
        String acctOrg = this.getPageCache().get("org");
        String costCenter = this.getPageCache().get("costaccountbook");
        bsp.setCustomParam("org", (Object)acctOrg);
        bsp.setCustomParam("costaccountbook", (Object)costCenter);
    }
}

