/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costestablished;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostUpdateDiffPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costaccountbook = (BasedataEdit)this.getControl("costaccountbook");
        costaccountbook.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        costcenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costobject = (BasedataEdit)this.getControl("costobject");
        costobject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        switch (name) {
            case "org": {
                List orgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                QFilter qFilter = new QFilter("id", "in", (Object)orgIds);
                listFilterParameter.setFilter(qFilter);
                break;
            }
            case "costaccountbook": {
                if (!this.validateOrgNotNull(beforeF7SelectEvent)) break;
                List baseFilter = listFilterParameter.getQFilters();
                baseFilter.add(StartCostHelper.getEndInitCostAccountIdsFilter((Long)((DynamicObject)this.getModel().getValue("org")).getLong("id"), (String)"sca"));
                break;
            }
            case "costcenter": {
                if (!this.validateOrgNotNull(beforeF7SelectEvent)) break;
                List baseFilter = listFilterParameter.getQFilters();
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                QFilter filter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
                filter.and(new QFilter("orgduty", "=", (Object)4L));
                baseFilter.add(filter);
                break;
            }
            case "costobject": {
                if (!this.validateOrgNotNull(beforeF7SelectEvent)) break;
                DynamicObject costcenter = (DynamicObject)this.getModel().getValue("costcenter");
                if (CadEmptyUtils.isEmpty((DynamicObject)costcenter)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u4e2d\u5fc3\u3002", (String)"CostUpdateDiffPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject period = (DynamicObject)this.getModel().getValue("period");
                if (CadEmptyUtils.isEmpty((DynamicObject)period)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u671f\u95f4\u3002", (String)"CostUpdateDiffPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                QFilter filter = new QFilter("org", "=", (Object)org.getLong("id"));
                filter.and(new QFilter("costcenter", "=", (Object)costcenter.getLong("id")));
                filter.and(new QFilter("createtime", "<=", (Object)period.getDate("enddate")));
                List baseFilter = listFilterParameter.getQFilters();
                baseFilter.add(filter);
                break;
            }
        }
    }

    private boolean validateOrgNotNull(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostUpdateDiffPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return false;
        }
        return true;
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String orgId = (String)fsp.getCustomParam("org");
        Object costAccBookId = fsp.getCustomParam("costaccountbook");
        if (orgId != null) {
            int begin = orgId.indexOf("\"");
            int end = orgId.lastIndexOf("\"");
            this.getModel().setValue("org", (Object)orgId.substring(begin + 1, end));
        }
        if (costAccBookId != null) {
            this.getModel().setValue("costaccountbook", costAccBookId);
        }
        this.setCurrency();
        this.setPeriod();
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccountbook");
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (fieldName) {
            case "org": {
                if (newValue == null) break;
                this.getModel().setValue("costaccountbook", null);
                this.getModel().setValue("currency", null);
                this.getModel().setValue("period", null);
                this.getModel().setValue("costcenter", null);
                this.clearEntity();
                break;
            }
            case "costaccountbook": {
                this.setCurrency();
                this.setPeriod();
                this.clearEntity();
                break;
            }
            case "costcenter": {
                this.clearEntity();
                break;
            }
            case "period": {
                this.clearEntity();
                break;
            }
            case "costobject": {
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                DynamicObject costobject = (DynamicObject)this.getModel().getValue("costobject", rowIndex);
                if (costobject == null) break;
                Long materialId = costobject.getDynamicObject("material") == null ? Long.valueOf(0L) : costobject.getDynamicObject("material").getPkValue();
                this.getModel().setValue("productcode", (Object)materialId, rowIndex);
                this.getModel().setValue("auxpty", costobject.get("auxpty"));
            }
        }
    }

    private void clearEntity() {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        int[] entryRows = new int[entryRowCount];
        for (int i = 0; i < entryRowCount; ++i) {
            entryRows[i] = i;
        }
        this.getModel().deleteEntryRows("entryentity", entryRows);
        this.getModel().createNewEntryRow("entryentity");
    }

    private void setPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org == null) {
            return;
        }
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccountbook");
        if (costAccount == null) {
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
        if (res != null) {
            Long currentperiod = res.getLong("currentperiod");
            this.getModel().setValue("period", (Object)currentperiod);
            this.getView().updateView("period");
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("bar_save".equals(itemKey) || "bar_submit".equals(itemKey)) {
            this.getModel().setValue("manbuild", (Object)Boolean.TRUE);
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            if (entryentity == null || entryentity.size() == 0 || ((DynamicObject)entryentity.get(0)).getDynamicObject("costobject") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5dee\u5f02\u660e\u7ec6\u4e3a\u7a7a", (String)"CostUpdateDiffPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }
}

