/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costestablished;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.macc.cad.algox.StandCostCalculateService;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.business.update.CostUpdateEstablishedHelper;
import kd.macc.cad.business.update.MaterialCostProcessor;
import kd.macc.cad.business.update.ProdCostProcessor;
import kd.macc.cad.business.update.StorCostProcessor;
import kd.macc.cad.common.dto.UpdateParam;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import net.sf.json.JSONObject;

public class CostUpdateEstablishedEditPlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(CostUpdateEstablishedEditPlugin.class);
    private static final String BARITEMAP_LIVEUPDATE = "bar_liveupdate";
    private static final String BAR_CHECK = "bar_check";
    private static final String BARITEMAP_EXPORTALL = "baritemap_exportall";
    private static final String PARAM_PAGEID = "pageid";
    private static final String PARAM_SETTING = "settingkey";
    private static final String PARAM_FILENAME = "fileName";
    private static final String PARAM_TYPE = "type";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"stortoolbar", "advcontoolbarap", BARITEMAP_EXPORTALL});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        logger.info("\u9875\u9762\u5f00\u59cb\u52a0\u8f7d");
        List updateBillIds = (List)this.getView().getFormShowParameter().getCustomParam("costUpdatePrimaryKey");
        if (CadEmptyUtils.isEmpty((List)updateBillIds)) {
            return;
        }
        DynamicObject updateBill = BusinessDataServiceHelper.loadSingle(updateBillIds.get(0), (String)"cad_costupdatenew");
        boolean quickUpdateFlag = (Boolean)this.getView().getFormShowParameter().getCustomParam("quickUpdateFlag");
        boolean bl = quickUpdateFlag = quickUpdateFlag || updateBill.getBoolean("isquickupdate");
        if (updateBill == null) {
            return;
        }
        if ("resource".equals(updateBill.getString("sourcepage"))) {
            this.getPageCache().put("sourcePage", updateBill.getString("sourcepage"));
            this.getPageCache().put("resourcesByNoRef", updateBill.getString("resbynoref"));
            this.getPageCache().put("resourceMatByUseAuxp", updateBill.getString("resmatbyuseauxpt"));
        }
        if (quickUpdateFlag) {
            boolean isPurMat = (Boolean)this.getView().getFormShowParameter().getCustomParam("isPurMat");
            this.doCalc(updateBill, isPurMat);
            boolean isAutoEndPeriodCal = CostUpdateHelper.isAutoEndPeriodCalPage();
            if (isAutoEndPeriodCal) {
                CostUpdateEstablishedHelper.doWipCalc((Long)((Long)updateBillIds.get(0)), (Boolean)Boolean.TRUE);
            }
            this.dynamicLoadData(updateBill);
        } else if (!CadEmptyUtils.isEmpty((Long)updateBill.getLong("updatebillid"))) {
            if (StringUtils.equals((CharSequence)updateBill.getString("updatestatus"), (CharSequence)"N")) {
                logger.info("\u52a8\u6001\u52a0\u8f7d\u9875\u9762\u6570\u636e");
                this.dynamicLoadData(updateBill);
                return;
            }
            ((IBillModel)this.getModel()).load((Object)updateBill.getLong("updatebillid"));
            DynamicObject query = QueryServiceHelper.queryOne((String)"cad_costupdateestablished", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)updateBill.getLong("updatebillid"))});
            this.getModel().setValue("billno", (Object)query.getString("billno"));
            this.getModel().setValue("targetcosttype", updateBill.get("targetcosttype"));
            boolean isCalcCostType = this.isCalcCostType(updateBill);
            this.setStorTabVisiable(isCalcCostType);
        } else {
            this.dynamicLoadData(updateBill);
        }
        logger.info("\u52a0\u8f7d\u754c\u9762\u5b8c\u6210");
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "viewacct": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"viewacct"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"viewacctwerah"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"acctpanelap"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"storflexpanelap"});
                break;
            }
            case "viewacctwerah": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"viewacct"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"viewacctwerah"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"acctpanelap"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"storflexpanelap"});
                break;
            }
            case "baritemap_exportall": {
                ConfirmCallBackListener confirmCallBacksAll = new ConfirmCallBackListener(BARITEMAP_EXPORTALL, (IFormPlugin)this);
                String msgAll = ResManager.loadKDString((String)"\u5c06\u5f15\u51fa\u5168\u90e8\u884c\u6570\u636e\uff0c\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u5f00\u59cb\u6267\u884c\u3002", (String)"CostUpdateEstablishedEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msgAll, MessageBoxOptions.OKCancel, confirmCallBacksAll);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (BARITEMAP_EXPORTALL.equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cad_costupdate_export");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam(PARAM_FILENAME, (Object)ResManager.loadKDString((String)"\u66f4\u65b0\u786e\u8ba4\u5355", (String)"CostUpdateEstablishedEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            showParameter.setCustomParam(PARAM_TYPE, (Object)"all");
            showParameter.setCustomParam(PARAM_PAGEID, (Object)this.getView().getPageId());
            showParameter.setCustomParam(PARAM_SETTING, (Object)this.getView().getFormShowParameter().getSettingKey());
            List updatebillIds = (List)this.getView().getFormShowParameter().getCustomParam("costUpdatePrimaryKey");
            showParameter.setCustomParam("updateBillIds", (Object)updatebillIds);
            this.getView().showForm(showParameter);
        } else if ("goOnUpdate".equals(e.getCallBackId())) {
            MessageBoxResult result = e.getResult();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getView().invokeOperation("liveupdate");
            } else if (MessageBoxResult.Cancel.equals((Object)result)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BARITEMAP_LIVEUPDATE});
                String failChkResultSet = this.getPageCache().get("failChkResultSet");
                String[] chkResIdArr = failChkResultSet.split("&");
                for (int i = 0; i < chkResIdArr.length; ++i) {
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setFormId("sca_checkresult");
                    showParameter.setStatus(OperationStatus.VIEW);
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.accumulate("checkResultId", (Object)chkResIdArr[i]);
                    showParameter.setCustomParam("custparam", (Object)jsonObject.toString());
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult opResult;
        super.afterDoOperation(args);
        if ("liveupdate".equals(args.getOperateKey()) && (opResult = args.getOperationResult()) != null && opResult.isSuccess()) {
            this.doEffectiveCost();
        }
    }

    private void doEffectiveCost() {
        if (this.getModel().getValue("effecttime") != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u751f\u6548\u7684\u786e\u8ba4\u5355\uff0c\u4e0d\u80fd\u518d\u6b21\u66f4\u65b0\u6210\u672c\u3002", (String)"CostUpdateEstablishedEditPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        logger.info("\u6267\u884c\u66f4\u65b0\u8fdb\u5ea6");
        this.showCostUpdateProgress();
        logger.info("\u5373\u65f6\u66f4\u65b0\u5b8c\u6210");
    }

    private void setStorTabVisiable(boolean isCalcCostType) {
        if (isCalcCostType) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"viewacct"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"storflexpanelap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"viewacct"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"storflexpanelap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"storagecosttab"});
        }
    }

    private void dynamicLoadData(DynamicObject updateBill) {
        DynamicObject currDataEntity = this.getModel().getDataEntity();
        this.loadHeaderData(updateBill);
        logger.info("\u52a0\u8f7d\u8868\u5934\u4fe1\u606f");
        Map relatedKeyColMap = CostUpdateHelper.getRelatedKeyCols((DynamicObject)updateBill);
        this.genCostInfo(updateBill, currDataEntity, relatedKeyColMap);
        boolean isCalcCostType = this.isCalcCostType(updateBill);
        this.setStorTabVisiable(isCalcCostType);
        if (isCalcCostType) {
            this.genStorageCostInfo(updateBill, currDataEntity);
            this.genProCostInfo(updateBill, currDataEntity);
        }
    }

    private void loadHeaderData(DynamicObject updateBill) {
        DynamicObject currDataEntity = this.getModel().getDataEntity();
        DynamicObject srcCostType = CostTypeHelper.getCostType((Long)updateBill.getLong("srccosttype.id"), null);
        currDataEntity.set("srccosttype", updateBill.get("srccosttype"));
        currDataEntity.set("currency", (Object)BusinessDataServiceHelper.loadSingle((Object)srcCostType.getLong("currency.id"), (String)"bd_currency"));
        this.getModel().setValue("targetcosttype", updateBill.get("targetcosttype"));
        currDataEntity.set("effecttime", updateBill.get("updatetime"));
        currDataEntity.set("effectperiod", updateBill.get("period"));
        Boolean effectPeriodVisible = updateBill.get("period") != null && CostUpdateHelper.isUpdateByPeriod((Long)updateBill.getLong("targetcosttype.id"));
        this.getView().setVisible(effectPeriodVisible, new String[]{"effectperiod"});
        String numbers = CodeRuleServiceHelper.getNumber((String)"cad_costupdateestablished", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdateestablished"), null);
        if (kd.bos.util.StringUtils.isBlank((String)numbers)) {
            numbers = "CBGXE-" + Long.toString(System.currentTimeMillis());
        }
        currDataEntity.set("billno", (Object)numbers);
    }

    private void genCostInfo(DynamicObject updatebill, DynamicObject costUpdateEstablishedBill, Map<Long, String> relatedKeyColMap) {
        MaterialCostProcessor matCostProcessor = new MaterialCostProcessor();
        matCostProcessor.genCostInfo(updatebill, costUpdateEstablishedBill, relatedKeyColMap);
    }

    private void genStorageCostInfo(DynamicObject updateBill, DynamicObject establishedBill) {
        StorCostProcessor storCostProcessor = new StorCostProcessor();
        storCostProcessor.genStorageCostInfo(updateBill, establishedBill);
    }

    private void genProCostInfo(DynamicObject updateBill, DynamicObject establishedBill) {
        ProdCostProcessor prodCostProcessor = new ProdCostProcessor();
        prodCostProcessor.genProCostInfo(updateBill, establishedBill);
    }

    private boolean isCalcCostType(DynamicObject updateBill) {
        if (updateBill == null) {
            return false;
        }
        return updateBill.getLong("targetcosttype.type") == 0L;
    }

    private void doCalc(DynamicObject updateBill, boolean isPurMat) {
        StandCostCalcParam param = new StandCostCalcParam();
        Date calcDate = new Date();
        param.setCalcDate(calcDate);
        param.setTaskId(DBServiceHelper.genGlobalLongId());
        param.setCostTypeId(updateBill.getString("srccosttype.id"));
        int pricePrecision = (Integer)updateBill.get("srccosttype.currency.priceprecision");
        param.setPriceprecision(pricePrecision);
        List<Long> matIds = this.getCalcMat(updateBill, calcDate, isPurMat);
        if (CadEmptyUtils.isEmpty(matIds)) {
            param.setScopetype(0);
        } else {
            param.setMatids(matIds);
            param.setScopetype(1);
        }
        try {
            StandCostCalculateService standCostCalculateService = new StandCostCalculateService();
            standCostCalculateService.calculate(param);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u7528\u5377\u7b97\u63a5\u53e3\u5931\u8d25\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u6700\u65b0\u7684\u6210\u672c\u4fe1\u606f\uff0c\u8bf7\u5377\u7b97\u5b8c\u6210\u540e\u8fdb\u884c\u66f4\u65b0\u3002", (String)"CostUpdateEstablishedEditPlugin_22", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getCalcMat(DynamicObject updateBill, Date calcDate, boolean isPurMat) {
        DynamicObjectCollection entrys = updateBill.getDynamicObjectCollection("entryentity");
        ArrayList<Long> relatedMatIds = new ArrayList<Long>();
        for (DynamicObject entry : entrys) {
            Long matId = entry.getLong("material.id");
            if (matId == null || relatedMatIds.contains(matId)) continue;
            relatedMatIds.add(matId);
        }
        if (isPurMat) {
            DataSet bomSettingDataSet = null;
            DataSet bomDataSet = null;
            try {
                QFilter filter = new QFilter("costtype.id", "=", (Object)updateBill.getLong("srccosttype.id"));
                filter.and("status", "=", (Object)"C");
                bomSettingDataSet = QueryServiceHelper.queryDataSet((String)"CostUpdateEstablishedEditPlugin.getCalcMat", (String)"cad_bomsetting", (String)"bom.id BomId,isdowncalc,material.masterid as materialId", (QFilter[])new QFilter[]{filter}, null);
                HashSet<Long> bomIdSet = new HashSet<Long>();
                HashSet<Long> matWithBomSetting = new HashSet<Long>(10);
                for (Row row : bomSettingDataSet) {
                    if (row.getBoolean("isdowncalc").booleanValue()) {
                        bomIdSet.add(row.getLong(0));
                    }
                    if (row.getBoolean("isdowncalc").booleanValue() || !relatedMatIds.contains(row.getLong("materialId"))) continue;
                    matWithBomSetting.add(row.getLong("materialId"));
                }
                QFilter bomFilter = new QFilter("id", "in", bomIdSet);
                bomFilter.and(new QFilter("entry.entrymaterial.masterid", "in", (Object)relatedMatIds.toArray()));
                bomFilter.and(new QFilter("entry.ownertype", "=", (Object)"bos_org"));
                bomFilter.and(new QFilter("entry.entryvaliddate", "<=", (Object)calcDate));
                bomFilter.and(new QFilter("entry.entryinvaliddate", ">=", (Object)calcDate));
                bomDataSet = QueryServiceHelper.queryDataSet((String)"getCalcMat", (String)"cad_costbom", (String)"material.masterid MaterialId", (QFilter[])new QFilter[]{bomFilter}, (String)"id");
                relatedMatIds.clear();
                relatedMatIds.addAll(matWithBomSetting);
                for (Row row : bomDataSet) {
                    relatedMatIds.add(row.getLong("MaterialId"));
                }
            }
            catch (Throwable throwable) {
                DataSetUtils.colse((DataSet[])new DataSet[]{bomSettingDataSet, bomDataSet});
                throw throwable;
            }
            DataSetUtils.colse((DataSet[])new DataSet[]{bomSettingDataSet, bomDataSet});
        }
        return relatedMatIds;
    }

    private void showCostUpdateProgress() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cad_costupdateprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        FormShowParameter para = this.getView().getFormShowParameter();
        UpdateParam updateParam = new UpdateParam();
        updateParam.setOpMode("2");
        showParameter.setCustomParam("params", (Object)updateParam);
        List updateBillIds = (List)para.getCustomParam("costUpdatePrimaryKey");
        showParameter.setCustomParam("updateBillIds", (Object)updateBillIds);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cost_update"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String taskId;
        super.closedCallBack(closedCallBackEvent);
        if (!"cost_update".equals(closedCallBackEvent.getActionId()) || closedCallBackEvent.getReturnData() == null) {
            return;
        }
        Map result = (Map)closedCallBackEvent.getReturnData();
        if (result.isEmpty()) {
            return;
        }
        if ("successful".equals(result.get("startprogress"))) {
            Set resourceMatByUseAuxp = new HashSet(10);
            if (this.getPageCache().get("resourceMatByUseAuxp") != null) {
                resourceMatByUseAuxp = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("resourceMatByUseAuxp"), Set.class);
            }
            Date effecttime = this.getEffectTime();
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BARITEMAP_LIVEUPDATE});
            this.getModel().getDataEntity().set("effecttime", (Object)effecttime);
            this.getView().updateView("effecttime");
            if (!resourceMatByUseAuxp.isEmpty()) {
                String content = String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u6807\u51c6\u8d39\u7528\u4ef7\u76ee\u8868\u4e0d\u652f\u6301\u7269\u6599\u542f\u7528\u8f85\u52a9\u5c5e\u6027\u573a\u666f\u4e0b\u7684\u5feb\u901f\u66f4\u65b0\uff0c\u4ee5\u4e0b\u7269\u6599\u66f4\u65b0\u5931\u8d25\uff1a%s\u3002", (String)"CostUpdateEstablishedEditPlugin_28", (String)"macc-cad-formplugin", (Object[])new Object[0]), resourceMatByUseAuxp);
                this.getView().showMessage(ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0\u5b8c\u6210\u3002", (String)"CostUpdateEstablishedEditPlugin_24", (String)"macc-cad-formplugin", (Object[])new Object[0]), content, MessageTypes.Default);
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0\u6210\u529f\u3002", (String)"CostUpdateEstablishedEditPlugin_25", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
        if (CadEmptyUtils.isEmpty((String)(taskId = (String)result.get("taskid")))) {
            return;
        }
        this.openUpdateLog(Long.parseLong(taskId));
    }

    private void openUpdateLog(Long taskId) {
        BillShowParameter bill = new BillShowParameter();
        bill.setFormId("cad_calctaskrecord");
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.MainNewTabPage);
        bill.setOpenStyle(style);
        bill.setStatus(OperationStatus.VIEW);
        bill.setPkId((Object)taskId);
        bill.setHasRight(true);
        bill.setCaption(ResManager.loadKDString((String)"\u66f4\u65b0\u62a5\u544a", (String)"CostUpdateEstablishedEditPlugin_29", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)bill);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "bar_check": {
                this.doCheck();
                break;
            }
            case "bar_liveupdate": {
                this.liveUpdate(evt);
                break;
            }
        }
    }

    private void doCheck() {
        List updateBillIds = (List)this.getView().getFormShowParameter().getCustomParam("costUpdatePrimaryKey");
        if (updateBillIds.isEmpty()) {
            return;
        }
        DynamicObject updateBill = BusinessDataServiceHelper.loadSingle(updateBillIds.get(0), (String)"cad_costupdatenew");
        if (updateBill == null) {
            return;
        }
        Boolean isAllUpdate = updateBill.getBoolean("isallupdate");
        HashSet keyColIds = new HashSet(16);
        if (Boolean.FALSE.equals(isAllUpdate)) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("costupdateentry");
            entrys.forEach(p -> keyColIds.add(p.getLong("keycolid.id")));
            if (CadEmptyUtils.isEmpty(keyColIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5f85\u66f4\u65b0\u7684\u7269\u6599\uff0c\u4e0d\u80fd\u8fdb\u884c\u5408\u6cd5\u6027\u68c0\u67e5\u3002", (String)"CostUpdateEstablishedEditPlugin_32", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        Long srcCostTypeId = updateBill.getLong("srccosttype.id");
        Long tarCostTypeId = updateBill.getLong("targetcosttype.id");
        Date effectTime = TimeServiceHelper.now();
        Boolean isUpdateByPeriod = updateBill.getDynamicObject("period") != null && CostUpdateHelper.isUpdateByPeriod((Long)tarCostTypeId);
        if (Boolean.TRUE.equals(isUpdateByPeriod)) {
            Date[] dates = PeriodHelper.getPeriodStartAndEndTime((Long)updateBill.getLong("period.id"));
            if (dates == null || dates.length != 2) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6548\u671f\u95f4\u6709\u8bef\uff0c\u8bf7\u786e\u8ba4\u8be5\u4f1a\u8ba1\u671f\u95f4\u662f\u5426\u5b58\u5728\u3002", (String)"CostUpdateEstablishedEditPlugin_33", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            effectTime = dates[0];
        }
        UpdateParam param = new UpdateParam();
        param.setSrcCostTypeId(srcCostTypeId);
        param.setTarCostTypeId(tarCostTypeId);
        param.setIsAllUpdate(isAllUpdate);
        param.setKeyColIds(keyColIds);
        param.setEffectTime(Long.valueOf(effectTime.getTime()));
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cad_checktasksetting");
        fsp.setCaption(ResManager.loadKDString((String)"\u66f4\u65b0\u5408\u6cd5\u6027\u68c0\u67e5\u5217\u8868", (String)"CostUpdateEstablishedEditPlugin_34", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        fsp.setCustomParam("calcParam", (Object)param);
        fsp.setCustomParam("calType", (Object)"cad_costupdatenew");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cost_check"));
        this.getView().showForm(fsp);
    }

    private void liveUpdate(BeforeItemClickEvent evt) {
        if (CostUpdateHelper.isAutoEndPeriodCalPage()) {
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
            Set<String> mapKeys = this.buildMapKey();
            Iterator<String> iterator = mapKeys.iterator();
            HashSet<Long> chkResultIdSet = new HashSet<Long>(3);
            boolean errFlag = false;
            while (iterator.hasNext()) {
                String key = iterator.next();
                String chkResultId = this.getFromCache(key, cache);
                if (kd.bos.util.StringUtils.isEmpty((String)chkResultId)) {
                    String errMsg = this.getFromCache(key + "_calOpErrMsg", cache);
                    if (kd.bos.util.StringUtils.isEmpty((String)errMsg)) break;
                    errFlag = true;
                    break;
                }
                chkResultIdSet.add(Long.valueOf(chkResultId));
            }
            if (errFlag) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u6267\u884c\u671f\u672b\u6210\u672c\u8ba1\u7b97\u51fa\u9519\uff0c\u5efa\u8bae\u5173\u95ed\u8be5\u529f\u80fd\uff0c\u624b\u5de5\u6267\u884c\u671f\u672b\u6210\u672c\u8ba1\u7b97\u3002", (String)"CostUpdateEstablishedEditPlugin_26", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter("id", "in", chkResultIdSet);
            qFilter.and("entryentity.result", "=", (Object)"2");
            DynamicObject[] col = BusinessDataServiceHelper.load((String)"sca_checkresult", (String)"id", (QFilter[])qFilter.toArray());
            if (col != null && col.length >= 1) {
                evt.setCancel(true);
                Set<String> chkResultSet = Arrays.stream(col).map(p -> p.getString("id")).collect(Collectors.toSet());
                this.getPageCache().put("failChkResultSet", String.join((CharSequence)"&", chkResultSet.toArray(new String[0])));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u6709\u4e0d\u901a\u8fc7\u7684\u68c0\u67e5\u9879\uff0c\u53ef\u80fd\u5bfc\u81f4\u8ba1\u7b97\u7ed3\u679c\u4e0d\u6b63\u786e\u3002\u662f\u5426\u7ee7\u7eed\u6267\u884c\uff1f", (String)"CostUpdateEstablishedEditPlugin_27", (String)"macc-cad-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("goOnUpdate"));
            }
        }
    }

    private Set<String> buildMapKey() {
        HashSet<String> keySet = new HashSet<String>(3);
        DynamicObject tarCostType = (DynamicObject)this.getModel().getValue("targetcosttype");
        HashSet<Long> targetCostTypeIds = new HashSet<Long>(5);
        targetCostTypeIds.add(tarCostType.getLong("id"));
        Set costAccountIds = CostTypeHelper.getCostAcctIdSetFromCostType(targetCostTypeIds);
        QFilter costaccountFilter = new QFilter("entryentity.costaccount", "in", (Object)costAccountIds);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Character.valueOf('1'));
        DynamicObjectCollection startstdcosts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"org.masterid orgid,entryentity.costaccount.id costaccountid", (QFilter[])new QFilter[]{costaccountFilter, isInitFilter});
        QFilter filter = null;
        for (DynamicObject startstdcost : startstdcosts) {
            QFilter itemFilter = new QFilter("org", "=", startstdcost.get("orgid"));
            itemFilter.and("entry.costaccount", "=", startstdcost.get("costaccountid"));
            if (filter == null) {
                filter = itemFilter;
                continue;
            }
            filter.or(itemFilter);
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"org.id orgid,entry.costaccount.id costaccountid,entry.currentperiod currentperiod", (QFilter[])new QFilter[]{filter});
        for (DynamicObject dyn : dynamicObjects) {
            CharSequence[] key = new String[]{dyn.getString("orgid"), dyn.getString("costaccountid"), dyn.getString("currentperiod")};
            keySet.add(String.join((CharSequence)"&", key));
        }
        return keySet;
    }

    private String getFromCache(String key, DistributeSessionlessCache cache) {
        return (String)cache.get(key);
    }

    private Date getEffectTime() {
        Date date = TimeServiceHelper.now();
        List updatebillIds = (List)this.getView().getFormShowParameter().getCustomParam("costUpdatePrimaryKey");
        if (updatebillIds.isEmpty()) {
            return date;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", updatebillIds.get(0))};
        DynamicObject updateBill = QueryServiceHelper.queryOne((String)"cad_costupdatenew", (String)"updatebillid", (QFilter[])filters);
        if (updateBill == null) {
            return date;
        }
        Object updateBillId = updateBill.get("updatebillid");
        if (updateBillId == null) {
            return date;
        }
        filters = new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(updateBillId.toString()))};
        DynamicObject costEstablished = QueryServiceHelper.queryOne((String)"cad_costupdateestablished", (String)"effecttime", (QFilter[])filters);
        if (costEstablished == null) {
            return date;
        }
        return costEstablished.getDate("effecttime");
    }
}

