/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costestablished;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.thread.TaskType;
import kd.macc.cad.common.thread.ThreadHelper;
import kd.macc.cad.formplugin.costestablished.CostUpdateExporter;

public class CostUpdateExportPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private Log log = LogFactory.getLog(CostUpdateExportPlugin.class);
    private static final String PROGRESS_BAR = "progressbarap";
    private static final String PARAM_PAGEID = "pageid";
    private static final String PARAM_FILENAME = "fileName";
    private static final String PARAM_TYPE = "type";
    private static final String LABEL_PROGRESS_TOTAL = "total";
    private static final String LABEL_PROGRESS_EXPORTED = "complete";
    private static final String CACHE_TOTAL = "total";
    private static final String CACHE_EXPORTED = "exported";
    private static final String CACHE_URLS = "urls";
    private static final String CACHE_ZIPING = "ziping";
    private static final String CACHE_ERRORS = "errors";
    private static final String COMFIRMED = "Comfirmed";
    private static final String CLOSE_CONFIRM = "CLOSE_CONFIRM";
    private final String NEWCOST = ResManager.loadKDString((String)"\u66f4\u65b0\u540e\u6210\u672c", (String)"CostUpdateExportPlugin_217", (String)"macc-cad-formplugin", (Object[])new Object[0]);
    private final String NEWPRICE = ResManager.loadKDString((String)"\u66f4\u65b0\u540e\u5355\u4ef7", (String)"CostUpdateExportPlugin_218", (String)"macc-cad-formplugin", (Object[])new Object[0]);
    private final String OLDPRICE = ResManager.loadKDString((String)"\u539f\u6807\u51c6\u5355\u4ef7", (String)"CostUpdateExportPlugin_219", (String)"macc-cad-formplugin", (Object[])new Object[0]);
    private final String SUBELEMENT = ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20", (String)"CostUpdateExportPlugin_220", (String)"macc-cad-formplugin", (Object[])new Object[0]);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESS_BAR);
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESS_BAR);
        progressbar.start();
        this.startExport(this.getView());
    }

    public void onProgress(ProgressEvent evt) {
        String sErrors;
        String totalCache = this.getView().getPageCache().get("total");
        if (StringUtils.isBlank((CharSequence)totalCache)) {
            return;
        }
        int total = Integer.parseInt(totalCache);
        String exportedCache = this.getView().getPageCache().get(CACHE_EXPORTED);
        if (StringUtils.isBlank((CharSequence)exportedCache)) {
            return;
        }
        int exported = Integer.parseInt(exportedCache);
        Label totalexport = (Label)this.getControl(LABEL_PROGRESS_EXPORTED);
        totalexport.setText(String.valueOf(exported));
        evt.setProgress((int)Math.min(99.0, (double)exported * 100.0 / (double)total));
        String urls = this.getView().getPageCache().get(CACHE_URLS);
        if (StringUtils.isNotBlank((CharSequence)urls)) {
            this.log.info("costExport: \u7ed3\u675f urls");
            String[] split = urls.split(",");
            if (split.length == 1) {
                this.getView().download(UrlService.getAttachmentFullUrl((String)split[0]));
            } else {
                if ("1".equals(this.getView().getPageCache().get(CACHE_ZIPING))) {
                    return;
                }
                this.getView().getPageCache().put(CACHE_ZIPING, "1");
                try {
                    String timeStr = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
                    String fileName = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_FILENAME);
                    String downloadFileName = fileName + "_" + timeStr + ".zip";
                    BatchDownloadRequest attachReq = new BatchDownloadRequest(downloadFileName);
                    ArrayList<BatchDownloadRequest.Dir> dirList = new ArrayList<BatchDownloadRequest.Dir>(10);
                    BatchDownloadRequest.Dir testDir = new BatchDownloadRequest.Dir(fileName);
                    ArrayList<BatchDownloadRequest.File> fileList = new ArrayList<BatchDownloadRequest.File>(10);
                    for (String url : split) {
                        String filename = kd.bos.orm.util.StringUtils.getFilename((String)url);
                        BatchDownloadRequest.File aFile = new BatchDownloadRequest.File(filename, url);
                        fileList.add(aFile);
                    }
                    testDir.setFiles(fileList.toArray(new BatchDownloadRequest.File[fileList.size()]));
                    dirList.add(testDir);
                    attachReq.setDirs(dirList.toArray(new BatchDownloadRequest.Dir[dirList.size()]));
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    FileService fs = FileServiceFactory.getAttachmentFileService();
                    fs.batchDownload(attachReq, (OutputStream)out, RequestContext.getOrCreate().getUserAgent());
                    ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                    TempFileCache e = CacheFactory.getCommonCacheFactory().getTempFileCache();
                    int timeout = 7200;
                    String tempUrl = e.saveAsUrl(downloadFileName, (InputStream)in, timeout);
                    this.getView().download(tempUrl);
                }
                catch (Exception ex) {
                    this.log.error((Throwable)ex);
                    throw ex;
                }
                finally {
                    this.getView().getPageCache().put(CACHE_ZIPING, "0");
                }
            }
            this.getView().sendFormAction(this.getView());
            this.getView().getPageCache().put(CLOSE_CONFIRM, COMFIRMED);
            this.getView().close();
        }
        if (StringUtils.isNotBlank((CharSequence)(sErrors = this.getView().getPageCache().get(CACHE_ERRORS)))) {
            this.log.error("costExport: \u7ed3\u675fsErrors- " + sErrors);
            String pageid = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_PAGEID);
            IFormView view = this.getView().getView(pageid);
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff1a%s\u3002", (String)"CostUpdateExportPlugin_269", (String)"macc-cad-formplugin", (Object[])new Object[0]), sErrors));
            this.getView().sendFormAction(view);
            this.getView().getPageCache().put(CLOSE_CONFIRM, COMFIRMED);
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (!COMFIRMED.equals(this.getPageCache().get(CLOSE_CONFIRM))) {
            this.getPageCache().put(CLOSE_CONFIRM, "Comfirming");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u5f15\u51fa\u6570\u636e\uff0c\u5173\u95ed\u5c06\u7ec8\u6b62\u5f15\u51fa\u6570\u636e\uff0c\u60a8\u786e\u8ba4\u5173\u95ed\u5417\uff1f", (String)"CostUpdateExportPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_CONFIRMED", (IFormPlugin)this));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put(CLOSE_CONFIRM, COMFIRMED);
            this.close();
        }
    }

    private void close() {
        if (!"Comfirming".equals(this.getPageCache().get(CLOSE_CONFIRM))) {
            this.getPageCache().put(CLOSE_CONFIRM, COMFIRMED);
            this.getView().close();
        }
    }

    private void startExport(final IFormView currView) {
        try {
            this.log.info("costExport: \u5f00\u59cb");
            FormShowParameter showParameter = currView.getFormShowParameter();
            String pageid = (String)showParameter.getCustomParam(PARAM_PAGEID);
            final IFormView parentView = currView.getView(pageid);
            Long updatebillId = (Long)showParameter.getCustomParam("updatebillid");
            DynamicObject updateBill = BusinessDataServiceHelper.loadSingle((Object)updatebillId, (String)"cad_costupdatenew");
            if (updateBill == null) {
                return;
            }
            CostUpdateHelper.getRelatedKeyCols((DynamicObject)updateBill);
            Label progressTotal = (Label)this.getControl("total");
            final int pricePrecision = updateBill.getInt("srccosttype.currency.priceprecision");
            final int amtprecision = updateBill.getInt("srccosttype.currency.amtprecision");
            final ArrayList results = new ArrayList(10);
            String fileName = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_FILENAME);
            final String[] excelFileName = new String[]{fileName};
            Long establishedId = updateBill.getLong("updatebillid");
            if (establishedId <= 0L) {
                return;
            }
            DynamicObject loadBill = BusinessDataServiceHelper.loadSingle((Object)establishedId, (String)"cad_costupdateestablished");
            int total = loadBill.getDynamicObjectCollection("costupdateentry").size();
            progressTotal.setText(String.valueOf(total));
            currView.getPageCache().put(CACHE_EXPORTED, "0");
            currView.getPageCache().put("total", String.valueOf(total));
            currView.getPageCache().saveChanges();
            final DynamicObject finalLoadBill = loadBill;
            final boolean isDiff = "diff".equals(showParameter.getCustomParam(PARAM_TYPE));
            ThreadHelper.submit((Callable)new Callable(){

                public Object call() throws Exception {
                    ExportTask task = new ExportTask(finalLoadBill, excelFileName[0], currView, parentView, pricePrecision, amtprecision, isDiff);
                    Future future = ThreadHelper.submit((Callable)task, (TaskType)TaskType.CAD_COSTUPDATE_PROCESS);
                    results.add(future);
                    ArrayList urls = new ArrayList(10);
                    results.forEach(result -> {
                        try {
                            CostUpdateExportPlugin.this.log.info("costExport: results.forEach begin");
                            Tuple r = (Tuple)result.get(5L, TimeUnit.MINUTES);
                            if (StringUtils.isNotBlank((CharSequence)((CharSequence)r.item1))) {
                                currView.getPageCache().put(CostUpdateExportPlugin.CACHE_ERRORS, (String)r.item1);
                                currView.getPageCache().saveChanges();
                            } else {
                                urls.add(r.item2);
                            }
                            CostUpdateExportPlugin.this.log.info("costExport: results.forEach end");
                        }
                        catch (Exception e) {
                            currView.getPageCache().put(CostUpdateExportPlugin.CACHE_ERRORS, e.getMessage());
                            currView.getPageCache().saveChanges();
                        }
                    });
                    if (!urls.isEmpty()) {
                        currView.getPageCache().put(CostUpdateExportPlugin.CACHE_URLS, StringUtils.join((Object[])urls.toArray(), (String)","));
                        currView.getPageCache().saveChanges();
                    }
                    return null;
                }
            }, (TaskType)TaskType.CAD_COSTUPDATE_PROCESS);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            currView.getPageCache().put(CACHE_ERRORS, e.getMessage());
            currView.getPageCache().saveChanges();
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u5f02\u5e38\uff0c\u8be6\u60c5\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"CostUpdateExportPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }

    private class ExportTask
    implements Callable<Tuple<String, String>> {
        private String fileName;
        private DynamicObject currDataEntity;
        private int priceprecision;
        private int amtprecision;
        private IFormView currView;
        private IFormView parentView;
        private boolean isDiff;

        public ExportTask(DynamicObject currDataEntity, String fileName, IFormView currView, IFormView parentView, int priceprecision, int amtprecision, boolean isDiff) {
            this.currDataEntity = currDataEntity;
            this.fileName = fileName;
            this.currView = currView;
            this.parentView = parentView;
            this.priceprecision = priceprecision;
            this.amtprecision = amtprecision;
            this.isDiff = isDiff;
        }

        @Override
        public Tuple<String, String> call() throws Exception {
            try {
                CostUpdateExporter exporter = new CostUpdateExporter(this.getCaptions_update(), this.getCaptions_storage(), this.getCaptions_prod());
                Object costUpdateEntry = this.currDataEntity.getDynamicObjectCollection("costupdateentry");
                if (this.isDiff) {
                    costUpdateEntry = costUpdateEntry.stream().filter(f -> BigDecimal.ZERO.compareTo((BigDecimal)f.get("diffprice")) != 0).collect(Collectors.toList());
                }
                if (!costUpdateEntry.isEmpty()) {
                    Map<String, String> auxptyInfo = this.getAuxpty("costupdateentry", (List<DynamicObject>)costUpdateEntry);
                    for (int r = 1; r <= costUpdateEntry.size(); ++r) {
                        DynamicObject rowDynObj = (DynamicObject)costUpdateEntry.get(r - 1);
                        DynamicObject material = (DynamicObject)rowDynObj.get("material");
                        exporter.writeLine_update(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"CostUpdateExportPlugin_270", (String)"macc-cad-formplugin", (Object[])new Object[0]), material == null ? "" : material.getString("number"), r, 0);
                        exporter.writeLine_update(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"CostUpdateExportPlugin_222", (String)"macc-cad-formplugin", (Object[])new Object[0]), material == null ? "" : material.getString("name"), r, 0);
                        exporter.writeLine_update(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"CostUpdateExportPlugin_223", (String)"macc-cad-formplugin", (Object[])new Object[0]), material == null ? "" : material.getString("modelnum"), r, 0);
                        DynamicObject auxprop = (DynamicObject)rowDynObj.get("auxprop");
                        exporter.writeLine_update(ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"CostUpdateExportPlugin_224", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getAuxptyName(auxprop, auxptyInfo), r, 0);
                        DynamicObject keyColId = rowDynObj.getDynamicObject("keycolid");
                        exporter.writeLine_update(ResManager.loadKDString((String)"\u914d\u7f6e\u53f7", (String)"CostUpdateExportPlugin_267", (String)"macc-cad-formplugin", (Object[])new Object[0]), keyColId == null ? "" : keyColId.getString("configuredcode.number"), r, 0);
                        exporter.writeLine_update(ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7", (String)"CostUpdateExportPlugin_268", (String)"macc-cad-formplugin", (Object[])new Object[0]), keyColId == null ? "" : keyColId.getString("tracknumber.number"), r, 0);
                        DynamicObject element = (DynamicObject)rowDynObj.get("element");
                        exporter.writeLine_update(ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20", (String)"CostUpdateExportPlugin_225", (String)"macc-cad-formplugin", (Object[])new Object[0]), element == null ? "" : element.getString("name"), r, 0);
                        DynamicObject subelement = (DynamicObject)rowDynObj.get("subelement");
                        exporter.writeLine_update(CostUpdateExportPlugin.this.SUBELEMENT, subelement == null ? "" : subelement.getString("name"), r, 0);
                        BigDecimal oldprice = (BigDecimal)rowDynObj.get("oldprice");
                        exporter.writeLine_update(CostUpdateExportPlugin.this.OLDPRICE, oldprice, r, this.priceprecision);
                        BigDecimal newprice = (BigDecimal)rowDynObj.get("newprice");
                        exporter.writeLine_update(CostUpdateExportPlugin.this.NEWPRICE, newprice, r, this.priceprecision);
                        BigDecimal diffprice = (BigDecimal)rowDynObj.get("diffprice");
                        exporter.writeLine_update(ResManager.loadKDString((String)"\u5dee\u5f02", (String)"CostUpdateExportPlugin_226", (String)"macc-cad-formplugin", (Object[])new Object[0]), diffprice, r, this.priceprecision);
                        exporter.writeLine_update(ResManager.loadKDString((String)"\u6765\u6e90\u7c7b\u578b", (String)"CostUpdateExportPlugin_227", (String)"macc-cad-formplugin", (Object[])new Object[0]), "1".equals(rowDynObj.getString("srctype")) ? ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0\u5355", (String)"CostUpdateExportPlugin_228", (String)"macc-cad-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u76f8\u5173\u5f71\u54cd", (String)"CostUpdateExportPlugin_229", (String)"macc-cad-formplugin", (Object[])new Object[0]), r, 0);
                    }
                    int totalExported = Integer.parseInt(this.currView.getPageCache().get(CostUpdateExportPlugin.CACHE_EXPORTED));
                    int total = Integer.parseInt(this.currView.getPageCache().get("total"));
                    int exportedAll = totalExported + costUpdateEntry.size();
                    if (exportedAll >= total) {
                        exportedAll = total - 1;
                    }
                    this.currView.getPageCache().put(CostUpdateExportPlugin.CACHE_EXPORTED, String.valueOf(exportedAll));
                    this.currView.getPageCache().saveChanges();
                }
                Object storageCostEntry = this.currDataEntity.getDynamicObjectCollection("storagecostentry");
                if (this.isDiff) {
                    storageCostEntry = storageCostEntry.stream().filter(f -> BigDecimal.ZERO.compareTo((BigDecimal)f.get("diffcost")) != 0).collect(Collectors.toList());
                }
                if (!storageCostEntry.isEmpty()) {
                    Map<String, String> auxptyInfo = this.getAuxpty("storagecostentry", (List<DynamicObject>)storageCostEntry);
                    for (int r = 1; r <= storageCostEntry.size(); ++r) {
                        DynamicObject rowDynObj = (DynamicObject)storageCostEntry.get(r - 1);
                        DynamicObject accountorg = (DynamicObject)rowDynObj.get("accountorg");
                        exporter.writeLine_storage(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"CostUpdateExportPlugin_230", (String)"macc-cad-formplugin", (Object[])new Object[0]), accountorg == null ? "" : accountorg.getString("name"), r, 0);
                        DynamicObject costaccount = (DynamicObject)rowDynObj.get("costaccount");
                        exporter.writeLine_storage(ResManager.loadKDString((String)"\u8d26\u7c3f", (String)"CostUpdateExportPlugin_231", (String)"macc-cad-formplugin", (Object[])new Object[0]), costaccount == null ? "" : costaccount.getString("name"), r, 0);
                        DynamicObject warehouse = (DynamicObject)rowDynObj.get("warehouse");
                        exporter.writeLine_storage(ResManager.loadKDString((String)"\u4ed3\u5e93", (String)"CostUpdateExportPlugin_232", (String)"macc-cad-formplugin", (Object[])new Object[0]), warehouse == null ? "" : warehouse.getString("name"), r, 0);
                        DynamicObject stormaterial = (DynamicObject)rowDynObj.get("stormaterial");
                        exporter.writeLine_storage(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"CostUpdateExportPlugin_270", (String)"macc-cad-formplugin", (Object[])new Object[0]), stormaterial == null ? "" : stormaterial.getString("number"), r, 0);
                        exporter.writeLine_storage(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"CostUpdateExportPlugin_222", (String)"macc-cad-formplugin", (Object[])new Object[0]), stormaterial == null ? "" : stormaterial.getString("name"), r, 0);
                        exporter.writeLine_storage(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"CostUpdateExportPlugin_223", (String)"macc-cad-formplugin", (Object[])new Object[0]), stormaterial == null ? "" : stormaterial.getString("modelnum"), r, 0);
                        DynamicObject storbaseunit = (DynamicObject)rowDynObj.get("storbaseunit");
                        exporter.writeLine_storage(ResManager.loadKDString((String)"\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"CostUpdateExportPlugin_233", (String)"macc-cad-formplugin", (Object[])new Object[0]), storbaseunit == null ? "" : storbaseunit.getString("name"), r, 0);
                        DynamicObject storauxprop = (DynamicObject)rowDynObj.get("storauxprop");
                        exporter.writeLine_storage(ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"CostUpdateExportPlugin_224", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getAuxptyName(storauxprop, auxptyInfo), r, 0);
                        DynamicObject storKeyColId = rowDynObj.getDynamicObject("storkeycolid");
                        exporter.writeLine_storage(ResManager.loadKDString((String)"\u914d\u7f6e\u53f7", (String)"CostUpdateExportPlugin_267", (String)"macc-cad-formplugin", (Object[])new Object[0]), storKeyColId == null ? "" : storKeyColId.getString("configuredcode.number"), r, 0);
                        exporter.writeLine_storage(ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7", (String)"CostUpdateExportPlugin_268", (String)"macc-cad-formplugin", (Object[])new Object[0]), storKeyColId == null ? "" : storKeyColId.getString("tracknumber.number"), r, 0);
                        DynamicObject storelement = (DynamicObject)rowDynObj.get("storelement");
                        exporter.writeLine_storage(ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20", (String)"CostUpdateExportPlugin_225", (String)"macc-cad-formplugin", (Object[])new Object[0]), storelement == null ? "" : storelement.getString("name"), r, 0);
                        DynamicObject storsubelement = (DynamicObject)rowDynObj.get("storsubelement");
                        exporter.writeLine_storage(CostUpdateExportPlugin.this.SUBELEMENT, storsubelement == null ? "" : storsubelement.getString("name"), r, 0);
                        BigDecimal storoldprice = (BigDecimal)rowDynObj.get("storoldprice");
                        exporter.writeLine_storage(CostUpdateExportPlugin.this.OLDPRICE, storoldprice, r, this.priceprecision);
                        BigDecimal stornewprice = (BigDecimal)rowDynObj.get("stornewprice");
                        exporter.writeLine_storage(CostUpdateExportPlugin.this.NEWPRICE, stornewprice, r, this.priceprecision);
                        BigDecimal qty = (BigDecimal)rowDynObj.get("qty");
                        exporter.writeLine_storage(ResManager.loadKDString((String)"\u5e93\u5b58\u6570\u91cf", (String)"CostUpdateExportPlugin_234", (String)"macc-cad-formplugin", (Object[])new Object[0]), qty, r, this.priceprecision);
                        BigDecimal oldcost = (BigDecimal)rowDynObj.get("oldcost");
                        exporter.writeLine_storage(ResManager.loadKDString((String)"\u539f\u5e93\u5b58\u6210\u672c", (String)"CostUpdateExportPlugin_235", (String)"macc-cad-formplugin", (Object[])new Object[0]), oldcost, r, this.amtprecision);
                        BigDecimal newcost = (BigDecimal)rowDynObj.get("newcost");
                        exporter.writeLine_storage(CostUpdateExportPlugin.this.NEWCOST, newcost, r, this.amtprecision);
                        BigDecimal diffcost = (BigDecimal)rowDynObj.get("diffcost");
                        exporter.writeLine_storage(ResManager.loadKDString((String)"\u53d8\u66f4\u5dee\u5f02", (String)"CostUpdateExportPlugin_236", (String)"macc-cad-formplugin", (Object[])new Object[0]), diffcost, r, this.amtprecision);
                    }
                }
                String url = exporter.flush(this.parentView.getModel().getDataEntityType(), this.fileName);
                CostUpdateExportPlugin.this.log.info("costExport: call url -" + url);
                return new Tuple((Object)"", (Object)url);
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (StringUtils.isBlank((CharSequence)message) && e instanceof NullPointerException) {
                    message = ResManager.loadKDString((String)"\u5b58\u5728\u7a7a\u5f15\u7528", (String)"CostUpdateExportPlugin_265", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                }
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    this.currView.getPageCache().put(CostUpdateExportPlugin.CACHE_ERRORS, message);
                }
                return new Tuple((Object)message, (Object)"");
            }
        }

        private String getAuxptyName(DynamicObject auxpty, Map<String, String> auxptyInfo) {
            String[] flex;
            if (auxpty == null) {
                return null;
            }
            String flexField = (String)auxpty.get(1);
            if (!flexField.startsWith("{")) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            flexField = flexField.substring(1, flexField.length() - 1);
            for (String fx : flex = flexField.split(",")) {
                String[] f = fx.split(":");
                String key = f[0].replace("\"", "") + f[1];
                String val = auxptyInfo.get(key);
                if (StringUtils.isEmpty((CharSequence)val)) continue;
                sb.append(val).append("\uff1b");
            }
            if (sb.length() > 0) {
                return sb.substring(0, sb.length() - 1);
            }
            return sb.toString();
        }

        private void getAuxptyInfo(String entryKey, List<DynamicObject> entryData, Set<Long> allAuxptyIds, Map<String, List<Long>> flexs) {
            String matKey = null;
            String auxptyKey = null;
            if ("costupdateentry".equals(entryKey)) {
                matKey = "material";
                auxptyKey = "auxprop";
            } else if ("storagecostentry".equals(entryKey)) {
                matKey = "stormaterial";
                auxptyKey = "storauxprop";
            } else if ("productentry".equals(entryKey)) {
                matKey = "prosubmaterial";
                auxptyKey = "proauxpty";
            }
            if (matKey == null || auxptyKey == null) {
                return;
            }
            for (DynamicObject entry : entryData) {
                String[] flex;
                String flexField;
                DynamicObject mat = entry.getDynamicObject(matKey);
                if (mat == null) continue;
                DynamicObjectCollection auxptyEntry = mat.getDynamicObjectCollection("auxptyentry");
                auxptyEntry.forEach(p -> allAuxptyIds.add(p.getLong("auxpty.id")));
                DynamicObject auxpty = entry.getDynamicObject(auxptyKey);
                if (auxpty == null || !(flexField = (String)auxpty.get(1)).startsWith("{")) continue;
                flexField = flexField.substring(1, flexField.length() - 1);
                for (String fx : flex = flexField.split(",")) {
                    String[] f = fx.split(":");
                    String key = f[0].replace("\"", "");
                    Long val = Long.parseLong(f[1]);
                    List<Long> values = flexs.get(key);
                    if (values == null) {
                        values = new ArrayList<Long>(1);
                    }
                    values.add(val);
                    flexs.put(key, values);
                }
            }
        }

        private Map<String, String> getAuxpty(String entryKey, List<DynamicObject> entryData) {
            DynamicObject[] auxpty;
            HashMap<String, String> result = new HashMap<String, String>(10);
            HashSet<Long> allAuxptyIds = new HashSet<Long>(10);
            HashMap<String, List<Long>> flexs = new HashMap<String, List<Long>>(10);
            this.getAuxptyInfo(entryKey, entryData, allAuxptyIds, flexs);
            if (allAuxptyIds.isEmpty() || flexs.size() == 0) {
                return result;
            }
            block4: for (DynamicObject aux : auxpty = BusinessDataServiceHelper.load((Object[])allAuxptyIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_auxproperty"))) {
                String flexField = aux.getString("flexfield");
                List values = (List)flexs.get(flexField);
                if (values == null) continue;
                String typeName = aux.getString("name");
                int valueType = aux.getInt("valuetype");
                switch (valueType) {
                    case 1: 
                    case 2: {
                        String valueSource = aux.getString("valuesource.number");
                        if (2 == valueType && StringUtils.isEmpty((CharSequence)valueSource)) {
                            valueSource = "bos_assistantdata_detail";
                        }
                        Map dyFlexs = BusinessDataServiceHelper.loadFromCache((Object[])values.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)valueSource));
                        for (Map.Entry entry : dyFlexs.entrySet()) {
                            result.put(flexField + ((DynamicObject)entry.getValue()).getString("id"), typeName + ":" + ((DynamicObject)entry.getValue()).getString("name"));
                        }
                        continue block4;
                    }
                    case 3: {
                        for (Object e : values) {
                            result.put(flexField + e, typeName + ":" + e);
                        }
                        continue block4;
                    }
                }
            }
            return result;
        }

        private List<String> getCaptions_update() {
            ArrayList<String> captions = new ArrayList<String>(8);
            captions.add(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"CostUpdateExportPlugin_270", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"CostUpdateExportPlugin_222", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"CostUpdateExportPlugin_223", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"CostUpdateExportPlugin_224", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u914d\u7f6e\u53f7", (String)"CostUpdateExportPlugin_267", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7", (String)"CostUpdateExportPlugin_268", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20", (String)"CostUpdateExportPlugin_225", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(CostUpdateExportPlugin.this.SUBELEMENT);
            captions.add(CostUpdateExportPlugin.this.OLDPRICE);
            captions.add(CostUpdateExportPlugin.this.NEWPRICE);
            captions.add(ResManager.loadKDString((String)"\u5dee\u5f02", (String)"CostUpdateExportPlugin_226", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u6765\u6e90\u7c7b\u578b", (String)"CostUpdateExportPlugin_227", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return captions;
        }

        private List<String> getCaptions_storage() {
            ArrayList<String> captions = new ArrayList<String>(8);
            captions.add(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"CostUpdateExportPlugin_230", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u8d26\u7c3f", (String)"CostUpdateExportPlugin_231", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u4ed3\u5e93", (String)"CostUpdateExportPlugin_232", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"CostUpdateExportPlugin_270", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"CostUpdateExportPlugin_222", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"CostUpdateExportPlugin_223", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"CostUpdateExportPlugin_233", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"CostUpdateExportPlugin_224", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u914d\u7f6e\u53f7", (String)"CostUpdateExportPlugin_267", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7", (String)"CostUpdateExportPlugin_268", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20", (String)"CostUpdateExportPlugin_225", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(CostUpdateExportPlugin.this.SUBELEMENT);
            captions.add(CostUpdateExportPlugin.this.OLDPRICE);
            captions.add(CostUpdateExportPlugin.this.NEWPRICE);
            captions.add(ResManager.loadKDString((String)"\u5e93\u5b58\u6570\u91cf", (String)"CostUpdateExportPlugin_234", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(ResManager.loadKDString((String)"\u539f\u5e93\u5b58\u6210\u672c", (String)"CostUpdateExportPlugin_235", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            captions.add(CostUpdateExportPlugin.this.NEWCOST);
            captions.add(ResManager.loadKDString((String)"\u53d8\u66f4\u5dee\u5f02", (String)"CostUpdateExportPlugin_236", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return captions;
        }

        private List<String> getCaptions_prod() {
            return new ArrayList<String>();
        }
    }
}

