/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costestablished;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.mvc.export.ExcelWriter;
import kd.bos.mvc.export.ExportSheetStyle;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CostUpdateExporter
extends ExcelWriter {
    private SXSSFSheet sheet_update = this.wb.createSheet(ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0", (String)"CostUpdateExporter_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
    private SXSSFSheet sheet_storage = this.wb.createSheet(ResManager.loadKDString((String)"\u5e93\u5b58\u6210\u672c\u66f4\u65b0", (String)"CostUpdateExporter_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
    private ExportSheetStyle styles;
    private List<String> captions_update;
    private List<String> captions_storage;
    private CellStyle decimalCellStyle = null;
    private int precision = 0;

    public CostUpdateExporter(List<String> captions_update, List<String> captions_storage, List<String> captions_prod) {
        this.captions_update = captions_update;
        this.captions_storage = captions_storage;
        this.styles = new ExportSheetStyle(this.wb);
        this.createHeader(this.sheet_update, captions_update);
        this.createHeader(this.sheet_storage, captions_storage);
    }

    private void createHeader(SXSSFSheet sheet, List<String> captions) {
        for (int col = 0; col < captions.size(); ++col) {
            this.creatHeaderCell(sheet, captions.get(col), col);
        }
    }

    private void creatHeaderCell(SXSSFSheet sheet, String caption, int col) {
        String align = "default";
        CellStyle cellStyle = this.styles.getTitleStyle(align);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        SXSSFCell cell = CostUpdateExporter.createCell((SXSSFWorkbook)this.wb, (SXSSFRow)CostUpdateExporter.getRow((SXSSFSheet)sheet, (int)0), (int)col, (CellStyle)cellStyle);
        cell.setCellValue(caption);
        this.sheet_update.setColumnWidth(col, Math.min(256 * Math.max(caption.length(), 8) * 2, 30720));
    }

    public void writeLine_update(String caption, Object value, int row, int precision) {
        int col = this.captions_update.indexOf(caption);
        if (col == -1) {
            throw new KDBizException(ResManager.loadKDString((String)"caption\u6709\u8bef\u3002", (String)"CostUpdateExporter_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
        this.creatValueCell(this.sheet_update, value, row, col, precision);
    }

    public void writeLine_storage(String caption, Object value, int row, int precision) {
        int col = this.captions_storage.indexOf(caption);
        if (col == -1) {
            throw new KDBizException(ResManager.loadKDString((String)"caption\u6709\u8bef\u3002", (String)"CostUpdateExporter_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
        this.creatValueCell(this.sheet_storage, value, row, col, precision);
    }

    private void creatValueCell(SXSSFSheet sheet, Object value, int row, int col, int precision) {
        String align = "default";
        if (value instanceof BigDecimal) {
            SXSSFCell cell = CostUpdateExporter.createCell((SXSSFWorkbook)this.wb, (SXSSFRow)CostUpdateExporter.getRow((SXSSFSheet)sheet, (int)row), (int)col, (CellStyle)this.getDecimalStyle(this.wb, precision));
            cell.setCellType(CellType.NUMERIC);
            Double dValue = Double.parseDouble(((BigDecimal)value).setScale(precision, RoundingMode.HALF_UP).toPlainString());
            cell.setCellValue(dValue.doubleValue());
        } else {
            CostUpdateExporter.createCell((SXSSFWorkbook)this.wb, (SXSSFRow)CostUpdateExporter.getRow((SXSSFSheet)sheet, (int)row), (int)col, (CellStyle)this.styles.getTextStyle(align)).setCellValue(value == null ? "" : value.toString());
        }
    }

    private CellStyle getDecimalStyle(SXSSFWorkbook wb, int precision) {
        if (this.decimalCellStyle == null || this.precision != precision) {
            String format = "_(#,##0.00_);_(-#,##0.00_)";
            format = format.replaceAll("\\.00", precision > 0 ? String.format(".%0" + precision + "d", 0) : "");
            this.decimalCellStyle = wb.createCellStyle();
            this.decimalCellStyle.setDataFormat(wb.createDataFormat().getFormat(format));
            this.decimalCellStyle.setAlignment(HorizontalAlignment.RIGHT);
            this.precision = precision;
        }
        return this.decimalCellStyle;
    }
}

