/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costestablished;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.update.CostUpdateEstablishedHelper;
import kd.macc.cad.business.update.CostUpdateTask;
import kd.macc.cad.common.dto.UpdateParam;
import kd.macc.cad.common.thread.TaskType;
import kd.macc.cad.common.thread.ThreadHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.costestablished.CostUpdateCheck;

public class CostUpdateProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private Log logger = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void onProgress(ProgressEvent arg0) {
        String err = this.getPageCache().get("tip_fail");
        if (!CadEmptyUtils.isEmpty((String)err)) {
            HashMap<String, String> result = new HashMap<String, String>(2);
            result.put("tip_fail", err);
            result.put("taskid", this.getPageCache().get("taskid"));
            this.getView().returnDataToParent(result);
            this.getView().close();
            return;
        }
        String startProgress = this.getPageCache().get("startprogress");
        if (CadEmptyUtils.isEmpty((String)startProgress)) {
            arg0.setProgress(0);
            return;
        }
        if ("false".equals(startProgress)) {
            HashMap<String, String> result = new HashMap<String, String>(2);
            result.put("startprogress", "successful");
            result.put("taskid", this.getPageCache().get("taskid"));
            this.getView().returnDataToParent(result);
            this.getView().close();
            return;
        }
        int progress = 0;
        String cacheProgress = this.getPageCache().get("progress");
        if (!CadEmptyUtils.isEmpty((String)cacheProgress)) {
            Label percent = (Label)this.getControl("percent");
            percent.setText(cacheProgress + "%");
            progress = Integer.parseInt(cacheProgress);
        }
        if (progress >= 100 && "1".equals(this.getPageCache().get("checkMode"))) {
            this.getView().close();
            Long taskId = this.getPageCache().get("taskid") != null ? Long.parseLong(this.getPageCache().get("taskid")) : 0L;
            BillShowParameter bill = new BillShowParameter();
            bill.setFormId("cad_calctaskrecord");
            OpenStyle style = new OpenStyle();
            style.setShowType(ShowType.MainNewTabPage);
            bill.setOpenStyle(style);
            bill.setStatus(OperationStatus.VIEW);
            bill.setPkId((Object)taskId);
            bill.setHasRight(true);
            bill.setCaption(ResManager.loadKDString((String)"\u66f4\u65b0\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CostUpdateProgressPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            this.getView().showForm((FormShowParameter)bill);
        }
        if (progress >= 100) {
            progress = 99;
        }
        arg0.setProgress(progress);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.start();
        this.startCostUpdate(view);
    }

    private void startCostUpdate(IFormView view) {
        String params = String.valueOf((char[])view.getFormShowParameter().getCustomParam("params"));
        UpdateParam updateParam = (UpdateParam)SerializationUtils.fromJsonString((String)params, UpdateParam.class);
        updateParam.setRc(RequestContext.get());
        updateParam.setPageId(view.getPageId());
        String opMode = updateParam.getOpMode();
        this.getPageCache().put("checkMode", opMode);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        progressBar.setPercent(0, ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d...", (String)"CostUpdateProgressPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        view.getPageCache().put("startprogress", "true");
        view.getPageCache().put("progress", "0");
        String pageId = view.getPageId();
        this.logger.info("\u542f\u52a8\u6210\u672c\u66f4\u65b0\u524d\uff0c" + pageId);
        if ("1".equals(opMode)) {
            this.getPageCache().put("taskid", updateParam.getTaskId().toString());
            CostUpdateCheck costUpdateCheck = new CostUpdateCheck(updateParam);
            ThreadHelper.execute((Runnable)costUpdateCheck, (TaskType)TaskType.CAD_COSTUPDATE_PROCESS);
        } else {
            FormShowParameter showParameter = view.getFormShowParameter();
            List updateBillIds = (List)showParameter.getCustomParam("updateBillIds");
            updateParam.setUpdatBillIds(updateBillIds);
            Long updateBillId = (Long)updateBillIds.get(0);
            Boolean isTrackUpdate = this.getIsTrackUpdate(updateBillId);
            this.logger.info(String.format("\u66f4\u65b0\u7533\u8bf7\u5355%s,\u8ddf\u8e2a\u53f7\u66f4\u65b0=%s", updateBillId, isTrackUpdate));
            updateParam.setIsTrackUpdate(isTrackUpdate);
            if (Boolean.FALSE.equals(isTrackUpdate)) {
                CostUpdateEstablishedHelper.doWipCalc((Long)updateBillId, (Boolean)Boolean.FALSE);
            }
            try {
                CostUpdateTask updateTask = new CostUpdateTask(updateParam);
                ThreadHelper.execute((Runnable)updateTask, (TaskType)TaskType.CAD_COSTUPDATE);
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
                view.getPageCache().put("tip_fail", String.format(ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0\u51fa\u9519\uff1a%s\u3002", (String)"CostUpdateProgressPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]), e.getMessage()));
                view.getPageCache().saveChanges();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private Boolean getIsTrackUpdate(Long updateBillId) {
        QFilter configFilter = new QFilter("entryentity.tracknumber", ">", (Object)0L);
        configFilter.or(new QFilter("entryentity.configuredcode", ">", (Object)0L));
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)updateBillId), configFilter};
        return QueryServiceHelper.exists((String)"cad_costupdatenew", (QFilter[])filters);
    }
}

