/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costestablished;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.algox.Data.Material;
import kd.macc.cad.algox.StandCostCalculateService;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.business.update.CostUpdateEstablishedHelper;
import kd.macc.cad.common.dto.UpdateParam;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PreUpdateCalcTask
implements Runnable {
    private Log logger = LogFactory.getLog(PreUpdateCalcTask.class);
    private static final String PREPROGRESS = "preprogress";
    private UpdateParam updateParam;

    public PreUpdateCalcTask(UpdateParam updateParam) {
        this.updateParam = updateParam;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.updateParam.getRc());
        this.doTask();
    }

    private void doTask() {
        long initTime = System.currentTimeMillis();
        this.setProgress(this.updateParam.getPageId(), PREPROGRESS, "5");
        Long updateBillId = (Long)this.updateParam.getUpdateBillIds().get(0);
        CostUpdateEstablishedHelper.updateId((Long)updateBillId, (Long)0L);
        this.setProgress(this.updateParam.getPageId(), PREPROGRESS, "10");
        long time = System.currentTimeMillis();
        DynamicObject updateBill = BusinessDataServiceHelper.loadSingle((Object)updateBillId, (String)"cad_costupdatenew");
        this.logger.info("\u9884\u66f4\u65b0\u52a0\u8f7d\u66f4\u65b0\u7533\u8bf7\u5355(ms)\uff1a" + (System.currentTimeMillis() - time));
        boolean isPurMat = this.updateParam.getIsPurMat() == null ? Boolean.FALSE : this.updateParam.getIsPurMat();
        String updateForStdCalc = CadBgParamUtils.getCadBgParamForString((String)"updateForStdCalc", (String)"0");
        if ("1".equals(updateForStdCalc) && !Boolean.TRUE.equals(updateBill.getBoolean("iscalccurlevel"))) {
            long startTime;
            boolean quickUpdateFlag = this.updateParam.getQuickUpdateFlag();
            if (quickUpdateFlag) {
                this.setProgress(this.updateParam.getPageId(), PREPROGRESS, "20");
                startTime = System.currentTimeMillis();
                this.doCalc(updateBill, isPurMat);
                this.logger.info("\u9884\u66f4\u65b0\u65f6\u8c03\u7528\u5377\u7b97\u8017\u65f6(ms)\uff1a" + (System.currentTimeMillis() - startTime));
            }
            this.setProgress(this.updateParam.getPageId(), PREPROGRESS, "40");
            startTime = System.currentTimeMillis();
            this.logger.info("\u9884\u66f4\u65b0\u65f6\u57fa\u7840\u8d44\u6599\u53d8\u52a8\u8c03\u7528\u5377\u7b97\u8017\u65f6(ms)\uff1a" + (System.currentTimeMillis() - startTime));
        }
        time = System.currentTimeMillis();
        if (Boolean.TRUE.equals(this.updateParam.getQuickUpdateFlag()) && isPurMat) {
            CostUpdateEstablishedHelper.doCalcByPurPrices((String)"cad_purprices", (List)this.updateParam.getSourceBillIds());
        }
        this.logger.info("\u9884\u66f4\u65b0\u8c03\u7528\u5916\u8d2d\u5377\u7b97(ms)\uff1a" + (System.currentTimeMillis() - time));
        this.setProgress(this.updateParam.getPageId(), PREPROGRESS, "60");
        boolean isAutoEndPeriodCal = CostUpdateHelper.isAutoEndPeriodCalPage();
        if (isAutoEndPeriodCal) {
            CostUpdateEstablishedHelper.doWipCalc((Long)updateBillId, (Boolean)Boolean.TRUE);
        }
        this.setProgress(this.updateParam.getPageId(), PREPROGRESS, "80");
        DynamicObject establishedBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdateestablished");
        time = System.currentTimeMillis();
        CostUpdateEstablishedHelper.initEstablishedBill((DynamicObject)updateBill, (DynamicObject)establishedBill);
        this.logger.info("\u9884\u66f4\u65b0\u8ba1\u7b97\u5dee\u5f02\u540e\u786e\u8ba4\u5355(ms)\uff1a" + (System.currentTimeMillis() - time));
        this.setProgress(this.updateParam.getPageId(), PREPROGRESS, "90");
        DynamicObjectCollection entrys = establishedBill.getDynamicObjectCollection("costupdateentry");
        time = System.currentTimeMillis();
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entrys)) {
            Object established;
            Object[] establishedBills = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{establishedBill});
            if (CadEmptyUtils.isEmpty((Object[])establishedBills)) {
                this.setProgress(this.updateParam.getPageId(), PREPROGRESS, "-1");
            }
            if ((established = establishedBills[0]) instanceof DynamicObject) {
                CostUpdateEstablishedHelper.updateId((Long)updateBillId, (Long)Long.valueOf(((DynamicObject)established).getPkValue().toString()));
            }
        } else {
            updateBill.set("updatestatus", (Object)"Y");
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{updateBill});
        }
        this.logger.info("\u9884\u66f4\u65b0\u786e\u8ba4\u5355\u5904\u7406(ms)\uff1a" + (System.currentTimeMillis() - time));
        this.logger.info("\u9884\u66f4\u65b0\u8017\u65f6(ms)\uff1a" + (System.currentTimeMillis() - initTime));
        this.setProgress(this.updateParam.getPageId(), PREPROGRESS, "100");
    }

    private void doCalc(DynamicObject updateBill, boolean isPurMat) {
        StandCostCalcParam param = new StandCostCalcParam();
        Date calcDate = new Date();
        param.setCalcDate(calcDate);
        param.setTaskId(DBServiceHelper.genGlobalLongId());
        param.setCostTypeId(updateBill.getString("srccosttype.id"));
        int pricePrecision = (Integer)updateBill.get("srccosttype.currency.priceprecision");
        param.setPriceprecision(pricePrecision);
        this.setBomRouteRule(param);
        List<Material> matIds = this.getCalcMat(updateBill, calcDate, isPurMat, param.isStartBomRuleCalc());
        if (CadEmptyUtils.isEmpty(matIds)) {
            param.setScopetype(0);
        } else {
            param.setMaterials(matIds);
            param.setScopetype(1);
        }
        try {
            StandCostCalculateService standCostCalculateService = new StandCostCalculateService();
            standCostCalculateService.calculate(param);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            this.setProgress(this.updateParam.getPageId(), PREPROGRESS, "-1");
            this.logger.info("\u8c03\u7528\u5377\u7b97\u63a5\u53e3\u5931\u8d25\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u6700\u65b0\u7684\u6210\u672c\u4fe1\u606f\uff0c\u8bf7\u5377\u7b97\u5b8c\u6210\u540e\u8fdb\u884c\u66f4\u65b0\u3002");
        }
    }

    private void setBomRouteRule(StandCostCalcParam param) {
        DynamicObject rulePlan;
        DynamicObject routeRule;
        QFilter filter = new QFilter("costtype", "=", (Object)param.getCostTypeId());
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        QFilter defaultFilter = new QFilter("default", "=", (Object)true);
        DynamicObject bomRule = QueryServiceHelper.queryOne((String)"cad_bomrulesetting", (String)"id", (QFilter[])new QFilter[]{filter, enableFilter, defaultFilter});
        if (bomRule == null) {
            filter = new QFilter("costtype", "=", (Object)0L);
            bomRule = QueryServiceHelper.queryOne((String)"cad_bomrulesetting", (String)"id", (QFilter[])new QFilter[]{filter, enableFilter, defaultFilter});
        }
        if (bomRule != null) {
            param.setBomRuleSetting(Long.valueOf(bomRule.getLong("id")));
            param.setStartBomRuleCalc(Boolean.TRUE);
        }
        if ((routeRule = QueryServiceHelper.queryOne((String)"cad_routerulesetting", (String)"id", (QFilter[])new QFilter[]{filter, enableFilter, defaultFilter})) == null) {
            filter = new QFilter("costtype", "=", (Object)0L);
            routeRule = QueryServiceHelper.queryOne((String)"cad_routerulesetting", (String)"id", (QFilter[])new QFilter[]{filter, enableFilter, defaultFilter});
        }
        if (routeRule != null) {
            param.setRouteRuleSetting(Long.valueOf(routeRule.getLong("id")));
            param.setStartRouteRuleCalc(Boolean.TRUE);
        }
        if ((rulePlan = QueryServiceHelper.queryOne((String)"cad_calcruleplan", (String)"id", (QFilter[])new QFilter[]{filter, enableFilter, defaultFilter})) == null) {
            filter = new QFilter("costtype", "=", (Object)0L);
            rulePlan = QueryServiceHelper.queryOne((String)"cad_routerulesetting", (String)"id", (QFilter[])new QFilter[]{filter, enableFilter, defaultFilter});
        }
        if (rulePlan != null) {
            param.setPriceRuleScheme(Long.valueOf(rulePlan.getLong("id")));
        }
    }

    private List<Material> getCalcMat(DynamicObject updateBill, Date calcDate, boolean isPurMat, Boolean startBomRuleCalc) {
        DynamicObjectCollection entrys = updateBill.getDynamicObjectCollection("entryentity");
        ArrayList<Material> materialList = new ArrayList<Material>(10);
        ArrayList<Long> matGrpIds = new ArrayList<Long>(10);
        for (DynamicObject entry : entrys) {
            if (entry.getDynamicObject("material") == null) {
                if (CadEmptyUtils.isEmpty((Long)entry.getLong("matgrp.id"))) continue;
                matGrpIds.add(entry.getLong("matgrp.id"));
                continue;
            }
            Material material = new Material();
            long matId = entry.getLong("material.id");
            material.setMaterialId(matId);
            if (entry.getDynamicObject("auxprop") != null) {
                long auxptyId = entry.getLong("auxprop.id");
                material.setMaterialAuxPropId(auxptyId);
            }
            if (entry.getDynamicObject("configuredcode") != null) {
                long configCodeId = entry.getLong("configuredcode.id");
                material.setConfiguredcode(configCodeId);
            }
            if (entry.getDynamicObject("tracknumber") != null) {
                long trackNumId = entry.getLong("tracknumber.id");
                material.setTracknumber(trackNumId);
            }
            if (entry.getDynamicObject("project") != null) {
                long projectId = entry.getLong("project.id");
                material.setProject(projectId);
            }
            String lot = entry.getString("lot");
            material.setLot(lot);
            if (isPurMat) {
                material.setPurPrice(Boolean.TRUE.booleanValue());
            }
            material.setKeycol();
            materialList.add(material);
        }
        if (!CadEmptyUtils.isEmpty(matGrpIds)) {
            DynamicObject costType = updateBill.getDynamicObject("srccosttype");
            DynamicObject matGrpStd = updateBill.getDynamicObject("matgrpstd");
            List<Material> materialByGroupIds = this.getMaterialByGroupIds(costType, matGrpStd, matGrpIds, calcDate, startBomRuleCalc);
            materialList.addAll(materialByGroupIds);
        }
        return materialList;
    }

    private List<Material> getMaterialByGroupIds(DynamicObject costType, DynamicObject matGroupStd, List<Long> matGroupIds, Date calcDate, Boolean isStartBomRule) {
        Material material;
        ArrayList<Material> materials = new ArrayList<Material>();
        if (CadEmptyUtils.isEmpty(matGroupIds)) {
            return materials;
        }
        DynamicObjectCollection matGroupItems = new DynamicObjectCollection();
        DynamicObject[] matGroups = BusinessDataServiceHelper.load((Object[])matGroupIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_materialgroup"));
        matGroupItems.addAll(Arrays.asList(matGroups));
        Set classifiedMaterialIds = MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)matGroupItems, (boolean)false, (DynamicObject)matGroupStd);
        QFilter filter = new QFilter("costtype", "=", (Object)(costType == null ? 0L : costType.getLong("id")));
        filter.and("status", "=", (Object)"C");
        QFilter matFilter = new QFilter("material", "in", (Object)classifiedMaterialIds);
        Set productOrgs = StdCalculateHelper.getProductOrgsByImitateCostType((Long)(costType == null ? 0L : costType.getLong("id")), (Date)calcDate);
        List<Long> noPurMatIds = this.getNoPurMatIds(productOrgs, classifiedMaterialIds);
        ArrayList purMatIds = new ArrayList(classifiedMaterialIds);
        purMatIds.removeAll(noPurMatIds);
        DynamicObjectCollection purPrices = QueryServiceHelper.query((String)"cad_purprices", (String)"material,keycol", (QFilter[])new QFilter[]{new QFilter("material", "in", purMatIds)});
        for (DynamicObject purPrice : purPrices) {
            material = new Material();
            material.setMaterialId(purPrice.getLong("material"));
            material.setKeycol(purPrice.getString("keycol"));
            material.setPurPrice(Boolean.TRUE.booleanValue());
            materials.add(material);
        }
        if (isStartBomRule.booleanValue()) {
            for (Long classifiedMaterialId : classifiedMaterialIds) {
                if (purMatIds.contains(classifiedMaterialId)) continue;
                material = new Material();
                material.setMaterialId(classifiedMaterialId.longValue());
                materials.add(material);
            }
        } else {
            DynamicObjectCollection bomSettingInfoList = QueryServiceHelper.query((String)"cad_bomsetting", (String)"material.id material,bomversion.id matversion,auxprop.id auxpty,configuredcode,tracknumber,project,lot,matcalcprop,material.isuseauxpty isuseauxpty,material.auxptyentry.isaffectprice isaffectprice,material.isenablematerialversion isenablematerialversion", (QFilter[])new QFilter[]{filter, matFilter});
            for (DynamicObject dynamicObject : bomSettingInfoList) {
                Material material2 = this.toMaterial(dynamicObject);
                String matcalcprop = dynamicObject.getString("matcalcprop");
                if ("B".equals(matcalcprop)) {
                    material2.setPurPrice(Boolean.TRUE.booleanValue());
                }
                materials.add(material2);
            }
        }
        return materials;
    }

    private List<Long> getNoPurMatIds(Set<Long> productOrgs, Set<Long> ids) {
        QFilter orgFilter = new QFilter("createorg", "in", productOrgs);
        orgFilter.or(new QFilter("ctrlstrategy", "=", (Object)"5"));
        QFilter matInfoFilter = new QFilter("masterid", "in", ids);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter materialAttrFilter = new QFilter("materialattr", "in", (Object)new String[]{"10030", "10050", "10020"});
        DynamicObjectCollection results = QueryServiceHelper.query((String)"bd_materialmftinfo", (String)"masterid", (QFilter[])new QFilter[]{orgFilter, matInfoFilter, statusFilter, enableFilter, materialAttrFilter});
        ArrayList<Long> purMatIds = new ArrayList<Long>(200);
        for (DynamicObject result : results) {
            purMatIds.add(result.getLong("masterid"));
        }
        return purMatIds;
    }

    private Material toMaterial(DynamicObject dyo) {
        Material material = new Material();
        material.setMaterialId(dyo.getLong("material"));
        material.setConfiguredcode(dyo.getLong("configuredcode"));
        material.setIsuseauxpty(dyo.getBoolean("isuseauxpty"));
        material.setAffectPrice(dyo.getBoolean("isaffectprice"));
        if (material.isIsuseauxpty() && material.isAffectPrice()) {
            material.setMaterialAuxPropId(dyo.getLong("auxpty"));
        }
        material.setTracknumber(dyo.getLong("tracknumber"));
        material.setLot(dyo.getString("lot"));
        material.setProject(dyo.getLong("project"));
        material.setKeycol();
        return material;
    }

    private void setProgress(String pageId, String cacheKey, String progress) {
        PageCache pageCache = new PageCache(pageId);
        pageCache.put(cacheKey, progress);
        this.logger.info(String.format("\u4efb\u52a1\u4e2d\u7684PageId:%s\uff0c\u8fdb\u5ea6:%s\uff0c\u5f53\u524d\u53d6\u51fa\u6765\u7684\u8fdb\u5ea6\u503c:%s", pageId, progress, pageCache.get(cacheKey)));
    }
}

