/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costestablished;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.calc.helper.CalcMutexHelper;
import kd.macc.cad.business.update.CostUpdateEstablishedHelper;
import kd.macc.cad.business.update.CostUpdateTask;
import kd.macc.cad.common.dto.UpdateParam;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.thread.TaskType;
import kd.macc.cad.common.thread.ThreadHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.formplugin.costestablished.PreUpdateCalcTask;

public class UpdateWizardPlugin
extends AbstractFormPlugin
implements ProgresssListener,
ClickListener,
IConfirmCallBack {
    private Log logger = LogFactory.getLog(UpdateWizardPlugin.class);
    private static final String[] LIST_NAMES1 = new String[]{"c", "s", "p"};
    private static final String[] LIST_NAMES2 = new String[]{"a", "b", "n"};
    private static final String COSTUPDATEID = "costupdateid";
    private static final String PREPROGRESS = "preprogress";

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        ProgressBar progressBar = (ProgressBar)view.getControl("progresspre");
        progressBar.start();
        this.initWizard(view);
        this.getView().setEnable(Boolean.FALSE, new String[]{"btnnext"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnprerun", "btnnext", "btnrun", "btncomplate"});
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbaraprpt"});
        ProgressBar progressPreBar = (ProgressBar)this.getView().getControl("progresspre");
        progressPreBar.addProgressListener((ProgresssListener)this);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progress");
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        boolean flag;
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        if ("btnnext".equals(source.getKey()) && !(flag = CostUpdateHelper.hasUpdatePerm((String)"cad_updatewizard"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6b64\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UpdateWizardPlugin_22", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnprerun": {
                break;
            }
            case "btnnext": {
                this.initUpdateStep();
                break;
            }
            case "btnrun": {
                break;
            }
            case "btncomplate": {
                String taskId = this.getPageCache().get("taskid");
                if (CadEmptyUtils.isEmpty((String)taskId)) break;
                this.openUpdateLog(Long.valueOf(taskId));
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "exportexcel": {
                this.showExportExcel();
                break;
            }
            case "costinforpt": 
            case "storageinforpt": 
            case "productinforpt": {
                Long updateBillId = (Long)this.getView().getFormShowParameter().getCustomParam(COSTUPDATEID);
                ReportShowParameter parameter = CostUpdateHelper.getReportShowParameter((String)evt.getItemKey(), (Long)updateBillId);
                if (parameter == null) break;
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
        }
    }

    public void onProgress(ProgressEvent arg) {
        String currentTab;
        this.logger.info("\u63d2\u4ef6\u4e2d\u7684PageId:{}", (Object)this.getView().getPageId());
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        switch (currentTab = tab.getCurrentTab()) {
            case "tabpageap": {
                String progress = this.getPageCache().get(PREPROGRESS);
                this.logger.info("\u63d2\u4ef6\u4e2d\u7684Grogress:{}", (Object)progress);
                if ("100".equals(progress)) {
                    ProgressBar progressBar = (ProgressBar)this.getView().getControl("progresspre");
                    progressBar.setPercent(100);
                    progressBar.stop();
                    this.showPreUpdateResult();
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flexpretip"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flexpreresult"});
                    this.getView().setEnable(Boolean.valueOf(this.isExistUpdateData()), new String[]{"btnnext"});
                    break;
                }
                if ("-1".equals(progress)) {
                    ProgressBar progressBar = (ProgressBar)this.getView().getControl("progresspre");
                    progressBar.stop();
                    Label lblPreTip = (Label)this.getView().getControl("lblpretip");
                    lblPreTip.setText(ResManager.loadKDString((String)"\u9884\u66f4\u65b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u8be2\u65e5\u5fd7\u8fdb\u884c\u95ee\u9898\u5206\u6790\u3002", (String)"UpdateWizardPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.modifyTip(arg, CadEmptyUtils.isEmpty((String)progress) ? Integer.valueOf(0) : Integer.valueOf(progress));
                break;
            }
            case "tabpageap1": {
                String cacheProgress = this.getPageCache().get("progress");
                String errTip = this.getPageCache().get("tip_fail");
                if ("100".equals(cacheProgress)) {
                    ProgressBar progressBar = (ProgressBar)this.getView().getControl("progress");
                    progressBar.setPercent(100);
                    progressBar.stop();
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btnrun"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"btncomplate"});
                    this.showUpdateResult();
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flextip"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flexresult"});
                    break;
                }
                if (!CadEmptyUtils.isEmpty((String)errTip)) {
                    ProgressBar progressBar = (ProgressBar)this.getView().getControl("progress");
                    progressBar.setPercent(100);
                    progressBar.stop();
                    this.getView().showErrorNotification(errTip);
                    break;
                }
                this.modifyStep(arg, CadEmptyUtils.isEmpty((String)cacheProgress) ? Integer.valueOf(0) : Integer.valueOf(cacheProgress));
                break;
            }
        }
    }

    private void modifyStep(ProgressEvent arg, Integer progress) {
        if (progress < 20) {
            this.getModel().setValue("runresult", (Object)"C", 0);
            this.getModel().setValue("runresult", (Object)"A", 1);
            this.getModel().setValue("runresult", (Object)"A", 2);
            this.getModel().setValue("runresult", (Object)"A", 3);
        } else if (progress < 60) {
            this.getModel().setValue("runresult", (Object)"D", 0);
            this.getModel().setValue("runresult", (Object)"C", 1);
            this.getModel().setValue("runresult", (Object)"A", 2);
            this.getModel().setValue("runresult", (Object)"A", 3);
        } else if (progress < 80) {
            this.getModel().setValue("runresult", (Object)"D", 0);
            this.getModel().setValue("runresult", (Object)"D", 1);
            this.getModel().setValue("runresult", (Object)"C", 2);
            this.getModel().setValue("runresult", (Object)"A", 3);
        } else if (progress < 100) {
            this.getModel().setValue("runresult", (Object)"D", 0);
            this.getModel().setValue("runresult", (Object)"D", 1);
            this.getModel().setValue("runresult", (Object)"D", 2);
            this.getModel().setValue("runresult", (Object)"C", 3);
        }
        this.getView().updateView("entryentity");
        Label lblPrePencent = (Label)this.getView().getControl("lblpencent");
        lblPrePencent.setText(progress + "%");
        arg.setProgress(progress.intValue());
    }

    private void modifyTip(ProgressEvent arg, Integer progress) {
        String tip = "";
        switch (progress) {
            case 0: {
                tip = ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u4e2d..", (String)"UpdateWizardPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                break;
            }
            case 5: {
                tip = ResManager.loadKDString((String)"\u6b63\u5728\u6e05\u9664\u7533\u8bf7\u5355\u4e0e\u786e\u8ba4\u5355\u95f4\u5173\u7cfb\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"UpdateWizardPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                break;
            }
            case 10: {
                tip = ResManager.loadKDString((String)"\u68c0\u67e5\u662f\u5426\u6765\u6e90\u4e8e\u201c\u5feb\u901f\u66f4\u65b0\u201d...", (String)"UpdateWizardPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                break;
            }
            case 20: {
                tip = ResManager.loadKDString((String)"\u5feb\u901f\u66f4\u65b0\u8c03\u7528\u5377\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"UpdateWizardPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                break;
            }
            case 40: {
                tip = ResManager.loadKDString((String)"\u5f53\u524d\u6e90\u6210\u672c\u7c7b\u578b\u4e0b\uff0c\u6539\u52a8\u7684\u57fa\u7840\u8d44\u6599\u8fdb\u884c\u5377\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"UpdateWizardPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                break;
            }
            case 60: {
                tip = ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u6807\u51c6\u6210\u672c\u8ba1\u7b97\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"UpdateWizardPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                break;
            }
            case 80: {
                tip = ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u66f4\u65b0\u5dee\u5f02\u8ba1\u7b97\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"UpdateWizardPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                break;
            }
            case 90: {
                tip = ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u4e0e\u786e\u8ba4\u5355\u5df2\u5efa\u7acb\u5173\u7cfb\u3002", (String)"UpdateWizardPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                break;
            }
            case 100: {
                tip = ResManager.loadKDString((String)"\u9884\u66f4\u65b0\u5b8c\u6210", (String)"UpdateWizardPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                break;
            }
            default: {
                tip = ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u4e2d...", (String)"UpdateWizardPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            }
        }
        Label lblPreTip = (Label)this.getView().getControl("lblpretip");
        lblPreTip.setText(tip);
        Label lblPrePencent = (Label)this.getView().getControl("lblprepencent");
        lblPrePencent.setText(progress + "%");
        this.getView().updateView("lblpretip");
        arg.setProgress(progress.intValue());
    }

    private void initWizard(IFormView view) {
        Object[] dates;
        Long costUpdateId = (Long)view.getFormShowParameter().getCustomParam(COSTUPDATEID);
        if (costUpdateId == null) {
            this.filternull();
            return;
        }
        DynamicObject updateBill = BusinessDataServiceHelper.loadSingle((Object)costUpdateId, (String)"cad_costupdatenew");
        Label labBillNo = (Label)this.getView().getControl("labbillno");
        labBillNo.setText(updateBill.getString("billno"));
        Label labsrccosttype = (Label)this.getView().getControl("labsrccosttype");
        labsrccosttype.setText(updateBill.getString("srccosttype.name"));
        Label labtarcosttype = (Label)this.getView().getControl("labtarcosttype");
        labtarcosttype.setText(updateBill.getString("targetcosttype.name"));
        StringBuilder sg = new StringBuilder();
        DynamicObjectCollection attachTargetCostTypes = updateBill.getDynamicObjectCollection("attachtargetcosttype");
        for (DynamicObject attachTargetCostType : attachTargetCostTypes) {
            DynamicObject costType = attachTargetCostType.getDynamicObject("fbasedataid");
            sg.append("\u3001");
            sg.append(costType.getString("name"));
        }
        if (sg.length() > 0) {
            Label labAttCostType = (Label)this.getControl("labattcosttype");
            labAttCostType.setText(sg.substring(1));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labattcosttype"});
        }
        Label labcurrency = (Label)this.getView().getControl("labcurrency");
        labcurrency.setText(updateBill.getString("srccosttype.currency.name"));
        String effectTime = null;
        Boolean isUpdateByPeriod = updateBill.getDynamicObject("period") != null && CostUpdateHelper.isUpdateByPeriod((Long)updateBill.getLong("targetcosttype.id"));
        if (Boolean.TRUE.equals(isUpdateByPeriod) && !CadEmptyUtils.isEmpty((Object[])(dates = PeriodHelper.getPeriodStartAndEndTime((Long)updateBill.getLong("period.id")))) && dates.length == 2) {
            effectTime = DateUtils.formatDate((Date)dates[0], (String)"yyyy-MM-dd HH:mm:ss");
            this.logger.info(String.format("\u6309\u671f\u66f4\u65b0%s", dates[0]));
        }
        if (CadEmptyUtils.isEmpty(effectTime)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labeleffecttime", "labeffecttime"});
        } else {
            Label labeffecttime = (Label)this.getView().getControl("labeffecttime");
            labeffecttime.setText(effectTime);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpreresult"});
        UpdateParam updateParam = new UpdateParam();
        updateParam.setRc(RequestContext.get());
        updateParam.setPageId(view.getPageId());
        boolean isQuickUpdate = (Boolean)this.getView().getFormShowParameter().getCustomParam("quickUpdateFlag");
        isQuickUpdate = isQuickUpdate || updateBill.getBoolean("isquickupdate");
        updateParam.setQuickUpdateFlag(Boolean.valueOf(isQuickUpdate));
        if (isQuickUpdate) {
            updateParam.setIsTrackUpdate(Boolean.valueOf(false));
        }
        updateParam.setIsPurMat((Boolean)this.getView().getFormShowParameter().getCustomParam("isPurMat"));
        updateParam.setSrcCostTypeId(Long.valueOf(updateBill.getLong("srccosttype.id")));
        updateParam.setUpdatBillIds((List)Lists.newArrayList((Object[])new Long[]{updateBill.getLong("id")}));
        updateParam.setSourceBillIds((List)this.getView().getFormShowParameter().getCustomParam("toUpdatePKs"));
        PreUpdateCalcTask preTask = new PreUpdateCalcTask(updateParam);
        try {
            ThreadHelper.execute((Runnable)preTask, (TaskType)TaskType.CAD_COSTUPDATE_PROCESS);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
        }
    }

    private void filternull() {
        QFilter filter = new QFilter("id", "=", (Object)0L);
        for (String listName : LIST_NAMES1) {
            BillList billList = (BillList)this.getView().getControl("billlistap" + listName);
            FilterParameter parameter = new FilterParameter();
            parameter.getQFilters().add(filter);
            billList.setClientQueryFilterParameter(parameter);
            billList.refreshData();
        }
    }

    private void showPreUpdateResult() {
        long time = System.currentTimeMillis();
        Long updateBillId = (Long)this.getView().getFormShowParameter().getCustomParam(COSTUPDATEID);
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)updateBillId)};
        String[] listNames = LIST_NAMES1;
        DynamicObject updateBill = QueryServiceHelper.queryOne((String)"cad_costupdatenew", (String)"updatebillid", (QFilter[])filters);
        if (updateBill == null || CadEmptyUtils.isEmpty((Long)updateBill.getLong("updatebillid"))) {
            for (String listName : listNames) {
                BillList billList = (BillList)this.getView().getControl("billlistap" + listName);
                billList.clearData();
            }
            this.filternull();
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnprerun", "btnnext"});
            return;
        }
        if (CostUpdateHelper.isEnabledUpdate((Long)updateBill.getLong("updatebillid"))) {
            this.filternull();
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnprerun", "btnnext"});
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5728T_IM_INVDBPARAM\u8868\u914d\u7f6e\u66f4\u65b0\u6700\u5927\u91cf\u3002", (String)"UpdateWizardPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("id", "=", (Object)updateBill.getLong("updatebillid"));
        for (String listName : listNames) {
            BillList billList = (BillList)this.getView().getControl("billlistap" + listName);
            FilterParameter parameter = new FilterParameter();
            parameter.getQFilters().add(filter);
            billList.setClientQueryFilterParameter(parameter);
            billList.refreshData();
        }
        this.logger.info(String.format("\u52a0\u8f7d\u786e\u8ba4\u5355\u8017\u65f6%s\u6beb\u79d2", System.currentTimeMillis() - time));
    }

    private void showUpdateResult() {
        long time = System.currentTimeMillis();
        Long updateBillId = (Long)this.getView().getFormShowParameter().getCustomParam(COSTUPDATEID);
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)updateBillId)};
        String[] listNames = LIST_NAMES2;
        DynamicObject updateBill = QueryServiceHelper.queryOne((String)"cad_costupdatenew", (String)"updatebillid", (QFilter[])filters);
        if (updateBill == null || CadEmptyUtils.isEmpty((Long)updateBill.getLong("updatebillid"))) {
            for (String listName : listNames) {
                BillList billList = (BillList)this.getView().getControl("billlistap" + listName);
                billList.clearData();
            }
            return;
        }
        QFilter filter = new QFilter("id", "=", (Object)updateBill.getLong("updatebillid"));
        for (String listName : listNames) {
            BillList billList = (BillList)this.getView().getControl("billlistap" + listName);
            FilterParameter parameter = new FilterParameter();
            parameter.getQFilters().add(filter);
            billList.setClientQueryFilterParameter(parameter);
            billList.refreshData();
        }
        this.logger.info(String.format("\u6b63\u5f0f\u66f4\u65b0\u52a0\u8f7d\u786e\u8ba4\u5355\u8017\u65f6%s\u6beb\u79d2", System.currentTimeMillis() - time));
    }

    private boolean isExistUpdateData() {
        Long updateBillId = (Long)this.getView().getFormShowParameter().getCustomParam(COSTUPDATEID);
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)updateBillId)};
        DynamicObject updateBill = QueryServiceHelper.queryOne((String)"cad_costupdatenew", (String)"updatebillid", (QFilter[])filters);
        if (updateBill == null) {
            return false;
        }
        return !CadEmptyUtils.isEmpty((Long)updateBill.getLong("updatebillid"));
    }

    private void showExportExcel() {
        Long updatebillId = (Long)this.getView().getFormShowParameter().getCustomParam(COSTUPDATEID);
        DynamicObject updateBill = BusinessDataServiceHelper.loadSingle((Object)updatebillId, (String)"cad_costupdatenew");
        if (updateBill == null) {
            return;
        }
        Long establishedId = updateBill.getLong("updatebillid");
        if (CadEmptyUtils.isEmpty((Long)establishedId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5f15\u51fa\u7684\u6570\u636e\u3002", (String)"UpdateWizardPlugin_23", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cad_costupdate_export");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("fileName", (Object)ResManager.loadKDString((String)"\u9884\u66f4\u65b0\u6570\u636e\u5bfc\u51fa", (String)"UpdateWizardPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("type", (Object)"all");
        showParameter.setCustomParam("pageid", (Object)this.getView().getPageId());
        showParameter.setCustomParam("settingkey", (Object)this.getView().getFormShowParameter().getSettingKey());
        showParameter.setCustomParam("updatebillid", (Object)((Long)this.getView().getFormShowParameter().getCustomParam(COSTUPDATEID)));
        this.getView().showForm(showParameter);
    }

    private void initUpdateStep() {
        String lockErr;
        this.getModel().beginInit();
        this.getModel().deleteEntryData("entryentity");
        List<String> steps = Arrays.asList(ResManager.loadKDString((String)"\u5dee\u5f02\u8ba1\u7b97", (String)"UpdateWizardPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5", (String)"UpdateWizardPlugin_17", (String)"macc-cad-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0", (String)"UpdateWizardPlugin_18", (String)"macc-cad-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e93\u5b58\u6210\u672c\u66f4\u65b0", (String)"UpdateWizardPlugin_19", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        for (String step : steps) {
            int curIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("stepname", (Object)step, curIndex);
            this.getModel().setValue("runresult", (Object)"A", curIndex);
        }
        this.getModel().endInit();
        IFormView view = this.getView();
        view.updateView("entryentity");
        view.setVisible(Boolean.FALSE, new String[]{"flexresult"});
        view.setEnable(Boolean.FALSE, new String[]{"btncomplate"});
        Long updateBillId = (Long)this.getView().getFormShowParameter().getCustomParam(COSTUPDATEID);
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)updateBillId)};
        DynamicObject updateBill = BusinessDataServiceHelper.loadSingle((String)"cad_costupdatenew", (String)"srccosttype,targetcosttype,attachtargetcosttype,iscalccurlevel,isquickupdate", (QFilter[])filters);
        if (updateBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u66f4\u65b0\u7684\u6570\u636e\u3002", (String)"UpdateWizardPlugin_24", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> tarCostTypeIds = new HashSet<Long>(1);
        tarCostTypeIds.add(updateBill.getLong("targetcosttype.id"));
        DynamicObjectCollection attachTargetCostTypes = updateBill.getDynamicObjectCollection("attachtargetcosttype");
        for (DynamicObject attachTargetCostType : attachTargetCostTypes) {
            tarCostTypeIds.add(attachTargetCostType.getDynamicObject("fbasedataid").getLong("id"));
        }
        if (Boolean.FALSE.equals(updateBill.getBoolean("iscalccurlevel"))) {
            tarCostTypeIds.add(updateBill.getLong("srccosttype.id"));
        }
        if (StringUtils.isNotEmpty((String)(lockErr = CalcMutexHelper.checkAndRequireXMutexAll((String)"update", tarCostTypeIds)))) {
            this.getView().showErrorNotification(lockErr);
            return;
        }
        ProgressBar progressBar = (ProgressBar)view.getControl("progress");
        progressBar.start();
        UpdateParam updateParam = new UpdateParam();
        updateParam.setRc(RequestContext.get());
        updateParam.setPageId(view.getPageId());
        boolean quickUpdateFlag = (Boolean)this.getView().getFormShowParameter().getCustomParam("quickUpdateFlag");
        quickUpdateFlag = quickUpdateFlag || updateBill.getBoolean("isquickupdate");
        updateParam.setQuickUpdateFlag(Boolean.valueOf(quickUpdateFlag));
        updateParam.setIsPurMat((Boolean)view.getFormShowParameter().getCustomParam("isPurMat"));
        updateParam.setSrcCostTypeId(Long.valueOf(updateBill.getLong("srccosttype.id")));
        updateParam.setUpdatBillIds((List)Lists.newArrayList((Object[])new Long[]{updateBillId}));
        updateParam.setSourceBillIds((List)this.getView().getFormShowParameter().getCustomParam("toUpdatePKs"));
        Tuple updateWay = CostUpdateEstablishedHelper.getUpdateWay((Long)updateBillId);
        this.logger.info(String.format("\u66f4\u65b0\u7533\u8bf7\u5355%s,\u8ddf\u8e2a\u53f7\u66f4\u65b0=%s,\u914d\u7f6e\u53f7\u66f4\u65b0=%s", updateBillId, updateWay.item1, updateWay.item2));
        updateParam.setIsTrackUpdate((Boolean)updateWay.item1);
        updateParam.setIsConfigUpdate((Boolean)updateWay.item2);
        CostUpdateTask updateTask = new CostUpdateTask(updateParam);
        try {
            ThreadHelper.execute((Runnable)updateTask, (TaskType)TaskType.CAD_COSTUPDATE);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
        }
    }

    private void openUpdateLog(Long taskId) {
        BillShowParameter bill = new BillShowParameter();
        bill.setFormId("cad_calctaskrecord");
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.MainNewTabPage);
        bill.setOpenStyle(style);
        bill.setStatus(OperationStatus.VIEW);
        bill.setPkId((Object)taskId);
        bill.setHasRight(true);
        bill.setCaption(ResManager.loadKDString((String)"\u66f4\u65b0\u62a5\u544a", (String)"UpdateWizardPlugin_21", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)bill);
        this.getView().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkMuteAndAddLock(Set<Long> accountIds, Set<Long> costTypeIds) {
        boolean cancelFirstLock = false;
        String lockErr = "";
        try {
            lockErr = CalcMutexHelper.checkAndRequireXMutexAll((String)"update", accountIds);
            if (StringUtils.isNotEmpty((String)lockErr)) {
                String string = lockErr;
                return string;
            }
            lockErr = CalcMutexHelper.checkAndRequireXMutexAll((String)"update", costTypeIds);
            if (StringUtils.isNotEmpty((String)lockErr)) {
                cancelFirstLock = true;
            }
        }
        finally {
            if (cancelFirstLock) {
                CalcMutexHelper.releaseXMutex((String)"update", accountIds);
            }
        }
        return lockErr;
    }
}

