/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costobject;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.base.BaseManuorgListPlugin;

public abstract class BaseCostObjectListPlugin
extends BaseManuorgListPlugin {
    private FilterContainerInitArgs filterContainerInitArgs = null;
    protected String ORG_FIELD = null;
    protected String PROORG_FIELD = null;
    protected String COSTCENTER_FIELD = null;
    protected String BIZDATE_FIELD = null;

    protected List<ComboItem> getORGComboItemList() {
        return OrgHelper.getOrgComboItems((String)this.getBillEntityId(), (String)"47150e89000000ac", (String)this.getView().getFormShowParameter().getAppId());
    }

    @Override
    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    protected List<ComboItem> getCostCenterComboItemListBy(String orgId) {
        QFilter orgdutyFilter;
        QFilter enableFilter;
        QFilter filter = null;
        filter = !CadEmptyUtils.isEmpty((String)orgId) ? new QFilter("accountorg", "=", (Object)Long.valueOf(orgId)) : new QFilter("accountorg", "=", (Object)0L);
        DynamicObjectCollection ccs = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])new QFilter[]{filter, enableFilter = new QFilter("enable", "=", (Object)"1"), orgdutyFilter = new QFilter("orgduty", "=", (Object)4L)}, (String)"number asc");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)ccs)) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    protected List<ComboItem> getCostCenterComboItemListByManuOrg(String orgId, String manuOrgId) {
        QFilter filter;
        if (!CadEmptyUtils.isEmpty((String)orgId)) {
            ArrayList<Long> manuOrgList = new ArrayList<Long>();
            if (!CadEmptyUtils.isEmpty((String)manuOrgId)) {
                manuOrgList.add(Long.parseLong(manuOrgId));
            }
            filter = CostCenterHelper.getCostCenterByMultFactoryForList((long)Long.parseLong(orgId), manuOrgList, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
        } else {
            filter = new QFilter("accountorg", "=", (Object)0L);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter orgdutyFilter = new QFilter("orgduty", "=", (Object)4L);
        DynamicObjectCollection ccs = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])new QFilter[]{filter, enableFilter, orgdutyFilter});
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)ccs)) {
            return acctItems;
        }
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (hasPermAccountOrgIds != null && hasPermAccountOrgIds.size() > 0) {
            this.getPageCache().put("hasPermOrg", "true");
        } else {
            this.getPageCache().remove("hasPermOrg");
        }
        this.updateOrgComboItem(args);
        if (OrgHelper.isOrgEnableMultiFactory((Long)(this.getPageCache().get(this.ORG_FIELD) == null ? 0L : Long.parseLong(this.getPageCache().get(this.ORG_FIELD))))) {
            this.updateProOrgComboItem(args);
        }
        this.updateCostCenterComboItem(args);
        CommonFilterColumn filterColumn = (CommonFilterColumn)args.getFilterColumn(this.BIZDATE_FIELD + ".name");
        if (filterColumn == null) {
            return;
        }
        List oldComboItems = filterColumn.getComboItems();
        if (oldComboItems != null && oldComboItems.size() > 0) {
            this.getPageCache().put("bizdate", "63");
        }
    }

    private void updateOrgComboItem(FilterContainerInitArgs args) {
        String org;
        String cacheKey;
        List<ComboItem> newComboItems;
        CommonFilterColumn filterColumn = (CommonFilterColumn)args.getFilterColumn(this.ORG_FIELD + ".name");
        if (filterColumn == null) {
            return;
        }
        List oldComboItems = filterColumn.getComboItems();
        if (oldComboItems != null) {
            oldComboItems.clear();
        }
        if (CadEmptyUtils.isEmpty(newComboItems = this.getCacheComboItems(cacheKey = "ComboItem" + this.ORG_FIELD))) {
            newComboItems = this.getORGComboItemList();
            this.setCacheComboItems(cacheKey, newComboItems);
        }
        if (CadEmptyUtils.isEmpty(newComboItems)) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String source = (String)formShowParameter.getCustomParam("source");
        if ("HyperLink".equals(source) && !CadEmptyUtils.isEmpty((String)(org = formShowParameter.getCustomParam("org") + ""))) {
            this.getPageCache().put(this.ORG_FIELD, org);
        }
        filterColumn.setComboItems(newComboItems);
        String orgId = this.getPageCache().get(this.ORG_FIELD);
        if (StringUtils.isEmpty((String)orgId)) {
            orgId = CadEmptyUtils.isEmpty(newComboItems) ? null : newComboItems.get(0).getValue();
            this.getPageCache().put(this.ORG_FIELD, orgId);
        }
        if ((orgId == null || "0".equals(orgId) || "null".equals(orgId)) && this.getPageCache().get("hasPermOrg") == null) {
            ArrayList emptyList = new ArrayList(10);
            filterColumn.setComboItems(emptyList);
        } else {
            filterColumn.setDefaultValue(orgId);
        }
    }

    private void updateCostCenterComboItem(FilterContainerInitArgs args) {
        CommonFilterColumn filterColumn = (CommonFilterColumn)args.getFilterColumn(this.COSTCENTER_FIELD + ".name");
        if (filterColumn == null) {
            return;
        }
        List oldComboItems = filterColumn.getComboItems();
        oldComboItems.clear();
        String orgId = this.getPageCache().get(this.ORG_FIELD);
        if (StringUtils.isEmpty((String)orgId) || "null".equals(orgId)) {
            return;
        }
        String manuOrgId = this.getPageCache().get("manuorg");
        String cacheKey = StringUtils.isNotEmpty((String)manuOrgId) ? "ComboItem-costcenter-" + orgId + "-" + manuOrgId : "ComboItem-costcenter-" + orgId;
        List<ComboItem> newComboItems = this.getCostCenterComboItemListByManuOrg(orgId, manuOrgId);
        this.setCacheComboItems(cacheKey, newComboItems);
        filterColumn.setComboItems(newComboItems);
        String cacheId = this.getPageCache().get("costcenter");
        if (StringUtils.isEmpty((String)cacheId)) {
            this.getPageCache().put("costcenter", "");
            filterColumn.setDefaultValue("");
        }
    }

    private void updateProOrgComboItem(FilterContainerInitArgs args) {
        CommonFilterColumn filterColumn = (CommonFilterColumn)args.getFilterColumn(this.PROORG_FIELD + ".name");
        if (filterColumn == null) {
            return;
        }
        List oldComboItems = filterColumn.getComboItems();
        oldComboItems.clear();
        String orgId = this.getPageCache().get(this.ORG_FIELD);
        if (StringUtils.isEmpty((String)orgId) || "null".equals(orgId)) {
            return;
        }
        String cacheKey = "ComboItem-manuorg-" + orgId;
        List newComboItems = this.getCacheComboItems(cacheKey);
        if (CadEmptyUtils.isEmpty(newComboItems)) {
            newComboItems = ImportServiceHelper.getPermProOrgsByAccOrg((Long)Long.parseLong(orgId), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            this.setCacheComboItems(cacheKey, newComboItems);
        }
        if (CadEmptyUtils.isEmpty(newComboItems)) {
            return;
        }
        filterColumn.setComboItems(newComboItems);
        String cacheId = this.getPageCache().get("manuorg");
        if (StringUtils.isEmpty((String)cacheId)) {
            this.getPageCache().put("manuorg", "");
            filterColumn.setDefaultValue("");
        }
    }

    private void setCacheComboItems(String key, List<ComboItem> newComboItems) {
        this.getPageCache().put(key, SerializationUtils.toJsonString(newComboItems));
    }

    private List<ComboItem> getCacheComboItems(String key) {
        String cache = this.getPageCache().get(key);
        if (StringUtils.isEmpty((String)cache)) {
            return new ArrayList<ComboItem>();
        }
        List list = (List)SerializationUtils.fromJsonString((String)cache, List.class);
        if (CadEmptyUtils.isEmpty((List)list)) {
            return new ArrayList<ComboItem>();
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        for (Map map : list) {
            ComboItem item = new ComboItem();
            Map captionMap = (Map)map.get("caption");
            item.setCaption(new LocaleString((String)captionMap.values().toArray()[0]));
            item.setValue((String)map.get("value"));
            comboItems.add(item);
        }
        return comboItems;
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        super.filterContainerSearchClick(e);
        Map filterValues = e.getSearchClickEvent().getFilterValues();
        if (!filterValues.containsKey("customfilter")) {
            return;
        }
        List customfilter = (List)filterValues.get("customfilter");
        if (customfilter == null || customfilter.isEmpty()) {
            return;
        }
        for (int i = 0; i < customfilter.size(); ++i) {
            List vals;
            Map map = (Map)customfilter.get(i);
            List names = (List)map.get("FieldName");
            if (String.format("%s.id", this.ORG_FIELD).equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) continue;
                String orgId = String.valueOf(vals.get(0));
                this.getPageCache().put(this.ORG_FIELD, StringUtils.isEmpty((String)orgId) ? "0" : orgId);
                this.getPageCache().remove("manuorg");
                this.getPageCache().remove("costcenter");
                this.filterContainerInit(this.filterContainerInitArgs);
            }
            if (String.format("%s.id", "costcenter").equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) continue;
                this.getPageCache().put("costcenter", String.valueOf(vals.get(0)));
            }
            if (String.format("%s.id", "manuorg").equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) continue;
                this.getPageCache().put("manuorg", String.valueOf(vals.get(0)));
                this.filterContainerInit(this.filterContainerInitArgs);
            }
            if (!String.format("%s.id", "bizdate").equals(String.valueOf(names.get(0))) || (vals = (List)map.get("Value")) == null || vals.isEmpty()) continue;
            this.getPageCache().put("bizdate", String.valueOf(vals.get(0)));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        String[] split;
        this.getPageCache().put("filterContainerBeforeF7Select", e.getFieldName());
        String fieldName = e.getFieldName();
        String accountorgId = this.getPageCache().get(this.ORG_FIELD);
        if (CadEmptyUtils.isEmpty((String)accountorgId)) {
            accountorgId = "0";
        }
        if (fieldName.startsWith(this.ORG_FIELD)) {
            List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            e.getQfilters().add(new QFilter("id", "in", (Object)hasPermAccountOrgIds));
        }
        if (fieldName.startsWith("costcenter") && (split = fieldName.split("\\.")).length <= 2) {
            QFilter filter;
            String orgId = this.getPageCache().get(this.ORG_FIELD);
            if (!StringUtils.isEmpty((String)orgId) && !"0".equals(orgId)) {
                String manuOrgId = this.getPageCache().get(this.PROORG_FIELD);
                ArrayList<Long> manuOrgList = new ArrayList<Long>();
                if (!CadEmptyUtils.isEmpty((String)manuOrgId)) {
                    manuOrgList.add(Long.parseLong(manuOrgId));
                }
                filter = CostCenterHelper.getCostCenterByMultFactoryForList((long)Long.parseLong(orgId), manuOrgList, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
            } else {
                List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId()).getHasPermOrgs();
                List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
                filter = new QFilter("accountorg", "in", (Object)orgIds);
            }
            e.getQfilters().add(new QFilter("accountorg", "=", (Object)Long.parseLong(accountorgId)).and(new QFilter("enable", "=", (Object)"1")));
            e.getQfilters().add(new QFilter("orgduty", "=", (Object)4L));
            e.getQfilters().add(filter);
        }
        if (fieldName.startsWith("manuorg")) {
            List userHasPermProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.parseLong(accountorgId), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            e.getQfilters().add(new QFilter("id", "in", (Object)userHasPermProOrgsByAccOrg));
        }
        super.filterContainerBeforeF7Select(e);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter bsp = e.getParameter();
        String acctOrg = this.getPageCache().get(this.ORG_FIELD);
        String costCenter = this.getPageCache().get("costcenter");
        bsp.setCustomParam(this.ORG_FIELD, (Object)acctOrg);
        bsp.setCustomParam("costcenter", (Object)costCenter);
    }

    protected QFilter getCostCenterQFilter() {
        String orgId;
        List<ComboItem> costCenterComboItems;
        QFilter qfCostCenter = null;
        String costCenterId = this.getPageCache().get("costcenter");
        if (StringUtils.isEmpty((String)costCenterId) && (costCenterComboItems = this.getCostCenterComboItemListBy(orgId = this.getPageCache().get(this.ORG_FIELD))) != null) {
            List costCenterIds = costCenterComboItems.stream().map(o -> Long.parseLong(o.getValue())).collect(Collectors.toList());
            qfCostCenter = new QFilter("costcenter", "in", costCenterIds);
        }
        return qfCostCenter;
    }

    protected QFilter getManuOrgQFilter() {
        Long orgIdL;
        String orgId;
        QFilter manuOrgQf = null;
        String manuOrgId = this.getPageCache().get("manuorg");
        if (StringUtils.isEmpty((String)manuOrgId) && !StringUtils.isEmpty((String)(orgId = this.getPageCache().get(this.ORG_FIELD))) && OrgHelper.isOrgEnableMultiFactory((Long)(orgIdL = Long.valueOf(orgId)))) {
            List userHasPermProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgIdL, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (!CadEmptyUtils.isEmpty((List)userHasPermProOrgsByAccOrg)) {
                userHasPermProOrgsByAccOrg.add(0L);
                manuOrgQf = new QFilter("manuorg", "in", (Object)userHasPermProOrgsByAccOrg);
            } else {
                manuOrgQf = new QFilter("manuorg", "=", (Object)0L);
            }
        }
        return manuOrgQf;
    }

    private Object getFilterVal(String field, FilterContainerSearchClickArgs e) {
        Map map = e.getFilterModel().getSelectedValues();
        Object fieldId = map.get(field);
        if (fieldId == null) {
            fieldId = e.getFilterValue(field);
        }
        return fieldId;
    }

    protected String getInnerType(String accountOrg, String costCenter, String newTypeKey, String appNum) {
        String result = "";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!CadEmptyUtils.isEmpty((String)accountOrg)) {
            filters.add(new QFilter("accountorg", "=", (Object)Long.valueOf(accountOrg)));
        }
        if (!CadEmptyUtils.isEmpty((String)costCenter)) {
            filters.add(new QFilter("costcenter", "=", (Object)Long.valueOf(costCenter)));
        }
        QFilter appnumFilter = null;
        if (this.getView().getFormShowParameter().getAppId() != null) {
            appnumFilter = new QFilter("appnum", "=", (Object)appNum);
        }
        DynamicObject queryOne = null;
        if (!CadEmptyUtils.isEmpty(filters) && filters.size() == 2) {
            if (appnumFilter != null) {
                filters.add(appnumFilter);
            }
            if ((queryOne = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)newTypeKey, (QFilter[])filters.toArray(new QFilter[0]))) == null) {
                ArrayList<QFilter> filters2 = new ArrayList<QFilter>();
                filters2.add(new QFilter("accountorg", "=", (Object)Long.valueOf(accountOrg)));
                filters2.add(new QFilter("costcenter", "=", (Object)0L));
                if (appnumFilter != null) {
                    filters2.add(appnumFilter);
                }
                queryOne = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)newTypeKey, (QFilter[])filters2.toArray(new QFilter[0]));
            }
        }
        if (!CadEmptyUtils.isEmpty(filters) && filters.size() == 1) {
            DynamicObjectCollection query;
            if (appnumFilter != null) {
                filters.add(appnumFilter);
            }
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(query = QueryServiceHelper.query((String)"cad_sysparam", (String)newTypeKey, (QFilter[])filters.toArray(new QFilter[0]))))) {
                for (DynamicObject dynamicObject : query) {
                    if (!"MANUAL".equals(dynamicObject.getString(newTypeKey))) continue;
                    return "MANUAL";
                }
                queryOne = (DynamicObject)query.get(0);
            }
        }
        if (queryOne != null) {
            result = queryOne.getString(newTypeKey);
        }
        return result;
    }
}

