/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costobject;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.config.engine.CollConfigEngine;
import kd.macc.cad.business.config.engine.TransferResult;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostObjectEditPlugin
extends AbstractBasePlugIn {
    private Log logger = LogFactory.getLog(CostObjectEditPlugin.class);
    private static final String ISOUTSOURCE_CONFIRM = "isoutsourceconfirm";
    private static final String ISREWORK_CONFIRM = "isreworkconfirm";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"srcbillnumber"});
        this.addListener();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String appId = AppIdHelper.getCurAppNum((IFormView)this.getView());
        if ("sca".equals(appId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new"});
        }
        if ("eca".equals(appId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"uplook"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"multipartcc"});
    }

    public void initialize() {
        super.initialize();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "save": 
            case "submit": {
                String costCalMethod = (String)this.getModel().getValue("biztype");
                String originype = (String)this.getModel().getValue("originype");
                if (!CostObjectEnum.BIZTYPE_CU.getValue().equals(costCalMethod) || !"MANUAL".equals(originype)) break;
                DynamicObject costCenter = this.getModel().getDataEntity().getDynamicObject("costcenter");
                DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
                if (costCenter == null || org == null) {
                    this.logger.info("\u6210\u672c\u6838\u7b97\u6210\u672c\u4e2d\u5fc3\u548c\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
                    return;
                }
                DynamicObject objectRule = CostObjectHelper.getRuleBy((Object)org.getPkValue(), (Object)costCenter.getPkValue());
                if (objectRule == null) {
                    this.logger.info("\u6210\u672c\u6838\u7b97\u6ca1\u6709\u83b7\u53d6\u5230\u5bf9\u5e94\u89c4\u5219");
                    return;
                }
                String[] names = CostObjectHelper.getCostObjectName((DynamicObject)this.getModel().getDataEntity(), (String)objectRule.getString("rulenumberext"));
                this.getModel().setValue("billno", (Object)names[0]);
                this.getModel().setValue("name", (Object)names[1]);
            }
        }
    }

    protected void addListener() {
        BasedataEdit mat = (BasedataEdit)this.getControl("material");
        mat.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            filters.add(QFilter.of((String)"enableproduct =? or enableoutsource =?", (Object[])new Object[]{true, true}));
        });
        BasedataEdit matVer = (BasedataEdit)this.getControl("bomversion");
        matVer.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            DynamicObject material = this.getModel().getDataEntity().getDynamicObject("material");
            if (material != null) {
                filters.add(new QFilter("material", "=", material.getPkValue()));
            }
        });
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
        manuOrg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            Long org = this.getModel().getDataEntity().getDynamicObject("org").getLong("id");
            if (CadEmptyUtils.isEmpty((Long)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostObjectEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            filters.add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
        });
        BasedataEdit productGroup = (BasedataEdit)this.getControl("productgroup");
        productGroup.addBeforeF7SelectListener(evt -> {
            Map assistAffectPriceMatMap;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            Long org = this.getModel().getDataEntity().getLong("org.id");
            Long material = this.getModel().getDataEntity().getLong("material.id");
            Long bomversion = this.getModel().getDataEntity().getLong("bomversion.id");
            Long auxpty = this.getModel().getDataEntity().getLong("auxpty.id");
            if (!CadEmptyUtils.isEmpty((Long)org)) {
                filters.add(new QFilter("calorg", "=", (Object)org));
            }
            if (!CadEmptyUtils.isEmpty((Long)material)) {
                filters.add(new QFilter("entryentity.material", "=", (Object)material));
            }
            if (!CadEmptyUtils.isEmpty((Long)bomversion)) {
                filters.add(new QFilter("entryentity.matversion", "=", (Object)bomversion));
            }
            if (!CadEmptyUtils.isEmpty((Long)auxpty) && (assistAffectPriceMatMap = CostObjectHelper.getAssistAffectPriceMatMap(Collections.singleton(material), (Long)org)).containsKey(material) && ((Boolean)assistAffectPriceMatMap.get(material)).booleanValue()) {
                filters.add(new QFilter("entryentity.auxpty", "=", (Object)auxpty));
            }
            filters.add(new QFilter("grouptype", "=", (Object)"1"));
            Date date = new Date();
            filters.add(new QFilter("effectdate", "<=", (Object)date).and(new QFilter("expdate", ">=", (Object)date)).or(new QFilter("expdate", "is null", null)));
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void afterBindData(EventObject e) {
        BasedataEdit basedataEdit;
        super.afterBindData(e);
        String bizTypeStr = (String)this.getModel().getValue("biztype");
        bizTypeStr = StringUtils.isEmpty((String)bizTypeStr) ? CostObjectEnum.BIZTYPE_RO.getValue() : bizTypeStr;
        CostObjectEnum objectEnum = CostObjectEnum.getEnumByValue((String)bizTypeStr);
        this.changeViewFieldBy(objectEnum);
        this.changeEnableFieldBy(objectEnum);
        this.hideFields();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String costCalMethod = (String)this.getModel().getValue("biztype");
        if (CostObjectEnum.BIZTYPE_RO.getValue().equals(costCalMethod) && OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(org.getPkValue().toString()))) {
            basedataEdit = (BasedataEdit)this.getControl("manuorg");
            basedataEdit.setMustInput(true);
            basedataEdit.setVisible("manuorg", true);
        } else {
            basedataEdit = (BasedataEdit)this.getControl("manuorg");
            basedataEdit.setMustInput(false);
            basedataEdit.setVisible("manuorg", false);
        }
        if (CostObjectEnum.BIZTYPE_RO.getValue().equals(costCalMethod)) {
            basedataEdit = (TextEdit)this.getControl("srcbillnumber");
            basedataEdit.setMustInput(true);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"srcbillnumber"});
        } else {
            basedataEdit = (TextEdit)this.getControl("srcbillnumber");
            basedataEdit.setMustInput(false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"srcbillnumber"});
        }
        if (CostObjectEnum.BIZTYPE_SO.getValue().equals(costCalMethod)) {
            basedataEdit = (TextEdit)this.getControl("producenum");
            basedataEdit.setMustInput(true);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"producenum"});
        } else {
            basedataEdit = (TextEdit)this.getControl("producenum");
            basedataEdit.setMustInput(false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"producenum"});
        }
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        if (CostObjectEnum.BIZTYPE_RO.getValue().equals(costCalMethod)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"isoutsource"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"isrework"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isoutsource"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isrework"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        IFormView parentView;
        String status = this.getView().getFormShowParameter().getStatus().toString();
        if ("ADDNEW".equals(status)) {
            this.initFormDataAtNew();
            this.updateNumberAndName();
        }
        if ((parentView = this.getView().getParentView()) != null && this.getModel().getValue("costcenter") == null) {
            String costaccount = parentView.getPageCache().get("costcenter");
            this.getModel().setValue("costcenter", (Object)costaccount);
        }
        String costCalMethod = (String)this.getModel().getValue("biztype");
        if (!CostObjectEnum.BIZTYPE_FL.getValue().equals(costCalMethod)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"productgroup"});
        } else {
            this.getModel().setValue("producttype", null);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"producttype"});
        }
        this.changManuorgStatus();
    }

    private void changeEnableFieldBy(CostObjectEnum bizTypeEnum) {
        Boolean isSample = CostObjectEnum.BIZTYPE_SO.getValue().equals(bizTypeEnum.getValue()) ? Boolean.TRUE : Boolean.FALSE;
        this.getView().setEnable(Boolean.valueOf(isSample == false), new String[]{"weight"});
        if (isSample.booleanValue()) {
            this.getModel().setValue("weight", (Object)1);
        }
        Boolean isFL = CostObjectEnum.BIZTYPE_FL.getValue().equals(bizTypeEnum.getValue()) ? Boolean.TRUE : Boolean.FALSE;
        this.getView().setEnable(isFL, new String[]{"productgroup"});
    }

    private void hideFields() {
        int showCoActfeenocal;
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("aca".equals(appId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bizstatus"});
        }
        if ((showCoActfeenocal = CadBgParamUtils.getCadParamForInt((String)"isactfeenocal", (int)0)) == 1 && "sca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"isactfeenocal"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isactfeenocal"});
        }
    }

    private void initFormDataAtNew() {
        String manuOrgId;
        String costCenterId;
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String acctOrgId = (String)fsp.getCustomParam("org");
        if (StringUtils.isNotEmpty((String)acctOrgId)) {
            this.getModel().setValue("org", (Object)Long.parseLong(acctOrgId));
        }
        if (StringUtils.isNotEmpty((String)(costCenterId = (String)fsp.getCustomParam("costcenter")))) {
            this.getModel().setValue("costcenter", (Object)Long.parseLong(costCenterId));
        }
        if (StringUtils.isNotEmpty((String)(manuOrgId = (String)fsp.getCustomParam("manuorg")))) {
            this.getModel().setValue("manuorg", (Object)Long.parseLong(manuOrgId));
            this.getView().setEnable(Boolean.FALSE, new String[]{"manuorg"});
        }
        if (StringUtils.isEmpty((String)acctOrgId) || StringUtils.isEmpty((String)costCenterId)) {
            return;
        }
        DynamicObject ruleItem = CostObjectHelper.getRuleBy((Object)acctOrgId, (Object)costCenterId);
        if (ruleItem == null) {
            return;
        }
        this.getModel().setValue("costobjectrule", ruleItem.get("id"));
        this.getModel().setValue("biztype", (Object)ruleItem.getString("biztype"));
        this.getModel().setValue("rule", (Object)ruleItem.getString("rule"));
        String soType = ruleItem.getString("sotype");
        this.getModel().setValue("sotype", (Object)soType);
        if (CostObjectEnum.SOTYPE_SB.getValue().equals(soType)) {
            this.getModel().setValue("producenum", (Object)"000001");
        }
        this.getModel().setValue("bookdate", (Object)new Date());
    }

    public void click(EventObject e) {
        super.click(e);
        if (e.getSource() instanceof TextEdit) {
            TextEdit textEdit = (TextEdit)e.getSource();
            Boolean isoutsource = (Boolean)this.getModel().getValue("isoutsource");
            if ("srcbillnumber".equalsIgnoreCase(textEdit.getKey())) {
                this.showProBIllf7(isoutsource);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Boolean isoutsource = (Boolean)this.getModel().getValue("isoutsource");
        if (this.getPageCache().get("probill") != null) {
            return;
        }
        String oldIsOutSource = "";
        if (oldValue != null) {
            oldIsOutSource = String.valueOf(oldValue);
        }
        Object value = this.getModel().getValue("srcbillnumber");
        switch (e.getProperty().getName()) {
            case "material": {
                this.updateByMaterial((DynamicObject)newValue);
                break;
            }
            case "bomversion": {
                this.updateNumberAndName();
                break;
            }
            case "biztype": {
                this.changeViewFieldBy(CostObjectEnum.getEnumByValue((String)String.valueOf(newValue)));
                break;
            }
            case "srcbillnumber": {
                if (newValue == null) {
                    return;
                }
                this.showProBIllf7(isoutsource);
                this.updateNumberAndName();
                break;
            }
            case "producenum": {
                if (newValue == null) {
                    return;
                }
                String soType = (String)this.getModel().getValue("sotype");
                if (!CostObjectEnum.SOTYPE_SB.getValue().equals(soType)) break;
                this.updateNumberAndName();
                break;
            }
            case "org": {
                this.changManuorgStatus();
                break;
            }
            case "productgroup": {
                this.updateByProductGroup((DynamicObject)newValue);
                break;
            }
            case "auxpty": {
                Long org = this.getModel().getDataEntity().getLong("org.id");
                Long material = this.getModel().getDataEntity().getLong("material.id");
                if (CadEmptyUtils.isEmpty((Long)material)) {
                    return;
                }
                Map assistAffectPriceMatMap = CostObjectHelper.getAssistAffectPriceMatMap(Collections.singleton(material), (Long)org);
                if (!assistAffectPriceMatMap.containsKey(material) || !((Boolean)assistAffectPriceMatMap.get(material)).booleanValue()) break;
                this.getModel().setValue("productgroup", null);
                break;
            }
            case "isoutsource": {
                if (value == null || CadEmptyUtils.isEmpty((String)value.toString())) {
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u59d4\u5916\u5c06\u6e05\u7a7a\u6e90\u5355\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"CostObjectEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(ISOUTSOURCE_CONFIRM), null, oldIsOutSource);
                break;
            }
            case "isrework": {
                if (value == null || CadEmptyUtils.isEmpty((String)value.toString())) {
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u8fd4\u5de5\u5c06\u6e05\u7a7a\u6e90\u5355\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"CostObjectEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(ISREWORK_CONFIRM), null, oldIsOutSource);
            }
        }
        if (e.getProperty().getName().contains("auxpty")) {
            this.updateNumberAndName();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (ISOUTSOURCE_CONFIRM.equals(callBackId)) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.clearSourceBillsMsg();
            } else {
                Boolean oldIsOutSource = Boolean.valueOf(messageBoxClosedEvent.getCustomVaule());
                this.getModel().beginInit();
                this.getModel().setValue("isoutsource", (Object)oldIsOutSource);
                this.getModel().endInit();
                this.getView().updateView("isoutsource");
            }
        } else if (ISREWORK_CONFIRM.equals(callBackId)) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.clearSourceBillsMsg();
            } else {
                Boolean oldIsRework = Boolean.valueOf(messageBoxClosedEvent.getCustomVaule());
                this.getModel().beginInit();
                this.getModel().setValue("isrework", (Object)oldIsRework);
                this.getModel().endInit();
                this.getView().updateView("isrework");
            }
        }
    }

    private void clearSourceBillsMsg() {
        this.getModel().setValue("srcbillnumber", null);
        this.getModel().setValue("srcbillrow", null);
        this.getModel().setValue("material", null);
        this.getModel().setValue("bomversion", null);
        this.getModel().setValue("auxpty", null);
        this.getModel().setValue("productgroup", null);
        this.getModel().setValue("auxpty", null);
        this.getModel().setValue("configuredcode", null);
        this.getModel().setValue("tracknumber", null);
    }

    private void updateByProductGroup(DynamicObject productgroup) {
        QFilter matFilter;
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        QFilter groupFilter = new QFilter("id", "=", (Object)(productgroup == null ? 0L : productgroup.getLong("id")));
        DynamicObject productGroup = QueryServiceHelper.queryOne((String)"cad_productintogroup", (String)"entryentity.producttype producttype", (QFilter[])new QFilter[]{groupFilter, matFilter = new QFilter("entryentity.material", "=", (Object)(material == null ? 0L : material.getLong("id")))});
        if (productGroup != null) {
            this.getModel().setValue("producttype", (Object)productGroup.getString("producttype"));
        }
        this.getView().updateView("producttype");
    }

    private void showProBIllf7(Boolean isoutsource) {
        String entryEntity = "pom_mftorder_f7";
        if (isoutsource.booleanValue()) {
            entryEntity = "om_mftorder_f7";
        }
        String soType = (String)this.getModel().getValue("sotype");
        if (CostObjectEnum.SOTYPE_PB.getValue().equals(soType)) {
            try {
                MetadataServiceHelper.getDataEntityType((String)entryEntity);
            }
            catch (Exception e) {
                this.logger.error("\u67e5\u770b\u5931\u8d25\uff1a", (Throwable)e);
                String msg = isoutsource != false ? ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u6ca1\u6709\u6743\u9650\u67e5\u770b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostObjectEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u6ca1\u6709\u6743\u9650\u67e5\u770b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostObjectEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                return;
            }
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)entryEntity, (boolean)false, (int)2);
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "getProBill"));
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject cc = this.getModel().getDataEntity().getDynamicObject("costcenter");
            if (cc == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u4e2d\u5fc3\u3002", (String)"CostObjectEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            Boolean isrework = (Boolean)this.getModel().getValue("isrework");
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            DynamicObject manuorg = this.getModel().getDataEntity().getDynamicObject("manuorg");
            if (org == null) {
                return;
            }
            Long[] manuOrgIds = null;
            if (manuorg != null) {
                manuOrgIds = new Long[]{manuorg.getLong("id")};
            }
            Long[] costCenterIds = new Long[]{cc.getLong("id")};
            try {
                Map objRules = CostObjectHelper.getCostObjectRulesMap((Long)org.getLong("id"), Collections.singletonList(cc.getLong("id")));
                CollConfigEngine configEngine = CollConfigEngine.buildEngine((Long)org.getLong("id"), null, null, (Long[])manuOrgIds, (Long[])costCenterIds, (String)"cad_costobject", (Map)objRules, (String)this.getView().getFormShowParameter().getAppId());
                CollectReport collectReport = new CollectReport();
                TransferResult transferResult = configEngine.getTargetDynamicObject(collectReport, null, null);
                Map configSrcAndTargetBillMap = transferResult.getConfigSrcAndTargetBillMap();
                HashSet manuEntryIds = new HashSet(10);
                configSrcAndTargetBillMap.forEach((config, srcAndTargetBill) -> {
                    String sourcebill = config.getString("sourcebill.id");
                    if (isoutsource.booleanValue()) {
                        if (!"om_mftorder".equals(sourcebill)) {
                            return;
                        }
                        Set srcBills = srcAndTargetBill.keySet();
                        srcBills.forEach(src -> manuEntryIds.add(src.getLong("entryId")));
                    } else {
                        if (!"pom_mftorder".equals(sourcebill)) {
                            return;
                        }
                        Set srcBills = srcAndTargetBill.keySet();
                        srcBills.forEach(src -> manuEntryIds.add(src.getLong("entryId")));
                    }
                });
                QFilter idQf = new QFilter("id", "=", (Object)-1L);
                if (!CadEmptyUtils.isEmpty(manuEntryIds)) {
                    idQf = new QFilter("id", "in", manuEntryIds);
                }
                filters.add(idQf);
                lsp.getListFilterParameter().setQFilters(filters);
                this.getView().showForm((FormShowParameter)lsp);
            }
            catch (Exception e) {
                this.logger.error("\u6839\u636e\u914d\u7f6e\u65b9\u6848\u83b7\u53d6\u6e90\u5355\u6570\u636e\u51fa\u73b0\u9519\u8bef:", (Throwable)e);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u636e\u914d\u7f6e\u65b9\u6848\u83b7\u53d6\u6e90\u5355\u6570\u636e\u51fa\u73b0\u9519\u8bef\u3002", (String)"CostObjectEditPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "getProBill": {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)e.getReturnData();
                if (CadEmptyUtils.isEmpty((ListSelectedRowCollection)selectedRows)) {
                    return;
                }
                ListSelectedRow selectedRow = selectedRows.get(0);
                this.updateByProBill(selectedRow);
            }
        }
    }

    private void updateByProBill(ListSelectedRow selectedRow) {
        if (selectedRow == null) {
            return;
        }
        Boolean isOutSource = (Boolean)this.getModel().getValue("isoutsource");
        this.getPageCache().put("probill", "probill");
        QFilter filter = new QFilter("id", "=", (Object)Long.valueOf(String.valueOf(selectedRow.getPrimaryKeyValue())));
        DynamicObject billNumF7 = null;
        billNumF7 = isOutSource != false ? QueryServiceHelper.queryOne((String)"om_mftorder_f7", (String)"id,headbillno,entryseq,material matinfoid,material.masterid material", (QFilter[])new QFilter[]{filter}) : QueryServiceHelper.queryOne((String)"pom_mftorder_f7", (String)"id,headbillno,entryseq,material matinfoid,material.masterid material", (QFilter[])new QFilter[]{filter});
        if (billNumF7 == null) {
            return;
        }
        this.getModel().setValue("probill", (Object)billNumF7.getLong("id"));
        this.logger.info("\u6210\u672c\u6838\u7b97\u53c2\u6570headbillno:" + billNumF7.getString("headbillno"));
        this.getModel().setValue("srcbillnumber", (Object)billNumF7.getString("headbillno"));
        this.getModel().setValue("srcbillrow", (Object)billNumF7.getInt("entryseq"));
        this.getModel().setValue("material", (Object)billNumF7.getLong("material"));
        QFilter nofilter = new QFilter("billno", "=", (Object)billNumF7.getString("headbillno"));
        QFilter rowfilter = new QFilter("treeentryentity.seq", "=", (Object)billNumF7.getInt("entryseq"));
        QFilter matfilter = new QFilter("treeentryentity.material", "=", (Object)billNumF7.getLong("matinfoid"));
        DynamicObject proBill = null;
        proBill = isOutSource != false ? QueryServiceHelper.queryOne((String)"om_mftorder", (String)"billno,treeentryentity.bomid bom,treeentryentity.auxproperty auxpty,treeentryentity.beginbookdate transmittime", (QFilter[])new QFilter[]{nofilter, rowfilter, matfilter}) : QueryServiceHelper.queryOne((String)"pom_mftorder", (String)"billno,treeentryentity.bomid bom,treeentryentity.auxproperty auxpty,treeentryentity.beginbookdate transmittime", (QFilter[])new QFilter[]{nofilter, rowfilter, matfilter});
        if (proBill == null) {
            return;
        }
        this.logger.info("\u6210\u672c\u6838\u7b97\u53c2\u6570treeentryentity.material:" + billNumF7.getLong("material") + "\uff0c\u5de5\u5355\uff1a" + proBill);
        this.getModel().setValue("auxpty", (Object)proBill.getLong("auxpty"));
        DynamicObject mat = BusinessDataServiceHelper.loadSingleFromCache((Object)billNumF7.get("material"), (String)"bd_material");
        if (BomRouterHelper.isEnableMatversion((DynamicObject)mat)) {
            DynamicObject bom = null;
            if (proBill.getLong("bom") > 0L) {
                bom = BusinessDataServiceHelper.loadSingle((Object)proBill.get("bom"), (String)"pdm_mftbom");
            }
            Object bomVer = Optional.ofNullable(bom).map(s -> s.get("version")).orElse(null);
            this.getModel().setValue("bomversion", bomVer);
        }
        if (isOutSource.booleanValue()) {
            this.getModel().setValue("srcbilltype", (Object)"om_mftorder");
        } else {
            this.getModel().setValue("srcbilltype", (Object)"pom_mftorder");
        }
        this.getModel().setValue("bookdate", (Object)proBill.getDate("transmittime"));
        this.getModel().setValue("createtime", (Object)proBill.getDate("transmittime"));
        this.updateNumberAndName();
        this.getPageCache().remove("probill");
    }

    private void changeViewFieldBy(CostObjectEnum bizTypeEnum) {
        switch (bizTypeEnum) {
            case BIZTYPE_RO: {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"material", "bomversion", "auxpty"});
                break;
            }
            case BIZTYPE_SO: {
                DynamicObject mat = (DynamicObject)this.getModel().getValue("material");
                this.getView().setEnable(Boolean.valueOf(BomRouterHelper.isEnableMatversion((DynamicObject)mat)), new String[]{"bomversion"});
                this.getView().setEnable(Boolean.valueOf(BomRouterHelper.isEnableAuxprop((DynamicObject)mat)), new String[]{"auxpty"});
                break;
            }
            case BIZTYPE_PZ: 
            case BIZTYPE_FL: {
                DynamicObject mat = (DynamicObject)this.getModel().getValue("material");
                this.getView().setEnable(Boolean.valueOf(BomRouterHelper.isEnableMatversion((DynamicObject)mat)), new String[]{"bomversion"});
                this.getView().setEnable(Boolean.valueOf(BomRouterHelper.isEnableAuxprop((DynamicObject)mat)), new String[]{"auxpty"});
                break;
            }
        }
    }

    private void updateByMaterial(DynamicObject mat) {
        if (!BomRouterHelper.isEnableMatversion((DynamicObject)mat)) {
            this.getModel().setValue("bomversion", null);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bomversion"});
        } else {
            this.getModel().setValue("bomversion", null);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"bomversion"});
        }
        if (!BomRouterHelper.isEnableAuxprop((DynamicObject)mat)) {
            this.getModel().setValue("auxpty", null);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"auxpty"});
        } else {
            this.getModel().setValue("auxpty", null);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"auxpty"});
        }
        this.getModel().setValue("productgroup", null);
        this.updateNumberAndName();
    }

    private void updateNumberAndName() {
        this.logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u66f4\u65b0\u7f16\u53f7\uff0c\u540d\u79f0\u5f00\u59cb");
        DynamicObject mainData = this.getModel().getDataEntity(true);
        String bizType = mainData.getString("biztype");
        String srcNum = mainData.getString("producenum");
        String srcRow = mainData.getString("srcbillrow");
        this.logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u53c2\u6570\u83b7\u53d6\uff1abizType:" + bizType + ",srcNum:" + srcNum + ",srcRow:" + srcRow);
        DynamicObject costCenter = mainData.getDynamicObject("costcenter");
        DynamicObject org = mainData.getDynamicObject("org");
        if (costCenter == null || org == null) {
            this.logger.info("\u6210\u672c\u6838\u7b97\u6210\u672c\u4e2d\u5fc3\u548c\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        DynamicObject objectRule = CostObjectHelper.getRuleBy((Object)org.getPkValue(), (Object)costCenter.getPkValue());
        if (objectRule == null) {
            this.logger.info("\u6210\u672c\u6838\u7b97\u6ca1\u6709\u83b7\u53d6\u5230\u5bf9\u5e94\u89c4\u5219");
            return;
        }
        DynamicObject bomversion = (DynamicObject)this.getModel().getValue("bomversion");
        DynamicObject auxpty = (DynamicObject)this.getModel().getValue("auxpty");
        String[] ruleNumberExt = objectRule.getString("rulenumberext").split(",");
        String[] ruleNameExt = objectRule.getString("rulenameext").split(",");
        String ass = objectRule.getString("objruleass");
        ass = StringUtils.isNotEmpty((String)ass) ? ass + "-" + costCenter.getString("number") : costCenter.getString("number");
        String nameAss = objectRule.getString("objrulenameass");
        String ccName = costCenter.getLocaleString("name").getLocaleValue();
        nameAss = StringUtils.isNotEmpty((String)nameAss) ? nameAss + "-" + ccName : ccName;
        DynamicObject mat = mainData.getDynamicObject("material");
        if (mat == null) {
            return;
        }
        switch (CostObjectEnum.getEnumByValue((String)bizType)) {
            case BIZTYPE_RO: {
                String billNo = ass + "-" + srcNum + "-" + srcRow;
                String billName = nameAss + "-" + srcNum + "-" + srcRow;
                this.setBillNo(billNo, ruleNumberExt, mat);
                this.setBillName(billName, ruleNameExt, mat);
                break;
            }
            case BIZTYPE_SO: {
                String billNo = ass + "-" + mat.getString("number");
                String billName = nameAss + "-" + mat.getString("name");
                if (bomversion != null) {
                    billNo = billNo + "-" + bomversion.getString("number");
                    billName = billName + "-" + bomversion.getString("number");
                }
                if (auxpty != null) {
                    this.setBillByAuxty(billNo, billName, objectRule, mat, auxpty, srcNum);
                    break;
                }
                billNo = billNo + "-" + srcNum;
                billName = billName + "-" + srcNum;
                this.setBillNo(billNo, ruleNumberExt, mat);
                this.setBillName(billName, ruleNameExt, mat);
                break;
            }
            case BIZTYPE_PZ: 
            case BIZTYPE_FL: {
                String billNo = ass + "-" + mat.getString("number");
                String billName = nameAss + "-" + mat.getString("name");
                if (bomversion != null) {
                    billNo = billNo + "-" + bomversion.getString("number");
                    billName = billName + "-" + bomversion.getString("number");
                }
                if (auxpty != null) {
                    this.setBillByAuxty(billNo, billName, objectRule, mat, auxpty, srcNum);
                    break;
                }
                this.setBillNo(billNo, ruleNumberExt, mat);
                this.setBillName(billName, ruleNameExt, mat);
                break;
            }
        }
    }

    private void setBillByAuxty(String billNo, String billName, DynamicObject objectRule, DynamicObject mat, DynamicObject auxpty, String srcNum) {
        HashSet<Long> auxptyIdSet = new HashSet<Long>(16);
        DynamicObjectCollection isaffectprices = mat.getDynamicObjectCollection("auxptyentry");
        for (DynamicObject price : isaffectprices) {
            Long auxptyId = price.getLong("auxpty.id");
            if (!price.getBoolean("isaffectprice")) continue;
            auxptyIdSet.add(auxptyId);
        }
        if (CadEmptyUtils.isEmpty(auxptyIdSet)) {
            return;
        }
        String auxStr = (String)auxpty.get(1);
        JSONObject auxptyJsonObject = (JSONObject)JSON.parse((String)auxStr);
        DynamicObject[] auxproperty = BusinessDataServiceHelper.load((String)"bd_auxproperty", (String)"number,name,flexfield,valuesource", (QFilter[])new QFilter[]{new QFilter("id", "in", auxptyIdSet)});
        StringBuilder auxptyNumberStr = new StringBuilder();
        StringBuilder auxptyNameStr = new StringBuilder();
        for (DynamicObject aux : auxproperty) {
            String flexfield = aux.getString("flexfield");
            String auxNumber = aux.getString("number");
            String auxName = aux.getString("name");
            String entity = aux.getString("valuesource.number");
            Long auxptyValue = 0L;
            if (auxptyJsonObject.get((Object)flexfield) instanceof Long) {
                auxptyValue = auxptyJsonObject.getLong(flexfield);
            } else if (auxptyJsonObject.get((Object)flexfield) instanceof Integer) {
                auxptyValue = Long.valueOf(auxptyJsonObject.get((Object)flexfield).toString());
            }
            if (CadEmptyUtils.isEmpty((Long)auxptyValue)) continue;
            this.setAuxtyNumberAndNameStr(auxptyNumberStr, auxNumber, auxptyNameStr, auxName, auxptyValue, entity);
        }
        if (!CadEmptyUtils.isEmpty((String)auxptyNumberStr.toString())) {
            billNo = billNo.concat("-").concat(auxptyNumberStr.toString());
        }
        if (!CadEmptyUtils.isEmpty((String)auxptyNameStr.toString())) {
            billName = billName.concat("-").concat(auxptyNameStr.toString());
        }
        if (!CadEmptyUtils.isEmpty((String)srcNum)) {
            billNo = billNo.concat("-").concat(srcNum);
            billName = billName.concat("-").concat(srcNum);
        }
        String[] ruleNumberExt = objectRule.getString("rulenumberext").split(",");
        String[] ruleNameExt = objectRule.getString("rulenameext").split(",");
        this.setBillNo(billNo, ruleNumberExt, mat);
        this.setBillName(billName, ruleNameExt, mat);
    }

    private void setAuxtyNumberAndNameStr(StringBuilder auxptyNumberStr, String auxNumber, StringBuilder auxptyNameStr, String auxName, Long auxptyValue, String entity) {
        QFilter filter = new QFilter("id", "=", (Object)auxptyValue);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)"number,name", (QFilter[])new QFilter[]{filter});
        if (dynamicObject == null) {
            return;
        }
        if (!CadEmptyUtils.isEmpty((String)auxptyNumberStr.toString())) {
            auxptyNumberStr.append("-");
            auxptyNumberStr.append(auxNumber);
        } else {
            auxptyNumberStr.append(auxNumber);
        }
        if (!CadEmptyUtils.isEmpty((String)auxptyNameStr.toString())) {
            auxptyNameStr.append("-");
            auxptyNameStr.append(auxName);
        } else {
            auxptyNameStr.append(auxName);
        }
        auxptyNumberStr.append("-");
        auxptyNumberStr.append(dynamicObject.getString("number"));
        auxptyNameStr.append("-");
        auxptyNameStr.append(dynamicObject.getString("name"));
    }

    private void setBillNo(String billNo, String[] ruleNumberExt, DynamicObject mat) {
        if (mat != null && Arrays.asList(ruleNumberExt).contains("CR_CPBM") && !CadEmptyUtils.isEmpty((String)mat.getString("number"))) {
            billNo = billNo + "-" + mat.getString("number");
        }
        if (mat != null && Arrays.asList(ruleNumberExt).contains("CR_GGXH") && !CadEmptyUtils.isEmpty((String)mat.getString("modelnum"))) {
            billNo = billNo + "-" + mat.getString("modelnum");
        }
        this.getModel().setValue("billno", (Object)billNo);
        this.getView().updateView("billno");
    }

    private void setBillName(String billName, String[] ruleNameExt, DynamicObject mat) {
        if (mat != null && Arrays.asList(ruleNameExt).contains("CRN_CPMC") && !CadEmptyUtils.isEmpty((String)mat.getString("name"))) {
            billName = billName + "-" + mat.getString("name");
        }
        if (mat != null && Arrays.asList(ruleNameExt).contains("CRN_GGXH") && !CadEmptyUtils.isEmpty((String)mat.getString("modelnum"))) {
            billName = billName + "-" + mat.getString("modelnum");
        }
        this.getModel().setValue("name", (Object)billName);
        this.getView().updateView("name");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("save".equals(e.getOperateKey()) || "submit".equals(e.getOperateKey())) {
            this.getView().updateView("auxpty");
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        switch (e.getItemKey()) {
            case "uplook": {
                Object proBillEntryId = this.getModel().getDataEntity().get("probill");
                Boolean isOutSource = (Boolean)this.getModel().getDataEntity().get("isoutsource");
                if (proBillEntryId == null) {
                    this.getView().showTipNotification(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u7684\u6570\u636e\u3002", (String)"CostObjectEditPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]), (String)"CostObjectEditPlugin_0"));
                    return;
                }
                HashSet<Long> proBillEntryIds = new HashSet<Long>();
                proBillEntryIds.add(Long.parseLong(proBillEntryId.toString()));
                if (!isOutSource.booleanValue()) {
                    CostObjectHelper.uplookBySource((IFormView)this.getView(), proBillEntryIds, (String)"pom_mftorder");
                    break;
                }
                CostObjectHelper.uplookBySource((IFormView)this.getView(), proBillEntryIds, (String)"om_mftorder");
            }
        }
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }
}

