/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costobject;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.config.service.CommonCollConfigService;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadPermissionUtil;
import kd.macc.cad.common.utils.CadUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.formplugin.common.Util;
import kd.macc.cad.formplugin.costobject.BaseCostObjectListPlugin;
import kd.macc.cad.servicehelper.CostObjectServiceHelper;

public class CostObjectListPlugin
extends BaseCostObjectListPlugin {
    private static final Log logger = LogFactory.getLog(CostObjectListPlugin.class);
    private static final String PAGECACHE_COSTCENTERSET = "costcenterset";
    private static final String closeBack_importResult = "importResult";
    private static List<ComboItem> costCenterComboItemListBy;

    public CostObjectListPlugin() {
        this.ORG_FIELD = "org";
        this.PROORG_FIELD = "manuorg";
        this.COSTCENTER_FIELD = "costcenter";
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        switch (e.getItemKey()) {
            case "tblnew": {
                String acctOrgId = this.getPageCache().get("org");
                String costCenterId = this.getPageCache().get("costcenter");
                if (StringUtils.isEmpty((String)acctOrgId) || StringUtils.isEmpty((String)costCenterId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostObjectListPlugin_18", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObject objRule = CostObjectHelper.getRuleBy((Object)acctOrgId, (Object)costCenterId);
                if (objRule != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"CostObjectListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "tblenable": {
                break;
            }
            case "bar_bizclose": 
            case "bar_bizunclose": {
                if (rows.size() != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostObjectListPlugin_19", (String)"macc-cad-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
                e.setCancel(true);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if ("eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"uplook"});
        } else if ("sca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "importdata", "importdetails"});
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        switch (e.getItemKey()) {
            case "newbyrulecover": {
                if (!CadPermissionUtil.check((Long)RequestContext.get().getCurrUserId(), (String)this.getPageCache().get("org"), (boolean)false, (String)this.getView().getFormShowParameter().getAppId(), (String)"cad_costobject", (String)"47156aff000000ac")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostObjectListPlugin_22", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.newByRule();
                break;
            }
            case "uplook": {
                if (CadEmptyUtils.isEmpty((ListSelectedRowCollection)rows)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4e0a\u67e5\u7684\u6570\u636e\u3002", (String)"CostObjectListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                Map probillEntryIdMap = CostObjectHelper.getProbillEntryIds((Object[])rows.getPrimaryKeyValues());
                CostObjectHelper.uplook((IFormView)this.getView(), (Map)probillEntryIdMap);
                break;
            }
            case "updatedata": {
                this.updateManuorg();
                break;
            }
            case "updatedataforisoutsource": {
                this.updateIsOutSource();
                break;
            }
            case "colreport": {
                this.viewColReport();
                break;
            }
            case "searchconfig": {
                this.searchConfig();
                break;
            }
            case "recalkeycol": {
                this.recalKeycol(rows);
                break;
            }
        }
    }

    private void recalKeycol(ListSelectedRowCollection rows) {
        String acctOrgId = this.getPageCache().get("org");
        if (CadEmptyUtils.isEmpty((String)acctOrgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostObjectListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        String appnum = this.getView().getFormShowParameter().getAppId();
        HashSet<Long> ids = null;
        if (!rows.isEmpty()) {
            ids = new HashSet<Long>(10);
            for (ListSelectedRow row : rows) {
                ids.add(Long.parseLong(row.getPrimaryKeyValue().toString()));
            }
        }
        CalcKeycolHelper.costobjectRecalKeycol((Long)Long.parseLong(acctOrgId), null, ids, (String)appnum);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7b97\u5b8c\u6210\u3002", (String)"CostObjectListPlugin_23", (String)"macc-cad-formplugin", (Object[])new Object[0]));
    }

    private void viewColReport() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"cad_colreport", (boolean)true, (int)1, (boolean)false);
        String acctOrgId = this.getPageCache().get("org");
        listShowParameter.setCustomParam("appnum", (Object)this.getView().getFormShowParameter().getAppId());
        listShowParameter.setCustomParam("org", (Object)acctOrgId);
        listShowParameter.setCustomParam("colobj", (Object)CollectObjectEnum.COST_OBJECT.getObj());
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f52\u96c6\u62a5\u544a", (String)"CostObjectListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void searchConfig() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() == 0) {
            return;
        }
        ImportServiceHelper.seachConfig((Object[])rows.getPrimaryKeyValues(), (String)"cad_costobject", (IFormView)this.getView());
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        super.beforeCreateListColumns(o);
        List listColumns = o.getListColumns();
        ArrayList toFixedColList = Lists.newArrayList((Object[])new String[]{"billno", "name", "org.name", "costcenter.name", "material.number", "material.name"});
        ArrayList toVisibleColList = Lists.newArrayList((Object[])new String[]{"bomversion.name", "auxpty", "originype", "remark"});
        HashSet<String> hiddenKeys = new HashSet<String>(1);
        int showCoActfeenocal = CadBgParamUtils.getCadParamForInt((String)"isactfeenocal", (int)0);
        if (showCoActfeenocal == 0 || !"sca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            hiddenKeys.add("isactfeenocal");
        }
        if ("aca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            hiddenKeys.add("bizstatus");
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)o, hiddenKeys);
        } else if ("sca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)o, hiddenKeys);
        } else if ("eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            hiddenKeys.add("producenum");
            hiddenKeys.add("productgroup.name");
            hiddenKeys.add("producttype");
            hiddenKeys.add("weight");
            hiddenKeys.add("configuredcode.number");
            hiddenKeys.add("tracknumber.number");
            hiddenKeys.add("isoutsource");
            hiddenKeys.add("isrework");
            hiddenKeys.add("bizstatus");
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)o, hiddenKeys);
            ArrayList visibleColList = Lists.newArrayList((Object[])new String[]{"material.number", "material.name", "material.modelnum"});
            Util.setDefaultFixedAndVisibleColumes(listColumns, null, visibleColList);
        }
        Util.setDefaultFixedAndVisibleColumes(listColumns, toFixedColList, toVisibleColList);
    }

    private void newByRule() {
        try {
            String acctOrgId = this.getPageCache().get("org");
            String costCenterId = this.getPageCache().get("costcenter");
            ArrayList<Long> costCenters = new ArrayList<Long>(10);
            if (CadEmptyUtils.isEmpty((String)acctOrgId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostObjectListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            List costCenterMultiSelect = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("multiselectcostcenters"), List.class);
            if (!CadEmptyUtils.isEmpty((List)costCenterMultiSelect) && costCenterMultiSelect.size() > 1) {
                costCenters.addAll(costCenterMultiSelect);
            } else if (!CadEmptyUtils.isEmpty((String)costCenterId)) {
                costCenters.add(Long.parseLong(costCenterId));
            } else {
                String manuOrgId = this.getPageCache().get("manuorg");
                List<ComboItem> comboItems = this.getCostCenterComboItemListByManuOrg(acctOrgId, manuOrgId);
                comboItems.forEach(p -> costCenters.add(Long.parseLong(p.getValue())));
                boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.valueOf(acctOrgId));
                if (isEnableMultiFactory && CadEmptyUtils.isEmpty(comboItems)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u672a\u7ef4\u62a4\u201c\u6210\u672c\u4e2d\u5fc3\u201d\u4e0e\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u7684\u5bf9\u5e94\u5173\u7cfb\u3002", (String)"CostObjectListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (CadEmptyUtils.isEmpty(costCenters)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostObjectListPlugin_18", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            Boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(acctOrgId));
            ArrayList<Long> manuOrgs = new ArrayList<Long>(10);
            if (isOrgEnableMultiFactory.booleanValue() && CadEmptyUtils.isEmpty((String)this.getPageCache().get("manuorg"))) {
                List userHasPermManuOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.parseLong(acctOrgId), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                manuOrgs.addAll(userHasPermManuOrgs);
            } else if (isOrgEnableMultiFactory.booleanValue() && !CadEmptyUtils.isEmpty((String)this.getPageCache().get("manuorg"))) {
                manuOrgs.add(Long.parseLong(this.getPageCache().get("manuorg")));
            }
            List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)RequestContext.get().getCurrUserId(), Collections.singletonList(Long.parseLong(acctOrgId)), (Set)Sets.newHashSet(costCenters), (String)"cad_costobject", (String)this.getView().getFormShowParameter().getAppId());
            Map objRules = CostObjectHelper.getCostObjectRulesMap((Long)Long.parseLong(acctOrgId), (List)enableCostCenters);
            if (CadEmptyUtils.isEmpty((Map)objRules)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"CostObjectListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            Set calDimensionIds = CostObjectHelper.getCalDimensionIds((Long)Long.parseLong(acctOrgId), (List)enableCostCenters, (Map)objRules);
            List collConfigs = CommonCollConfigService.getCollConfigs((Long)Long.parseLong(acctOrgId), null, (Set)calDimensionIds, (String)"cad_costobject", (String)this.getView().getFormShowParameter().getAppId());
            if (CadEmptyUtils.isEmpty((List)collConfigs)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f52\u96c6\u65b9\u6848\u3002", (String)"CostObjectListPlugin_21", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"CostObjectListPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                Map responseInfo = new HashMap(2);
                try {
                    responseInfo = (Map)CostObjectServiceHelper.importCostObject(null, (Long)Long.parseLong(acctOrgId), (List)costCenters, (List)manuOrgs, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()), (String)progressId);
                }
                catch (Exception e) {
                    MsgUtils.putMsg2Map((String)"error", (String)e.toString(), responseInfo);
                    MsgUtils.putMsg2Map((String)"error", (String)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s\u3002", (String)"CostObjectListPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]), e.toString()), responseInfo);
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                String responseInfoStr = SerializationUtils.toJsonString(responseInfo);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_importResult));
        }
        catch (Exception ex) {
            logger.error("\u4ece\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\u62a5\u9519\uff1a", (Throwable)ex);
            throw ex;
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        this.getView().hideLoading();
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "importResult": {
                BillList billList = (BillList)this.getControl("billlistap");
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                if ("confirm".equals(responseInfo.get("type"))) {
                    billList.refresh();
                    this.getView().showConfirm((String)responseInfo.get("msg"), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("showReport", (IFormPlugin)this));
                    break;
                }
                MsgUtils.showMsgAndRefresh((Map)responseInfo, (IFormView)this.getView(), (BillList)billList);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            switch (callBackId) {
                case "showReport": {
                    String responseInfoStr = this.getPageCache().get("responseInfo");
                    if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                        return;
                    }
                    Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                    this.showColReport((String)responseInfo.get("colReportId"));
                    break;
                }
            }
        }
    }

    private void showColReport(String colReportId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("cad_colreport");
        billShowParameter.setCustomParam("id", (Object)colReportId);
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f52\u96c6\u62a5\u544a", (String)"CostObjectListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void setFilter(SetFilterEvent e) {
        QFilter manuOrgQFilter;
        QFilter costCenterFilter = this.getCostCenterQFilter();
        if ("sca".equals(this.getView().getFormShowParameter().getAppId())) {
            e.getQFilters().add(new QFilter("biztype", "in", (Object)new String[]{"RO", "SO"}));
        }
        if (costCenterFilter != null) {
            e.getQFilters().add(costCenterFilter);
        }
        if ((manuOrgQFilter = this.getManuOrgQFilter()) != null) {
            e.getQFilters().add(manuOrgQFilter);
        }
        e.setOrderBy("bookdate desc,billno desc");
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        super.filterContainerSearchClick(e);
        Map filterValues = e.getSearchClickEvent().getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        if (customfilter == null || customfilter.isEmpty()) {
            return;
        }
        String pageCacheCostcenter = null;
        for (int i = 0; i < customfilter.size(); ++i) {
            String val;
            Map map = (Map)customfilter.get(i);
            List names = (List)map.get("FieldName");
            if (!"costcenter.id".equals(String.valueOf(names.get(0)))) continue;
            List vals = (List)map.get("Value");
            if (vals == null || vals.isEmpty()) {
                pageCacheCostcenter = "";
                continue;
            }
            if (!CadEmptyUtils.isEmpty(costCenterComboItemListBy)) {
                Set costCenterIdsSet = costCenterComboItemListBy.stream().map(o -> o.getValue()).collect(Collectors.toSet());
                if (!costCenterIdsSet.contains(vals.get(0))) {
                    vals.clear();
                    vals.add("");
                }
            } else {
                vals.clear();
                vals.add("");
            }
            pageCacheCostcenter = val = String.valueOf(vals.get(0));
        }
        if (pageCacheCostcenter != null) {
            this.getPageCache().put(this.COSTCENTER_FIELD, pageCacheCostcenter);
        }
        Long costCenterId = this.getPageCache().get("accountorg") == null ? 0L : Long.parseLong(this.getPageCache().get(this.ORG_FIELD));
        List multiCostCenters = CadUtils.getMultiCostCentersByFilterName((FilterContainerSearchClickArgs)e, (String)"costcenter.id", (Long)costCenterId);
        this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString((Object)multiCostCenters));
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter bsp = e.getParameter();
        String acctOrg = this.getPageCache().get(this.ORG_FIELD);
        String costCenter = this.getPageCache().get("costcenter");
        String manuOrg = this.getPageCache().get("manuorg");
        bsp.setCustomParam(this.ORG_FIELD, (Object)acctOrg);
        bsp.setCustomParam("costcenter", (Object)costCenter);
        bsp.setCustomParam("manuorg", (Object)manuOrg);
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        if ("sca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            List commonFilterColumns = args.getCommonFilterColumns();
            List schemeFilterColumns = args.getSchemeFilterColumns();
            Optional<FilterColumn> bizStatusCommonF = commonFilterColumns.stream().filter(commonFilterColumn -> commonFilterColumn.getFieldName().equals("bizstatus")).findFirst();
            Optional<FilterColumn> bizStatusSchemeF = schemeFilterColumns.stream().filter(schemeFilterColumn -> schemeFilterColumn.getFieldName().equals("bizstatus")).findFirst();
            if (!bizStatusCommonF.isPresent()) {
                args.addFilterColumn((FilterColumn)this.createBizStatusCommonFilter());
            }
            if (!bizStatusSchemeF.isPresent()) {
                args.addFilterColumn((FilterColumn)this.createBizStatusSchemeFilter());
            }
        } else if ("aca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"updatedata"});
        }
        String org = this.getPageCache().get(this.ORG_FIELD);
        if (!CadEmptyUtils.isEmpty((String)org)) {
            costCenterComboItemListBy = this.getCostCenterComboItemListBy(org);
        }
        CommonFilterColumn filterColumn = (CommonFilterColumn)args.getFilterColumn("costcenter.name");
        List comboItems = filterColumn.getComboItems();
        HashSet<String> costCenterSet = new HashSet<String>(10);
        for (ComboItem comboItem : comboItems) {
            costCenterSet.add(comboItem.getValue());
        }
        this.getPageCache().put(PAGECACHE_COSTCENTERSET, SerializationUtils.toJsonString(costCenterSet));
        this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString(new ArrayList()));
    }

    private CommonFilterColumn createBizStatusCommonFilter() {
        CommonFilterColumn bizStatusComlumn = new CommonFilterColumn();
        bizStatusComlumn.setKey("bizstatus");
        bizStatusComlumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001", (String)"CostObjectListPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        bizStatusComlumn.setFieldName("bizstatus");
        bizStatusComlumn.setMustInput(false);
        bizStatusComlumn.setType("enum");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u672a\u7ed3\u7b97", (String)"CostObjectListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0])), "A"));
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5df2\u7ed3\u7b97", (String)"CostObjectListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0])), "B"));
        bizStatusComlumn.setComboItems(comboItems);
        return bizStatusComlumn;
    }

    private SchemeFilterColumn createBizStatusSchemeFilter() {
        SchemeFilterColumn schemeFilterColumn = new SchemeFilterColumn();
        schemeFilterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001", (String)"CostObjectListPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        schemeFilterColumn.setKey("bizstatus");
        schemeFilterColumn.setFieldName("bizstatus");
        schemeFilterColumn.setType("enum");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u672a\u7ed3\u7b97", (String)"CostObjectListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0])), "A"));
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5df2\u7ed3\u7b97", (String)"CostObjectListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0])), "B"));
        schemeFilterColumn.setComboItems(comboItems);
        schemeFilterColumn.setDefaultCompareType(ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"CostObjectListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        return schemeFilterColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIsOutSource() {
        try (TXHandle txHandle = TX.required();){
            DynamicObject[] costobjects;
            QFilter filter = new QFilter("biztype", "=", (Object)"RO");
            QFilter sourceTypefilter = new QFilter("sotype", "=", (Object)"WPB");
            for (DynamicObject costobject : costobjects = BusinessDataServiceHelper.load((String)"cad_costobject", (String)"sotype,isoutsource", (QFilter[])new QFilter[]{filter, sourceTypefilter})) {
                costobject.set("sotype", (Object)"PB");
                costobject.set("isoutsource", (Object)Boolean.TRUE);
            }
            SaveServiceHelper.update((DynamicObject[])costobjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateManuorg() {
        ArrayList<Long> costobjectId = new ArrayList<Long>(16);
        HashSet<Long> scrbillentryId = new HashSet<Long>(16);
        HashMap<Long, Long> entryIdManuorgIdMap = new HashMap<Long, Long>(16);
        QFilter sourceIdFilter = new QFilter("probill", ">", (Object)0L);
        QFilter manuorgIdFilter = new QFilter("manuorg", "=", (Object)0L);
        manuorgIdFilter.or("manuorg", "is null", null);
        DataSet costobject = QueryServiceHelper.queryDataSet((String)"updatedata", (String)"cad_costobject", (String)"id,probill", (QFilter[])new QFilter[]{sourceIdFilter, manuorgIdFilter}, null);
        while (costobject.hasNext()) {
            Row next = costobject.next();
            costobjectId.add(next.getLong("id"));
            scrbillentryId.add(next.getLong("probill"));
        }
        if (scrbillentryId.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"CostObjectListPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("treeentryentity.id", "in", scrbillentryId);
        DataSet probill = QueryServiceHelper.queryDataSet((String)"loadprobill", (String)"pom_mftorder", (String)"org.id orgId,treeentryentity.id entryId", (QFilter[])filter.toArray(), null);
        while (probill.hasNext()) {
            Row next = probill.next();
            entryIdManuorgIdMap.put(next.getLong("entryId"), next.getLong("orgId"));
        }
        if (entryIdManuorgIdMap.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7684\u6e90\u5355\u3002", (String)"CostObjectListPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        try (TXHandle txHandle = TX.required();){
            Lists.partition(costobjectId, (int)5000).forEach(list -> {
                DynamicObject[] costobjects;
                QFilter idFilter = new QFilter("id", "in", list);
                for (DynamicObject cos : costobjects = BusinessDataServiceHelper.load((String)"cad_costobject", (String)"manuorg,probill", (QFilter[])idFilter.toArray())) {
                    long entryid = cos.getLong("probill");
                    Long manuorg = (Long)entryIdManuorgIdMap.get(entryid);
                    cos.set("manuorg", (Object)manuorg);
                }
                SaveServiceHelper.update((DynamicObject[])costobjects);
            });
            String ksql = "update t_cad_plannedoutputbill as aa set fmanuorgid = (select tmp.fmanuorgid from t_cad_costobject as tmp where tmp.fid=aa.FCOSTOBJECTID) where fmanuorgid=0 or fmanuorgid is null";
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)ksql);
            ksql = "update t_cad_factnedoutputbill as aa set fmanuorgid = (select distinct co.fmanuorgid from t_cad_factnedoutputentry as entry join t_cad_costobject as co on entry.fcostobjectid=co.FID where entry.FID=aa.FID) where fmanuorgid=0 or fmanuorgid is null";
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)ksql);
            ksql = "update t_sca_matusecollect as aa set fmanuorgid = (select distinct co.fmanuorgid from t_sca_matusecollectentry as entry join t_cad_costobject as co on entry.fcostobjectid=co.FID where entry.FID=aa.FID) where fmanuorgid=0 or fmanuorgid is null";
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)ksql);
            ksql = "update t_sca_matalloc as aa set fmanuorgid = (select distinct tmp.fmanuorgid from t_cad_costobject as tmp where tmp.fid=aa.FCOSTOBJECTID) where fmanuorgid=0 or fmanuorgid is null";
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)ksql);
            ksql = "update t_sca_resourceuse as aa set fmanuorgid = (select distinct co.fmanuorgid from t_sca_resourceuseentry as entry join t_cad_costobject as co on entry.fcostobjectid=co.FID where entry.FID=aa.FID) where fmanuorgid=0 or fmanuorgid is null";
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)ksql);
            ksql = "update t_sca_absorbadjust as aa set fmanuorgid = (select tmp.fmanuorgid from t_cad_costobject as tmp where tmp.fid=aa.FCOSTOBJECTID) where fmanuorgid=0 or fmanuorgid is null";
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)ksql);
            ksql = "update t_sca_finishdiffbill as aa set fmanuorgid = (select tmp.fmanuorgid from t_cad_costobject as tmp where tmp.fid=aa.FCOSTOBJECTID) where fmanuorgid=0 or fmanuorgid is null";
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)ksql);
            ksql = "update t_sca_unabsorbdiff as aa set fmanuorgid = (select tmp.fmanuorgid from t_cad_costobject as tmp where tmp.fid=aa.FCOSTOBJECTID) where fmanuorgid=0 or fmanuorgid is null";
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)ksql);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u6570\u636e\u5347\u7ea7\u6210\u529f\u3002", (String)"CostObjectListPlugin_17", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }
}

