/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costobject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.constants.CostDimensionConstant;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostObjectRuleEditPlugin
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListener();
    }

    public void initialize() {
        super.initialize();
        String appId = AppIdHelper.getCurAppNum((IFormView)this.getView());
        List comboItem = CostObjectHelper.getCalMthodComboItem((String)appId);
        ComboEdit ruleEdit = (ComboEdit)this.getControl("biztype");
        ruleEdit.setComboItems(comboItem);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("audit".equals(formOperate.getOperateKey()) || "enable".equals(formOperate.getOperateKey())) {
            operate.getOption().setVariableValue("appnum", AppIdHelper.getCurAppNum((IFormView)this.getView()));
        }
    }

    protected void addListener() {
        BasedataEdit costCenterEdit = (BasedataEdit)this.getControl("costcenter");
        costCenterEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject acctOrg = this.getModel().getDataEntity().getDynamicObject("accountorg");
            if (acctOrg != null) {
                filters.add(new QFilter("accountorg", "=", acctOrg.getPkValue()));
            } else {
                filters.add(new QFilter("accountorg", "=", (Object)0L));
            }
            filters.add(new QFilter("orgduty", "=", (Object)4L));
            List hasPermCostCenterIds = CostCenterHelper.getCostCenterByUser((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            QFilter costCenterIdsFilter = new QFilter("id", "in", (Object)hasPermCostCenterIds);
            filters.add(costCenterIdsFilter);
            filterParameter.setQFilters(filters);
        });
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("accountorg");
        orgEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject costCenterOrg;
            Object costCenterOrgId;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject costCenter = this.getModel().getDataEntity().getDynamicObject("costcenter");
            if (costCenter != null && (costCenterOrgId = Optional.of(costCenterOrg = costCenter.getDynamicObject("accountorg")).map(s -> s.getPkValue()).orElse(null)) != null) {
                filters.add(new QFilter("id", "=", costCenterOrgId));
            }
            List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            QFilter orgIdsFilter = new QFilter("id", "in", (Object)hasPermAccountOrgIds);
            filters.add(orgIdsFilter);
            filterParameter.setQFilters(filters);
        });
        BasedataEdit dimensionEdit = (BasedataEdit)this.getControl("costcalcdimension");
        dimensionEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            QFilter filter = new QFilter("preset", "=", (Object)false);
            filter.and("enable", "=", (Object)true);
            filterParameter.setFilter(filter);
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void afterCreateNewData(EventObject e) {
        String ccId;
        super.afterCreateNewData(e);
        this.getModel().setValue("rulecase", (Object)ResManager.loadKDString((String)"\u6e90\u5355\u7f16\u7801-\u6e90\u5355\u884c\u53f7", (String)"CostObjectRuleEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("rulenamecase", (Object)ResManager.loadKDString((String)"\u6210\u672c\u8ba1\u7b97\u65b9\u6cd5-\u6e90\u5355\u7f16\u7801-\u6e90\u5355\u884c\u53f7", (String)"CostObjectRuleEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String acctOrgId = (String)fsp.getCustomParam("accountorg");
        if (!"null".equals(acctOrgId)) {
            this.getModel().setValue("accountorg", (Object)acctOrgId);
        }
        if (!"null".equals(ccId = (String)fsp.getCustomParam("costcenter"))) {
            this.getModel().setValue("costcenter", (Object)ccId);
        }
        if ("eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            this.getModel().setValue("biztype", (Object)CostObjectEnum.BIZTYPE_SW.getValue());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String bizType = this.getModel().getDataEntity().getString("biztype");
        if (CostObjectEnum.BIZTYPE_CU.getValue().equals(bizType)) {
            String dimenSion = this.getModel().getDataEntity().getString("costcalcdimension.calcrule");
            DynamicObject dimension = (DynamicObject)this.getModel().getValue("costcalcdimension");
            DynamicObjectCollection costCalcDimension = new DynamicObjectCollection();
            if (dimension != null) {
                costCalcDimension = dimension.getDynamicObjectCollection("entryentity");
            }
            ArrayList<CostObjectEnum> enumList = new ArrayList<CostObjectEnum>(10);
            if (dimenSion != null) {
                String calcRule = dimenSion.substring(1, dimenSion.length() - 1);
                for (String key : Arrays.asList(calcRule.split(","))) {
                    CostObjectEnum costObjectRuleEnum = CostObjectEnum.getEnumByValue((String)key);
                    enumList.add(costObjectRuleEnum);
                }
            }
            this.setDefComBoEditVal("rulenumberext", enumList, costCalcDimension);
            this.setDefComBoEditVal("rulenameext", enumList, costCalcDimension);
        } else if (CostObjectEnum.BIZTYPE_RO.getValue().equals(bizType)) {
            this.resetComBoEditVal("rulenumberext", CostObjectEnum.CODE_RULE_CPBM, CostObjectEnum.CODE_RULE_GGXH);
            this.resetComBoEditVal("rulenameext", CostObjectEnum.CODE_RULE_NAME_CPMC, CostObjectEnum.CODE_RULE_NAME_GGXH);
        } else if (CostObjectEnum.BIZTYPE_SW.getValue().equals(bizType)) {
            this.resetComBoEditVal("rulenumberext", CostObjectEnum.CODE_RULE_XMH);
            this.resetComBoEditVal("rulenameext", CostObjectEnum.CODE_RULE_NAME_XMH);
        } else if (!CostObjectEnum.BIZTYPE_SP.getValue().equals(bizType)) {
            this.resetComBoEditVal("rulenumberext", CostObjectEnum.CODE_RULE_GGXH);
            this.resetComBoEditVal("rulenameext", CostObjectEnum.CODE_RULE_NAME_GGXH);
        }
        this.disableAfterUnaudit();
        this.showPnorule();
        this.dimensionEnable();
        String appId = AppIdHelper.getCurAppNum((IFormView)this.getView());
        if ("sca".equals(appId)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"biztype"});
        }
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("audit".equals(operateKey) && e.getOperationResult().isSuccess()) {
            Long auditorId = (Long)this.getModel().getValue("auditor");
            if (auditorId == null) {
                return;
            }
            this.getModel().setValue("auditor", (Object)BusinessDataServiceHelper.loadSingle((Object)auditorId, (String)"bos_user"));
            this.getView().updateView("auditor");
        }
    }

    private boolean isSimpleBizType() {
        String ruleVal = this.getModel().getDataEntity().getString("rule");
        return CostObjectEnum.RULE_PN.getValue().equalsIgnoreCase(ruleVal);
    }

    private void disableAfterUnaudit() {
        Long id = this.getModel().getDataEntity().getLong("id");
        boolean existObject = true;
        if (!CadEmptyUtils.isEmpty((Long)id)) {
            DynamicObject costCenter = this.getModel().getDataEntity().getDynamicObject("costcenter");
            DynamicObject acctOrg = this.getModel().getDataEntity().getDynamicObject("accountorg");
            if (costCenter == null || acctOrg == null) {
                return;
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("costcenter", "=", costCenter.getPkValue()));
            filters.add(new QFilter("org", "=", acctOrg.getPkValue()));
            filters.add(new QFilter("costobjectrule", "=", (Object)id));
            existObject = !QueryServiceHelper.exists((String)"cad_costobject", (QFilter[])filters.toArray(new QFilter[0]));
        }
        this.getView().setEnable(Boolean.valueOf(existObject), new String[]{"accountorg", "costcenter", "biztype", "rule", "sotype"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (e.getProperty().getName()) {
            case "biztype": {
                this.changeRule(CostObjectEnum.getEnumByValue((String)String.valueOf(newValue)));
                CostObjectEnum bizType = CostObjectEnum.getEnumByValue((String)String.valueOf(newValue));
                this.updateSOType();
                this.setCodeRule(bizType);
                this.showPnorule();
                this.dimensionEnable();
                break;
            }
            case "costcenter": {
                DynamicObject cc = (DynamicObject)newValue;
                if (cc == null) break;
                this.getModel().setValue("accountorg", cc.get("accountorg"));
                break;
            }
            case "rulenumberext": {
                String calMethod = this.getModel().getDataEntity().getString("biztype");
                if (!"CU".equals(calMethod)) break;
                this.getModel().beginInit();
                this.getModel().setValue("rulenameext", (Object)this.getModel().getDataEntity().getString("rulenumberext"));
                this.getView().updateView("rulenameext");
                this.getModel().endInit();
                break;
            }
            case "costcalcdimension": {
                this.updateConfigItem();
                break;
            }
        }
    }

    private void updateConfigItem() {
        this.getModel().beginInit();
        String dimenSion = this.getModel().getDataEntity().getString("costcalcdimension.calcrule");
        StringJoiner value = new StringJoiner(",", ",", ",");
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("costcalcdimension");
        DynamicObjectCollection costCalcDimension = new DynamicObjectCollection();
        if (dimension != null) {
            costCalcDimension = dimension.getDynamicObjectCollection("entryentity");
        }
        ArrayList<CostObjectEnum> enumList = new ArrayList<CostObjectEnum>(10);
        if (dimenSion != null) {
            String calcRule = dimenSion.substring(1, dimenSion.length() - 1);
            for (String key : Arrays.asList(calcRule.split(","))) {
                CostObjectEnum costObjectRuleEnum = CostObjectEnum.getEnumByValue((String)key);
                enumList.add(costObjectRuleEnum);
                value.add(key);
            }
        }
        for (DynamicObject cdimension : costCalcDimension) {
            value.add(cdimension.getString("field"));
        }
        this.setDefComBoEditVal("rulenumberext", enumList, costCalcDimension);
        this.setDefComBoEditVal("rulenameext", enumList, costCalcDimension);
        this.getModel().setValue("rulenumberext", (Object)value.toString());
        this.getModel().setValue("rulenameext", (Object)value.toString());
        this.getView().updateView("rulenumberext");
        this.getView().updateView("rulenameext");
        this.getModel().endInit();
    }

    private void setDefComBoEditVal(String field, List<CostObjectEnum> costObjectEnums, DynamicObjectCollection costCalcDimension) {
        ComboItem comboItem;
        ComboEdit ruleEdit = (ComboEdit)this.getControl(field);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(10);
        for (CostObjectEnum costObjectEnum : costObjectEnums) {
            comboItem = new ComboItem();
            comboItem.setValue(costObjectEnum.getValue());
            comboItem.setCaption(new LocaleString(costObjectEnum.getName()));
            comboItem.setItemVisible(true);
            comboItem.setDisable(true);
            propertyItems.add(comboItem);
        }
        for (DynamicObject cdimension : costCalcDimension) {
            comboItem = new ComboItem();
            comboItem.setValue(cdimension.getString("field"));
            comboItem.setCaption(new LocaleString(cdimension.getString("fieldname")));
            comboItem.setItemVisible(true);
            comboItem.setDisable(true);
            propertyItems.add(comboItem);
        }
        ruleEdit.setComboItems(propertyItems);
        this.getView().updateView(field);
    }

    private void dimensionEnable() {
        String bizType = this.getModel().getDataEntity().getString("biztype");
        if (CostObjectEnum.BIZTYPE_CU.getValue().equals(bizType)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"costcalcdimension"});
            ComboEdit ruleNumberExtEdit = (ComboEdit)this.getControl("rulenumberext");
            ComboEdit ruleNameExtEdit = (ComboEdit)this.getControl("rulenameext");
            ruleNumberExtEdit.setMustInput(true);
            ruleNameExtEdit.setMustInput(true);
        } else {
            this.getModel().beginInit();
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"costcalcdimension"});
            if (CostObjectEnum.BIZTYPE_RO.getValue().equals(bizType)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.RO_ID);
            } else if (CostObjectEnum.BIZTYPE_SO.getValue().equals(bizType)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.SO_ID);
            } else if (CostObjectEnum.BIZTYPE_PZ.getValue().equals(bizType) || CostObjectEnum.BIZTYPE_FL.getValue().equals(bizType)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.PZ_FL_ID);
            } else if (CostObjectEnum.BIZTYPE_SW.getValue().equals(bizType)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.SW_ID);
            } else if (CostObjectEnum.BIZTYPE_SP.getValue().equals(bizType)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.SP_ID);
            }
            this.getView().updateView("costcalcdimension");
            this.getModel().endInit();
        }
    }

    private void changeRule(CostObjectEnum bizType) {
        switch (bizType) {
            case BIZTYPE_RO: {
                this.resetComBoEditVal("rule", CostObjectEnum.RULE_SN);
                this.getModel().setValue("rule", (Object)CostObjectEnum.RULE_SN.getValue());
                break;
            }
            case BIZTYPE_SO: {
                this.resetComBoEditVal("rule", CostObjectEnum.RULE_PN);
                this.getModel().setValue("rule", (Object)CostObjectEnum.RULE_PN.getValue());
                break;
            }
            case BIZTYPE_PZ: 
            case BIZTYPE_FL: {
                this.resetComBoEditVal("rule", CostObjectEnum.RULE_CP);
                this.getModel().setValue("rule", (Object)CostObjectEnum.RULE_CP.getValue());
                break;
            }
            case BIZTYPE_SW: {
                this.resetComBoEditVal("rule", CostObjectEnum.RULE_SW);
                this.getModel().setValue("rule", (Object)CostObjectEnum.RULE_SW.getValue());
                break;
            }
            case BIZTYPE_SP: {
                this.resetComBoEditVal("rule", CostObjectEnum.RULE_SP);
                this.getModel().setValue("rule", (Object)CostObjectEnum.RULE_SP.getValue());
                break;
            }
            case BIZTYPE_CU: {
                this.getModel().setValue("rule", (Object)CostObjectEnum.RULE_CU.getValue());
                break;
            }
        }
    }

    private void updateSOType() {
        String ruleVal = this.getModel().getDataEntity().getString("rule");
        if (ruleVal == null) {
            this.getModel().setValue("sotype", null);
            return;
        }
        if (CostObjectEnum.RULE_SN.getValue().equalsIgnoreCase(ruleVal)) {
            this.getModel().setValue("sotype", (Object)CostObjectEnum.SOTYPE_PB.getValue());
            return;
        }
        if (CostObjectEnum.RULE_SW.getValue().equalsIgnoreCase(ruleVal)) {
            this.getModel().setValue("sotype", (Object)CostObjectEnum.SOTYPE_SW.getValue());
            return;
        }
        if (CostObjectEnum.RULE_SP.getValue().equalsIgnoreCase(ruleVal)) {
            this.getModel().setValue("sotype", (Object)CostObjectEnum.SOTYPE_SP.getValue());
            return;
        }
        if (CostObjectEnum.RULE_PN.getValue().equalsIgnoreCase(ruleVal)) {
            this.getModel().setValue("sotype", (Object)CostObjectEnum.SOTYPE_SB.getValue());
            return;
        }
        this.getModel().setValue("sotype", null);
    }

    private void resetComBoEditVal(String field, CostObjectEnum ... costObjectEnums) {
        ComboEdit ruleEdit = (ComboEdit)this.getControl(field);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(10);
        for (CostObjectEnum costObjectEnum : costObjectEnums) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(costObjectEnum.getValue());
            comboItem.setCaption(new LocaleString(CostObjectEnum.getName((String)costObjectEnum.getValue())));
            propertyItems.add(comboItem);
        }
        ruleEdit.setComboItems(propertyItems);
        this.getView().updateView(field);
    }

    private void setCodeRule(CostObjectEnum bizType) {
        switch (bizType) {
            case BIZTYPE_RO: {
                this.clearExt();
                this.resetComBoEditVal("objrule", CostObjectEnum.CODE_RULE_SRC);
                this.resetComBoEditVal("rulenumberext", CostObjectEnum.CODE_RULE_CPBM, CostObjectEnum.CODE_RULE_GGXH);
                this.resetComBoEditVal("objrulename", CostObjectEnum.CODE_RULE_NAME_SRC);
                this.resetComBoEditVal("rulenameext", CostObjectEnum.CODE_RULE_NAME_CPMC, CostObjectEnum.CODE_RULE_NAME_GGXH);
                this.getModel().setValue("pnorule", null);
                this.getModel().setValue("objrule", (Object)CostObjectEnum.CODE_RULE_SRC.getValue());
                this.getModel().setValue("objrulename", (Object)CostObjectEnum.CODE_RULE_NAME_SRC.getValue());
                break;
            }
            case BIZTYPE_SO: {
                this.clearExt();
                this.resetComBoEditVal("objrule", CostObjectEnum.CODE_RULE_PRO);
                this.resetComBoEditVal("rulenumberext", CostObjectEnum.CODE_RULE_GGXH);
                this.resetComBoEditVal("objrulename", CostObjectEnum.CODE_RULE_NAME_PRO);
                this.resetComBoEditVal("rulenameext", CostObjectEnum.CODE_RULE_NAME_GGXH);
                this.getModel().setValue("pnorule", (Object)CostObjectEnum.PNO_RULE_NO.getValue());
                this.getModel().setValue("objrule", (Object)CostObjectEnum.CODE_RULE_PRO.getValue());
                this.getModel().setValue("objrulename", (Object)CostObjectEnum.CODE_RULE_NAME_PRO.getValue());
                break;
            }
            case BIZTYPE_PZ: {
                this.clearExt();
                this.resetComBoEditVal("objrule", CostObjectEnum.CODE_RULE_CP);
                this.resetComBoEditVal("rulenumberext", CostObjectEnum.CODE_RULE_GGXH);
                this.resetComBoEditVal("objrulename", CostObjectEnum.CODE_RULE_NAME_CP);
                this.resetComBoEditVal("rulenameext", CostObjectEnum.CODE_RULE_NAME_GGXH);
                this.getModel().setValue("pnorule", null);
                this.getModel().setValue("objrule", (Object)CostObjectEnum.CODE_RULE_CP.getValue());
                this.getModel().setValue("objrulename", (Object)CostObjectEnum.CODE_RULE_NAME_CP.getValue());
                break;
            }
            case BIZTYPE_FL: {
                this.clearExt();
                this.resetComBoEditVal("objrule", CostObjectEnum.CODE_RULE_CP);
                this.resetComBoEditVal("rulenumberext", CostObjectEnum.CODE_RULE_GGXH);
                this.resetComBoEditVal("objrulename", CostObjectEnum.CODE_RULE_NAME_CP);
                this.resetComBoEditVal("rulenameext", CostObjectEnum.CODE_RULE_NAME_GGXH);
                this.getModel().setValue("pnorule", null);
                this.getModel().setValue("objrule", (Object)CostObjectEnum.CODE_RULE_CP.getValue());
                this.getModel().setValue("objrulename", (Object)CostObjectEnum.CODE_RULE_NAME_CP.getValue());
                break;
            }
            case BIZTYPE_SW: {
                this.clearExt();
                this.resetComBoEditVal("objrule", CostObjectEnum.CODE_RULE_SRC);
                this.resetComBoEditVal("rulenumberext", CostObjectEnum.CODE_RULE_XMH);
                this.resetComBoEditVal("objrulename", CostObjectEnum.CODE_RULE_NAME_SRC);
                this.resetComBoEditVal("rulenameext", CostObjectEnum.CODE_RULE_NAME_XMH);
                this.getModel().setValue("pnorule", null);
                this.getModel().setValue("objrule", (Object)CostObjectEnum.CODE_RULE_SRC.getValue());
                this.getModel().setValue("objrulename", (Object)CostObjectEnum.CODE_RULE_NAME_SRC.getValue());
                break;
            }
            case BIZTYPE_SP: {
                this.clearExt();
                this.resetComBoEditVal("objrule", CostObjectEnum.CODE_RULE_COP);
                this.resetComBoEditVal("objrulename", CostObjectEnum.CODE_RULE_NAME_COP);
                this.getModel().setValue("objrule", (Object)CostObjectEnum.CODE_RULE_COP.getValue());
                this.getModel().setValue("objrulename", (Object)CostObjectEnum.CODE_RULE_NAME_COP.getValue());
                this.getModel().setValue("pnorule", null);
                ComboEdit ruleNumberExtEdit = (ComboEdit)this.getControl("rulenumberext");
                ComboEdit ruleNameExtEdit = (ComboEdit)this.getControl("rulenameext");
                ruleNumberExtEdit.setComboItems(null);
                ruleNameExtEdit.setComboItems(null);
                break;
            }
            case BIZTYPE_CU: {
                this.clearExt();
                this.getModel().setValue("pnorule", null);
                this.getModel().setValue("pnorulecase", null);
                this.resetComBoEditVal("objrule", CostObjectEnum.CODE_CENTER_NU);
                this.getModel().setValue("objrule", (Object)CostObjectEnum.CODE_CENTER_NU.getValue());
                this.resetComBoEditVal("objrulename", CostObjectEnum.CODE_RULE_NAME_CEN);
                this.getModel().setValue("objrulename", (Object)CostObjectEnum.CODE_RULE_NAME_CEN.getValue());
                this.getModel().setValue("rulenumberext", null);
                this.getModel().setValue("rulenameext", null);
                ComboEdit ruleNumberExtEdit = (ComboEdit)this.getControl("rulenumberext");
                ComboEdit ruleNameExtEdit = (ComboEdit)this.getControl("rulenameext");
                ruleNumberExtEdit.setComboItems(null);
                ruleNameExtEdit.setComboItems(null);
                ruleNumberExtEdit.setMustInput(true);
                ruleNameExtEdit.setMustInput(true);
                this.getModel().setValue("costcalcdimension", null);
            }
        }
    }

    private void clearExt() {
        this.getModel().setValue("rulenumberext", null);
        this.getModel().setValue("rulenameext", null);
        ComboEdit ruleNumberExtEdit = (ComboEdit)this.getControl("rulenumberext");
        ruleNumberExtEdit.setMustInput(false);
        ComboEdit ruleNameExtEdit = (ComboEdit)this.getControl("rulenameext");
        ruleNameExtEdit.setMustInput(false);
    }

    private void showPnorule() {
        this.getView().setVisible(Boolean.valueOf(this.isSimpleBizType()), new String[]{"pnorule", "pnoruleass", "pnorulecase"});
    }
}

