/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costobject;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.formplugin.common.Util;
import kd.macc.cad.formplugin.costobject.BaseCostObjectListPlugin;

public class CostObjectRuleListPlugin
extends BaseCostObjectListPlugin {
    public CostObjectRuleListPlugin() {
        this.ORG_FIELD = "accountorg";
        this.COSTCENTER_FIELD = "costcenter";
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("audit".equals(formOperate.getOperateKey()) || "enable".equals(formOperate.getOperateKey())) {
            operate.getOption().setVariableValue("appnum", AppIdHelper.getCurAppNum((IFormView)this.getView()));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setRuleAndRuleName();
    }

    private void setRuleAndRuleName() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        if (rows.size() < 1) {
            return;
        }
        QFilter filter = new QFilter("id", "in", (Object)rows.getPrimaryKeyValues());
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"cad_costobjectrule", (String)"id,biztype,objrule,objruleass,objrulename,objrulenameass,pnorule,pnoruleass", (QFilter[])new QFilter[]{filter});
        HashMap ruleMap = new HashMap();
        HashMap ruleNameMap = new HashMap();
        HashMap pnoRuleAssMap = new HashMap();
        cols.forEach(item -> {
            String pnoAss = item.getString("pnoruleass");
            String objRuleAss = item.getString("objruleass");
            String objRuleNameAss = item.getString("objrulenameass");
            String bizTypeVal = item.getString("biztype");
            if (StringUtils.isNotEmpty((String)objRuleAss)) {
                String rule = CostObjectEnum.getName((String)item.getString("objrule"));
                rule = objRuleAss + "-" + rule;
                if (CostObjectEnum.BIZTYPE_SO.getValue().equalsIgnoreCase(bizTypeVal)) {
                    rule = this.addPnoRule(rule, pnoAss, item.getString("pnorule"));
                }
                ruleMap.putIfAbsent(item.get("id"), rule);
            }
            if (StringUtils.isNotEmpty((String)objRuleNameAss)) {
                String ruleName = CostObjectEnum.getName((String)item.getString("objrulename"));
                ruleName = objRuleNameAss + "-" + ruleName;
                if (CostObjectEnum.BIZTYPE_SO.getValue().equalsIgnoreCase(bizTypeVal)) {
                    ruleName = this.addPnoRule(ruleName, pnoAss, item.getString("pnorule"));
                }
                ruleNameMap.putIfAbsent(item.get("id"), ruleName);
            }
            if (StringUtils.isNotEmpty((String)pnoAss)) {
                String pnoRule = item.getString("pnorule");
                if (CostObjectEnum.PNO_RULE_NO.getValue().equals(pnoRule)) {
                    pnoRuleAssMap.putIfAbsent(item.get("id"), String.format(ResManager.loadKDString((String)"%s\u6d41\u6c34\u53f7", (String)"CostObjectRuleListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), pnoAss));
                }
            }
        });
        int i = 0;
        for (ListSelectedRow row : rows) {
            Object id = row.getPrimaryKeyValue();
            if (id == null) continue;
            if (ruleMap.get(id) != null) {
                billList.setCellFieldValue("objrule", i, ruleMap.get(id));
            }
            if (ruleNameMap.get(id) != null) {
                billList.setCellFieldValue("objrulename", i, ruleNameMap.get(id));
            }
            if (pnoRuleAssMap.get(id) != null) {
                billList.setCellFieldValue("pnorule", i, pnoRuleAssMap.get(id));
            }
            ++i;
        }
    }

    private String addPnoRule(String item, String pnoRuleAss, String pnoRule) {
        return item.substring(0, item.lastIndexOf("-") + 1) + pnoRuleAss + pnoRule;
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("number asc");
        List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        QFilter orgIdsFilter = new QFilter("accountorg.id", "in", (Object)hasPermAccountOrgIds);
        e.getQFilters().add(orgIdsFilter);
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        List listColumns = o.getListColumns();
        ArrayList toFixedCloumns = Lists.newArrayList((Object[])new String[]{"number", "name"});
        ArrayList toVisableCloumns = Lists.newArrayList((Object[])new String[]{"objrule", "objrulename", "remark"});
        Util.setDefaultFixedAndVisibleColumes(listColumns, toFixedCloumns, toVisableCloumns);
    }
}

