/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costupdatebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.calc.helper.CalcMutexHelper;
import kd.macc.cad.algox.function.TimeUtils;
import kd.macc.cad.business.update.CostUpdateEstablishedHelper;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class CostQuickUpdateEdit
extends AbstractFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final Log logger = LogFactory.getLog(CostQuickUpdateEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        DynamicObject srccosttype = (DynamicObject)this.getModel().getValue("srccosttype");
        if (srccosttype != null) {
            QFilter filter = new QFilter("currency", "=", srccosttype.get("currency.id"));
            filter.and("id", "!=", srccosttype.get("id"));
            BasedataEdit targetcosttype = (BasedataEdit)this.getControl("targetcosttype");
            targetcosttype.addBeforeF7SelectListener(evt -> {
                ListShowParameter lsp = (ListShowParameter)evt.getFormShowParameter();
                lsp.getListFilterParameter().getQFilters().add(filter);
                lsp.getListFilterParameter().getQFilters().add(CostTypeHelper.getScaCostType());
                QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
                if (baseDataFilter != null) {
                    lsp.getListFilterParameter().getQFilters().add(baseDataFilter);
                }
            });
            MulBasedataEdit attachTargetCostType = (MulBasedataEdit)this.getControl("attachtargetcosttype");
            attachTargetCostType.addBeforeF7SelectListener(evt -> {
                QFilter baseDataFilter;
                ListShowParameter lsp = (ListShowParameter)evt.getFormShowParameter();
                QFilter currencyFilter = new QFilter("currency", "=", srccosttype.get("currency.id"));
                lsp.getListFilterParameter().getQFilters().add(CostTypeHelper.getCurrUserUsableCostTypeFilter());
                lsp.getListFilterParameter().getQFilters().add(currencyFilter);
                DynamicObjectCollection costTypeEntrys = srccosttype.getDynamicObjectCollection("costtypeentry");
                ArrayList<Long> ids = new ArrayList<Long>(1);
                for (DynamicObject costTypeEntry : costTypeEntrys) {
                    if (!CostTypePtyEnum.CALCULATING.getValue().equals(costTypeEntry.getString("costtypeattr"))) continue;
                    ids.add(costTypeEntry.getLong("costtype.id"));
                }
                if (!CadEmptyUtils.isEmpty(ids)) {
                    lsp.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", ids));
                }
                if ((baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter()) != null) {
                    lsp.getListFilterParameter().getQFilters().add(baseDataFilter);
                }
            });
            BasedataEdit period = (BasedataEdit)this.getControl("period");
            period.addBeforeF7SelectListener(evt -> {
                ListShowParameter lsp = (ListShowParameter)evt.getFormShowParameter();
                DynamicObject targgetCostType = (DynamicObject)this.getModel().getValue("targetcosttype");
                if (targgetCostType == null) {
                    evt.setCancel(true);
                    return;
                }
                lsp.getListFilterParameter().getQFilters().add(this.getPeriodQFilter(targgetCostType.getLong("id")));
            });
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property;
        switch (property = e.getProperty().getName()) {
            case "targetcosttype": {
                this.initPeriod();
                break;
            }
            case "iscalccurlevel": {
                this.updateCurLevel();
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String isAttTargetCostType = CadBgParamUtils.getCadBgParamForString((String)"isAttTargetCostType", (String)"0");
        if (!"1".equals(isAttTargetCostType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"attachtargetcosttype"});
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String costtypeId = (String)formShowParameter.getCustomParam("costtype");
        String sourcePage = (String)formShowParameter.getCustomParam("sourcePage");
        List ids = (List)formShowParameter.getCustomParam("ids");
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)ids)};
        List<Object> toUpdatePKs = new ArrayList();
        long costTypeId = StringUtils.isEmpty((String)costtypeId) ? 0L : Long.parseLong(costtypeId);
        DynamicObject costtype = BusinessDataServiceHelper.loadSingle((Object)costTypeId, (String)"cad_costtype");
        this.getModel().setValue("srccosttype", (Object)costtype);
        this.getModel().setValue("costtypeprop", (Object)(CostTypePtyEnum.SIMULATED.getValue().equals(costtype.getString("type")) ? ResManager.loadKDString((String)"\u6a21\u62df\u6210\u672c", (String)"CostQuickUpdateEdit_0", (String)"macc-cad-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c", (String)"CostQuickUpdateEdit_1", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        this.getModel().setValue("currency", costtype.get("currency.name"));
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        entryentity.clear();
        switch (sourcePage) {
            case "bomSetting": {
                Object[] bomSettings = BusinessDataServiceHelper.load((String)"cad_bomsetting", (String)"id,material,bomversion,auxprop", (QFilter[])filters);
                if (!CadEmptyUtils.isEmpty((Object[])bomSettings)) {
                    toUpdatePKs = Arrays.stream(bomSettings).map(obj -> obj.get("id")).collect(Collectors.toList());
                    for (Object bomSetting : bomSettings) {
                        DynamicObject entry = entryentity.addNew();
                        entry.set("material", bomSetting.get("material"));
                        entry.set("matversion", bomSetting.get("bomversion"));
                        entry.set("auxprop", bomSetting.get("auxprop"));
                    }
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"attachtargetcosttype"});
                break;
            }
            case "purPrice": {
                Object[] outPurchases = BusinessDataServiceHelper.load((String)"cad_purprices", (String)"id,material,matversion,auxpty,configuredcode,lot,tracknumber,project", (QFilter[])filters);
                if (CadEmptyUtils.isEmpty((Object[])outPurchases)) break;
                toUpdatePKs = Arrays.stream(outPurchases).map(obj -> obj.get("id")).collect(Collectors.toList());
                for (Object ourPurchase : outPurchases) {
                    DynamicObject entry = entryentity.addNew();
                    entry.set("material", ourPurchase.get("material"));
                    entry.set("matversion", ourPurchase.get("matversion"));
                    entry.set("auxprop", ourPurchase.get("auxpty"));
                    entry.set("configuredcode", ourPurchase.get("configuredcode"));
                    entry.set("tracknumber", ourPurchase.get("tracknumber"));
                    entry.set("project", ourPurchase.get("project"));
                    entry.set("lot", ourPurchase.get("lot"));
                }
                break;
            }
            case "outSource": {
                this.getPageCache().put("ids", SerializationUtils.toJsonString((Object)ids));
                Object[] outSources = BusinessDataServiceHelper.load((String)"cad_outsourceprice", (String)"id,material,matversion,auxpty,configuredcode,lot,tracknumber,project", (QFilter[])filters);
                if (CadEmptyUtils.isEmpty((Object[])outSources)) break;
                toUpdatePKs = Arrays.stream(outSources).map(obj -> obj.get("id")).collect(Collectors.toList());
                for (Object outSource : outSources) {
                    DynamicObject entry = entryentity.addNew();
                    entry.set("material", outSource.get("material"));
                    entry.set("auxprop", outSource.get("auxpty"));
                    entry.set("configuredcode", outSource.get("configuredcode"));
                    entry.set("tracknumber", outSource.get("tracknumber"));
                    entry.set("project", outSource.get("project"));
                    entry.set("lot", outSource.get("lot"));
                }
                break;
            }
            case "resource": {
                boolean iscalccurlevel;
                List matIds = (List)formShowParameter.getCustomParam("resourceMatIds");
                TableValueSetter vs = new TableValueSetter(new String[0]);
                if (CadEmptyUtils.isEmpty((List)ids)) {
                    int index = 0;
                    for (Object matId : matIds) {
                        vs.set("material", matId, index);
                        ++index;
                    }
                } else {
                    List resIds = (List)formShowParameter.getCustomParam("resourcesByNoRef");
                    DynamicObjectCollection resourceOuts = QueryServiceHelper.query((String)"cad_resourceout", (String)"material,auxpty,resource", (QFilter[])filters);
                    int index = 0;
                    for (DynamicObject resourceOut : resourceOuts) {
                        Long materialId = resourceOut.getLong("material");
                        if (CadEmptyUtils.isEmpty((Long)materialId) || resIds.contains(resourceOut.get("resource"))) {
                            logger.info(String.format("\u7269\u6599=%s\uff0c\u8d44\u6e90=%s", materialId, resourceOut.get("resource")));
                            continue;
                        }
                        vs.set("material", (Object)materialId, index);
                        vs.set("auxprop", (Object)resourceOut.getLong("auxpty"), index);
                        ++index;
                    }
                }
                if (!(iscalccurlevel = ((Boolean)this.getModel().getValue("iscalccurlevel")).booleanValue())) {
                    ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"attachtargetcosttype"});
                this.getPageCache().put("resourceformid", (String)formShowParameter.getCustomParam("resourceformid"));
                this.getPageCache().put("ids", SerializationUtils.toJsonString((Object)ids));
                this.getPageCache().put("resourceMatIds", SerializationUtils.toJsonString((Object)matIds));
                this.getPageCache().put("resourcesByNoRef", SerializationUtils.toJsonString((Object)formShowParameter.getCustomParam("resourcesByNoRef")));
                this.getPageCache().put("resourceMatByUseAuxp", SerializationUtils.toJsonString((Object)formShowParameter.getCustomParam("resourceMatByUseAuxp")));
                break;
            }
            default: {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"attachtargetcosttype"});
            }
        }
        this.getPageCache().put("sourcePage", sourcePage);
        this.getPageCache().put("sourcePKs", SerializationUtils.serializeToBase64(toUpdatePKs));
        if (!entryentity.isEmpty()) {
            this.getModel().setValue("isspecifymaterial", (Object)Boolean.TRUE);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDefaultTargetCostType();
        DynamicObject targetCostType = (DynamicObject)this.getModel().getValue("targetcosttype");
        if (targetCostType == null) {
            this.getView().setVisible(Boolean.valueOf(this.getModel().getValue("period") != null), new String[]{"period"});
        } else {
            String status = CostUpdateHelper.getIsUpdateByPeriod((Long)targetCostType.getLong("id"));
            this.getView().setVisible(Boolean.valueOf(Boolean.TRUE.toString().equals(status) || this.getModel().getValue("period") != null), new String[]{"period"});
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"iscalccurlevel"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"iscalccurlevel"});
        this.getModel().setValue("iscalccurlevel", (Object)Boolean.TRUE);
        this.getView().updateView("iscalccurlevel");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("quickupdate".equals(evt.getItemKey())) {
            DynamicObject period;
            DynamicObject targetCostType = (DynamicObject)this.getModel().getValue("targetcosttype");
            if (targetCostType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u76ee\u6807\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"CostQuickUpdateEdit_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String status = CostUpdateHelper.getIsUpdateByPeriod((Long)targetCostType.getLong("id"));
            if (Boolean.TRUE.toString().equals(status) && (period = (DynamicObject)this.getModel().getValue("period")) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u751f\u6548\u671f\u95f4\u201d\u3002", (String)"CostQuickUpdateEdit_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if ("outSource".equals(this.getPageCache().get("sourcePage"))) {
                boolean iscalccurlevel = (Boolean)this.getModel().getValue("iscalccurlevel");
                if (iscalccurlevel) {
                    return;
                }
                List ids = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("ids"), List.class);
                if (CadEmptyUtils.isEmpty((List)ids)) {
                    return;
                }
                String existsKeyCol = CostUpdateHelper.isUpdateByKeyCol((String)"cad_outsourceprice", (List)ids, (String)"billno");
                if (!CadEmptyUtils.isEmpty((String)existsKeyCol)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5feb\u901f\u66f4\u65b0\u5931\u8d25\uff0c\u5355\u636e\u201c%s\u201d\u7684\u4ea7\u54c1\u59d4\u5916\u6807\u51c6\u4ef7\u76ee\u8868\u4e0d\u652f\u6301\u7269\u6599\u6309\u8ddf\u8e2a\u53f7\u7ef4\u5ea6\u8fdb\u884c\u5feb\u901f\u66f4\u65b0\u3002", (String)"CostQuickUpdateEdit_14", (String)"macc-cad-formplugin", (Object[])new Object[0]), existsKeyCol));
                    evt.setCancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("quickupdate".equals(evt.getItemKey())) {
            boolean hasPerimit = this.checkPerimission();
            if (!hasPerimit) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u66f4\u65b0\u7533\u8bf7\u5355\u201d\u7684\u201c\u5ba1\u6838\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostQuickUpdateEdit_15", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)ResManager.loadKDString((String)"\u5feb\u901f\u66f4\u65b0\u7533\u8bf7", (String)"CostQuickUpdateEdit_16", (String)"macc-cad-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u65e0\u201c\u66f4\u65b0\u7533\u8bf7\u5355\u201d\u7684\u201c\u5ba1\u6838\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostQuickUpdateEdit_15", (String)"macc-cad-formplugin", (Object[])new Object[0]), (String)"cad_quickapplyupdate", (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
                return;
            }
            DynamicObject targetCostType = (DynamicObject)this.getModel().getValue("targetcosttype");
            if (targetCostType == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76ee\u6807\u6210\u672c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostQuickUpdateEdit_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            Long targetCostTypeId = targetCostType.getLong("id");
            DynamicObject srcCostType = (DynamicObject)this.getModel().getValue("srccosttype");
            Object srcCostTypeId = srcCostType.getPkValue();
            Set resourceMatIds = new HashSet(10);
            if (this.getPageCache().get("resourceMatIds") != null) {
                resourceMatIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("resourceMatIds"), Set.class);
            }
            boolean iscalccurlevel = (Boolean)this.getModel().getValue("iscalccurlevel");
            if ("outSource".equals(this.getPageCache().get("sourcePage")) && iscalccurlevel) {
                String isAttTargetCostType = CadBgParamUtils.getCadBgParamForString((String)"isAttTargetCostType", (String)"0");
                if ("1".equals(isAttTargetCostType)) {
                    DynamicObjectCollection attTargetCostTypes = (DynamicObjectCollection)this.getModel().getValue("attachtargetcosttype");
                    HashSet<Long> costTypeIds = new HashSet<Long>(10);
                    costTypeIds.add(targetCostTypeId);
                    for (DynamicObject attTargetCostType : attTargetCostTypes) {
                        long attCostTypeId = attTargetCostType.getLong("fbasedataid.id");
                        if (CadEmptyUtils.isEmpty((Long)attCostTypeId)) continue;
                        costTypeIds.add(attCostTypeId);
                    }
                    this.updateOutSourcePrice(srcCostType.getLong("id"), costTypeIds);
                    return;
                }
                DynamicObject updateBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew");
                updateBill.set("srccosttype_id", srcCostTypeId);
                updateBill.set("targetcosttype_id", (Object)targetCostTypeId);
                updateBill.set("isallupdate", (Object)false);
                updateBill.set("billno", (Object)("CBGX-" + TimeUtils.formatDate((Date)TimeServiceHelper.now(), (String)"yyyyMMddHHmmss")));
                updateBill.set("updatestatus", (Object)"N");
                updateBill.set("matgrpstd_id", (Object)730148448254487552L);
                BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{updateBill}, (IDataEntityType)updateBill.getDynamicObjectType());
                List ids = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("ids"), List.class);
                if (CadEmptyUtils.isEmpty((List)ids)) {
                    logger.info("\u4ea7\u54c1\u59d4\u5916\u4ef7\u76ee\u8868Ids\u4e3a\u7a7a\u3002");
                    return;
                }
                Date effectTime = TimeServiceHelper.now();
                if (this.getModel().getValue("period") != null && Boolean.TRUE.toString().equals(CostUpdateHelper.getIsUpdateByPeriod((Long)Long.parseLong(targetCostTypeId.toString())))) {
                    DynamicObject period = (DynamicObject)this.getModel().getValue("period");
                    Date[] dates = PeriodHelper.getPeriodStartAndEndTime((Long)period.getLong("id"));
                    if (dates == null || dates.length != 2) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6548\u671f\u95f4\u6709\u8bef\uff0c\u8bf7\u786e\u8ba4\u8be5\u4f1a\u8ba1\u671f\u95f4\u662f\u5426\u5b58\u5728\u3002", (String)"CostQuickUpdateEdit_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    }
                    effectTime = dates[0];
                }
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
                HashSet<Long> keyColIds = new HashSet<Long>(entrys.size());
                HashMap<String, Long> values = new HashMap<String, Long>(7);
                for (DynamicObject entry : entrys) {
                    Long matId = entry.getLong("material.id");
                    if (CadEmptyUtils.isEmpty((Long)matId)) continue;
                    values.clear();
                    values.put("material", entry.getLong("material.id"));
                    values.put("matvers", entry.getLong("matversion.id"));
                    values.put("auxproperty", entry.getLong("auxprop.id"));
                    values.put("project", entry.getLong("project.id"));
                    values.put("tracknumber", entry.getLong("tracknumber.id"));
                    values.put("configuredcode", entry.getLong("configuredcode.id"));
                    values.put("lot", entry.getLong("lot"));
                    Long keyColId = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)Boolean.FALSE).getId();
                    if (CadEmptyUtils.isEmpty((Long)keyColId)) continue;
                    keyColIds.add(keyColId);
                }
                QFilter filter = new QFilter("costtype", "=", (Object)targetCostTypeId);
                filter.and(new QFilter("keycolid", "in", keyColIds));
                filter.and(new QFilter("effectdate", ">", (Object)effectTime));
                if (QueryServiceHelper.exists((String)"cad_outsourceprice", (QFilter[])new QFilter[]{filter})) {
                    String matInfos = this.getMatInfos(keyColIds);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5b58\u5728\u5927\u4e8e\u751f\u6548\u65f6\u95f4\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u66f4\u65b0\u3002", (String)"CostQuickUpdateEdit_17", (String)"macc-cad-formplugin", (Object[])new Object[0]), matInfos));
                    return;
                }
                String lockErr = CalcMutexHelper.checkAndRequireXMutexAll((String)"update", Collections.singleton(targetCostTypeId));
                if (StringUtils.isNotEmpty((String)lockErr)) {
                    this.getView().showErrorNotification(lockErr);
                    return;
                }
                try {
                    CostUpdateEstablishedHelper.copyOutSourcePrice((DynamicObject)updateBill, new HashSet(ids), keyColIds, (Date)effectTime);
                }
                finally {
                    CalcMutexHelper.releaseXMutex((String)"update", Collections.singleton(targetCostTypeId));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4ea7\u54c1\u59d4\u5916\u6807\u51c6\u4ef7\u76ee\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"CostQuickUpdateEdit_18", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("resource".equals(this.getPageCache().get("sourcePage")) && iscalccurlevel) {
                resourceMatIds.clear();
            }
            if ("resource".equals(this.getPageCache().get("sourcePage")) && resourceMatIds.isEmpty()) {
                String resourceFormId = this.getPageCache().get("resourceformid");
                if (CadEmptyUtils.isEmpty((String)resourceFormId)) {
                    logger.info("resourceFormId\u83b7\u53d6\u4e3a\u7a7a\u3002");
                    return;
                }
                Set resIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("resourcesByNoRef"), Set.class);
                if (iscalccurlevel) {
                    this.getResourceIds(resourceFormId, resIds);
                }
                if (CadEmptyUtils.isEmpty((Set)resIds)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u7269\u6599\u5f15\u7528\u8d44\u6e90\u7684\u60c5\u51b5\u4e0b\uff0c\u6ca1\u6709\u53ef\u66f4\u65b0\u7684\u8d44\u6e90\u3002", (String)"CostQuickUpdateEdit_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                Date effecttime = TimeServiceHelper.now();
                if (this.getModel().getValue("period") != null && Boolean.TRUE.toString().equals(CostUpdateHelper.getIsUpdateByPeriod((Long)Long.parseLong(targetCostTypeId.toString())))) {
                    DynamicObject period = (DynamicObject)this.getModel().getValue("period");
                    Date[] dates = PeriodHelper.getPeriodStartAndEndTime((Long)period.getLong("id"));
                    if (dates == null || dates.length != 2) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6548\u671f\u95f4\u6709\u8bef\uff0c\u8bf7\u786e\u8ba4\u8be5\u4f1a\u8ba1\u671f\u95f4\u662f\u5426\u5b58\u5728\u3002", (String)"CostQuickUpdateEdit_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    }
                    effecttime = dates[0];
                }
                DynamicObject updateBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew");
                updateBill.set("srccosttype_id", srcCostTypeId);
                updateBill.set("targetcosttype_id", (Object)targetCostTypeId);
                updateBill.set("isallupdate", (Object)false);
                updateBill.set("billno", (Object)("CBGX-" + TimeUtils.formatDate((Date)TimeServiceHelper.now(), (String)"yyyyMMddHHmmss")));
                updateBill.set("updatestatus", (Object)"N");
                updateBill.set("matgrpstd_id", (Object)730148448254487552L);
                BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{updateBill}, (IDataEntityType)updateBill.getDynamicObjectType());
                String tipName = null;
                HashMap<String, String> returnData = new HashMap<String, String>();
                String lockErr = CalcMutexHelper.checkAndRequireXMutexAll((String)"update", Collections.singleton(targetCostTypeId));
                if (StringUtils.isNotEmpty((String)lockErr)) {
                    this.getView().showErrorNotification(lockErr);
                    return;
                }
                try {
                    Set<Long> ids;
                    if ("cad_resourcerate".equals(resourceFormId)) {
                        ids = this.getIds(resourceFormId, resIds, iscalccurlevel);
                        String checkTip = this.checkEffectTimeByRate(ids, effecttime, targetCostTypeId);
                        if (!CadEmptyUtils.isEmpty((String)checkTip)) {
                            this.getView().showErrorNotification(checkTip);
                            return;
                        }
                        tipName = ResManager.loadKDString((String)"\u81ea\u5236\u8d44\u6e90\u6807\u51c6\u8d39\u7387\u4ef7\u76ee\u8868", (String)"CostQuickUpdateEdit_8", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                        CostUpdateEstablishedHelper.copyResourceRate((DynamicObject)updateBill, (Date)effecttime, ids);
                    } else if ("cad_resourceout".equals(resourceFormId)) {
                        ids = this.getIds(resourceFormId, resIds, iscalccurlevel);
                        String checkTip = this.checkEffectTimeByOut(ids, effecttime, targetCostTypeId);
                        if (!CadEmptyUtils.isEmpty((String)checkTip)) {
                            this.getView().showErrorNotification(checkTip);
                            return;
                        }
                        tipName = ResManager.loadKDString((String)"\u5916\u534f\u8d44\u6e90\u6807\u51c6\u8d39\u7387\u4ef7\u76ee\u8868", (String)"CostQuickUpdateEdit_9", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                        CostUpdateEstablishedHelper.copyResourceOut((DynamicObject)updateBill, (Date)effecttime, ids);
                    }
                    returnData.put("result", "success");
                    returnData.put("msg", String.format(ResManager.loadKDString((String)"%s\u66f4\u65b0\u6210\u529f\u3002", (String)"CostQuickUpdateEdit_10", (String)"macc-cad-formplugin", (Object[])new Object[0]), tipName));
                }
                catch (KDBizException ex) {
                    returnData.put("result", "failed");
                    returnData.put("msg", String.format(ResManager.loadKDString((String)"%s\u66f4\u65b0\u5931\u8d25\u3002", (String)"CostQuickUpdateEdit_11", (String)"macc-cad-formplugin", (Object[])new Object[0]), tipName));
                    logger.error((Throwable)ex);
                }
                finally {
                    CalcMutexHelper.releaseXMutex((String)"update", Collections.singleton(targetCostTypeId));
                }
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                return;
            }
            HashSet<String> notUpdateBills = new HashSet<String>(10);
            boolean enabledAdd = false;
            if (iscalccurlevel) {
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
                ArrayList<Long> keyColIds = new ArrayList<Long>(entrys.size());
                HashMap<String, Object> values = new HashMap<String, Object>(7);
                for (DynamicObject entry : entrys) {
                    Long matId = entry.getLong("material.id");
                    if (CadEmptyUtils.isEmpty((Long)matId)) continue;
                    values.clear();
                    values.put("material", entry.getLong("material.id"));
                    values.put("matvers", entry.getLong("matversion.id"));
                    values.put("auxproperty", entry.getLong("auxprop.id"));
                    values.put("project", entry.getLong("project.id"));
                    values.put("tracknumber", entry.getLong("tracknumber.id"));
                    values.put("configuredcode", entry.getLong("configuredcode.id"));
                    values.put("lot", entry.getLong("lot"));
                    Long keyColId = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)Boolean.FALSE).getId();
                    if (CadEmptyUtils.isEmpty((Long)keyColId)) continue;
                    keyColIds.add(keyColId);
                }
                ArrayList<Long> existsKeyColIds = new ArrayList<Long>(16);
                QFilter[] filters = new QFilter[]{new QFilter("targetcosttype", "=", (Object)targetCostTypeId), new QFilter("updatestatus", "=", (Object)Character.valueOf('N')), new QFilter("iscalccurlevel", "=", (Object)"1")};
                String selectFields = "entryentity.material material,entryentity.matversion matversion,entryentity.auxprop auxprop,entryentity.project project,entryentity.configuredcode configuredcode,entryentity.tracknumber tracknumber,entryentity.lot lot";
                DynamicObjectCollection datas = QueryServiceHelper.query((String)"cad_costupdatenew", (String)selectFields, (QFilter[])filters);
                for (DynamicObject data : datas) {
                    Long matId = data.getLong("material");
                    if (CadEmptyUtils.isEmpty((Long)matId)) continue;
                    values.clear();
                    values.put("material", data.getLong("material"));
                    values.put("matvers", data.getLong("matversion"));
                    values.put("auxproperty", data.getLong("auxprop"));
                    values.put("project", data.getLong("project"));
                    values.put("tracknumber", data.getLong("tracknumber"));
                    values.put("configuredcode", data.getLong("configuredcode"));
                    values.put("lot", data.getString("lot"));
                    Long keyColId = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)Boolean.FALSE).getId();
                    if (CadEmptyUtils.isEmpty((Long)keyColId)) continue;
                    existsKeyColIds.add(keyColId);
                }
                for (Long keyColId : keyColIds) {
                    if (!existsKeyColIds.contains(keyColId)) continue;
                    enabledAdd = true;
                }
                existsKeyColIds.retainAll(keyColIds);
                notUpdateBills.addAll(this.getNotUpdateBills(targetCostTypeId, existsKeyColIds));
            } else {
                QFilter[] filters = new QFilter[]{new QFilter("targetcosttype", "=", (Object)targetCostTypeId), new QFilter("updatestatus", "=", (Object)"N")};
                enabledAdd = QueryServiceHelper.exists((String)"cad_costupdatenew", (QFilter[])filters);
                notUpdateBills.addAll(this.getNotUpdateBills(filters));
            }
            if (enabledAdd) {
                String tip = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u76ee\u6807\u6210\u672c\u7c7b\u578b\u201c%1$s\u201d\u5b58\u5728\u66f4\u65b0\u7533\u8bf7\u5355\u201c%2$s\u201d\u672a\u5b8c\u6210\u66f4\u65b0\uff0c\u4e0d\u80fd\u91cd\u590d\u7533\u8bf7\u3002", (String)"CostQuickUpdateEdit_19", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                StringBuilder sg = new StringBuilder();
                sg.append(targetCostType.getString("number"));
                sg.append('/');
                sg.append(targetCostType.getString("name"));
                this.getView().showErrorNotification(String.format(tip, sg.toString(), String.join((CharSequence)"\u3001", notUpdateBills)));
                return;
            }
            DynamicObject costupdatenew = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew");
            costupdatenew.set("srccosttype", srcCostTypeId);
            costupdatenew.set("targetcosttype", (Object)targetCostTypeId);
            Object periodId = this.getModel().getValue("period");
            costupdatenew.set("period", periodId != null ? ((DynamicObject)periodId).getPkValue() : null);
            costupdatenew.set("updatestatus", (Object)"N");
            costupdatenew.set("matgrpstd", (Object)730148448254487552L);
            boolean isspecifymaterial = (Boolean)this.getModel().getValue("isspecifymaterial");
            if (!isspecifymaterial) {
                costupdatenew.set("isspecifymaterial", (Object)false);
            } else {
                costupdatenew.set("isspecifymaterial", (Object)true);
                this.fillMaterialEntry(costupdatenew);
            }
            costupdatenew.set("iscalccurlevel", (Object)iscalccurlevel);
            costupdatenew.set("isallupdate", (Object)Boolean.FALSE);
            if ("resource".equals(this.getPageCache().get("sourcePage"))) {
                costupdatenew.set("sourcepage", (Object)this.getPageCache().get("sourcePage"));
                costupdatenew.set("resbynoref", (Object)this.getPageCache().get("resourcesByNoRef"));
                costupdatenew.set("resmatbyuseauxpt", (Object)this.getPageCache().get("resourceMatByUseAuxp"));
            }
            DynamicObjectCollection attTargetCostTypes = (DynamicObjectCollection)this.getModel().getValue("attachtargetcosttype");
            costupdatenew.set("attachtargetcosttype", (Object)attTargetCostTypes);
            costupdatenew.set("isquickupdate", (Object)true);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_costupdatenew", (DynamicObject[])new DynamicObject[]{costupdatenew}, (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                DynamicObject[] dynamicObjects;
                List pkIds = operationResult.getSuccessPkIds();
                for (DynamicObject dobj : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_costupdatenew", (String)"billstatus,auditdate,createtime,auditor,creator", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)})) {
                    dobj.set("billstatus", (Object)Character.valueOf('C'));
                    dobj.set("createtime", (Object)new Date());
                    dobj.set("auditdate", (Object)new Date());
                    dobj.set("auditor", (Object)RequestContext.getOrCreate().getCurrUserId());
                    dobj.set("creator", (Object)RequestContext.getOrCreate().getCurrUserId());
                }
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                Map<String, Object> params = this.buildCustomParams(pkIds);
                CostUpdateHelper.showUpdateWizard((IFormView)this.getView(), params, pkIds.get(0));
            } else {
                this.getView().showOperationResult(operationResult);
            }
        }
    }

    private void updateOutSourcePrice(Long srcCostTypeId, Set<Long> costTypeIds) {
        try (TXHandle tx = TX.requiresNew();){
            StringBuilder sb = new StringBuilder();
            costTypeIds.forEach(targetCostTypeId -> {
                DynamicObject updateBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew");
                updateBill.set("srccosttype_id", (Object)srcCostTypeId);
                updateBill.set("targetcosttype_id", targetCostTypeId);
                updateBill.set("isallupdate", (Object)false);
                updateBill.set("billno", (Object)("CBGX-" + TimeUtils.formatDate((Date)TimeServiceHelper.now(), (String)"yyyyMMddHHmmss")));
                updateBill.set("updatestatus", (Object)"N");
                updateBill.set("matgrpstd_id", (Object)730148448254487552L);
                BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{updateBill}, (IDataEntityType)updateBill.getDynamicObjectType());
                List ids = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("ids"), List.class);
                if (CadEmptyUtils.isEmpty((List)ids)) {
                    logger.info("\u4ea7\u54c1\u59d4\u5916\u4ef7\u76ee\u8868Ids\u4e3a\u7a7a\u3002");
                    return;
                }
                Date effectTime = TimeServiceHelper.now();
                if (this.getModel().getValue("period") != null && Boolean.TRUE.toString().equals(CostUpdateHelper.getIsUpdateByPeriod((Long)Long.parseLong(targetCostTypeId.toString())))) {
                    DynamicObject period = (DynamicObject)this.getModel().getValue("period");
                    Date[] dates = PeriodHelper.getPeriodStartAndEndTime((Long)period.getLong("id"));
                    if (dates == null || dates.length != 2) {
                        if (!CadEmptyUtils.isEmpty((String)sb.toString())) {
                            sb.append("\uff1b");
                        }
                        sb.append(String.format(ResManager.loadKDString((String)"\u5f85\u66f4\u65b0\u6210\u672c\u7c7b\u578b\u201c%s\u201d\u7684\u751f\u6548\u671f\u95f4\u6709\u8bef\uff0c\u8bf7\u786e\u8ba4\u8be5\u4f1a\u8ba1\u671f\u95f4\u662f\u5426\u5b58\u5728\u3002", (String)"CostQuickUpdateEdit_20", (String)"macc-cad-formplugin", (Object[])new Object[0]), updateBill.getString("targetcosttype.name")));
                        return;
                    }
                    effectTime = dates[0];
                }
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
                HashSet<Long> keyColIds = new HashSet<Long>(entrys.size());
                HashMap<String, Long> values = new HashMap<String, Long>(7);
                for (DynamicObject entry : entrys) {
                    Long matId = entry.getLong("material.id");
                    if (CadEmptyUtils.isEmpty((Long)matId)) continue;
                    values.clear();
                    values.put("material", entry.getLong("material.id"));
                    values.put("matvers", entry.getLong("matversion.id"));
                    values.put("auxproperty", entry.getLong("auxprop.id"));
                    values.put("project", entry.getLong("project.id"));
                    values.put("tracknumber", entry.getLong("tracknumber.id"));
                    values.put("configuredcode", entry.getLong("configuredcode.id"));
                    values.put("lot", entry.getLong("lot"));
                    Long keyColId = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)Boolean.FALSE).getId();
                    if (CadEmptyUtils.isEmpty((Long)keyColId)) continue;
                    keyColIds.add(keyColId);
                }
                QFilter filter = new QFilter("costtype", "=", targetCostTypeId);
                filter.and(new QFilter("keycolid", "in", keyColIds));
                filter.and(new QFilter("effectdate", ">", (Object)effectTime));
                if (QueryServiceHelper.exists((String)"cad_outsourceprice", (QFilter[])new QFilter[]{filter})) {
                    String matInfos = this.getMatInfos(keyColIds);
                    if (!CadEmptyUtils.isEmpty((String)sb.toString())) {
                        sb.append("\uff1b");
                    }
                    sb.append(String.format(ResManager.loadKDString((String)"\u5f85\u66f4\u65b0\u6210\u672c\u7c7b\u578b\u201c%1$s\u201d\u7684%2$s\u5b58\u5728\u5927\u4e8e\u751f\u6548\u65f6\u95f4\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u66f4\u65b0\u3002", (String)"CostQuickUpdateEdit_21", (String)"macc-cad-formplugin", (Object[])new Object[0]), updateBill.getString("targetcosttype.name"), matInfos));
                    return;
                }
                CostUpdateEstablishedHelper.copyOutSourcePrice((DynamicObject)updateBill, new HashSet(ids), keyColIds, (Date)effectTime);
            });
            if (!CadEmptyUtils.isEmpty((String)sb.toString())) {
                throw new KDBizException(sb.toString());
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4ea7\u54c1\u59d4\u5916\u6807\u51c6\u4ef7\u76ee\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"CostQuickUpdateEdit_18", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }

    private Set<String> getNotUpdateBills(QFilter[] filters) {
        DynamicObjectCollection costUpdates = QueryServiceHelper.query((String)"cad_costupdatenew", (String)"billno", (QFilter[])filters);
        HashSet<String> notUpdateBills = new HashSet<String>(10);
        for (DynamicObject costUpdate : costUpdates) {
            String billno = costUpdate.getString("billno");
            if (CadEmptyUtils.isEmpty((String)billno)) continue;
            notUpdateBills.add(billno);
        }
        return notUpdateBills;
    }

    private Set<String> getNotUpdateBills(Long costType, List<Long> existsKeyColIds) {
        QFilter targetFilter = new QFilter("targetcosttype", "=", (Object)costType);
        QFilter statusFilter = new QFilter("updatestatus", "=", (Object)Character.valueOf('N'));
        DataSet costUpdates = QueryServiceHelper.queryDataSet((String)"getNotUpdateBills", (String)"cad_costupdatenew", (String)"billno,entryentity.material material,entryentity.auxprop auxprop,entryentity.configuredcode configuredcode,entryentity.tracknumber tracknumber,entryentity.lot lot,entryentity.project project", (QFilter[])new QFilter[]{targetFilter, statusFilter}, null);
        DataSet keyColObjs = QueryServiceHelper.queryDataSet((String)"getNotUpdateBills", (String)"cad_keycol", (String)"material,matvers mversion,auxproperty assist,project,tracknumber,configuredcode,lot", (QFilter[])new QFilter[]{new QFilter("id", "in", existsKeyColIds)}, null);
        costUpdates = costUpdates.join(keyColObjs, JoinType.INNER).on("material", "material").on("auxprop", "assist").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").on("project", "project").on("lot", "lot").select(costUpdates.getRowMeta().getFieldNames()).finish();
        HashSet<String> notUpdateBills = new HashSet<String>(10);
        while (costUpdates.hasNext()) {
            Row row = costUpdates.next();
            String billno = row.getString("billno");
            if (CadEmptyUtils.isEmpty((String)billno)) continue;
            notUpdateBills.add(billno);
        }
        return notUpdateBills;
    }

    private String getMatInfos(Set<Long> keyColIds) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", keyColIds)};
        DynamicObjectCollection dyKeyCols = QueryServiceHelper.query((String)"cad_keycol", (String)"material.number materialnumber,material.name materialname,matvers mversion,auxproperty,project.number projectnumber,tracknumber.number tracknumber,configuredcode.number configuredcodenumber,lot", (QFilter[])filters);
        StringBuilder sb = new StringBuilder();
        for (DynamicObject dyKeyCol : dyKeyCols) {
            String lot;
            String projectnumber;
            String tracknumber;
            String configuredcodenumber;
            String materialnumber = dyKeyCol.getString("materialnumber");
            String materialname = dyKeyCol.getString("materialname");
            if (!CadEmptyUtils.isEmpty((String)sb.toString())) {
                sb.append("\u3001");
            }
            sb.append(ResManager.loadKDString((String)"\u7269\u6599", (String)"CostQuickUpdateEdit_22", (String)"macc-cad-formplugin", (Object[])new Object[0])).append("\u3010").append(materialnumber).append("/").append(materialname);
            String auxproperty = dyKeyCol.getString("auxproperty");
            if (!CadEmptyUtils.isEmpty((String)auxproperty)) {
                sb.append(String.format(ResManager.loadKDString((String)"%s\u8f85\u52a9\u5c5e\u6027id\uff1a", (String)"CostQuickUpdateEdit_23", (String)"macc-cad-formplugin", (Object[])new Object[0]), "\uff0c")).append(auxproperty);
            }
            if (!CadEmptyUtils.isEmpty((String)(configuredcodenumber = dyKeyCol.getString("configuredcodenumber")))) {
                sb.append(String.format(ResManager.loadKDString((String)"%s\u914d\u7f6e\u53f7\uff1a", (String)"CostQuickUpdateEdit_24", (String)"macc-cad-formplugin", (Object[])new Object[0]), "\uff0c")).append(configuredcodenumber);
            }
            if (!CadEmptyUtils.isEmpty((String)(tracknumber = dyKeyCol.getString("tracknumber")))) {
                sb.append(String.format(ResManager.loadKDString((String)"%s\u8ddf\u8e2a\u53f7\uff1a", (String)"CostQuickUpdateEdit_25", (String)"macc-cad-formplugin", (Object[])new Object[0]), "\uff0c")).append(tracknumber);
            }
            if (!CadEmptyUtils.isEmpty((String)(projectnumber = dyKeyCol.getString("projectnumber")))) {
                sb.append(String.format(ResManager.loadKDString((String)"%s\u9879\u76ee\u53f7\uff1a", (String)"CostQuickUpdateEdit_26", (String)"macc-cad-formplugin", (Object[])new Object[0]), "\uff0c")).append(projectnumber);
            }
            if (!CadEmptyUtils.isEmpty((String)(lot = dyKeyCol.getString("lot")))) {
                sb.append(String.format(ResManager.loadKDString((String)"%s\u6279\u53f7\uff1a", (String)"CostQuickUpdateEdit_27", (String)"macc-cad-formplugin", (Object[])new Object[0]), "\uff0c")).append(lot);
            }
            sb.append("\u3011");
        }
        return sb.toString();
    }

    private Set<Long> getIds(String entityName, Set<Object> resIds, boolean iscalccurlevel) {
        HashSet<Long> result = new HashSet<Long>(16);
        List ids = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("ids"), List.class);
        if (CadEmptyUtils.isEmpty((List)ids)) {
            return result;
        }
        if (iscalccurlevel) {
            result.addAll(ids);
            return result;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)ids), new QFilter("resource", "in", resIds)};
        DynamicObjectCollection resources = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])filters);
        for (DynamicObject resource : resources) {
            result.add(resource.getLong("id"));
        }
        return result;
    }

    private void getResourceIds(String entityName, Set<Object> resIds) {
        List ids = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("ids"), List.class);
        if (CadEmptyUtils.isEmpty((List)ids)) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)ids)};
        DynamicObjectCollection resources = QueryServiceHelper.query((String)entityName, (String)"resource", (QFilter[])filters);
        for (DynamicObject resource : resources) {
            resIds.add(resource.getLong("resource"));
        }
    }

    private boolean checkPerimission() {
        String appId = this.getView().getFormShowParameter().getAppId();
        return PermissionServiceHelper.hasSpecificPerm((long)RequestContext.getOrCreate().getCurrUserId(), (String)appId, (String)"cad_costupdatenew", (String)"47162f66000000ac");
    }

    private Map<String, Object> buildCustomParams(List<Object> ids) {
        String sourcePage = this.getPageCache().get("sourcePage");
        List sourcePKs = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("sourcePKs"));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("costUpdatePrimaryKey", ids);
        params.put("quickUpdateFlag", true);
        params.put("sourcePage", sourcePage);
        params.put("toUpdatePKs", sourcePKs);
        params.put("isPurMat", "purPrice".equals(sourcePage));
        return params;
    }

    private void fillMaterialEntry(DynamicObject costupdatenew) {
        DynamicObjectCollection entryentity = costupdatenew.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection pageEntry = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : pageEntry) {
            DynamicObject updateEntry = entryentity.addNew();
            updateEntry.set("material", (Object)entry.getDynamicObject("material"));
            updateEntry.set("matversion", (Object)entry.getDynamicObject("matversion"));
            updateEntry.set("auxprop", (Object)entry.getDynamicObject("auxprop"));
            updateEntry.set("project", (Object)entry.getDynamicObject("project"));
            updateEntry.set("configuredcode", (Object)entry.getDynamicObject("configuredcode"));
            updateEntry.set("tracknumber", (Object)entry.getDynamicObject("tracknumber"));
            updateEntry.set("lot", (Object)entry.getString("lot"));
        }
    }

    private void initPeriod() {
        DynamicObject targetCostType = (DynamicObject)this.getModel().getValue("targetcosttype");
        Boolean isUpdateByPeriod = Boolean.FALSE;
        if (targetCostType != null) {
            String status = CostUpdateHelper.getIsUpdateByPeriod((Long)targetCostType.getLong("id"));
            if (Boolean.TRUE.toString().equals(status)) {
                isUpdateByPeriod = Boolean.TRUE;
            } else if (Boolean.FALSE.toString().equals(status)) {
                isUpdateByPeriod = Boolean.FALSE;
            } else {
                isUpdateByPeriod = Boolean.FALSE;
                this.getView().showTipNotification(status);
            }
        }
        this.getView().setVisible(isUpdateByPeriod, new String[]{"period"});
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.setMustInput(isUpdateByPeriod.booleanValue());
        this.updateCurLevel();
    }

    private QFilter getPeriodQFilter(Long costTypeId) {
        List ids = CostUpdateHelper.getPeriodIds((Long)costTypeId);
        if (ids.isEmpty()) {
            return new QFilter("id", "=", (Object)-1L);
        }
        return new QFilter("id", "in", (Object)ids);
    }

    private void setDefaultTargetCostType() {
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)os)) {
            return;
        }
        DynamicObject srcCostType = (DynamicObject)this.getModel().getValue("srccosttype");
        if (srcCostType == null) {
            return;
        }
        DynamicObjectCollection entrys = srcCostType.getDynamicObjectCollection("costtypeentry");
        for (DynamicObject entry : entrys) {
            if (!CostTypePtyEnum.CALCULATING.getValue().equals(entry.getString("costtypeattr"))) continue;
            this.getModel().setValue("targetcosttype", (Object)entry.getLong("costtype.id"));
            this.getView().updateView("targetcosttype");
            this.initPeriod();
            return;
        }
    }

    private void updateCurLevel() {
        String sourcePage = (String)this.getView().getFormShowParameter().getCustomParam("sourcePage");
        if ("resource".equals(sourcePage)) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            if (!entryentity.isEmpty()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"isspecifymaterial", "advconap"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"isspecifymaterial", "advconap"});
            }
        }
    }

    private String checkEffectTimeByRate(Set<Long> ids, Date effecttime, Long targetCostTypeId) {
        if (CadEmptyUtils.isEmpty(ids)) {
            return null;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObjectCollection resourceRates = QueryServiceHelper.query((String)"cad_resourcerate", (String)"workcenter,resource", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)resourceRates)) {
            return null;
        }
        HashSet workResources = new HashSet(resourceRates.size());
        resourceRates.forEach(p -> workResources.add(p.getString("workcenter") + "@" + p.getString("resource")));
        filters = new QFilter[]{new QFilter("costtype", "=", (Object)targetCostTypeId), new QFilter("effectdate", ">", (Object)effecttime)};
        resourceRates = QueryServiceHelper.query((String)"cad_resourcerate", (String)"billno,workcenter,resource", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)resourceRates)) {
            return null;
        }
        HashSet<String> billNos = new HashSet<String>(resourceRates.size());
        for (DynamicObject resourceRate : resourceRates) {
            String key = resourceRate.getString("workcenter") + "@" + resourceRate.getString("resource");
            if (!workResources.contains(key)) continue;
            billNos.add(resourceRate.getString("billno"));
        }
        if (CadEmptyUtils.isEmpty(billNos)) {
            return null;
        }
        return String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5b58\u5728\u5927\u4e8e\u751f\u6548\u65f6\u95f4\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u66f4\u65b0\u3002", (String)"CostQuickUpdateEdit_28", (String)"macc-cad-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", billNos));
    }

    private String checkEffectTimeByOut(Set<Long> ids, Date effecttime, Long targetCostTypeId) {
        if (CadEmptyUtils.isEmpty(ids)) {
            return null;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObjectCollection resourceOuts = QueryServiceHelper.query((String)"cad_resourceout", (String)"material,auxpty,resource", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)resourceOuts)) {
            return null;
        }
        HashSet matResources = new HashSet(resourceOuts.size());
        resourceOuts.forEach(p -> matResources.add(p.getString("material") + "@" + p.getString("auxpty") + "@" + p.getString("resource")));
        filters = new QFilter[]{new QFilter("costtype", "=", (Object)targetCostTypeId), new QFilter("effectdate", ">", (Object)effecttime)};
        resourceOuts = QueryServiceHelper.query((String)"cad_resourceout", (String)"billno,material,auxpty,resource", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)resourceOuts)) {
            return null;
        }
        HashSet<String> billNos = new HashSet<String>(resourceOuts.size());
        for (DynamicObject resourceOut : resourceOuts) {
            String key = resourceOut.getString("material") + "@" + resourceOut.getString("auxpty") + "@" + resourceOut.getString("resource");
            if (!matResources.contains(key)) continue;
            billNos.add(resourceOut.getString("billno"));
        }
        if (CadEmptyUtils.isEmpty(billNos)) {
            return null;
        }
        return String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5b58\u5728\u5927\u4e8e\u751f\u6548\u65f6\u95f4\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u66f4\u65b0\u3002", (String)"CostQuickUpdateEdit_28", (String)"macc-cad-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", billNos));
    }
}

