/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costupdatebill;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.macc.cad.business.update.CostUpdateEstablishedHelper;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.ConfigTrackHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostUpdateNewEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"entrytoolbarap"});
        BasedataEdit srcCostType = (BasedataEdit)this.getControl("srccosttype");
        srcCostType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit targetCostType = (BasedataEdit)this.getControl("targetcosttype");
        targetCostType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit attachTargetCostType = (MulBasedataEdit)this.getControl("attachtargetcosttype");
        attachTargetCostType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit matVersion = (BasedataEdit)this.getControl("matversion");
        matVersion.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit matGrp = (BasedataEdit)this.getControl("matgrp");
        matGrp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit matGrpStd = (BasedataEdit)this.getControl("matgrpstd");
        matGrpStd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit configuredcode = (BasedataEdit)this.getControl("configuredcode");
        configuredcode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String keyname = beforeF7SelectEvent.getProperty().getName();
        ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
        switch (keyname) {
            case "srccosttype": {
                listFilterParameter.getQFilters().add(new QFilter("type", "=", (Object)"1"));
                listFilterParameter.getQFilters().add(CostTypeHelper.getCurrUserUsableCostTypeFilter());
                break;
            }
            case "targetcosttype": {
                DynamicObject srcCostType = (DynamicObject)this.getModel().getValue("srccosttype");
                if (srcCostType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u6210\u672c\u7c7b\u578b\u3002", (String)"CostUpdateNewEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                QFilter currencyFilter = new QFilter("currency", "=", srcCostType.get("currency.id"));
                QFilter idFilter = new QFilter("id", "!=", srcCostType.get("id"));
                listFilterParameter.getQFilters().add(CostTypeHelper.getCurrUserUsableCostTypeFilter());
                listFilterParameter.getQFilters().add(currencyFilter);
                listFilterParameter.getQFilters().add(idFilter);
                break;
            }
            case "attachtargetcosttype": {
                DynamicObject srcCostType = (DynamicObject)this.getModel().getValue("srccosttype");
                if (srcCostType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u6210\u672c\u7c7b\u578b\u3002", (String)"CostUpdateNewEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                QFilter currencyFilter = new QFilter("currency", "=", srcCostType.get("currency.id"));
                listFilterParameter.getQFilters().add(CostTypeHelper.getCurrUserUsableCostTypeFilter());
                listFilterParameter.getQFilters().add(currencyFilter);
                DynamicObjectCollection costTypeEntrys = srcCostType.getDynamicObjectCollection("costtypeentry");
                ArrayList<Long> ids = new ArrayList<Long>(1);
                for (DynamicObject costTypeEntry : costTypeEntrys) {
                    if (!CostTypePtyEnum.CALCULATING.getValue().equals(costTypeEntry.getString("costtypeattr"))) continue;
                    ids.add(costTypeEntry.getLong("costtype.id"));
                }
                if (CadEmptyUtils.isEmpty(ids)) break;
                listFilterParameter.getQFilters().add(new QFilter("id", "not in", ids));
                break;
            }
            case "period": {
                DynamicObject targgetCostType = (DynamicObject)this.getModel().getValue("targetcosttype");
                if (targgetCostType == null) {
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                listFilterParameter.getQFilters().add(this.getPeriodQFilter(targgetCostType.getLong("id")));
                break;
            }
            case "matgrpstd": {
                DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                ArrayList<Long> matGrpIds = new ArrayList<Long>(entrys.size());
                for (DynamicObject entry : entrys) {
                    Long matGrpId = entry.getLong("matgrp.id");
                    if (CadEmptyUtils.isEmpty((Long)matGrpId)) continue;
                    matGrpIds.add(matGrpId);
                    break;
                }
                if (CadEmptyUtils.isEmpty(matGrpIds)) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6e05\u7a7a\u201c\u7269\u6599\u5206\u7c7b\u7f16\u7801\u201d\u540e\u518d\u9009\u62e9\u201c\u7269\u6599\u5206\u7c7b\u6807\u51c6\u201d", (String)"CostUpdateNewEditPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                break;
            }
            case "material": {
                DynamicObject matGrp = (DynamicObject)this.getModel().getValue("matgrp");
                if (matGrp != null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7269\u6599\u5206\u7c7b\uff0c\u8bf7\u52ff\u91cd\u590d\u9009\u62e9\u3002", (String)"CostUpdateNewEditPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject srccosttype = (DynamicObject)this.getModel().getValue("srccosttype");
                Boolean isspecifymaterial = (Boolean)this.getModel().getValue("isspecifymaterial");
                if (srccosttype != null && isspecifymaterial.booleanValue()) {
                    ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
                    filters.add(new QFilter("status", "=", (Object)"C"));
                    filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
                    ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    listShowParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
                    listShowParameter.getListFilterParameter().setQFilters(filters);
                    break;
                }
                beforeF7SelectEvent.setCancel(true);
                break;
            }
            case "matverison": {
                DynamicObject srccosttype = (DynamicObject)this.getModel().getValue("srccosttype");
                Boolean isspecifymaterial = (Boolean)this.getModel().getValue("isspecifymaterial");
                if (srccosttype != null && isspecifymaterial.booleanValue()) {
                    DynamicObject material = (DynamicObject)this.getModel().getValue("material", beforeF7SelectEvent.getRow());
                    if (material != null) {
                        listFilterParameter.getQFilters().add(new QFilter("material", "=", material.get("id")));
                        break;
                    }
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                beforeF7SelectEvent.setCancel(true);
                break;
            }
            case "matgrp": {
                DynamicObject mat = (DynamicObject)this.getModel().getValue("material");
                if (mat != null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7269\u6599\uff0c\u8bf7\u52ff\u91cd\u590d\u9009\u62e9\u3002", (String)"CostUpdateNewEditPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject matGrpStd = (DynamicObject)this.getModel().getValue("matgrpstd");
                if (matGrpStd == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"CostUpdateNewEditPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject costType = this.getModel().getDataEntity().getDynamicObject("srccosttype");
                if (costType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u6210\u672c\u7c7b\u578b\u3002", (String)"CostUpdateNewEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
                createOrgIds.add(costType.getLong("createorg.id"));
                QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, matGrpStd.getPkValue(), true});
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                List qFilters = listShowParameter.getListFilterParameter().getQFilters();
                qFilters.add(serviceResponse);
                HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
                params.put("useOrgs", createOrgIds);
                listShowParameter.setCustomParams(params);
                listShowParameter.setCustomParam("groupStandard", matGrpStd.getPkValue());
                listShowParameter.setF7ClickByFilter(false);
                break;
            }
            case "configuredcode": {
                int index = this.getModel().getEntryCurrentRowIndex("entryentity");
                DynamicObject matObj = (DynamicObject)this.getModel().getValue("material", index);
                if (matObj == null) break;
                List qList = listFilterParameter.getQFilters();
                List configCodeIds = ConfigTrackHelper.getConfigCodeIdsByMaterial(Collections.singleton(matObj.getLong("id")));
                if (CadEmptyUtils.isEmpty((List)configCodeIds)) break;
                qList.add(new QFilter("id", "in", (Object)configCodeIds));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        switch (property) {
            case "material": {
                DynamicObject material = (DynamicObject)e.getChangeSet()[0].getNewValue();
                int index = e.getChangeSet()[0].getRowIndex();
                if (material != null) {
                    this.getView().setEnable(Boolean.valueOf(material.getBoolean("isenablematerialversion")), index, new String[]{"matversion"});
                    boolean enableAuxprop = BomRouterHelper.enableAuxNotEffCost((DynamicObject)material);
                    this.getView().setEnable(Boolean.valueOf(enableAuxprop), index, new String[]{"auxprop"});
                } else {
                    this.getModel().setValue("configuredcode", null, index);
                    this.getModel().setValue("tracknumber", null, index);
                }
                this.getView().setEnable(Boolean.valueOf(material == null), index, new String[]{"matgrp"});
                break;
            }
            case "srccosttype": {
                if (!this.getModel().getEntryEntity("entryentity").isEmpty()) {
                    this.getModel().deleteEntryData("entryentity");
                    this.getView().invokeOperation("newentry");
                }
                this.getModel().setValue("targetcosttype", null);
                break;
            }
            case "targetcosttype": {
                this.initPeriod();
                this.visibleAllUpdate();
                break;
            }
            case "isspecifymaterial": {
                boolean isspecifymaterial = (Boolean)this.getModel().getValue("isspecifymaterial");
                if (!isspecifymaterial) {
                    this.getModel().deleteEntryData("entryentity");
                    this.getModel().setValue("iscalccurlevel", (Object)Boolean.FALSE);
                    this.getModel().setValue("isallupdate", (Object)Boolean.TRUE);
                } else {
                    this.getModel().setValue("isallupdate", (Object)Boolean.FALSE);
                }
                this.getView().setVisible(Boolean.valueOf(isspecifymaterial), new String[]{"matgrpstd"});
                BasedataEdit matGrpStd = (BasedataEdit)this.getControl("matgrpstd");
                matGrpStd.setMustInput(isspecifymaterial);
                DynamicObject srccosttype = (DynamicObject)this.getModel().getValue("srccosttype");
                if (srccosttype == null) {
                    this.getModel().setValue("iscalccurlevel", (Object)false);
                    return;
                }
                this.autoFillEntry(srccosttype.getLong("id"), "full");
                break;
            }
            case "iscalccurlevel": {
                boolean iscalccurlevel = (Boolean)this.getModel().getValue("iscalccurlevel");
                boolean isspecifymaterial1 = (Boolean)this.getModel().getValue("isspecifymaterial");
                if (iscalccurlevel && !isspecifymaterial1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5f53\u52fe\u9009\u6307\u5b9a\u7269\u6599\u66f4\u65b0\u65f6\uff0c\u624d\u80fd\u52fe\u9009\u4ec5\u66f4\u65b0\u672c\u5c42\u3002", (String)"CostUpdateNewEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("iscalccurlevel", (Object)false);
                    return;
                }
                if (!iscalccurlevel) break;
                this.getModel().deleteEntryData("entryentity");
                DynamicObject srccosttype = (DynamicObject)this.getModel().getValue("srccosttype");
                if (srccosttype == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6e90\u6210\u672c\u7c7b\u578b\u3002", (String)"CostUpdateNewEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("iscalccurlevel", (Object)Boolean.FALSE);
                    return;
                }
                this.autoFillEntry(srccosttype.getLong("id"), "part");
                break;
            }
            case "isallupdate": {
                boolean isAllUpdate = (Boolean)this.getModel().getValue("isallupdate");
                if (Boolean.TRUE.equals(isAllUpdate)) {
                    this.getModel().setValue("isspecifymaterial", (Object)Boolean.FALSE);
                    this.getModel().deleteEntryData("entryentity");
                    this.getModel().setValue("iscalccurlevel", (Object)Boolean.FALSE);
                    break;
                }
                this.getModel().setValue("isspecifymaterial", (Object)Boolean.TRUE);
                break;
            }
            case "matgrp": {
                DynamicObject matgrp = (DynamicObject)e.getChangeSet()[0].getNewValue();
                int index = e.getChangeSet()[0].getRowIndex();
                this.getView().setEnable(Boolean.valueOf(matgrp == null), index, new String[]{"material"});
                break;
            }
            case "configuredcode": {
                this.setMaterialByConfigCode(rowIndex);
                break;
            }
        }
    }

    private void setMaterialByConfigCode(int rowIndex) {
        DynamicObject configuRedcode = (DynamicObject)this.getModel().getValue("configuredcode", rowIndex);
        if (configuRedcode == null) {
            return;
        }
        DynamicObject mat = (DynamicObject)this.getModel().getValue("material", rowIndex);
        if (mat != null) {
            return;
        }
        Long material = configuRedcode.getLong("material.id");
        this.getModel().setValue("material", (Object)material, rowIndex);
        this.getModel().setValue("configuredcode", (Object)configuRedcode.getLong("id"), rowIndex);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("addentry".equals(evt.getItemKey()) && this.getModel().getValue("srccosttype") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6307\u5b9a\u7269\u6599\u524d\u8bf7\u5148\u9009\u62e9\u201c\u6e90\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"CostUpdateNewEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            this.getModel().deleteEntryData("entryentity");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        boolean is2UpdatePage;
        OperationResult opResult;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("audit".equals(operateKey) && (opResult = afterDoOperationEventArgs.getOperationResult()) != null && opResult.isSuccess() && (is2UpdatePage = CostUpdateHelper.isAuditToUpdateConfirmPage())) {
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            boolean iscalccurlevel = (Boolean)this.getModel().getValue("iscalccurlevel");
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put("costUpdatePrimaryKey", Lists.newArrayList((Object[])new Object[]{pkValue}));
            params.put("quickUpdateFlag", Boolean.valueOf(false));
            params.put("iscalccurlevel", Boolean.valueOf(iscalccurlevel));
            CostUpdateHelper.showUpdateWizard((IFormView)this.getView(), params, (Object)pkValue);
            CostUpdateEstablishedHelper.doWipCalc((Long)Long.valueOf(pkValue.toString()), (Boolean)Boolean.TRUE);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean iscalccurlevel;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if (("save".equals(source.getOperateKey()) || "submit".equals(source.getOperateKey()) || "submitandnew".equals(source.getOperateKey())) && (iscalccurlevel = ((Boolean)this.getModel().getValue("iscalccurlevel")).booleanValue())) {
            DynamicObjectCollection matentry = this.getModel().getEntryEntity("entryentity");
            ArrayList<String> matIds = new ArrayList<String>(5);
            for (DynamicObject matdetai : matentry) {
                if (matdetai.getString("material") != null) {
                    matIds.add(matdetai.getString("material"));
                    break;
                }
                if (matdetai.get("matgrp") == null) continue;
                matIds.add(matdetai.getString("matgrp.id"));
                break;
            }
            if (matIds.size() < 1) {
                this.getModel().setValue("iscalccurlevel", (Object)false);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4ec5\u66f4\u65b0\u672c\u5c42\uff0c\u9700\u8981\u6307\u5b9a\u76f8\u5e94\u7269\u6599\u3002", (String)"CostUpdateNewEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.visiblePeriod();
        this.visibleAllUpdate();
        if (this.getModel().getValue("isquickupdate") != null && ((Boolean)this.getModel().getValue("isquickupdate")).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isspecifymaterial"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"iscalccurlevel"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"isallupdate"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"contentpanelflex"});
        }
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    private void autoFillEntry(long costtypeid, String type) {
    }

    private void initPeriod() {
        DynamicObject targetCostType = (DynamicObject)this.getModel().getValue("targetcosttype");
        Boolean isUpdateByPeriod = Boolean.FALSE;
        if (targetCostType != null) {
            String status = CostUpdateHelper.getIsUpdateByPeriod((Long)targetCostType.getLong("id"));
            if (Boolean.TRUE.toString().equals(status)) {
                isUpdateByPeriod = Boolean.TRUE;
            } else if (Boolean.FALSE.toString().equals(status)) {
                isUpdateByPeriod = Boolean.FALSE;
            } else {
                isUpdateByPeriod = Boolean.FALSE;
                this.getView().showTipNotification(status);
            }
        }
        this.getView().setVisible(isUpdateByPeriod, new String[]{"period"});
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.setMustInput(isUpdateByPeriod.booleanValue());
        this.getView().setVisible(Boolean.TRUE, new String[]{"iscalccurlevel"});
        this.getModel().setValue("isspecifymaterial", (Object)isUpdateByPeriod);
        this.getModel().setValue("iscalccurlevel", (Object)isUpdateByPeriod);
    }

    private QFilter getPeriodQFilter(Long costTypeId) {
        List ids = CostUpdateHelper.getPeriodIds((Long)costTypeId);
        if (ids.isEmpty()) {
            return new QFilter("id", "=", (Object)-1L);
        }
        return new QFilter("id", "in", (Object)ids);
    }

    private void visiblePeriod() {
        Object period = this.getModel().getValue("period");
        Boolean isVisible = period != null && ((DynamicObject)period).getLong("id") > 0L;
        this.getView().setVisible(isVisible, new String[]{"period"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"iscalccurlevel"});
    }

    private void visibleAllUpdate() {
        Boolean isAllUpdate = Boolean.FALSE;
        DynamicObject targetCostType = (DynamicObject)this.getModel().getValue("targetcosttype");
        if (targetCostType != null) {
            isAllUpdate = CostUpdateHelper.getIsAllUpdate((Long)targetCostType.getLong("id"));
        }
        this.getView().setVisible(isAllUpdate, new String[]{"isallupdate"});
        if (Boolean.FALSE.equals(isAllUpdate)) {
            this.getModel().setValue("isallupdate", (Object)Boolean.FALSE);
            this.getModel().setValue("isspecifymaterial", (Object)Boolean.TRUE);
            this.getView().setEnable(Boolean.FALSE, new String[]{"isspecifymaterial"});
        }
    }
}

