/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costupdatebill;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.calc.helper.CalcMutexHelper;
import kd.macc.cad.business.update.CostUpdateEstablishedHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.cad.formplugin.price.PriceCommon;

public class CostUpdateNewListPlugin
extends AbstractListPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final Log logger = LogFactory.getLog(CostUpdateNewListPlugin.class);
    private static final String TBLUPDATE = "tblupdate";
    private static final String BILLLISTAP = "billlistap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TBLUPDATE, "tblcheck", "audittoconfirm", "autoendperiodcal"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        BillList billlist = (BillList)this.getControl(BILLLISTAP);
        Object[] selectedRowsPK = billlist.getSelectedRows().getPrimaryKeyValues();
        switch (evt.getItemKey()) {
            case "tblupdate": {
                boolean flag = CostUpdateHelper.hasUpdatePerm((String)"cad_costupdatenew");
                if (!flag) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u66f4\u65b0\u7533\u8bf7\u5355\u201d\u7684\u201c\u66f4\u65b0\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostUpdateNewListPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(Boolean.TRUE.booleanValue());
                    String opType = ResManager.loadKDString((String)"\u66f4\u65b0", (String)"CostUpdateNewListPlugin_17", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    String checkType = ResManager.loadKDString((String)"\u65e0\u7533\u8bf7\u5355\u7684\u201c\u66f4\u65b0\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostUpdateNewListPlugin_18", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_costupdatenew", (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
                    return;
                }
                if (selectedRowsPK.length != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u5f20\u66f4\u65b0\u7533\u8bf7\u5355\u6267\u884c\u66f4\u65b0\u3002", (String)"CostUpdateNewListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(selectedRowsPK[0].toString())), new QFilter("updatestatus", "=", (Object)Character.valueOf('Y'))};
                if (QueryServiceHelper.exists((String)"cad_costupdatenew", (QFilter[])filters)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u786e\u8ba4\u5355\u5bf9\u5e94\u7684\u7533\u8bf7\u5355\u5df2\u7ecf\u66f4\u65b0\u6210\u672c\u5b8c\u6210\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CostUpdateNewListPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                DynamicObject updateBill = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(selectedRowsPK[0].toString()), (String)"cad_costupdatenew");
                if (updateBill.getBoolean("isallupdate")) {
                    DynamicObject srcCostType = updateBill.getDynamicObject("srccosttype");
                    DynamicObject tarCostType = updateBill.getDynamicObject("targetcosttype");
                    String tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u66f4\u65b0\u9009\u62e9\u4e86\u5168\u91cf\u66f4\u65b0\uff0c\u5168\u91cf\u66f4\u65b0\u4f1a\u5bfc\u81f4 %1$s/%2$s\u7684\u73b0\u6709\u7269\u6599\u6210\u672c\u4fe1\u606f\u5168\u90e8\u5931\u6548\uff0c\u4ece%3$s/%4$s\u91cd\u65b0\u83b7\u53d6\u7269\u6599\u6210\u672c\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u3002\u70b9\u51fb\u786e\u8ba4\uff0c\u5219\u7ee7\u7eed\u8fdb\u884c\u66f4\u65b0\u7684\u5176\u4ed6\u5224\u65ad\uff1b\u70b9\u51fb\u53d6\u6d88\uff0c\u5219\u4e0d\u8fdb\u884c\u66f4\u65b0\u3002", (String)"CostUpdateNewListPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]), tarCostType.getString("number"), tarCostType.getString("name"), srcCostType.getString("number"), srcCostType.getString("name"));
                    this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("allUpdate"));
                    evt.setCancel(true);
                    return;
                }
                String noExistsMatCostInfo = this.existsCostMatInfo(updateBill.getLong("targetcosttype.id"));
                if (!StringUtils.isNotEmpty((String)noExistsMatCostInfo)) break;
                logger.info(noExistsMatCostInfo);
                break;
            }
            case "tblcostinforpt": 
            case "tblstorageinforpt": 
            case "tblproductinforpt": {
                if (selectedRowsPK.length != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u5f20\u66f4\u65b0\u7533\u8bf7\u5355\u8fdb\u884c\u66f4\u65b0\u7ed3\u679c\u67e5\u8be2\u3002", (String)"CostUpdateNewListPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(selectedRowsPK[0].toString())), new QFilter("updatestatus", "!=", (Object)Character.valueOf('Y'))};
                if (!QueryServiceHelper.exists((String)"cad_costupdatenew", (QFilter[])filters)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u66f4\u65b0\u7533\u8bf7\u5355\u672a\u8fdb\u884c\u6210\u672c\u66f4\u65b0\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ed3\u679c\u67e5\u8be2\u3002", (String)"CostUpdateNewListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        BillList billlist = (BillList)this.getControl(BILLLISTAP);
        Object[] selectedRowsPK = billlist.getSelectedRows().getPrimaryKeyValues();
        String pageId = this.getView().getPageId();
        switch (evt.getItemKey()) {
            case "tblupdate": {
                Object primaryKeyValue = selectedRowsPK[0];
                DynamicObject updateBill = QueryServiceHelper.queryOne((String)"cad_costupdatenew", (String)"billstatus,updatestatus,iscalccurlevel,sourcepage,resbynoref,resmatbyuseauxpt", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
                if ("C".equals(updateBill.get("billstatus"))) {
                    if ("N".equals(updateBill.getString("updatestatus")) && CostUpdateHelper.isAutoEndPeriodCalPage()) {
                        CostUpdateEstablishedHelper.doWipCalc((Long)Long.valueOf(primaryKeyValue.toString()), (Boolean)Boolean.TRUE);
                    }
                    this.showUpdateWizard(pageId, primaryKeyValue);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u672a\u5b8c\u6210\u5ba1\u6838\uff0c\u4e0d\u80fd\u6267\u884c\u66f4\u65b0\u3002", (String)"CostUpdateNewListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                break;
            }
            case "tblcostinforpt": 
            case "tblstorageinforpt": 
            case "tblproductinforpt": {
                Long updateBillId = Long.valueOf(selectedRowsPK[0].toString());
                String key = evt.getItemKey().replace("tbl", "");
                ReportShowParameter parameter = CostUpdateHelper.getReportShowParameter((String)key, (Long)updateBillId);
                if (parameter == null) break;
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "tblcheck": {
                boolean is2ConfirmPage = CostUpdateHelper.isAuditToUpdateConfirmPage();
                if (is2ConfirmPage && selectedRowsPK.length > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u66f4\u65b0\u5355\uff0c\u5ba1\u6838\u540e\u5c06\u81ea\u52a8\u8fdb\u5165\u66f4\u65b0\u5411\u5bfc\u3002", (String)"CostUpdateNewListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                }
                boolean isAutoEndPeriodCal = CostUpdateHelper.isAutoEndPeriodCalPage();
                if (!is2ConfirmPage || !isAutoEndPeriodCal || selectedRowsPK.length != 1) break;
                CostUpdateEstablishedHelper.doWipCalc((Long)Long.valueOf(selectedRowsPK[0].toString()), (Boolean)Boolean.TRUE);
                break;
            }
            case "audittoconfirm": {
                this.showUpdatetoConfirm();
                break;
            }
            case "autoendperiodcal": {
                this.showAutoEndPeriodCalForm();
                break;
            }
            case "dealmatcostinfo": {
                this.showMatCostUpdateForm();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("allUpdate".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            BillList billlist = (BillList)this.getControl(BILLLISTAP);
            Object[] selectedRowsPK = billlist.getSelectedRows().getPrimaryKeyValues();
            String pageId = this.getView().getPageId();
            Object primaryKeyValue = selectedRowsPK[0];
            DynamicObject updateBill = QueryServiceHelper.queryOne((String)"cad_costupdatenew", (String)"billstatus,updatestatus,iscalccurlevel,sourcepage,resbynoref,resmatbyuseauxpt", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
            if ("C".equals(updateBill.get("billstatus"))) {
                if ("N".equals(updateBill.getString("updatestatus")) && CostUpdateHelper.isAutoEndPeriodCalPage()) {
                    CostUpdateEstablishedHelper.doWipCalc((Long)Long.valueOf(primaryKeyValue.toString()), (Boolean)Boolean.TRUE);
                }
                this.showUpdateWizard(pageId, primaryKeyValue);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u672a\u5b8c\u6210\u5ba1\u6838\uff0c\u4e0d\u80fd\u6267\u884c\u66f4\u65b0\u3002", (String)"CostUpdateNewListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult opResult;
        super.afterDoOperation(args);
        if ("audit".equals(args.getOperateKey()) && (opResult = args.getOperationResult()) != null && opResult.isSuccess()) {
            BillList billlist = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
            boolean is2ConfirmPage = CostUpdateHelper.isAuditToUpdateConfirmPage();
            if (is2ConfirmPage && selectedRows.size() == 1) {
                ListSelectedRow listSelectedRow = selectedRows.get(0);
                Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
                DynamicObject costUpdate = QueryServiceHelper.queryOne((String)"cad_costupdatenew", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
                if (!"C".equals(costUpdate.get("billstatus"))) {
                    return;
                }
                HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                params.put("costUpdatePrimaryKey", Lists.newArrayList((Object[])new Object[]{primaryKeyValue}));
                params.put("quickUpdateFlag", Boolean.valueOf(false));
                CostUpdateHelper.showUpdateWizard((IFormView)this.getView(), params, (Object)primaryKeyValue);
            }
        }
    }

    private void showUpdatetoConfirm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cad_costupdatetoconfirm");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u5ba1\u6838\u540e\u81ea\u52a8\u8fdb\u5165\u66f4\u65b0\u5411\u5bfc", (String)"CostUpdateNewListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        this.getView().showForm(parameter);
    }

    private void showUpdateWizard(String pageId, Object costUpdateId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cad_updatewizard");
        formShowParameter.setCustomParam("costupdateid", costUpdateId);
        formShowParameter.setCustomParam("quickUpdateFlag", (Object)Boolean.FALSE);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setParentPageId(pageId);
        this.getView().showForm(formShowParameter);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            String fieldName = filterColumn.getFieldName();
            if (fieldName.contains("srccosttype")) {
                List<ComboItem> costTypeComboItemList = PriceCommon.getCostTypeComboItemList(this.getView().getFormShowParameter().getAppId());
                ((CommonFilterColumn)filterColumn).setComboItems(costTypeComboItemList);
                continue;
            }
            if (!fieldName.contains("targetcosttype")) continue;
            DynamicObject[] costTypes = CostTypeHelper.getCostType((int)-1);
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            for (DynamicObject costType : costTypes) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(costType.getString("name")));
                item.setValue(costType.getString("id"));
                if (items.contains(item)) continue;
                items.add(item);
            }
            ((CommonFilterColumn)filterColumn).setComboItems(items);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        String fieldName = e.getFieldName();
        List qFilters = e.getQfilters();
        if (fieldName.contains("srccosttype")) {
            qFilters.add(this.getCommonFilter());
            if ("aca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
                qFilters.add(new QFilter("type", "=", (Object)"1"));
            } else {
                qFilters.add(new QFilter("type", "in", (Object)new String[]{"0", "1"}));
            }
        } else if (fieldName.contains("targetcosttype")) {
            qFilters.add(this.getCommonFilter());
        }
    }

    private QFilter getCommonFilter() {
        QFilter qFilter = CostTypeHelper.getScaCostType();
        qFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
        if (baseDataFilter != null) {
            qFilter.and(baseDataFilter);
        }
        return qFilter;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if ("unaudit".equals(source.getOperateKey())) {
            Set<Long> lockCostType = this.getSelectedCostTypeIds();
            if (CadEmptyUtils.isEmpty(lockCostType)) {
                return;
            }
            String lockErr = CalcMutexHelper.enableReentrant((String)"update", lockCostType);
            if (StringUtils.isNotEmpty((String)lockErr)) {
                this.getView().showErrorNotification(lockErr);
                args.setCancel(true);
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        List listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            switch (column.toString()) {
                case "billno": {
                    column.setFixed(true);
                    break;
                }
                case "srccosttype.currency.name": {
                    column.setVisible(0);
                    break;
                }
                case "creator.name": {
                    column.setVisible(0);
                    break;
                }
                case "createtime": {
                    column.setVisible(0);
                    break;
                }
                case "auditor.name": {
                    column.setVisible(0);
                    break;
                }
                case "auditdate": {
                    column.setVisible(0);
                    break;
                }
            }
        }
    }

    private Set<Long> getSelectedCostTypeIds() {
        HashSet<Long> costTypeIds = new HashSet<Long>(10);
        BillList billlist = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        if (CadEmptyUtils.isEmpty((Object[])ids)) {
            return costTypeIds;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)ids)};
        DynamicObjectCollection costUpdate = QueryServiceHelper.query((String)"cad_costupdatenew", (String)"srccosttype.id srccosttype,targetcosttype.id targetcosttype", (QFilter[])filters);
        for (DynamicObject cost : costUpdate) {
            costTypeIds.add(cost.getLong("srccosttype"));
            costTypeIds.add(cost.getLong("targetcosttype"));
        }
        return costTypeIds;
    }

    private void showAutoEndPeriodCalForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cad_autoendperiodcal");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u751f\u6210\u5728\u5236\u66f4\u65b0\u5dee\u5f02", (String)"CostUpdateNewListPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        this.getView().showForm(parameter);
    }

    private void showMatCostUpdateForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cad_matcostupdate");
        parameter.setCaption(ResManager.loadKDString((String)"\u7269\u6599\u6210\u672c\u4fe1\u606f\u5173\u8054\u5347\u7ea7", (String)"CostUpdateNewListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }

    private String existsCostMatInfo(Long tarCostTypeId) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("costupdateentry");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entrys)) {
            return null;
        }
        HashSet<Long> matIds = new HashSet<Long>(10);
        entrys.forEach(p -> matIds.add(p.getLong("material.id")));
        if (CadEmptyUtils.isEmpty(matIds)) {
            return null;
        }
        Object[] params = new Object[]{tarCostTypeId, matIds};
        Object result = null;
        try {
            result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCostUpdateService", (String)"getMaterialQty", (Object[])params);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        if (result == null) {
            logger.info("\u83b7\u53d6getMaterialQty\u8fd4\u56de\u503c\u4e3a\u7a7a");
            return null;
        }
        Map resultMap = (Map)result;
        if (resultMap.isEmpty()) {
            logger.error("\u83b7\u53d6\u5b58\u8d27\u670d\u52a1getMaterialQty\u5f02\u5e38\u3002");
            return null;
        }
        HashSet matQtyInfoMap = (HashSet)resultMap.get("resultset");
        if (CadEmptyUtils.isEmpty((Set)matQtyInfoMap)) {
            return null;
        }
        HashMap<String, BigDecimal> costInfoMap = new HashMap<String, BigDecimal>(16);
        for (DynamicObject entry : entrys) {
            String matKey = entry.getString("material.id");
            BigDecimal price = entry.getBigDecimal("newprice");
            if (costInfoMap.containsKey(matKey)) {
                costInfoMap.put(matKey, price.add((BigDecimal)costInfoMap.get(matKey)));
                continue;
            }
            costInfoMap.put(matKey, price);
        }
        matIds.clear();
        for (Map matQtyInfo : matQtyInfoMap) {
            String matId = matQtyInfo.get("materialid").toString();
            if (costInfoMap.containsKey(matId)) continue;
            matIds.add(Long.parseLong(matId));
        }
        if (CadEmptyUtils.isEmpty(matIds)) {
            return null;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", matIds)};
        DynamicObjectCollection mats = QueryServiceHelper.query((String)"bd_material", (String)"number,name", (QFilter[])filters);
        if (mats.isEmpty()) {
            return null;
        }
        String tip = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%s\u5b58\u5728\u5e93\u5b58\u6570\u91cf\uff0c\u4f46\u662f\u5728\u6e90\u6210\u672c\u7c7b\u578b\u6ca1\u6709\u5bf9\u5e94\u7684\u7269\u6599\u4fe1\u606f\uff0c\u7ee7\u7eed\u66f4\u65b0\u4f1a\u5bfc\u81f4\u65b0\u5355\u636e\u65e0\u6cd5\u83b7\u53d6\u5230\u6807\u51c6\u6210\u672c\uff0c\u662f\u5426\u7ee7\u7eed\u66f4\u65b0\uff1f", (String)"CostUpdateNewListPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        StringBuilder sg = new StringBuilder();
        for (DynamicObject mat : mats) {
            sg.append('\u3001');
            sg.append(mat.getString("number"));
            sg.append('/');
            sg.append(mat.getString("name"));
        }
        if (sg.length() > 0) {
            return String.format(tip, sg.substring(1));
        }
        return null;
    }
}

