/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.costupdatebill;

import java.util.Date;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class UpdateToConfirmEditPlugin
extends AbstractFormPlugin {
    private static final String ENTITY_CAD_USERDATARECORD = "cad_userdatarecord";
    private static final String USER = "user";
    private static final String AUDITTOCONFIRM = "audittoconfirm";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        QFilter filter = new QFilter(USER, "=", (Object)RequestContext.getOrCreate().getCurrUserId());
        DynamicObject userRecord = QueryServiceHelper.queryOne((String)ENTITY_CAD_USERDATARECORD, (String)AUDITTOCONFIRM, (QFilter[])new QFilter[]{filter});
        if (userRecord != null) {
            this.getModel().setValue(AUDITTOCONFIRM, (Object)userRecord.getBoolean(AUDITTOCONFIRM));
            this.getView().updateView(AUDITTOCONFIRM);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if ("btnok".equals(source.getKey())) {
            this.saveUserData();
            this.getView().close();
        }
    }

    private void saveUserData() {
        boolean audittoconfirm = this.getModel().getDataEntity().getBoolean(AUDITTOCONFIRM);
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        QFilter filter = new QFilter(USER, "=", (Object)userId);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)ENTITY_CAD_USERDATARECORD, (String)"user,modifytime,audittoconfirm", (QFilter[])new QFilter[]{filter});
        if (records != null && records.length > 0) {
            records[0].set(AUDITTOCONFIRM, (Object)audittoconfirm);
            SaveServiceHelper.save((DynamicObject[])records);
        } else {
            DynamicObject userData = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_CAD_USERDATARECORD);
            userData.set(USER, (Object)userId);
            userData.set("modifytime", (Object)new Date());
            userData.set(AUDITTOCONFIRM, (Object)audittoconfirm);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userData});
        }
    }
}

