/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.feealloc;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.algox.constants.AllocResultEnum;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.helper.CostCloseAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.output.MfgAllocResult;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import kd.macc.cad.formplugin.base.BaseOrgAndCostAccountListPlugin;

public class MfgAllocBaseListPlugin
extends BaseOrgAndCostAccountListPlugin {
    public static final String closeBack_allocResult = "allocResult";
    public static final String closeBack_importResult = "importResult";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        BeforeItemClickEvent event = evt;
        if ("previewvoucher".equals(event.getOperationKey()) || "tracevoucher".equals(event.getOperationKey()) || "deletevoucher".equals(event.getOperationKey()) || "generatevoucher".equals(event.getOperationKey())) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selRowCols = billList.getSelectedRows();
            for (ListSelectedRow row : selRowCols) {
                if (StringUtils.equals((CharSequence)"C", (CharSequence)row.getBillStatus())) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u5df2\u786e\u8ba4\u7684\u5355\u636e\u3002", (String)"MfgAllocBaseListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs beforeCreateListColumnsArgs) {
        super.beforeCreateListColumns(beforeCreateListColumnsArgs);
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("sca".equals(appId)) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)beforeCreateListColumnsArgs, (Set)Sets.newHashSet((Object[])new String[]{"projectnumber.number", "tracknumber.number", "lot", "productgroup.number", "productgroup.name"}));
        }
    }

    protected void openAllocReportPage(String taskname, String orgId, String accountId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("cad_allocreport");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        showParameter.getCustomParams().put("taskname", taskname);
        showParameter.getCustomParams().put("orgId", orgId);
        showParameter.getCustomParams().put("accountId", accountId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected List<Long> getSelectIds() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        ArrayList<Long> ids = new ArrayList<Long>(rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            Long id = (Long)rows.get(i).getPrimaryKeyValue();
            if (ids.contains(id)) continue;
            ids.add(id);
        }
        return ids;
    }

    protected MfgFeeAllocImportParam getPageImportDto() {
        MfgFeeAllocImportParam importDto = new MfgFeeAllocImportParam();
        importDto.setEntityType(this.getBillEntityId());
        importDto.setAppnum(this.getView().getFormShowParameter().getAppId());
        if (CadEmptyUtils.isEmpty((String)this.getPageCache().get("costaccount"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"MfgAllocBaseListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return null;
        }
        List<Object> orgIds = this.getOrgCache();
        Long curOrgid = Long.valueOf(orgIds.get(0).toString());
        Long costaccount = Long.valueOf(this.getPageCache().get("costaccount"));
        List<Long> manuorgs = this.getSelectManuOrg(curOrgid);
        List<ComboItem> comboItems = this.getCostAccountComboItemListBy(orgIds);
        boolean isExistCostaccount = false;
        for (ComboItem item : comboItems) {
            if (!item.getValue().equals(this.getPageCache().get("costaccount"))) continue;
            isExistCostaccount = true;
            break;
        }
        if (!isExistCostaccount && CadEmptyUtils.isEmpty((String)this.getPageCache().get("costaccount"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"MfgAllocBaseListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return null;
        }
        importDto.setOrg(curOrgid);
        importDto.setCostaccount(costaccount);
        importDto.setManuorg(manuorgs);
        DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costaccount);
        if (curPeriod == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u83b7\u53d6\u5931\u8d25\u3002", (String)"MfgAllocBaseListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return null;
        }
        String periodId = this.getPageCache().get("period");
        if (StringUtils.isNotEmpty((CharSequence)periodId) && !periodId.equals(curPeriod.getString("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u5bf9\u975e\u5f53\u524d\u671f\u95f4\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MfgAllocBaseListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return null;
        }
        importDto.setPeriod(Long.valueOf(curPeriod.getLong("id")));
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)curOrgid);
        importDto.setEnableFactory(enableMulFactory);
        if (enableMulFactory) {
            for (Long manuorgId : importDto.getManuorg()) {
                if (!CostCloseAccountHelper.checkIsCloseAccount((Long)importDto.getOrg(), (Long)manuorgId, (Long)importDto.getCostaccount(), (Long)importDto.getPeriod())) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\uff08%s\uff09+\u6210\u672c\u8d26\u7c3f+\u5f53\u524d\u671f\u95f4\u5df2\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MfgAllocBaseListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getManuOrgName(importDto.getOrg(), manuorgId));
                this.getView().showTipNotification(msg);
                return null;
            }
            List<Long> manuList = manuorgs.isEmpty() ? ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)curOrgid, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId()) : new ArrayList<Long>(manuorgs);
            Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)curOrgid, manuList, (String)this.getView().getFormShowParameter().getAppId());
            if (CadEmptyUtils.isEmpty((Set)centerIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u672a\u7ef4\u62a4\u201c\u6210\u672c\u4e2d\u5fc3\u201d\u4e0e\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u7684\u5bf9\u5e94\u5173\u7cfb\u3002", (String)"MfgAllocBaseListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return null;
            }
            importDto.setCostCenterIds(centerIds);
        }
        return importDto;
    }

    protected List<MfgFeeAllocImportParam> wrapImportDto(MfgFeeAllocImportParam importDto) {
        ArrayList<MfgFeeAllocImportParam> importDtos = new ArrayList<MfgFeeAllocImportParam>();
        importDtos.add(importDto);
        return importDtos;
    }

    private List<Long> getSelectManuOrg(Long orgId) {
        ArrayList<Long> manuorg = null;
        String manuorgStr = this.getPageCache().get("manuorg");
        if (StringUtils.isNotEmpty((CharSequence)manuorgStr)) {
            manuorg = JSON.parseArray((String)manuorgStr, Long.class);
        }
        if (manuorg == null || manuorg.size() == 0 || manuorg.get(0) == null) {
            manuorg = new ArrayList<Long>(16);
            for (ComboItem item : ImportServiceHelper.getPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())) {
                manuorg.add(Long.valueOf(item.getValue()));
            }
        }
        return manuorg;
    }

    private String getManuOrgName(Long orgId, Long manuOrg) {
        for (ComboItem item : ImportServiceHelper.getPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())) {
            if (!item.getValue().equals(manuOrg.toString())) continue;
            return item.getCaption().toString();
        }
        return "";
    }

    public static void viewAllocResult(MfgAllocResult allocResult, IFormView view) {
        if (allocResult.getVerifyMsgs() != null && !allocResult.getVerifyMsgs().isEmpty()) {
            if (allocResult.getVerifyMsgs().size() == 1 && ((String)allocResult.getVerifyMsgs().get(0)).length() <= 50) {
                view.showErrorNotification((String)allocResult.getVerifyMsgs().get(0));
                return;
            }
            StringBuilder sb = new StringBuilder();
            allocResult.getVerifyMsgs().forEach(t -> sb.append((String)t).append("\r\n"));
            view.showMessage(sb.toString());
            return;
        }
        if (AllocResultEnum.ALLSUCCESS.getResult().equals(allocResult.getAllocStatus())) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f", (String)"MfgAllocBaseListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        } else if (AllocResultEnum.PartSUCCESS.getResult().equals(allocResult.getAllocStatus())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5206\u914d\u5b8c\u6bd5\uff0c\u6709\u90e8\u5206\u5355\u636e\u5206\u914d\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u70b9\u51fb\u5206\u914d\u62a5\u544a\u67e5\u8be2\u3002", (String)"MfgAllocBaseListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        } else if (AllocResultEnum.Failure.getResult().equals(allocResult.getAllocStatus())) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff0c\u8bf7\u70b9\u51fb\u201c\u5206\u914d\u62a5\u544a\u201d\u67e5\u770b\u8be6\u60c5\u3002", (String)"MfgAllocBaseListPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }

    public boolean permItemCheck(String type, String entityName, String permItemKey, String appId) {
        String tips = null;
        if (type.equals("import")) {
            tips = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u201c%s\u201d\u7684\u201c\u5bfc\u5165\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"MfgAllocBaseListPlugin_18", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getTipsEntityName(entityName));
        } else if (type.equals("alloc")) {
            tips = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u201c%s\u201d\u7684\u201c\u5206\u914d\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"MfgAllocBaseListPlugin_19", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getTipsEntityName(entityName));
        }
        List<Object> orgIds = this.getOrgCache();
        if (orgIds == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MfgAllocBaseListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long orgId = Long.valueOf(orgIds.get(0).toString());
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityName, (String)permItemKey);
        if (rs.hasAllOrgPerm()) {
            return true;
        }
        if (rs.getHasPermOrgs().contains(orgId)) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)tips, (String)"MfgAllocBaseListPlugin_6", (String)"MfgAllocBaseListPlugin_13", (Object[])new Object[0]));
        return false;
    }

    private String getTipsEntityName(String entityName) {
        if (entityName.equals("cad_basicalloc")) {
            return ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d", (String)"MfgAllocBaseListPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        }
        if (entityName.equals("cad_mfgfeeallocco")) {
            return ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d", (String)"MfgAllocBaseListPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        }
        if (entityName.equals("cad_auxprodalloc")) {
            return ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d", (String)"MfgAllocBaseListPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d", (String)"MfgAllocBaseListPlugin_17", (String)"macc-cad-formplugin", (Object[])new Object[0]);
    }

    public void setFilter(SetFilterEvent e) {
        QFilter manuOrgQFilter = this.getManuOrgQFilter();
        if (manuOrgQFilter != null) {
            e.getQFilters().add(manuOrgQFilter);
        }
    }

    @Override
    protected QFilter getManuOrgQFilter() {
        String orgId;
        boolean enableMultiFactory;
        QFilter manuOrgQf = null;
        List<Object> orgIdList = this.getOrgCache();
        if (orgIdList != null && (enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(orgId = String.valueOf(orgIdList.get(0))))) && !StringUtils.isEmpty((CharSequence)orgId)) {
            List<Long> userHasPermProOrgsByAccOrg = this.getSelectManuOrg(Long.parseLong(orgId));
            if (!CadEmptyUtils.isEmpty(userHasPermProOrgsByAccOrg)) {
                userHasPermProOrgsByAccOrg.add(0L);
                manuOrgQf = new QFilter("manuorg", "in", userHasPermProOrgsByAccOrg);
            } else {
                manuOrgQf = new QFilter("manuorg", "=", (Object)0L);
            }
        }
        return manuOrgQf;
    }
}

