/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.feealloc;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MfgAllocCalcReportEditPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String ENTRY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        Object bizBillId = ((DynamicObject)this.getModel().getEntryEntity(ENTRY).get(e.getRowIndex())).get("bizbillid");
        String bizEntityNumber = ((DynamicObject)this.getModel().getEntryEntity(ENTRY).get(e.getRowIndex())).getString("billtypenum");
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId(bizEntityNumber);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setPkId(bizBillId);
        formShowParameter.setPageId(this.getPageCache().getPageId() + bizBillId);
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void afterBindData(EventObject e) {
        String entityNumber;
        super.afterBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        HashMap<String, Set> entityToIdsMap = new HashMap<String, Set>(16);
        for (DynamicObject entry : entryEntity) {
            String entityNumber2 = entry.getString("billtypenum");
            if (!StringUtils.isNotBlank((CharSequence)entityNumber2)) continue;
            entityToIdsMap.computeIfAbsent(entityNumber2, s -> new HashSet(2)).add(entry.getLong("bizbillid"));
        }
        if (CadEmptyUtils.isEmpty(entityToIdsMap)) {
            return;
        }
        HashMap<String, String> entityNameMap = new HashMap<String, String>(16);
        for (Map.Entry entryMap : entityToIdsMap.entrySet()) {
            entityNumber = (String)entryMap.getKey();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityNumber);
            entityNameMap.put(entityNumber, type.getDisplayName().getLocaleValue());
        }
        this.getModel().beginInit();
        for (DynamicObject entry : entryEntity) {
            entityNumber = entry.getString("billtypenum");
            entry.set("billtype", entityNameMap.get(entityNumber));
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY);
        this.getModel().setDataChanged(false);
    }
}

