/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.feealloc;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.base.BaseOrgAndCostAccountListPlugin;

public class MfgAllocCalcReportListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private volatile boolean orgFlag = true;
    private volatile boolean accountFlag = true;

    public void setFilter(SetFilterEvent e) {
        String orderBy;
        String appNumStr;
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("iscalcdata", "=", (Object)Boolean.FALSE));
        Object appNum = this.getView().getFormShowParameter().getCustomParam("appnum");
        if (appNum != null && !StringUtils.isEmpty((Object)(appNumStr = appNum.toString()))) {
            qFilters.add(new QFilter("appnum", "=", (Object)appNumStr));
        }
        orderBy = StringUtils.isEmpty((Object)(orderBy = e.getOrderBy())) ? "alloctime desc" : orderBy.concat(",alloctime desc");
        e.setOrderBy(orderBy);
    }

    @Override
    protected void resetOrg(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam("org");
        if (orgId == null) {
            super.resetOrg(commonFilterColumn, orgIdList);
        } else {
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            List<ComboItem> acctOrgs = this.getORGComboItemList();
            if (CadEmptyUtils.isEmpty(acctOrgs)) {
                return;
            }
            String defOrgId = null;
            commonFilterColumn.setComboItems(acctOrgs);
            ComboItem item = acctOrgs.get(0);
            String string = defOrgId = kd.bos.util.StringUtils.isEmpty(defOrgId) ? item.getValue() : defOrgId;
            if (CadEmptyUtils.isEmpty(orgIdList) && this.orgFlag) {
                orgIdList = Collections.singletonList(orgId);
            } else if (CadEmptyUtils.isEmpty(orgIdList)) {
                orgIdList = Collections.singletonList(defOrgId);
            }
            if (this.orgFlag) {
                commonFilterColumn.setDefaultValues(Collections.singletonList(orgId));
                this.orgFlag = false;
            } else {
                commonFilterColumn.setDefaultValues(Collections.singletonList(defOrgId));
            }
            this.putOrgCache(orgIdList);
        }
    }

    @Override
    protected void resetCostAccount(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam("org");
        if (orgId == null) {
            super.resetCostAccount(commonFilterColumn, orgIdList);
        } else {
            String defVal;
            List listComItem = commonFilterColumn.getComboItems();
            listComItem.clear();
            List<ComboItem> comboItems = null;
            comboItems = this.accountFlag ? this.getCostAccountComboItemListBy(Collections.singletonList(orgId)) : this.getCostAccountComboItemListBy(orgIdList);
            if (CollectionUtils.isEmpty(comboItems)) {
                this.getPageCache().remove("costaccount");
                return;
            }
            commonFilterColumn.setComboItems(comboItems);
            ComboItem item = comboItems.get(0);
            String string = defVal = this.isCostAccountDef != false ? "" : item.getValue();
            if (this.accountFlag) {
                String accountId = (String)this.getView().getFormShowParameter().getCustomParam("costAccount");
                commonFilterColumn.setDefaultValue(accountId);
                this.accountFlag = false;
            } else {
                commonFilterColumn.setDefaultValue(defVal);
            }
            this.getPageCache().put("costaccount", defVal);
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("org")) {
            List orgEnableMultiFactoryIds = OrgHelper.getOrgEnableMultiFactory((List)OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId()));
            args.getQfilters().add(new QFilter("id", "in", (Object)orgEnableMultiFactoryIds));
        }
        if (fieldName.startsWith("costaccount")) {
            String accountOrgId = null;
            String org = this.getPageCache().get(this.ORG_FIELD);
            if (org != null) {
                List list = (List)SerializationUtils.fromJsonString((String)org, List.class);
                accountOrgId = (String)list.get(0);
            }
            if (!CadEmptyUtils.isEmpty(accountOrgId)) {
                QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledCostAccountIdsFilter((Long)Long.parseLong(accountOrgId), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
                args.getQfilters().add(enabledCostAccountIdsFilter);
            }
        }
    }
}

