/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.feealloc;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.ClickEventHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import kd.macc.cad.formplugin.base.BaseOrgAndCostAccountListPlugin;

public class MfgAllocReportDetailListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private volatile boolean orgFlag = true;
    private volatile boolean accountFlag = true;
    private Log logger = LogFactory.getLog(MfgAllocReportDetailListPlugin.class);

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        Object taskName = this.getView().getFormShowParameter().getCustomParams().get("taskname");
        if (taskName != null) {
            BillShowParameter bsp = e.getParameter();
            bsp.setCustomParam("taskname", (Object)taskName.toString());
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("planscheme.")) {
            List<Object> orgIdList = this.getOrgCache();
            if (orgIdList == null) {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            } else {
                String costaccountSel = this.getPageCache().get("costaccount");
                ArrayList ids = new ArrayList(10);
                if (CadEmptyUtils.isEmpty((String)costaccountSel)) {
                    List<Long> costAccounts = this.getCostAccounts(orgIdList);
                    for (Long costaccount : costAccounts) {
                        ids.addAll(PlanFeeAllocHelper.getPlanEnableSchemeList((Long)costaccount));
                    }
                } else {
                    ids.addAll(PlanFeeAllocHelper.getPlanEnableSchemeList((Long)Long.valueOf(costaccountSel)));
                }
                args.getQfilters().add(new QFilter("id", "in", ids));
            }
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.filterContainerInit1(args, null);
    }

    private void filterContainerInit1(FilterContainerInitArgs args, String initName) {
        Object isPlanData = Boolean.FALSE;
        Object taskname = null;
        try {
            isPlanData = this.getView().getFormShowParameter().getCustomParam("isplandata");
            taskname = this.getView().getFormShowParameter().getCustomParam("taskname");
        }
        catch (Exception ex) {
            this.logger.error("isplandata or taskname", (Throwable)ex);
        }
        Iterator iterator = args.getFilterContainerInitEvent().getCommonFilterColumns().iterator();
        while (iterator.hasNext()) {
            FilterColumn filterColumn = (FilterColumn)iterator.next();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.startsWith("planscheme.")) {
                if (isPlanData == null || StringUtils.equals((CharSequence)isPlanData.toString(), (CharSequence)"false")) {
                    iterator.remove();
                } else {
                    String costaccount = this.getPageCache().get("costaccount");
                    this.resetPlanScheme(commonFilterColumn, costaccount);
                }
            }
            if (taskname == null || !StringUtils.equals((CharSequence)fieldName, (CharSequence)"starttime") || !StringUtils.equals((CharSequence)taskname.toString(), (CharSequence)"9")) continue;
            LocaleString caption = filterColumn.getCaption();
            caption.setLocaleValue_zh_CN(ResManager.loadKDString((String)"\u8ba1\u7b97\u65f6\u95f4", (String)"MfgAllocReportDetailListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            filterColumn.setCaption(caption);
        }
    }

    protected void resetPlanScheme(CommonFilterColumn commonFilterColumn, String costaccount) {
        List<ComboItem> comboItems;
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        Long costaccountId = 0L;
        if (StringUtils.isNotEmpty((CharSequence)costaccount)) {
            costaccountId = Long.parseLong(costaccount);
        }
        if (CollectionUtils.isEmpty(comboItems = this.getPlanSchemeComboItemsPlanStart(costaccountId))) {
            commonFilterColumn.setDefaultValue("");
            this.getPageCache().put("planscheme", "");
            return;
        }
        commonFilterColumn.setComboItems(comboItems);
        String defVal = comboItems.get(0).getValue();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String period = formShowParameter.getCustomParam("planscheme") + "";
        if (!CadEmptyUtils.isEmpty((String)period) && !"null".equals(period)) {
            boolean isContains = false;
            for (ComboItem item : comboItems) {
                if (!item.getValue().equals(period)) continue;
                isContains = true;
                break;
            }
            if (isContains) {
                defVal = period;
            }
        }
        commonFilterColumn.setDefaultValue(defVal);
        this.getPageCache().put("planscheme", defVal);
    }

    private List<ComboItem> getPlanSchemeComboItemsPlanStart(Long costaccountId) {
        List schemeIds = PlanFeeAllocHelper.getPlanEnableSchemeList((Long)costaccountId);
        QFilter periodFilter = new QFilter("id", "in", (Object)schemeIds);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"cad_planscheme", (String)"id,name", (QFilter[])periodFilter.toArray());
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        for (DynamicObject dyn : periods) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(dyn.getString("name")));
            item.setValue(dyn.getString("id"));
            items.add(item);
        }
        return items;
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        String val;
        List vals;
        List names;
        Map map;
        int i;
        super.filterContainerSearchClick(e);
        Map filterValues = e.getSearchClickEvent().getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        if (customfilter == null || customfilter.isEmpty()) {
            return;
        }
        Long costaccountId = 0L;
        Long planschemeId = 0L;
        for (i = 0; i < customfilter.size(); ++i) {
            map = (Map)customfilter.get(i);
            names = (List)map.get("FieldName");
            vals = (List)map.get("Value");
            if (vals == null || vals.isEmpty() || CadEmptyUtils.isEmpty((String)(val = String.valueOf(vals.get(0))))) continue;
            if ("costaccount.id".equals(String.valueOf(names.get(0)))) {
                costaccountId = Long.valueOf(val);
                continue;
            }
            if (!"planscheme.id".equals(String.valueOf(names.get(0)))) continue;
            planschemeId = Long.valueOf(val);
        }
        if (!(CadEmptyUtils.isEmpty((Long)planschemeId) || !CadEmptyUtils.isEmpty((Long)costaccountId) && PlanFeeAllocHelper.getPlanEnableSchemeList((Long)costaccountId).contains(planschemeId))) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"planscheme.id");
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"period.id");
        }
        for (i = 0; i < customfilter.size(); ++i) {
            map = (Map)customfilter.get(i);
            names = (List)map.get("FieldName");
            if (!"costaccount.id".equals(String.valueOf(names.get(0))) || (vals = (List)map.get("Value")) == null || vals.isEmpty()) continue;
            val = String.valueOf(vals.get(0));
            this.getPageCache().put("costaccount", val);
            this.filterContainerInit1(this.filterContainerInitArgs, "planscheme");
        }
    }

    public void setFilter(SetFilterEvent e) {
        QFilter manuOrgQFilter;
        super.setFilter(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null) {
            Object isPlanData = customParams.get("isplandata");
            Object taskName = customParams.get("taskname");
            QFilter planDataFilter = new QFilter("isplandata", "=", (Object)Character.valueOf('0'));
            if (isPlanData != null && StringUtils.equals((CharSequence)isPlanData.toString(), (CharSequence)"true")) {
                QFilter taskNameFilter;
                planDataFilter = new QFilter("isplandata", "=", (Object)Character.valueOf('1'));
                if (taskName == null) {
                    List<String> taskNames = Arrays.asList("5", "6", "7");
                    taskNameFilter = new QFilter("taskname", "in", taskNames);
                } else {
                    taskNameFilter = "9".equals(taskName.toString()) ? new QFilter("taskname", "=", (Object)Character.valueOf('9')) : QFilter.of((String)"1=1", (Object[])new Object[0]);
                }
                e.getQFilters().add(taskNameFilter);
            }
            e.getQFilters().add(planDataFilter);
        }
        if (this.getView().getFormShowParameter() instanceof ListShowParameter && this.getView().getFormShowParameter() != null) {
            String taskName = (String)this.getView().getFormShowParameter().getCustomParam("taskname");
            if (StringUtils.isNotBlank((CharSequence)taskName)) {
                QFilter taskFilter = new QFilter("taskname", "=", (Object)taskName);
                e.getQFilters().add(taskFilter);
                this.getView().getFormShowParameter().getCustomParams().put("taskname", null);
            }
            QFilter filter = new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
            e.getQFilters().add(filter);
        }
        if ((manuOrgQFilter = this.getManuOrgQFilter()) != null) {
            e.getQFilters().add(manuOrgQFilter);
        }
    }

    @Override
    protected void resetOrg(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam("orgId");
        if (orgId == null) {
            super.resetOrg(commonFilterColumn, orgIdList);
        } else {
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            List<ComboItem> acctOrgs = this.getORGComboItemList();
            if (CadEmptyUtils.isEmpty(acctOrgs)) {
                return;
            }
            String defOrgId = null;
            commonFilterColumn.setComboItems(acctOrgs);
            ComboItem item = acctOrgs.get(0);
            String string = defOrgId = kd.bos.util.StringUtils.isEmpty(defOrgId) ? item.getValue() : defOrgId;
            if (CadEmptyUtils.isEmpty(orgIdList) && this.orgFlag) {
                orgIdList = Collections.singletonList(orgId);
            } else if (CadEmptyUtils.isEmpty(orgIdList)) {
                orgIdList = Collections.singletonList(defOrgId);
            }
            if (this.orgFlag) {
                commonFilterColumn.setDefaultValues(Collections.singletonList(orgId));
                this.orgFlag = false;
            } else {
                commonFilterColumn.setDefaultValues(Collections.singletonList(defOrgId));
            }
            String costaccount = this.getPageCache().get("costaccount");
            this.putOrgCache(orgIdList);
            if (!CadEmptyUtils.isEmpty((String)costaccount)) {
                List<ComboItem> accountItems = this.getCostAccountComboItemListBy(orgIdList);
                for (ComboItem cbitem : accountItems) {
                    if (!cbitem.getValue().equals(costaccount)) continue;
                    this.getPageCache().put("costaccount", costaccount);
                    break;
                }
            }
        }
    }

    @Override
    protected void resetCostAccount(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam("orgId");
        if (orgId == null) {
            super.resetCostAccount(commonFilterColumn, orgIdList);
        } else {
            List listComItem = commonFilterColumn.getComboItems();
            listComItem.clear();
            List<ComboItem> comboItems = null;
            comboItems = this.accountFlag ? this.getCostAccountComboItemListBy(Collections.singletonList(orgId)) : this.getCostAccountComboItemListBy(orgIdList);
            if (CollectionUtils.isEmpty(comboItems)) {
                this.getPageCache().remove("costaccount");
                return;
            }
            commonFilterColumn.setComboItems(comboItems);
            ComboItem item = comboItems.get(0);
            String defVal = this.isCostAccountDef != false ? "" : item.getValue();
            String costaccountSel = this.getPageCache().get("costaccount");
            if (!CadEmptyUtils.isEmpty((String)costaccountSel)) {
                for (ComboItem cbitem : comboItems) {
                    if (!cbitem.getValue().equals(costaccountSel)) continue;
                    defVal = costaccountSel;
                    break;
                }
            }
            if (this.accountFlag) {
                String accountId = (String)this.getView().getFormShowParameter().getCustomParam("accountId");
                commonFilterColumn.setDefaultValue(accountId);
                this.accountFlag = false;
            } else {
                commonFilterColumn.setDefaultValue(defVal);
            }
            this.getPageCache().put("costaccount", defVal);
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        Object isPlanData = Boolean.FALSE;
        Object taskname = null;
        try {
            isPlanData = this.getView().getFormShowParameter().getCustomParam("isplandata");
            taskname = this.getView().getFormShowParameter().getCustomParam("taskname");
        }
        catch (Exception ex) {
            this.logger.error("isplandata or taskname", (Throwable)ex);
        }
        if (isPlanData == null || StringUtils.equals((CharSequence)isPlanData.toString(), (CharSequence)"false")) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)args, (Set)Sets.newHashSet((Object[])new String[]{"planscheme.id", "planscheme.number", "planscheme.name"}));
        }
        if (taskname != null && StringUtils.equals((CharSequence)taskname.toString(), (CharSequence)"9")) {
            LocaleString caption = args.getListColumn("starttime").getCaption();
            caption.setLocaleValue_zh_CN(ResManager.loadKDString((String)"\u8ba1\u7b97\u65f6\u95f4", (String)"MfgAllocReportDetailListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            args.getListColumn("starttime").setCaption(caption);
        }
    }

    @Override
    protected List<ComboItem> getORGComboItemList() {
        return OrgHelper.getOrgComboItems((String)"cad_allocreport", (String)"47150e89000000ac", (String)this.getView().getFormShowParameter().getAppId());
    }
}

