/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.feealloc;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.feealloc.MfgFeeAuxProdAllocService;
import kd.macc.cad.common.enums.AssistantEnum;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.output.MfgAllocResult;
import kd.macc.cad.formplugin.feealloc.MfgAllocBaseListPlugin;
import org.apache.commons.lang.StringUtils;

public class MfgAuxProdAllocEditPlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    private static final String KEY_REFRESH = "refresh";
    private static final String KEY_IS_AUTOALLOC = "isAutoAlloc";

    public void afterBindData(EventObject e) {
        this.setManuOrg();
        this.hiddenField();
        this.doAllocOperation();
    }

    private void doAllocOperation() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            return;
        }
        String allocstatus = this.getModel().getDataEntity().getString("allocstatus");
        Long id = this.getModel().getDataEntity().getLong("id");
        String cacheId = this.getPageCache().get(KEY_IS_AUTOALLOC);
        if (ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue().equals(allocstatus) && (cacheId == null || !StringUtils.equals((String)id.toString(), (String)cacheId))) {
            this.getPageCache().put(KEY_IS_AUTOALLOC, id.toString());
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(id);
            this.doAlloc(ids);
            this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
        }
    }

    private void setManuOrg() {
        String costAccount = this.getModel().getDataEntity().getString("costaccount.id");
        boolean enableMulFactory = costAccount != null && CostAccountHelper.isEnableMulFactory((Long)Long.valueOf(costAccount));
        this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
    }

    private void doAlloc(List<Long> ids) {
        MfgFeeAuxProdAllocService service = new MfgFeeAuxProdAllocService();
        MfgAllocResult allocResult = service.doSelectAlloc(ids, this.getView().getFormShowParameter().getAppId(), null, false);
        MfgAllocBaseListPlugin.viewAllocResult(allocResult, this.getView());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("parallelentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("parallelentity");
        entryGrid.setCollapse(false);
    }

    public void entryRowClick(RowClickEvent evt) {
        DynamicObjectCollection dynCols;
        super.entryRowClick(evt);
        String allocmethod = this.getModel().getDataEntity().getString("allocmethod");
        boolean isDivideAllocMethod = AssistantEnum.DIVIDE_MUTUAL.getValue().equals(allocmethod);
        boolean isAlgebraAllocMethod = AssistantEnum.DIVIDE_ALGEBRA.getValue().equals(allocmethod);
        if ((isDivideAllocMethod || isAlgebraAllocMethod) && evt.getRow() != 0 && (dynCols = this.getModel().getEntryEntity("parallelentity")).size() > 0) {
            Long id = ((DynamicObject)dynCols.get(0)).getLong("id");
            DynamicObjectCollection subcols = this.getModel().getEntryEntity("parallelsubentity");
            if (subcols.size() == 0) {
                DynamicObjectCollection cols = this.getAuxProdBill(id);
                for (DynamicObject dyn : cols) {
                    DynamicObject dynObj = subcols.addNew();
                    dynObj.set("parsubexpenseitem_id", (Object)dyn.getLong("parsubexpenseitem"));
                    dynObj.set("parsubcostdriver_id", (Object)dyn.getLong("parsubcostdriver"));
                    dynObj.set("parsubbaseunit_id", (Object)dyn.getLong("parsubbaseunit"));
                    dynObj.set("parsubcostcenter_id", (Object)dyn.getLong("parsubcostcenter"));
                    dynObj.set("parsubqty", (Object)dyn.getBigDecimal("parsubqty"));
                    dynObj.set("parsubinqty", (Object)dyn.getBigDecimal("parsubinqty"));
                    dynObj.set("parsuboutqty", (Object)dyn.getBigDecimal("parsuboutqty"));
                    dynObj.set("parsubamt", (Object)dyn.getBigDecimal("parsubamt"));
                    dynObj.set("parsubinamt", (Object)dyn.getBigDecimal("parsubinamt"));
                    dynObj.set("parsuboutamt", (Object)dyn.getBigDecimal("parsuboutamt"));
                }
                BusinessDataServiceHelper.loadRefence((Object[])subcols.toArray((Object[])new DynamicObject[0]), (IDataEntityType)subcols.getDynamicObjectType());
                this.getView().updateView("parallelsubentity");
            }
            this.getModel().setDataChanged(false);
        }
    }

    public DynamicObjectCollection getAuxProdBill(Long id) {
        QFilter filter = new QFilter("parallelentity.id", "=", (Object)id);
        String absorbSelectFields = "parallelentity.parallelsubentity.parsubcostcenter parsubcostcenter,parallelentity.parallelsubentity.parsubexpenseitem parsubexpenseitem,parallelentity.parallelsubentity.parsubcostdriver parsubcostdriver,parallelentity.parallelsubentity.parsubbaseunit parsubbaseunit,parallelentity.parallelsubentity.parsubqty parsubqty,parallelentity.parallelsubentity.parsubinqty parsubinqty,parallelentity.parallelsubentity.parsuboutqty parsuboutqty,parallelentity.parallelsubentity.parsubamt parsubamt,parallelentity.parallelsubentity.parsubinamt parsubinamt,parallelentity.parallelsubentity.parsuboutamt parsuboutamt";
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"cad_auxprodalloc", (String)absorbSelectFields, (QFilter[])filter.toArray(), (String)"parallelentity.parallelsubentity.seq");
        return bills;
    }

    private void hiddenField() {
        String allocmethod = this.getModel().getDataEntity().getString("allocmethod");
        Boolean publicaux = this.getModel().getDataEntity().getBoolean("publicaux");
        boolean isDivideAllocMethod = AssistantEnum.DIVIDE_MUTUAL.getValue().equals(allocmethod);
        boolean isAlgebraAllocMethod = AssistantEnum.DIVIDE_ALGEBRA.getValue().equals(allocmethod);
        boolean showFlag = isDivideAllocMethod || isAlgebraAllocMethod;
        this.getView().setVisible(Boolean.valueOf(publicaux == false && isDivideAllocMethod), new String[]{"actualoutrate"});
        this.getView().setVisible(Boolean.valueOf(publicaux == false && isDivideAllocMethod), new String[]{"actualinrate"});
        this.getView().setVisible(Boolean.valueOf(publicaux == false && !isDivideAllocMethod), new String[]{"actualrate"});
        this.getView().setVisible(Boolean.valueOf(publicaux == false), new String[]{"allocmethod"});
        this.getView().setVisible(Boolean.valueOf(showFlag), new String[]{"subinamt"});
        this.getView().setVisible(Boolean.valueOf(showFlag), new String[]{"suboutamt"});
        this.getView().setVisible(Boolean.valueOf(showFlag), new String[]{"subinqty"});
        this.getView().setVisible(Boolean.valueOf(showFlag), new String[]{"suboutqty"});
        this.getView().setVisible(Boolean.valueOf(!showFlag), new String[]{"subqty"});
        this.getView().setVisible(Boolean.valueOf(!showFlag), new String[]{"subamt"});
        this.getView().setVisible(Boolean.valueOf(publicaux == false && isDivideAllocMethod), new String[]{"paractualoutrate"});
        this.getView().setVisible(Boolean.valueOf(publicaux == false && isDivideAllocMethod), new String[]{"paractualinrate"});
        this.getView().setVisible(Boolean.valueOf(publicaux == false && !isDivideAllocMethod), new String[]{"paractualrate"});
        this.getView().setVisible(Boolean.valueOf(!showFlag), new String[]{"parallocsum"});
        this.getView().setVisible(Boolean.valueOf(showFlag), new String[]{"parsubinqty"});
        this.getView().setVisible(Boolean.valueOf(showFlag), new String[]{"parsuboutqty"});
        this.getView().setVisible(Boolean.valueOf(showFlag), new String[]{"parsubinamt"});
        this.getView().setVisible(Boolean.valueOf(showFlag), new String[]{"parsuboutamt"});
        this.getView().setVisible(Boolean.valueOf(!showFlag), new String[]{"parsubqty"});
        this.getView().setVisible(Boolean.valueOf(!showFlag), new String[]{"parsubamt"});
    }
}

