/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.feealloc;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.feealloc.MfgFeeBasicAllocService;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.output.MfgAllocResult;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import kd.macc.cad.common.utils.MessgeBoxUtils;
import kd.macc.cad.formplugin.feealloc.MfgAllocBaseListPlugin;
import org.apache.commons.lang.StringUtils;

public class MfgBasicAllocListPlugin
extends MfgAllocBaseListPlugin {
    private static final String CONFIRM_BACK = "doImport";
    private static final String KEY_REFRESH = "refresh";
    private static final String CONFIRMBACK_DOUNCONFIRM = "do_unconfirm";

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("period desc,billno asc");
        if (AppIdHelper.isMacc((IFormView)this.getView())) {
            e.getQFilters().add(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs beforeCreateListColumnsArgs) {
        super.beforeCreateListColumns(beforeCreateListColumnsArgs);
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("sca".equals(appId)) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)beforeCreateListColumnsArgs, (Set)Sets.newHashSet((Object[])new String[]{"productgroup.number", "productgroup.name"}));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "importcollc": {
                if (CadEmptyUtils.isEmpty((String)this.getPageCache().get("costaccount"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"MfgBasicAllocListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Long costAccountId = Long.valueOf(this.getPageCache().get("costaccount"));
                String lockErrStr = SimpleMutexHelper.mfgCheckAndRequireXMutex((String)"basicImport", (Long)costAccountId);
                if (!StringUtils.isNotEmpty((String)lockErrStr)) break;
                this.getView().showErrorNotification(lockErrStr);
                args.setCancel(true);
                return;
            }
            case "op_unconfirm": {
                MfgFeeBasicAllocService service = new MfgFeeBasicAllocService();
                MfgFeeAllocImportParam importDto = this.getPageImportDto();
                if (importDto == null) {
                    args.setCancel(true);
                    return;
                }
                if (service.isBillHasData(importDto, "cad_mfgfeeallocco", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53cd\u786e\u8ba4\u5931\u8d25\uff0c\u4e0b\u6e38\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5355\u5df2\u7ecf\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", (String)"MfgBasicAllocListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (!service.isBillHasData(importDto, "cad_mfgfeeallocco")) break;
                RefObject afterConfirm = new RefObject();
                if (operate.getOption().tryGetVariableValue(CONFIRMBACK_DOUNCONFIRM, afterConfirm)) break;
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMBACK_DOUNCONFIRM, (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u53cd\u786e\u8ba4\u4f1a\u5220\u9664\u4e0b\u6e38\u5206\u914d\u5355\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6267\u884c\u201c\u53cd\u786e\u8ba4\u201d\u64cd\u4f5c\u3002", (String)"MfgBasicAllocListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
                break;
            }
            case "generatevoucher": {
                ListSelectedRowCollection selectedRows = args.getListSelectedData();
                Object[] pkValues = selectedRows.getPrimaryKeyValues();
                if (CadEmptyUtils.isEmpty((ListSelectedRowCollection)selectedRows)) break;
                QFilter idFilter = new QFilter("id", "in", (Object)pkValues);
                DynamicObjectCollection bills = QueryServiceHelper.query((String)"cad_basicalloc", (String)"id,costaccount,period", (QFilter[])idFilter.toArray());
                Set costAccountIds = bills.stream().map(e -> e.getLong("costaccount")).collect(Collectors.toSet());
                Map costAccountCurrentPeriodMap = PeriodHelper.getAccountCurrentPeriod(costAccountIds);
                boolean isCurrentPeriod = true;
                for (DynamicObject bill : bills) {
                    if (bill.getLong("period") == ((Long)costAccountCurrentPeriodMap.get(bill.getLong("costaccount"))).longValue()) continue;
                    isCurrentPeriod = false;
                    break;
                }
                if (isCurrentPeriod) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5931\u8d25\u3002\u5206\u914d\u5355\u7684\u6838\u7b97\u671f\u95f4\u975e\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u51ed\u8bc1\u3002", (String)"MfgBasicAllocListPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "importcollc": {
                MfgFeeAllocImportParam importDto = this.getPageImportDto();
                Long costAccountId = Long.valueOf(this.getPageCache().get("costaccount"));
                if (importDto != null) {
                    this.importCheck(importDto);
                    break;
                }
                SimpleMutexHelper.releaseXMutex((String)"basicImport", (Object)(costAccountId + "basicImport"));
                break;
            }
            case "op_confirm": {
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                break;
            }
            case "op_unconfirm": {
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                break;
            }
            case "allocation": {
                if (!e.getOperationResult().isSuccess()) break;
                Long costAccountId = Long.valueOf(this.getPageCache().get("costaccount"));
                List<Long> ids = this.getSelectIds();
                if (ids.size() <= 0) break;
                String lockErrStr = SimpleMutexHelper.mfgCheckAndRequireXMutex((String)"basicAlloc", (Long)costAccountId);
                if (StringUtils.isNotEmpty((String)lockErrStr)) {
                    this.getView().showErrorNotification(lockErrStr);
                    return;
                }
                this.doAlloc(ids, this.getView().getFormShowParameter().getAppId(), false);
                break;
            }
            case "allocreport": {
                String org = this.getPageCache().get(this.ORG_FIELD);
                if (org == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MfgBasicAllocListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                List list = (List)SerializationUtils.fromJsonString((String)org, List.class);
                String OrgId = (String)list.get(0);
                String accountId = this.getPageCache().get("costaccount");
                this.openAllocReportPage("3", OrgId, accountId);
            }
        }
    }

    private void doAlloc(List<Long> ids, String appId, boolean planData) {
        try {
            MfgFeeBasicAllocService service = new MfgFeeBasicAllocService();
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d", (String)"MfgBasicAllocListPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                MfgAllocResult allocResult = new MfgAllocResult();
                try {
                    allocResult = service.doAlloc(ids, appId, progressId, planData, Long.valueOf(0L));
                }
                catch (Exception e) {
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                String responseInfoStr = SerializationUtils.toJsonString((Object)allocResult);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), "allocResult"));
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
        this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        this.getView().hideLoading();
        switch (actionId = e.getActionId()) {
            case "allocResult": {
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                MfgAllocResult allocResult = (MfgAllocResult)SerializationUtils.fromJsonString((String)responseInfoStr, MfgAllocResult.class);
                MfgBasicAllocListPlugin.viewAllocResult(allocResult, this.getView());
                this.getView().invokeOperation(KEY_REFRESH);
                break;
            }
            case "importResult": {
                String importResponseInfoStr = this.getPageCache().get("importresponseInfo");
                if (CadEmptyUtils.isEmpty((String)importResponseInfoStr)) {
                    return;
                }
                ExecuteResult result = (ExecuteResult)SerializationUtils.fromJsonString((String)importResponseInfoStr, ExecuteResult.class);
                if (result.isSuccess()) {
                    String successTip = (String)result.getSuccessInfo().get("Success");
                    if (StringUtils.isEmpty((String)successTip)) {
                        if (result.getSuccessQty() > 0) {
                            String successMsg = ResManager.loadKDString((String)"\u6210\u529f\u751f\u6210%s\u5f20\u5355\u636e\uff0c\u4e0b\u6e38\u5206\u914d\u5355\u9700\u8981\u91cd\u65b0\u5f15\u5165\u3002", (String)"MfgBasicAllocListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                            this.getView().showSuccessNotification(String.format(successMsg, result.getSuccessQty()));
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"MfgBasicAllocListPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                        }
                    } else {
                        this.getView().showSuccessNotification(successTip);
                    }
                    this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                    break;
                }
                result.showNotificationSample(this.getView());
                break;
            }
        }
    }

    private void importCheck(MfgFeeAllocImportParam importParam) {
        MfgFeeBasicAllocService allocService = new MfgFeeBasicAllocService();
        long costAccountId = importParam.getCostaccount();
        if (allocService.getAuxProdBillIsAllConfirm(importParam)) {
            SimpleMutexHelper.releaseXMutex((String)"basicImport", (Object)(costAccountId + "basicImport"));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355\u672a\u5168\u90e8\u786e\u8ba4\uff0c\u8bf7\u5904\u7406\u3002", (String)"MfgBasicAllocListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet errorInfo = new HashSet(16);
        String error = allocService.validateAllocStand(importParam, errorInfo);
        if (!CadEmptyUtils.isEmpty(errorInfo)) {
            ArrayList errorList = Lists.newArrayList();
            String operateName = ResManager.loadKDString((String)"\u5f15\u5165", (String)"MfgBasicAllocListPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            errorInfo.forEach(s -> errorList.add(new String[]{operateName, "Error", s}));
            SimpleMutexHelper.releaseXMutex((String)"basicImport", (Object)(costAccountId + "basicImport"));
            MessgeBoxUtils.showDetailsMessageBox((IFormView)this.getView(), (String)operateName, (String)ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25", (String)"MfgBasicAllocListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]), (List)errorList);
            return;
        }
        if (StringUtils.isNotBlank((String)error)) {
            SimpleMutexHelper.releaseXMutex((String)"basicImport", (Object)(costAccountId + "basicImport"));
            this.getView().showMessage(error);
            return;
        }
        if (allocService.isBillHasData(importParam, "cad_basicalloc")) {
            if (allocService.isBillGenVounums(importParam, "cad_basicalloc")) {
                SimpleMutexHelper.releaseXMutex((String)"basicImport", (Object)(costAccountId + "basicImport"));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u914d\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u5bfc\u5165\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u518d\u64cd\u4f5c\u3002", (String)"MfgBasicAllocListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            if (allocService.isBillGenVounums(importParam, "cad_mfgfeeallocco")) {
                SimpleMutexHelper.releaseXMutex((String)"basicImport", (Object)(costAccountId + "basicImport"));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u7684\u5206\u914d\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u5bfc\u5165\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u518d\u64cd\u4f5c\u3002", (String)"MfgBasicAllocListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            if (allocService.isBillHasData(importParam, "cad_basicalloc", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) {
                SimpleMutexHelper.releaseXMutex((String)"basicImport", (Object)(costAccountId + "basicImport"));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff0c\u5f53\u524d\u5206\u914d\u5355\u9700\u8981\u5168\u90e8\u53cd\u786e\u8ba4\uff0c\u624d\u80fd\u91cd\u65b0\u5bfc\u5165\u6570\u636e\u3002", (String)"MfgBasicAllocListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            allocService.delRelateBills(importParam, Boolean.valueOf(false));
        }
        this.doImport(importParam);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes) {
            if (StringUtils.equals((String)CONFIRM_BACK, (String)e.getCallBackId())) {
                MfgFeeAllocImportParam importParam = (MfgFeeAllocImportParam)JSON.parseObject((String)this.getPageCache().get("importParams"), MfgFeeAllocImportParam.class);
                MfgFeeBasicAllocService allocService = new MfgFeeBasicAllocService();
                allocService.delRelateBills(importParam, Boolean.valueOf(false));
                this.doImport(importParam);
            } else if (StringUtils.equals((String)CONFIRMBACK_DOUNCONFIRM, (String)e.getCallBackId())) {
                OperateOption operationOption = OperateOption.create();
                operationOption.setVariableValue(CONFIRMBACK_DOUNCONFIRM, "true");
                this.getView().invokeOperation("op_unconfirm", operationOption);
            }
        }
    }

    private void doImport(MfgFeeAllocImportParam importParam) {
        String progressId = UUID.randomUUID().toString();
        MfgFeeBasicAllocService service = new MfgFeeBasicAllocService();
        ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"MfgBasicAllocListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
            ExecuteResult result = new ExecuteResult();
            try {
                result = service.pooBillAndNonProdAndAuxImport(importParam, progressId);
            }
            catch (Exception e) {
                ProgressHelper.showError((String)progressId, (String)e.getMessage());
            }
            String responseInfoStr = SerializationUtils.toJsonString((Object)result);
            this.getPageCache().put("importresponseInfo", responseInfoStr);
        }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), "importResult"));
    }

    @Override
    protected List<ComboItem> getORGComboItemList() {
        return OrgHelper.getOrgComboItems((String)"cad_basicalloc", (String)"47150e89000000ac", (String)this.getView().getFormShowParameter().getAppId());
    }
}

