/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.feealloc;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.macc.cad.business.feealloc.MfgFeeInnerCostcenterAllocService;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.output.MfgAllocResult;
import kd.macc.cad.formplugin.feealloc.MfgAllocBaseListPlugin;
import org.apache.commons.lang.StringUtils;

public class MfgFeeAllocCostcenterEditPlugin
extends AbstractBillPlugIn {
    private static final String KEY_REFRESH = "refresh";
    private static final String KEY_IS_AUTOALLOC = "isAutoAlloc";

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        switch (e.getOperateKey()) {
            case "op_confirm": 
            case "op_unconfirm": {
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                break;
            }
            case "allocation": {
                Long id = this.getModel().getDataEntity().getLong("id");
                ArrayList<Long> ids = new ArrayList<Long>();
                ids.add(id);
                this.doAlloc(ids);
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                if (!"eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView())) || !ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue().equals(this.getModel().getValue("allocstatus"))) break;
                this.getView().invokeOperation("op_confirm");
            }
        }
    }

    public void beforeBindData(EventObject e) {
        this.hideAcaFields();
        this.setFieldVisible();
    }

    private void setFieldVisible() {
        DynamicObject org = (DynamicObject)this.getModel().getDataEntity().get("org");
        DynamicObject costAccount = (DynamicObject)this.getModel().getDataEntity().get("costaccount");
        boolean isMergeBill = true;
        if (org != null && costAccount != null) {
            isMergeBill = SysParamHelper.isMergeBill((Long)org.getLong("id"), (Long)costAccount.getLong("id"), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
        }
        this.getView().setVisible(Boolean.valueOf(!isMergeBill), new String[]{"allocexpenseitem"});
    }

    private void hideAcaFields() {
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("sca".equalsIgnoreCase(appId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"productgroup", "outsourcetype"});
        }
        this.getView().setVisible(Boolean.valueOf("eca".equalsIgnoreCase(appId)), new String[]{"project"});
    }

    public void afterBindData(EventObject e) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            return;
        }
        this.setManuOrg();
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(!AppIdHelper.isSCA((IFormView)this.getView())), new String[]{"projectnumber", "tracknumber", "lot"});
        String allocstatus = this.getModel().getDataEntity().getString("allocstatus");
        Long id = this.getModel().getDataEntity().getLong("id");
        String cacheId = this.getPageCache().get(KEY_IS_AUTOALLOC);
        if (ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue().equals(allocstatus) && (cacheId == null || !StringUtils.equals((String)id.toString(), (String)cacheId))) {
            this.getPageCache().put(KEY_IS_AUTOALLOC, id.toString());
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(id);
            this.doAlloc(ids);
            this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
            if ("eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView())) && ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue().equals(this.getModel().getValue("allocstatus"))) {
                this.getView().invokeOperation("op_confirm");
            }
        }
    }

    private void setManuOrg() {
        String costAccount = this.getModel().getDataEntity().getString("org.id");
        boolean enableMulFactory = costAccount != null && OrgHelper.isOrgEnableMultiFactory((Long)Long.valueOf(costAccount));
        this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
    }

    private void doAlloc(List<Long> ids) {
        try {
            MfgFeeInnerCostcenterAllocService service = new MfgFeeInnerCostcenterAllocService();
            MfgAllocResult allocResult = service.doAlloc(ids, this.getView().getFormShowParameter().getAppId(), null);
            MfgAllocBaseListPlugin.viewAllocResult(allocResult, this.getView());
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }
}

