/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.feealloc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.algox.constants.AllocResultEnum;
import kd.macc.cad.business.feealloc.MfgFeeInnerCostcenterAllocService;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.output.MfgAllocResult;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import kd.macc.cad.formplugin.feealloc.MfgAllocBaseListPlugin;

public class MfgFeeAllocCostcenterListPlugin
extends MfgAllocBaseListPlugin {
    private boolean isFirstInitFilterByMainPage = false;
    private boolean isfirstSetFilterByMainPage = false;
    private static final String CONFIRMBACK_DOIMPORT = "do_import";
    private static final String KEY_REFRESH = "refresh";
    private static final String KEY_IMPORT_JSON = "importdtos";

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        BillList billlist = (BillList)e.getSource();
        if ("comexpentry".equals(billlist.getEntryEntity())) {
            e.setOrderBy("period desc,billno asc,comexpentry.srcexpenseitem.number asc");
        } else {
            e.setOrderBy("period desc,billno asc");
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String source = (String)formShowParameter.getCustomParam("source");
        if (StringUtils.equals((CharSequence)"HyperLink", (CharSequence)source) && this.isfirstSetFilterByMainPage) {
            Map paramMap = formShowParameter.getCustomParams();
            String filterStr = (String)paramMap.get("otherFilter");
            if (StringUtils.isNotBlank((CharSequence)filterStr)) {
                QFilter filter = QFilter.fromSerializedString((String)filterStr);
                e.getQFilters().add(filter);
            }
            this.isfirstSetFilterByMainPage = false;
        }
        if (AppIdHelper.isMacc((IFormView)this.getView())) {
            e.getQFilters().add(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.isFirstInitFilterByMainPage = true;
        this.isfirstSetFilterByMainPage = true;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("calcreport".equals(evt.getItemKey())) {
            boolean hasPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()), (String)"cad_alloccalcreport", (String)"47150e89000000ac");
            if (!hasPermission) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5206\u914d\u8ba1\u7b97\u62a5\u544a\u201d\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"MfgFeeAllocCostcenterListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            Object[] primaryKeyValues = rows.getPrimaryKeyValues();
            boolean isSelectOneBill = false;
            if (primaryKeyValues.length == 1) {
                isSelectOneBill = QueryServiceHelper.exists((String)"cad_alloccalcreport", (Object)primaryKeyValues[0]);
            }
            if (isSelectOneBill) {
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setFormId("cad_alloccalcreport");
                billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                billShowParameter.setPkId(primaryKeyValues[0]);
                billShowParameter.setPageId(this.getPageCache().getPageId() + primaryKeyValues[0]);
                this.getView().showForm((FormShowParameter)billShowParameter);
            } else {
                ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"cad_alloccalcreport", (boolean)true, (int)1, (boolean)false);
                String org = this.getPageCache().get(this.ORG_FIELD);
                if (org == null) {
                    return;
                }
                List list = (List)SerializationUtils.fromJsonString((String)org, List.class);
                String orgId = (String)list.get(0);
                String accountId = this.getPageCache().get("costaccount");
                listShowParameter.setCustomParam("appnum", (Object)this.getView().getFormShowParameter().getAppId());
                listShowParameter.setCustomParam("org", (Object)orgId);
                listShowParameter.setCustomParam("costAccount", (Object)accountId);
                listShowParameter.setPageId(this.getPageCache().getPageId() + "cad_alloccalcreport");
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Map paramMap = formShowParameter.getCustomParams();
        if (this.isMatchCondition(paramMap) && this.isFirstInitFilterByMainPage) {
            this.mainPageFilterInit(filterColumns, paramMap);
            this.isFirstInitFilterByMainPage = false;
        }
    }

    private void mainPageFilterInit(List<FilterColumn> filterColumns, Map<String, Object> paramMap) {
        for (int i = 0; i < filterColumns.size(); ++i) {
            FilterColumn filterColumn = filterColumns.get(i);
            CommonFilterColumn schemeFilterColumn = (CommonFilterColumn)filterColumn;
            String schemeFilterColumnName = schemeFilterColumn.getFieldName();
            if ("costaccount.name".equals(schemeFilterColumnName) && paramMap.get("costaccount") != null) {
                ArrayList<Object> orgIdList = new ArrayList<Object>();
                orgIdList.add(paramMap.get("org"));
                List<ComboItem> comboItems = this.getCostAccountComboItemListBy(orgIdList);
                schemeFilterColumn.setComboItems(comboItems);
                schemeFilterColumn.setDefaultValue(paramMap.get("costaccount").toString());
                this.getPageCache().put("costaccount", paramMap.get("costaccount").toString());
                continue;
            }
            if ("org.name".equals(schemeFilterColumnName) && paramMap.get("org") != null) {
                schemeFilterColumn.setDefaultValue(paramMap.get("org").toString());
                continue;
            }
            if ("allocstatus".equals(schemeFilterColumnName) && paramMap.get("allocstatus") != null) {
                List parseArray = JSONArray.parseArray((String)paramMap.get("allocstatus").toString(), String.class);
                schemeFilterColumn.setDefaultValues(parseArray.toArray());
                continue;
            }
            if ("period.name".equals(schemeFilterColumnName) && this.getPageCache().get("costaccount") != null) {
                List<ComboItem> pcomboItems = this.getPeriodComboItemsByLast(Long.valueOf(this.getPageCache().get("costaccount")));
                schemeFilterColumn.setComboItems(pcomboItems);
            }
            schemeFilterColumn.setDefaultValue(null);
        }
    }

    private boolean isMatchCondition(Map<String, Object> paramMap) {
        boolean flag = false;
        String key = (String)paramMap.get("source");
        if ("GardHomePlugin".equals(key)) {
            flag = true;
        }
        return flag;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "importalloc": {
                if (CadEmptyUtils.isEmpty((String)this.getPageCache().get("costaccount"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"MfgFeeAllocCostcenterListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Long costAccountId = Long.valueOf(this.getPageCache().get("costaccount"));
                String lockErrStr = SimpleMutexHelper.mfgCheckAndRequireXMutex((String)"coImport", (Long)costAccountId);
                if (!StringUtils.isNotEmpty((CharSequence)lockErrStr)) break;
                this.getView().showErrorNotification(lockErrStr);
                args.setCancel(true);
                return;
            }
            case "op_confirm": 
            case "op_unconfirm": 
            case "allocation": {
                boolean historyPeriodData = this.historyDataPeriod(args);
                if (!historyPeriodData) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4e0d\u5141\u8bb8\u5bf9\u975e\u5f53\u524d\u671f\u95f4\u6570\u636e\u8fdb\u884c\u64cd\u4f5c", (String)"MfgFeeAllocCostcenterListPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "generatevoucher": {
                ListSelectedRowCollection selectedRows = args.getListSelectedData();
                Object[] pkValues = selectedRows.getPrimaryKeyValues();
                if (CadEmptyUtils.isEmpty((ListSelectedRowCollection)selectedRows)) break;
                QFilter idFilter = new QFilter("id", "in", (Object)pkValues);
                DynamicObjectCollection bills = QueryServiceHelper.query((String)"cad_mfgfeeallocco", (String)"id,costaccount,period", (QFilter[])idFilter.toArray());
                Set costAccountIds = bills.stream().map(e -> e.getLong("costaccount")).collect(Collectors.toSet());
                Map costAccountCurrentPeriodMap = PeriodHelper.getAccountCurrentPeriod(costAccountIds);
                boolean isCurrentPeriod = true;
                for (DynamicObject bill : bills) {
                    if (bill.getLong("period") == ((Long)costAccountCurrentPeriodMap.get(bill.getLong("costaccount"))).longValue()) continue;
                    isCurrentPeriod = false;
                    break;
                }
                if (isCurrentPeriod) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5931\u8d25\u3002\u5206\u914d\u5355\u7684\u6838\u7b97\u671f\u95f4\u975e\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u51ed\u8bc1\u3002", (String)"MfgFeeAllocCostcenterListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private boolean historyDataPeriod(BeforeDoOperationEventArgs args) {
        Long costAccountId = Long.valueOf(this.getPageCache().get("costaccount"));
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        if (!CadEmptyUtils.isEmpty((ListSelectedRowCollection)listSelectedData)) {
            Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
            QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
            DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            if (curPeriod != null) {
                qFilter.and("period", "!=", (Object)curPeriod.getLong("id"));
                return QueryServiceHelper.exists((String)"cad_mfgfeeallocco", (QFilter[])qFilter.toArray());
            }
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        switch (e.getOperateKey()) {
            case "importalloc": {
                MfgFeeAllocImportParam importDto = this.getPageImportDto();
                Long costAccountId = Long.valueOf(this.getPageCache().get("costaccount"));
                if (importDto == null) {
                    SimpleMutexHelper.releaseXMutex((String)"coImport", (Object)(costAccountId + "coImport"));
                    return;
                }
                this.doSearchImport(importDto);
                break;
            }
            case "op_confirm": {
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                break;
            }
            case "op_unconfirm": {
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                break;
            }
            case "allocation": {
                List<Long> ids;
                if (!e.getOperationResult().isSuccess() || (ids = this.getSelectIds()).size() <= 0) break;
                this.doAlloc(ids, null);
                break;
            }
            case "allocreport": {
                String org = this.getPageCache().get(this.ORG_FIELD);
                if (org == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MfgFeeAllocCostcenterListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                List list = (List)SerializationUtils.fromJsonString((String)org, List.class);
                String OrgId = (String)list.get(0);
                String accountId = this.getPageCache().get("costaccount");
                this.openAllocReportPage("4", OrgId, accountId);
            }
        }
    }

    private void doAlloc(List<Long> ids, String importProgressId) {
        MfgFeeInnerCostcenterAllocService service = this.getService();
        Long costAccountId = Long.valueOf(this.getPageCache().get("costaccount"));
        String lockErrStr = SimpleMutexHelper.mfgCheckAndRequireXMutex((String)"coImport", (Long)costAccountId);
        if (StringUtils.isNotEmpty((CharSequence)lockErrStr)) {
            this.getView().showErrorNotification(lockErrStr);
            return;
        }
        if (!CadEmptyUtils.isEmpty((String)importProgressId)) {
            service.doAlloc(ids, this.getView().getFormShowParameter().getAppId(), importProgressId);
        } else {
            try {
                String progressId = UUID.randomUUID().toString();
                ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d", (String)"MfgFeeAllocCostcenterListPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                    MfgAllocResult allocResult = new MfgAllocResult();
                    try {
                        allocResult = service.doAlloc(ids, this.getView().getFormShowParameter().getAppId(), progressId);
                    }
                    catch (Exception e) {
                        ProgressHelper.showError((String)progressId, (String)e.getMessage());
                    }
                    String responseInfoStr = SerializationUtils.toJsonString((Object)allocResult);
                    this.getPageCache().put("responseInfo", responseInfoStr);
                    this.getPageCache().put("selectAllocIds", SerializationUtils.toJsonString((Object)ids));
                }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), "allocResult"));
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ex.getMessage());
            }
        }
    }

    private void doSearchImport(MfgFeeAllocImportParam importDto) {
        boolean isBasicNotAllConfirm;
        MfgFeeInnerCostcenterAllocService service = this.getService();
        long costAccountId = importDto.getCostaccount();
        boolean isAuxNotAllConfirm = service.isHasNotConfirmBill(importDto, "cad_auxprodalloc");
        if (isAuxNotAllConfirm) {
            SimpleMutexHelper.releaseXMutex((String)"coImport", (Object)(costAccountId + "coImport"));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff1a\u5bf9\u5e94\u7684\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355\u672a\u5168\u90e8\u786e\u8ba4\uff0c\u8bf7\u5904\u7406\u3002", (String)"MfgFeeAllocCostcenterListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        Boolean isMergeBill = SysParamHelper.isMergeBill((Long)importDto.getOrg(), (Long)importDto.getCostaccount(), (String)importDto.getAppnum());
        importDto.setMergeBill(isMergeBill.booleanValue());
        boolean billHasData = service.isBillHasData(importDto, "cad_mfgfeeallocco");
        if (billHasData && !"eca".equals(importDto.getAppnum()) && isMergeBill.booleanValue()) {
            if (service.isBillGenVounums(importDto, "cad_mfgfeeallocco")) {
                SimpleMutexHelper.releaseXMutex((String)"coImport", (Object)(costAccountId + "coImport"));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u914d\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u5bfc\u5165\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u518d\u64cd\u4f5c\u3002", (String)"MfgFeeAllocCostcenterListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            if (service.isBillHasData(importDto, "cad_mfgfeeallocco", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) {
                SimpleMutexHelper.releaseXMutex((String)"coImport", (Object)(costAccountId + "coImport"));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff1a\u5f53\u524d\u5206\u914d\u5355\u9700\u8981\u5168\u90e8\u53cd\u786e\u8ba4\uff0c\u624d\u80fd\u91cd\u65b0\u5bfc\u5165\u6570\u636e\uff1b\u8bf7\u5148\u8fdb\u884c\u53cd\u786e\u8ba4\u64cd\u4f5c\u3002", (String)"MfgFeeAllocCostcenterListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (isBasicNotAllConfirm = service.isHasNotConfirmBill(importDto, "cad_basicalloc")) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMBACK_DOIMPORT, (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u6709\u672a\u786e\u8ba4\u72b6\u6001\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5f15\u5165\u6570\u636e\uff1f", (String)"MfgFeeAllocCostcenterListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            this.getPageCache().put(KEY_IMPORT_JSON, SerializationUtils.toJsonString((Object)importDto));
            return;
        }
        if (billHasData) {
            service.deleteInnerCostcenterBills(importDto);
        }
        this.doImport(importDto);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (StringUtils.equals((CharSequence)CONFIRMBACK_DOIMPORT, (CharSequence)e.getCallBackId())) {
            if (e.getResult() == MessageBoxResult.Yes) {
                MfgFeeAllocImportParam importDto = (MfgFeeAllocImportParam)JSON.parseObject((String)this.getPageCache().get(KEY_IMPORT_JSON), MfgFeeAllocImportParam.class);
                MfgFeeInnerCostcenterAllocService service = this.getService();
                service.deleteInnerCostcenterBills(importDto);
                this.doImport(importDto);
            } else {
                Long costAccountId = Long.valueOf(this.getPageCache().get("costaccount"));
                SimpleMutexHelper.releaseXMutex((String)"coImport", (Object)(costAccountId + "coImport"));
            }
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.productGroupVisible(args);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        this.getView().hideLoading();
        switch (actionId = e.getActionId()) {
            case "allocResult": {
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                MfgAllocResult allocResult = (MfgAllocResult)SerializationUtils.fromJsonString((String)responseInfoStr, MfgAllocResult.class);
                if (!AllocResultEnum.Failure.getResult().equals(allocResult.getAllocStatus())) {
                    String selectAllocIdstr = this.getPageCache().get("selectAllocIds");
                    if (CadEmptyUtils.isEmpty((String)selectAllocIdstr)) {
                        return;
                    }
                    List selectAllocIds = (List)SerializationUtils.fromJsonString((String)selectAllocIdstr, List.class);
                    OperationServiceHelper.executeOperate((String)"op_confirm", (String)"cad_mfgfeeallocco", (Object[])selectAllocIds.toArray(), (OperateOption)OperateOption.create());
                    this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                }
                MfgFeeAllocCostcenterListPlugin.viewAllocResult(allocResult, this.getView());
                this.getView().invokeOperation(KEY_REFRESH);
                break;
            }
            case "importResult": {
                String importResponseInfoStr = this.getPageCache().get("importresponseInfo");
                if (CadEmptyUtils.isEmpty((String)importResponseInfoStr)) {
                    return;
                }
                ExecuteResult result = (ExecuteResult)SerializationUtils.fromJsonString((String)importResponseInfoStr, ExecuteResult.class);
                if (result.isSuccess()) {
                    String successTip = (String)result.getSuccessInfo().get("Success");
                    if (StringUtils.isEmpty((CharSequence)successTip)) {
                        if (result.getSuccessQty() > 0) {
                            String successMsg = ResManager.loadKDString((String)"\u6210\u529f\u751f\u6210%s\u5f20\u5355\u636e\u3002", (String)"MfgFeeAllocCostcenterListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                            this.getView().showSuccessNotification(String.format(successMsg, result.getSuccessQty()));
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"MfgFeeAllocCostcenterListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                        }
                    } else {
                        this.getView().showSuccessNotification(successTip);
                    }
                    this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                } else {
                    result.showNotificationSample(this.getView());
                }
                String importDtoStr = this.getPageCache().get("importDto");
                if (CadEmptyUtils.isEmpty((String)importDtoStr)) {
                    return;
                }
                MfgFeeAllocImportParam importDto = (MfgFeeAllocImportParam)SerializationUtils.fromJsonString((String)importDtoStr, MfgFeeAllocImportParam.class);
                List<Long> allocEntityBillIds = this.getCoEntityBillIds(importDto, ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue());
                if (!CadEmptyUtils.isEmpty(allocEntityBillIds)) {
                    OperationServiceHelper.executeOperate((String)"op_confirm", (String)"cad_mfgfeeallocco", (Object[])allocEntityBillIds.toArray(), (OperateOption)OperateOption.create());
                }
                this.getView().invokeOperation(KEY_REFRESH);
                break;
            }
        }
    }

    private void productGroupVisible(BeforeCreateListColumnsArgs args) {
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("sca".equals(appId)) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)args, (Set)Sets.newHashSet((Object[])new String[]{"productgroup.name"}));
        }
    }

    public List<Long> getCoEntityBillIds(MfgFeeAllocImportParam importDto, String allocStatus) {
        ArrayList<Long> ids = new ArrayList<Long>();
        QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
        filter.and("costaccount", "=", (Object)importDto.getCostaccount());
        filter.and("period", "=", (Object)importDto.getPeriod());
        filter.and("allocstatus", "=", (Object)allocStatus);
        if (importDto.isEnableFactory()) {
            filter.and("manuorg", "in", (Object)importDto.getManuorg());
        }
        filter.and("appnum", "=", (Object)importDto.getAppnum());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getCoEntityBillIds", (String)"cad_mfgfeeallocco", (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong(0));
            }
        }
        return ids;
    }

    private void doImport(MfgFeeAllocImportParam importDto) {
        if (importDto == null) {
            return;
        }
        MfgFeeInnerCostcenterAllocService service = this.getService();
        boolean isAutoAlloc = this.isDisableAutoAlloc();
        String progressId = UUID.randomUUID().toString();
        ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"MfgFeeAllocCostcenterListPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
            ExecuteResult result = new ExecuteResult();
            try {
                List<Long> unAllocEntityBillIds;
                result = service.feeAllocInnerCostcenterImport(importDto, progressId);
                if (isAutoAlloc && !CadEmptyUtils.isEmpty(unAllocEntityBillIds = this.getCoEntityBillIds(importDto, ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue()))) {
                    this.doAlloc(unAllocEntityBillIds, progressId);
                }
            }
            catch (Exception e) {
                ProgressHelper.showError((String)progressId, (String)e.getMessage());
            }
            String responseInfoStr = SerializationUtils.toJsonString((Object)result);
            String importDtoStr = SerializationUtils.toJsonString((Object)importDto);
            this.getPageCache().put("importresponseInfo", responseInfoStr);
            this.getPageCache().put("importDto", importDtoStr);
        }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), "importResult"));
    }

    public Boolean isDisableAutoAlloc() {
        QFilter filter = new QFilter("key", "=", (Object)"disableInnerAutoAlloc");
        DynamicObject param = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_bgparam", (String)"value", (QFilter[])new QFilter[]{filter});
        if (param == null) {
            return Boolean.TRUE;
        }
        return param.getBoolean("value");
    }

    private MfgFeeInnerCostcenterAllocService getService() {
        return new MfgFeeInnerCostcenterAllocService();
    }

    @Override
    protected List<ComboItem> getORGComboItemList() {
        return OrgHelper.getOrgComboItems((String)"cad_mfgfeeallocco", (String)"47150e89000000ac", (String)this.getView().getFormShowParameter().getAppId());
    }
}

