/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.feealloc;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.feealloc.MfgFeeNonProdAllocService;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.output.MfgAllocResult;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.feealloc.MfgAllocBaseListPlugin;

public class MfgNonProdAllocListPlugin
extends MfgAllocBaseListPlugin {
    private static final String CONFIRMBACK_DOIMPORT = "do_import";
    private static final String CONFIRMBACK_DOUNCONFIRM = "do_unconfirm";
    private static final String KEY_REFRESH = "refresh";
    private static final String KEY_IMPORT_JSON = "importdtos";

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("period desc,billno asc");
        if (AppIdHelper.isMacc((IFormView)this.getView())) {
            e.getQFilters().add(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "importcollc": {
                if (CadEmptyUtils.isEmpty((String)this.getPageCache().get("costaccount"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"MfgNonProdAllocListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Long costAccountId = Long.valueOf(this.getPageCache().get("costaccount"));
                String lockErrStr = SimpleMutexHelper.mfgCheckAndRequireXMutex((String)"nonImport", (Long)costAccountId);
                if (!StringUtils.isNotEmpty((CharSequence)lockErrStr)) break;
                this.getView().showErrorNotification(lockErrStr);
                args.setCancel(true);
                return;
            }
            case "op_unconfirm": {
                MfgFeeNonProdAllocService service = this.getService();
                MfgFeeAllocImportParam importDto = this.getPageImportDto();
                if (importDto == null) {
                    args.setCancel(true);
                    return;
                }
                if (service.isBillHasData(importDto, "cad_auxprodalloc", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53cd\u786e\u8ba4\u5931\u8d25\uff0c\u4e0b\u6e38\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355\u5df2\u7ecf\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", (String)"MfgNonProdAllocListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (service.isBillHasData(importDto, "cad_basicalloc", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53cd\u786e\u8ba4\u5931\u8d25\uff0c\u4e0b\u6e38\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u5df2\u7ecf\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", (String)"MfgNonProdAllocListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (service.isBillHasData(importDto, "cad_mfgfeeallocco", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53cd\u786e\u8ba4\u5931\u8d25\uff0c\u4e0b\u6e38\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5355\u5df2\u7ecf\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", (String)"MfgNonProdAllocListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (!service.isBillHasData(importDto, "cad_auxprodalloc") && !service.isBillHasData(importDto, "cad_basicalloc")) break;
                RefObject afterConfirm = new RefObject();
                if (operate.getOption().tryGetVariableValue(CONFIRMBACK_DOUNCONFIRM, afterConfirm)) break;
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMBACK_DOUNCONFIRM, (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u53cd\u786e\u8ba4\u4f1a\u5220\u9664\u4e0b\u6e38\u5206\u914d\u5355\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6267\u884c\u201c\u53cd\u786e\u8ba4\u201d\u64cd\u4f5c\u3002", (String)"MfgNonProdAllocListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
                break;
            }
            case "generatevoucher": {
                ListSelectedRowCollection selectedRows = args.getListSelectedData();
                Object[] pkValues = selectedRows.getPrimaryKeyValues();
                if (CadEmptyUtils.isEmpty((ListSelectedRowCollection)selectedRows)) break;
                QFilter idFilter = new QFilter("id", "in", (Object)pkValues);
                DynamicObjectCollection bills = QueryServiceHelper.query((String)"cad_nonprodalloc", (String)"id,costaccount,period", (QFilter[])idFilter.toArray());
                Set costAccountIds = bills.stream().map(e -> e.getLong("costaccount")).collect(Collectors.toSet());
                Map costAccountCurrentPeriodMap = PeriodHelper.getAccountCurrentPeriod(costAccountIds);
                boolean isCurrentPeriod = true;
                for (DynamicObject bill : bills) {
                    if (bill.getLong("period") == ((Long)costAccountCurrentPeriodMap.get(bill.getLong("costaccount"))).longValue()) continue;
                    isCurrentPeriod = false;
                    break;
                }
                if (isCurrentPeriod) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5931\u8d25\u3002\u5206\u914d\u5355\u7684\u6838\u7b97\u671f\u95f4\u975e\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u51ed\u8bc1\u3002", (String)"MfgNonProdAllocListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        switch (e.getOperateKey()) {
            case "importcollc": {
                MfgFeeAllocImportParam importDto = this.getPageImportDto();
                Long costAccountId = Long.valueOf(this.getPageCache().get("costaccount"));
                if (importDto != null) {
                    this.doSearchImport(importDto);
                    break;
                }
                SimpleMutexHelper.releaseXMutex((String)"nonImport", (Object)(costAccountId + "nonImport"));
                break;
            }
            case "op_confirm": {
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                break;
            }
            case "op_unconfirm": {
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                break;
            }
            case "allocation": {
                List<Long> ids;
                if (!e.getOperationResult().isSuccess() || (ids = this.getSelectIds()).size() <= 0) break;
                Long costAccountId = Long.valueOf(this.getPageCache().get("costaccount"));
                String lockErrStr = SimpleMutexHelper.mfgCheckAndRequireXMutex((String)"nonAlloc", (Long)costAccountId);
                if (StringUtils.isNotEmpty((CharSequence)lockErrStr)) {
                    this.getView().showErrorNotification(lockErrStr);
                    return;
                }
                this.doAlloc(ids);
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                break;
            }
            case "allocreport": {
                String org = this.getPageCache().get(this.ORG_FIELD);
                if (org == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MfgNonProdAllocListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                List list = (List)SerializationUtils.fromJsonString((String)org, List.class);
                String OrgId = (String)list.get(0);
                String accountId = this.getPageCache().get("costaccount");
                this.openAllocReportPage("1", OrgId, accountId);
            }
        }
    }

    private void doAlloc(List<Long> ids) {
        try {
            MfgFeeNonProdAllocService service = this.getService();
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d", (String)"MfgNonProdAllocListPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                MfgAllocResult allocResult = new MfgAllocResult();
                try {
                    allocResult = service.doAlloc(ids, this.getView().getFormShowParameter().getAppId(), progressId, false, Long.valueOf(0L));
                }
                catch (Exception e) {
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                String responseInfoStr = SerializationUtils.toJsonString((Object)allocResult);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), "allocResult"));
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private void doSearchImport(MfgFeeAllocImportParam importDto) {
        MfgFeeNonProdAllocService service = this.getService();
        long costAccountId = importDto.getCostaccount();
        if (service.isBillHasData(importDto, "cad_nonprodalloc")) {
            String releaseXMutexKey = costAccountId + "nonImport";
            if (service.isBillGenVounums(importDto, "cad_nonprodalloc")) {
                SimpleMutexHelper.releaseXMutex((String)"nonImport", (Object)releaseXMutexKey);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u914d\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u5bfc\u5165\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u518d\u64cd\u4f5c\u3002", (String)"MfgNonProdAllocListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            if (service.isBillGenVounums(importDto, "cad_auxprodalloc") || service.isBillGenVounums(importDto, "cad_basicalloc") || service.isBillGenVounums(importDto, "cad_mfgfeeallocco")) {
                SimpleMutexHelper.releaseXMutex((String)"nonImport", (Object)releaseXMutexKey);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u7684\u5206\u914d\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u5bfc\u5165\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u518d\u64cd\u4f5c\u3002", (String)"MfgNonProdAllocListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            if (service.isBillHasData(importDto, "cad_nonprodalloc", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) {
                SimpleMutexHelper.releaseXMutex((String)"nonImport", (Object)releaseXMutexKey);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff0c\u5f53\u524d\u5206\u914d\u5355\u9700\u8981\u5168\u90e8\u53cd\u786e\u8ba4\uff0c\u624d\u80fd\u91cd\u65b0\u5bfc\u5165\u6570\u636e\u3002", (String)"MfgNonProdAllocListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            service.deleteNonProdAndRelaBills(importDto, true);
        }
        this.doImport(importDto);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "allocResult": {
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                MfgAllocResult allocResult = (MfgAllocResult)SerializationUtils.fromJsonString((String)responseInfoStr, MfgAllocResult.class);
                MfgNonProdAllocListPlugin.viewAllocResult(allocResult, this.getView());
                this.getView().invokeOperation(KEY_REFRESH);
                break;
            }
            case "importResult": {
                String importResponseInfoStr = this.getPageCache().get("importresponseInfo");
                if (CadEmptyUtils.isEmpty((String)importResponseInfoStr)) {
                    return;
                }
                ExecuteResult result = (ExecuteResult)SerializationUtils.fromJsonString((String)importResponseInfoStr, ExecuteResult.class);
                if (result.isSuccess()) {
                    String successTip = (String)result.getSuccessInfo().get("Success");
                    if (StringUtils.isEmpty((CharSequence)successTip)) {
                        if (result.getSuccessQty() > 0) {
                            String successMsg = ResManager.loadKDString((String)"\u6210\u529f\u751f\u6210%s\u5f20\u5355\u636e\uff0c\u4e0b\u6e38\u5206\u914d\u5355\u9700\u8981\u91cd\u65b0\u5f15\u5165\u3002", (String)"MfgNonProdAllocListPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                            this.getView().showSuccessNotification(String.format(successMsg, result.getSuccessQty()));
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"MfgNonProdAllocListPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                        }
                    } else {
                        this.getView().showSuccessNotification(successTip);
                    }
                    this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                    break;
                }
                result.showNotificationSample(this.getView());
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes) {
            if (StringUtils.equals((CharSequence)CONFIRMBACK_DOIMPORT, (CharSequence)e.getCallBackId())) {
                MfgFeeAllocImportParam importDto = (MfgFeeAllocImportParam)JSON.parseObject((String)this.getPageCache().get(KEY_IMPORT_JSON), MfgFeeAllocImportParam.class);
                MfgFeeNonProdAllocService service = this.getService();
                service.deleteNonProdAndRelaBills(importDto, true);
                this.doImport(importDto);
            } else if (StringUtils.equals((CharSequence)CONFIRMBACK_DOUNCONFIRM, (CharSequence)e.getCallBackId())) {
                OperateOption operationOption = OperateOption.create();
                operationOption.setVariableValue(CONFIRMBACK_DOUNCONFIRM, "true");
                this.getView().invokeOperation("op_unconfirm", operationOption);
            }
        }
    }

    private void doImport(MfgFeeAllocImportParam importDto) {
        if (importDto == null) {
            return;
        }
        String progressId = UUID.randomUUID().toString();
        MfgFeeNonProdAllocService service = this.getService();
        ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"MfgNonProdAllocListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
            ExecuteResult result = new ExecuteResult();
            try {
                result = service.feeAllocNonProdImport(importDto, progressId);
            }
            catch (Exception e) {
                ProgressHelper.showError((String)progressId, (String)e.getMessage());
            }
            String responseInfoStr = SerializationUtils.toJsonString((Object)result);
            this.getPageCache().put("importresponseInfo", responseInfoStr);
        }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), "importResult"));
    }

    private MfgFeeNonProdAllocService getService() {
        return new MfgFeeNonProdAllocService();
    }

    @Override
    protected List<ComboItem> getORGComboItemList() {
        return OrgHelper.getOrgComboItems((String)"cad_nonprodalloc", (String)"47150e89000000ac", (String)this.getView().getFormShowParameter().getAppId());
    }
}

