/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.feealloc;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MfgfeeBillEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private Log logger = LogFactory.getLog(MfgfeeBillEditPlugin.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initFilter();
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    private void initFilter() {
        BasedataEdit costObjectInput;
        BasedataEdit costCenterInput = (BasedataEdit)this.getControl("costcenter");
        costCenterInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            List<QFilter> qFilters = this.getInputQFilters(evt);
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            Long orgId = org.getLong("id");
            if (OrgHelper.isOrgEnableMultiFactory((Long)orgId)) {
                Long manuorg = this.getModel().getDataEntity().getLong("manuorg.id");
                if (CadEmptyUtils.isEmpty((Long)manuorg)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MfgfeeBillEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                ArrayList<Long> manuOrgs = new ArrayList<Long>();
                manuOrgs.add(manuorg);
                Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)orgId, manuOrgs, (String)this.getView().getFormShowParameter().getAppId());
                if (centerIds.isEmpty()) {
                    qFilters.add(new QFilter("id", "=", (Object)-1));
                } else {
                    qFilters.add(new QFilter("id", "in", (Object)centerIds));
                }
            } else {
                QFilter orgQf = new QFilter("accountorg", "=", (Object)org.getLong("id"));
                qFilters.add(orgQf);
            }
            qFilters.add(this.getAllocMoldQF());
        });
        BasedataEdit costaccountInput = (BasedataEdit)this.getControl("costaccount");
        costaccountInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            List<QFilter> qFilters = this.getInputQFilters(evt);
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledCostAccountIdsFilter((Long)org.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
            qFilters.add(enabledCostAccountIdsFilter);
        });
        BasedataEdit expenseItem = (BasedataEdit)this.getControl("expenseitem");
        expenseItem.addBeforeF7SelectListener(evt -> {
            List<QFilter> qFilters = this.getInputQFilters(evt);
            qFilters.add(new QFilter("isleaf", "=", (Object)true));
        });
        BasedataEdit productGroupInput = (BasedataEdit)this.getControl("productgroup");
        if (productGroupInput != null) {
            productGroupInput.addBeforeF7SelectListener(evt -> {
                DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
                List<QFilter> qFilters = this.getInputQFilters(evt);
                if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                    qFilters.add(new QFilter("id", "=", (Object)-1L));
                } else {
                    qFilters.add(new QFilter("org", "=", org.get("id")));
                    qFilters.add(new QFilter("grouptype", "=", (Object)"3"));
                }
            });
        }
        if ((costObjectInput = (BasedataEdit)this.getControl("costobject")) != null) {
            costObjectInput.addBeforeF7SelectListener(evt -> {
                String appNum;
                List<QFilter> qFilters = this.getInputQFilters(evt);
                DynamicObject dataEntity = this.getModel().getDataEntity();
                DynamicObject manuorg = dataEntity.getDynamicObject("manuorg");
                boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)this.getModel().getDataEntity().getLong("costaccount.id"));
                if (enableMulFactory && CadEmptyUtils.isEmpty((DynamicObject)manuorg)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MfgfeeBillEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                DynamicObject costCenter = dataEntity.getDynamicObject("costcenter");
                if (CadEmptyUtils.isEmpty((DynamicObject)costCenter)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u4e2d\u5fc3\u3002", (String)"MfgfeeBillEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                qFilters.add(new QFilter("costcenter", "=", costCenter.get("id")));
                DynamicObject productGroup = dataEntity.getDynamicObject("productgroup");
                if (productGroup != null) {
                    DynamicObjectCollection productGroupRes = QueryServiceHelper.query((String)"cad_productintogroup", (String)"entryentity.material AS material", (QFilter[])new QFilter[]{new QFilter("id", "=", productGroup.getPkValue())});
                    List fieldList = DynamicObjectHelper.getFieldList((DynamicObjectCollection)productGroupRes, (String)"material");
                    if (CadEmptyUtils.isEmpty((List)fieldList)) {
                        return;
                    }
                    qFilters.add(new QFilter("material", "in", (Object)fieldList));
                }
                if ("aca".equals(appNum = this.getView().getFormShowParameter().getAppId())) {
                    qFilters.add(new QFilter("producttype", "=", (Object)"C"));
                }
            });
        }
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
        manuOrg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            Long org = this.getModel().getDataEntity().getLong("org.id");
            if (CadEmptyUtils.isEmpty((Long)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgfeeBillEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            filters.add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
        });
        BasedataEdit planScheme = (BasedataEdit)this.getControl("planscheme");
        planScheme.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            Long costaccount = this.getModel().getDataEntity().getLong("costaccount.id");
            qList.add(new QFilter("costaccount", "=", (Object)costaccount));
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private boolean isEca() {
        String appNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
        return "eca".equals(appNum);
    }

    private List<QFilter> getInputQFilters(BeforeF7SelectEvent evt) {
        ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        return filterParameter.getQFilters();
    }

    public void afterBindData(EventObject e) {
        this.setMustInputCostCenter();
        this.initEcaApp();
        Long id = (Long)this.getModel().getValue("id");
        this.setManuOrg();
        this.logger.info("MfgfeeBillEditPlugin afterBindData id=>{}", (Object)id);
        boolean flag = false;
        if (id != null && id != 0L) {
            QFilter filter = new QFilter("id", "=", (Object)id);
            flag = QueryServiceHelper.exists((String)"cad_mfgfeebill", (QFilter[])filter.toArray());
        }
        this.getView().setVisible(Boolean.valueOf(!AppIdHelper.isSCA((IFormView)this.getView())), new String[]{"projectnumber", "tracknumber", "lot"});
        if (id != null && id != 0L && flag) {
            this.setBillEnable();
        } else {
            if (!"copy".equals(this.getView().getFormShowParameter().getCustomParam("operate"))) {
                this.initByListData();
            } else {
                long costAccount = this.getModel().getDataEntity().getLong("costaccount.id");
                if (!CadEmptyUtils.isEmpty((Long)costAccount)) {
                    this.getModel().setValue("bookdate", (Object)PeriodHelper.getCurrentPeriodenddate((Long)costAccount));
                }
                this.setPeriod();
            }
            this.getModel().setValue("sourcetype", (Object)"NEW");
            this.getModel().setDataChanged(false);
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"costaccount"});
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"billno"});
        }
        this.setOutSourceType();
        this.setCostObjectIsShow();
    }

    private void initEcaApp() {
        Boolean isEca = this.isEca();
        ComboEdit allocMoldCom = (ComboEdit)this.getControl("allocmold");
        HashMap<String, LocaleString> allocMoldMap = new HashMap<String, LocaleString>(4);
        allocMoldMap.put("A", new LocaleString(ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d", (String)"MfgfeeBillEditPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        allocMoldMap.put("B", new LocaleString(ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d", (String)"MfgfeeBillEditPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        allocMoldMap.put("C", new LocaleString(ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d", (String)"MfgfeeBillEditPlugin_17", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(allocMoldMap.size());
        for (Map.Entry entry : allocMoldMap.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue((String)entry.getKey());
            item.setCaption((LocaleString)entry.getValue());
            if ("B".equals(entry.getKey())) {
                item.setItemVisible(isEca == false);
            }
            comboItems.add(item);
        }
        if (isEca.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"productgroup"});
        }
        allocMoldCom.setComboItems(comboItems);
    }

    private void setOutSourceType() {
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("sca".equals(appId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"outsourcetype"});
        } else {
            if ("C".equals(this.getModel().getDataEntity().getString("allocmold"))) {
                long costObject = this.getModel().getDataEntity().getLong("costobject.id");
                QFilter filter = new QFilter("id", "=", (Object)costObject);
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_costobject", (String)"isoutsource", (QFilter[])filter.toArray());
                if (dynamicObject != null && dynamicObject.getBoolean("isoutsource")) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"outsourcetype"});
                    if (CadEmptyUtils.isEmpty((Long)costObject)) {
                        this.getView().setEnable(Boolean.valueOf(false), new String[]{"outsourcetype"});
                        this.getModel().setValue("outsourcetype", (Object)" ");
                    } else {
                        String srcSys = this.getModel().getDataEntity().getString("srcbillnum");
                        if (StringUtils.isNotBlank((CharSequence)srcSys)) {
                            this.getView().setEnable(Boolean.valueOf(false), new String[]{"outsourcetype"});
                        } else {
                            this.getView().setEnable(Boolean.valueOf(true), new String[]{"outsourcetype"});
                        }
                        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
                            this.getModel().setValue("outsourcetype", (Object)"A");
                        }
                        this.setOutSourceItem();
                    }
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"outsourcetype"});
                    this.getModel().setValue("outsourcetype", (Object)" ");
                }
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"outsourcetype"});
                this.getModel().setValue("outsourcetype", (Object)" ");
            }
            this.getModel().setDataChanged(false);
        }
    }

    private void setOutSourceItem() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ComboItem itemA = new ComboItem();
        itemA.setCaption(new LocaleString(ResManager.loadKDString((String)"\u59d4\u5916\u52a0\u5de5\u8d39", (String)"MfgfeeBillEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        itemA.setValue("A");
        items.add(itemA);
        ComboItem itemB = new ComboItem();
        itemB.setCaption(new LocaleString(ResManager.loadKDString((String)"\u59d4\u5916\u8d39\u7528", (String)"MfgfeeBillEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        itemB.setValue("B");
        items.add(itemB);
        ComboEdit amountEditor = (ComboEdit)this.getView().getControl("outsourcetype");
        amountEditor.setComboItems(items);
    }

    private void setBillEnable() {
        Object operate = this.getView().getFormShowParameter().getCustomParam("operate");
        if (StringUtils.isNotBlank((Object)operate) && (StringUtils.equals((CharSequence)"new", (CharSequence)operate.toString()) || StringUtils.equals((CharSequence)"copy", (CharSequence)operate.toString()))) {
            this.setEnable(true);
            return;
        }
        String srcSys = this.getModel().getDataEntity().getString("srcbillnum");
        if (StringUtils.isNotBlank((CharSequence)srcSys)) {
            this.setEnable(false);
        } else {
            QFilter filter = new QFilter("srcbillentry.srcbill", "=", (Object)this.getModel().getDataEntity().getLong("id"));
            filter.and("srcbillentry.type", "=", (Object)"A");
            boolean nonExists = QueryServiceHelper.exists((String)"cad_nonprodalloc", (QFilter[])filter.toArray());
            boolean auxExists = QueryServiceHelper.exists((String)"cad_auxprodalloc", (QFilter[])filter.toArray());
            boolean basicExists = QueryServiceHelper.exists((String)"cad_basicalloc", (QFilter[])filter.toArray());
            QFilter centerFilter = new QFilter("srcexpentry.expbillid", "=", (Object)this.getModel().getDataEntity().getLong("id"));
            centerFilter.and("srcexpentry.srctype", "=", (Object)"A");
            boolean cooExists = QueryServiceHelper.exists((String)"cad_mfgfeeallocco", (QFilter[])centerFilter.toArray());
            boolean flag = true;
            if (nonExists || auxExists || basicExists || cooExists) {
                flag = false;
            }
            this.setEnable(flag);
        }
    }

    private void setEnable(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"costaccount"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"manuorg"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"period"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"allocmold"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"costcenter"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"costcentertype"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"expenseitem"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"totalamount"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"currency"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"costobject"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"bookdate"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"outsourcetype"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"productgroup"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"projectnumber", "tracknumber", "lot"});
        long costObjectId = this.getModel().getDataEntity().getLong("costobject.id");
        if (CadEmptyUtils.isEmpty((Long)costObjectId)) {
            this.getView().setVisible(Boolean.valueOf(flag), new String[]{"costobject"});
            this.getView().setVisible(Boolean.valueOf(flag), new String[]{"costobjectname"});
        }
    }

    private void initByListData() {
        String costCenterId;
        IDataModel model = this.getModel();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String orgId = (String)fsp.getCustomParam("accountorgId");
        if (!CadEmptyUtils.isEmpty((String)orgId)) {
            model.setValue("org", (Object)orgId);
        }
        if (!CadEmptyUtils.isEmpty((String)(costCenterId = (String)fsp.getCustomParam("costCenterId")))) {
            model.setValue("costcenter", (Object)costCenterId);
            this.initAllocMold(costCenterId);
        }
        String costAccountId = (String)fsp.getCustomParam("costaccountId");
        this.logger.info("initByListData costAccountId ==>{}", (Object)costAccountId);
        if (!CadEmptyUtils.isEmpty((String)costAccountId)) {
            model.setValue("costaccount", (Object)costAccountId);
            model.setValue("bookdate", (Object)PeriodHelper.getCurrentPeriodenddate((Long)Long.parseLong(costAccountId)));
        }
        model.setValue("appnum", (Object)this.getView().getFormShowParameter().getAppId());
        boolean enableMulFactory = CadEmptyUtils.isEmpty((String)costAccountId) ? false : CostAccountHelper.isEnableMulFactory((Long)Long.valueOf(costAccountId));
        String manuOrg = (String)fsp.getCustomParam("manuorg");
        if (!CadEmptyUtils.isEmpty((String)manuOrg) && enableMulFactory) {
            model.setValue("manuorg", (Object)manuOrg);
        } else {
            model.setValue("manuorg", null);
            this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
        }
    }

    private void initAllocMold(String costCenterId) {
        DynamicObject costCenter = this.getModel().getDataEntity().getDynamicObject("costcenter");
        if (CadEmptyUtils.isEmpty((String)costCenterId)) {
            return;
        }
        String orgduty = costCenter.getString("orgduty.number");
        String allocMold = "";
        allocMold = "4".equals(orgduty) ? "C" : ("5".equals(orgduty) ? "B" : "A");
        this.getModel().setValue("allocmold", (Object)allocMold);
        this.getModel().setValue("costcenter", (Object)costCenterId);
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        super.propertyChanged(e);
        switch (proName = e.getProperty().getName()) {
            case "org": {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                DynamicObject org = dataEntity.getDynamicObject("org");
                if (org != null) {
                    this.setCostAccount(org.getLong("id"));
                }
                this.setPeriod();
                break;
            }
            case "costaccount": {
                this.setCurrency();
                this.setPeriod();
                this.setManuOrg();
                break;
            }
            case "allocmold": {
                this.getModel().setValue("costcenter", null);
                this.setMustInputCostCenter();
                this.cleanInputByAllocMold();
                this.setCostObjectIsShow();
                this.setProductGroupEnable();
                this.setAllocDimEnable();
                break;
            }
            case "costcenter": {
                this.setCostObjectValueIsNull();
                break;
            }
            case "manuorg": {
                this.setCostObjAndCosCenterIsNull();
                break;
            }
            case "costobject": {
                this.setOutSourceType();
                break;
            }
            case "bookdate": {
                Object bookDateObj = this.getModel().getValue("bookdate");
                if (bookDateObj == null) break;
                Date bookDate = (Date)bookDateObj;
                DynamicObject period = (DynamicObject)this.getModel().getValue("period");
                Date beginDate = period.getDate("begindate");
                Date endDate = period.getDate("enddate");
                if (!bookDate.before(beginDate) && !bookDate.after(endDate)) break;
                this.getModel().setValue("bookdate", null);
                this.getModel().setDataChanged(false);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u8303\u56f4\u9700\u5728\u5f53\u524d\u671f\u95f4\u4e4b\u5185\u3002", (String)"MfgfeeBillEditPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setProductGroupEnable() {
        String allocMold = this.getModel().getDataEntity().getString("allocmold");
        if ("C".equals(allocMold)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"productgroup"});
        } else {
            this.getModel().setValue("productgroup", null);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"productgroup"});
        }
    }

    private void setAllocDimEnable() {
        String allocMold = this.getModel().getDataEntity().getString("allocmold");
        this.getView().setEnable(Boolean.valueOf(!"B".equals(allocMold)), new String[]{"projectnumber", "tracknumber", "lot"});
    }

    private void setCostObjAndCosCenterIsNull() {
        this.getModel().setValue("costcenter", null);
        this.getModel().setValue("costobject", null);
    }

    public void setCostObjectValueIsNull() {
        this.getModel().setValue("costobject", null);
    }

    public void setManuOrg() {
        long costId = this.getModel().getDataEntity().getLong("costaccount.id");
        boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)costId);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("manuorg");
        basedataEdit.setMustInput(enableMulFactory);
        this.getView().setEnable(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
        this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
    }

    private void setCostObjectIsShow() {
        String allocMold = this.getModel().getDataEntity().getString("allocmold");
        if (StringUtils.isEmpty((CharSequence)allocMold)) {
            return;
        }
        switch (allocMold) {
            case "A": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"costobject"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"costobjectname"});
                break;
            }
            case "B": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"costobject"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"costobjectname"});
                break;
            }
            case "C": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"costobject"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"costobjectname"});
            }
        }
    }

    private void setPeriod() {
        Long costaccountId;
        QFilter costaccountQF;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (org == null || costaccount == null) {
            return;
        }
        Long orgId = org.getLong("id");
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        DynamicObjectCollection res = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{orgQF, costaccountQF = new QFilter("entry.costaccount", "=", (Object)(costaccountId = Long.valueOf(costaccount.getLong("id"))))});
        if (res != null && res.size() > 0) {
            Long currentPeriod = ((DynamicObject)res.get(0)).getLong("currentperiod");
            this.getModel().setValue("period", (Object)currentPeriod);
        }
    }

    private void setCostAccount(long orgId) {
        DynamicObjectCollection costaccounts = this.getCostaccount(orgId);
        if (costaccounts == null || costaccounts.size() == 0 || costaccounts.size() > 1) {
            return;
        }
        DynamicObject costaccount = (DynamicObject)costaccounts.get(0);
        this.getModel().setValue("costaccount", (Object)costaccount.getLong("id"));
    }

    private DynamicObjectCollection getCostaccount(Long orgId) {
        QFilter accountOrgQF = new QFilter("calorg", "=", (Object)orgId);
        QFilter enableStdtQF = new QFilter("enablestandardcost", "=", (Object)Boolean.TRUE);
        String orderby = "enablestandardcost DESC, number ASC";
        return QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id, name", (QFilter[])new QFilter[]{accountOrgQF, enableStdtQF}, (String)orderby);
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency AS currency", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccount.get("id"))});
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        switch (operateKey) {
            case "searchup": {
                this.searchUpOriginalBill();
                break;
            }
            case "new": {
                fsp.setCustomParam("operate", (Object)"new");
                this.setBillEnable();
                break;
            }
            case "copy": {
                fsp.setCustomParam("operate", (Object)"copy");
                this.setBillEnable();
                break;
            }
            case "save": {
                long manuorgId;
                if (CostAccountHelper.isEnableMulFactory((Long)this.getModel().getDataEntity().getLong("costaccount.id")) && (StringUtils.isBlank((Object)(manuorgId = this.getModel().getDataEntity().getLong("manuorg.id"))) || manuorgId == 0L)) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u591a\u5de5\u5382\u5df2\u542f\u7528\uff0c\u8bf7\u5f55\u5165\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MfgfeeBillEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                }
                this.checkOutSourceValue(e);
                this.checkBookDate(e);
            }
        }
    }

    private void checkBookDate(BeforeDoOperationEventArgs e) {
        long costAccount = this.getModel().getDataEntity().getLong("costaccount.id");
        if (!CadEmptyUtils.isEmpty((Long)costAccount)) {
            String bookDataString;
            SimpleDateFormat sdf;
            String currentDataString;
            Date periodEndDate = PeriodHelper.getCurrentPeriodenddate((Long)costAccount);
            Date bookDate = this.getModel().getDataEntity().getDate("bookdate");
            if (periodEndDate != null && bookDate != null && !(currentDataString = (sdf = new SimpleDateFormat("yyyy-MM")).format(periodEndDate)).equals(bookDataString = sdf.format(bookDate))) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u8303\u56f4\u9700\u5728\u5f53\u524d\u671f\u95f4\u4e4b\u5185\u3002", (String)"MfgfeeBillEditPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkOutSourceValue(BeforeDoOperationEventArgs e) {
        String outSourceType;
        QFilter filter;
        DynamicObject dynamicObject;
        long costObject;
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("aca".equals(appId) && !CadEmptyUtils.isEmpty((Long)(costObject = this.getModel().getDataEntity().getLong("costobject.id"))) && (dynamicObject = QueryServiceHelper.queryOne((String)"cad_costobject", (String)"isoutsource", (QFilter[])(filter = new QFilter("id", "=", (Object)costObject)).toArray())) != null && dynamicObject.getBoolean("isoutsource") && CadEmptyUtils.isEmpty((String)(outSourceType = this.getModel().getDataEntity().getString("outsourcetype")))) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u59d4\u5916\u6210\u672c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MfgfeeBillEditPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }

    private void searchUpOriginalBill() {
        String[] pkidArr;
        String srcBill = this.getModel().getDataEntity().getString("srcbillid");
        if (CadEmptyUtils.isEmpty((String)srcBill)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5236\u9020\u8d39\u7528\u5f52\u96c6\u6ca1\u6709\u6765\u6e90\u5355\u636e\u3002", (String)"MfgfeeBillEditPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)this.getModel().getDataEntity().getLong("id"));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_mfgfeebill", (String)"srcbilltype,srcbillid", (QFilter[])new QFilter[]{idFilter});
        HashSet<String> voucherIds = new HashSet<String>();
        HashSet<String> apFiIds = new HashSet<String>();
        HashSet<String> apBusIds = new HashSet<String>();
        HashMap<String, Set> billTypeIdsMap = new HashMap<String, Set>(16);
        for (Object dynamicObject : dynamicObjects) {
            String billId = dynamicObject.getString("srcbillid");
            String billType = dynamicObject.getString("srcbilltype");
            if (billId == null || "".equals(billId)) continue;
            if (billType == null || "".equals(billType) || billType.equals("VOUCHER")) {
                voucherIds.add(billId);
                continue;
            }
            if (billType.equals("AP_FI")) {
                apFiIds.add(billId);
                continue;
            }
            if (billType.equals("AP_BUS")) {
                apBusIds.add(billId);
                continue;
            }
            billTypeIdsMap.computeIfAbsent(billType, s -> new HashSet(16)).add(billId);
        }
        if (voucherIds.isEmpty() && apFiIds.isEmpty() && apBusIds.isEmpty() && CadEmptyUtils.isEmpty(billTypeIdsMap)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u8bb0\u5f55\u6ca1\u6709\u6765\u6e90\u5355\u636e\u53f7\u3002", (String)"MfgfeeBillEditPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!voucherIds.isEmpty()) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("gl_voucher");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            for (String srcBillId : voucherIds) {
                for (String pkid : pkidArr = srcBillId.split("@")) {
                    showParameter.addLinkQueryPkId((Object)Long.parseLong(pkid));
                }
            }
            showParameter.getCustomParams().put("org", "");
            showParameter.getCustomParams().put("booktype", "");
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if (!apFiIds.isEmpty()) {
            ListShowParameter apFiShowParameter = new ListShowParameter();
            apFiShowParameter.setBillFormId("ap_finapbill");
            apFiShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            apFiShowParameter.setShowFilter(false);
            apFiShowParameter.setShowQuickFilter(false);
            for (String srcBillId : apFiIds) {
                for (String pkid : pkidArr = srcBillId.split("@")) {
                    apFiShowParameter.addLinkQueryPkId((Object)Long.parseLong(pkid));
                }
            }
            this.getView().showForm((FormShowParameter)apFiShowParameter);
        }
        if (!apBusIds.isEmpty()) {
            ListShowParameter apBusShowParameter = new ListShowParameter();
            apBusShowParameter.setBillFormId("ap_busbill");
            apBusShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            apBusShowParameter.setShowFilter(false);
            apBusShowParameter.setShowQuickFilter(false);
            for (String srcBillId : apBusIds) {
                for (String pkid : pkidArr = srcBillId.split("@")) {
                    apBusShowParameter.addLinkQueryPkId((Object)Long.parseLong(pkid));
                }
            }
            this.getView().showForm((FormShowParameter)apBusShowParameter);
        }
        if (!CadEmptyUtils.isEmpty(billTypeIdsMap)) {
            for (Map.Entry billTypeEntry : billTypeIdsMap.entrySet()) {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId((String)billTypeEntry.getKey());
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setShowFilter(false);
                showParameter.setShowQuickFilter(false);
                for (String srcBillId : (Set)billTypeEntry.getValue()) {
                    String[] pkIdArr;
                    for (String pkId : pkIdArr = srcBillId.split("@")) {
                        showParameter.addLinkQueryPkId((Object)Long.parseLong(pkId));
                    }
                }
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "delete": {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                this.unaudit();
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("afterconfirm", "true");
            }
        }
    }

    private void unaudit() {
        Long billId = (Long)this.getModel().getValue("id");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"sca_mfgfeebill", (Object[])new Object[]{billId}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getModel().setValue("billstatus", (Object)"A");
            this.getView().updateView();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f\u3002", (String)"MfgfeeBillEditPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    private QFilter getAllocMoldQF() {
        String allocMold = this.getModel().getDataEntity().getString("allocmold");
        if (StringUtils.isEmpty((CharSequence)allocMold)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u914d\u7c7b\u578b\u3002", (String)"MfgfeeBillEditPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return new QFilter("orgduty.number", "=", (Object)"-1");
        }
        switch (allocMold) {
            case "A": {
                return new QFilter("orgduty.number", "not in", (Object)new String[]{"4", "5"});
            }
            case "B": {
                return new QFilter("orgduty.number", "=", (Object)"5");
            }
            case "C": {
                return new QFilter("orgduty.number", "=", (Object)"4");
            }
        }
        return new QFilter("orgduty.number", "=", (Object)"-1");
    }

    private void setMustInputCostCenter() {
        String allocMold = this.getModel().getDataEntity().getString("allocmold");
        if (StringUtils.isEmpty((CharSequence)allocMold)) {
            return;
        }
        BasedataEdit costCenterBD = (BasedataEdit)this.getControl("costcenter");
        switch (allocMold) {
            case "A": {
                costCenterBD.setMustInput(false);
                break;
            }
            case "B": 
            case "C": {
                costCenterBD.setMustInput(true);
            }
        }
    }

    private void cleanInputByAllocMold() {
        String allocMold = (String)this.getModel().getValue("allocmold");
        if (!"C".equals(allocMold)) {
            this.getModel().setValue("productgroup", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        sourceData.put("sourcetype", "IMP");
        sourceData.put("appnum", AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }

    public void beforeBindData(EventObject e) {
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("sca".equals(appId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"productgroup"});
        }
    }
}

