/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.feealloc;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.dto.MfgFeeImportReport;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ClickEventHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MfgfeeBillImportHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import kd.macc.cad.formplugin.base.BaseListPlugin;
import org.apache.commons.lang.StringUtils;

public class MfgfeeBillListPlugin
extends BaseListPlugin {
    private Log logger = LogFactory.getLog(MfgfeeBillListPlugin.class);
    private FilterContainerInitArgs filterContainerInitArgs = null;
    private static final String closeBack_importResult = "importResult";
    private static final String KEY_REFRESH = "refresh";
    private static final String KEY_DELETE = "delete";
    private volatile boolean orgClick = false;

    @Override
    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initClickEvent(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        List acctOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
        String orgId = "0";
        if (!acctOrgs.isEmpty()) {
            orgId = this.getDefOrg(acctOrgs);
            this.moveTop(acctOrgs, orgId);
        }
        List<ComboItem> costAccountItems = null;
        List costCenterItems = null;
        List manuorgItems = null;
        if (!CadEmptyUtils.isEmpty((String)orgId)) {
            costAccountItems = this.getCostAccountComboItemListBy(Collections.singletonList(orgId));
            costCenterItems = OrgHelper.getCostCenterByAccoutOrg((String)orgId);
            manuorgItems = ImportServiceHelper.getPermProOrgsByAccOrg((Long)Long.parseLong(orgId), (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
        }
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List listcomitem = commonFilterColumn.getComboItems();
            switch (fieldName) {
                case "org.id": {
                    listcomitem.clear();
                    if (CadEmptyUtils.isEmpty((List)acctOrgs)) break;
                    commonFilterColumn.setComboItems(acctOrgs);
                    commonFilterColumn.setDefaultValue(orgId);
                    this.getPageCache().put("org", orgId);
                    break;
                }
                case "costaccount.name": {
                    listcomitem.clear();
                    if (costAccountItems != null && !costAccountItems.isEmpty()) {
                        commonFilterColumn.setComboItems(costAccountItems);
                        String defVal = this.getCustomParam("costaccount");
                        if (CadEmptyUtils.isEmpty((String)defVal)) {
                            defVal = costAccountItems.get(0).getValue();
                        }
                        commonFilterColumn.setDefaultValue(defVal);
                        this.getPageCache().put("costaccountId", defVal);
                        break;
                    }
                    this.getPageCache().put("costaccountId", "");
                    break;
                }
                case "costcenter.name": {
                    listcomitem.clear();
                    this.setCostCenter(orgId, commonFilterColumn, costCenterItems);
                    break;
                }
                case "manuorg.name": {
                    listcomitem.clear();
                    if (CollectionUtils.isEmpty((Collection)manuorgItems)) break;
                    commonFilterColumn.setComboItems(manuorgItems);
                    break;
                }
                case "period.name": {
                    long costAccountId;
                    List<ComboItem> comboItems;
                    String costaccountId = this.getPageCache().get("costaccountId");
                    listcomitem.clear();
                    if (!kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)costaccountId) || CollectionUtils.isEmpty(comboItems = this.getPeriodComboItemsByLast(costAccountId = Long.parseLong(costaccountId)))) break;
                    commonFilterColumn.setComboItems(comboItems);
                    commonFilterColumn.setDefaultValue(comboItems.get(0).getValue());
                }
            }
        }
        this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString(new ArrayList()));
    }

    private void setCostCenter(String orgId, CommonFilterColumn commonFilterColumn, List<ComboItem> costCenterItems) {
        String manuorgIds = this.getPageCache().get("mutimanuorg");
        if (OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(orgId))) {
            List comboItems;
            String appId = this.getView().getFormShowParameter().getAppId();
            if (!CadEmptyUtils.isEmpty((String)manuorgIds)) {
                List list = (List)SerializationUtils.fromJsonString((String)manuorgIds, List.class);
                ArrayList<Long> manuList = new ArrayList<Long>(list.size());
                for (String manuOrgId : list) {
                    manuList.add(Long.parseLong(manuOrgId));
                }
                comboItems = OrgHelper.getCentersByManuOrgIds((Long)Long.parseLong(orgId), manuList, (String)appId);
            } else {
                List manuList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.parseLong(orgId), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                comboItems = OrgHelper.getCentersByManuOrgIds((Long)Long.parseLong(orgId), (List)manuList, (String)appId);
            }
            if (!CadEmptyUtils.isEmpty((List)comboItems)) {
                commonFilterColumn.setComboItems(comboItems);
            }
        } else if (!CadEmptyUtils.isEmpty(costCenterItems)) {
            commonFilterColumn.setComboItems(costCenterItems);
        }
    }

    private void initClickEvent(FilterContainerInitArgs args) {
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Iterator var3 = filterColumns.iterator();
        String org = this.getPageCache().get("accountorgId");
        while (var3.hasNext()) {
            FilterColumn filterColumn = (FilterColumn)var3.next();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List selectValue = (List)ClickEventHelper.getSelectValue(commonFilterColumn.getClass(), (Object)commonFilterColumn);
            boolean selNotNull = selectValue != null && selectValue.size() > 0;
            String defaultValue = "";
            if (selNotNull) {
                defaultValue = selectValue.get(0);
            }
            if (!fieldName.startsWith("org.") || org == null || "".equals(org)) continue;
            if (!defaultValue.equals(org)) {
                this.orgClick = true;
                continue;
            }
            this.orgClick = false;
        }
    }

    private void costAccountChangeInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List comboItems;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            List listcomitem = commonFilterColumn.getComboItems();
            String fieldName = commonFilterColumn.getFieldName();
            String costaccountId = this.getPageCache().get("costaccountId");
            if (fieldName.contains("period.")) {
                long costAccountId;
                listcomitem.clear();
                if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)costaccountId) && !CollectionUtils.isEmpty(comboItems = this.getPeriodComboItemsByLast(costAccountId = Long.parseLong(costaccountId)))) {
                    commonFilterColumn.setComboItems(comboItems);
                    commonFilterColumn.setDefaultValue(comboItems.get(0).getValue());
                }
            }
            if (!fieldName.contains("manuorg.")) continue;
            boolean enableMulFactory = false;
            if (costaccountId != null && !"".equals(costaccountId)) {
                enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)Long.valueOf(costaccountId));
            }
            listcomitem.clear();
            if (!enableMulFactory) continue;
            String orgId = this.getPageCache().get("accountorgId");
            comboItems = ImportServiceHelper.getPermProOrgsByAccOrg((Long)Long.parseLong(orgId), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            commonFilterColumn.setComboItems(comboItems);
            String defVal = "";
            commonFilterColumn.setDefaultValue(defVal);
            this.getPageCache().put("manuorg", defVal);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        String accountOrgId = this.getPageCache().get("accountorgId");
        if (fieldName.startsWith("costcenter")) {
            if (CadEmptyUtils.isEmpty((String)accountOrgId)) {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            } else {
                args.getQfilters().add(new QFilter("accountorg", "=", (Object)Long.parseLong(accountOrgId)).and(new QFilter("enable", "=", (Object)"1")));
            }
        }
        if (fieldName.startsWith("period")) {
            Long costAccountId = 0L;
            String beforeCostAccount = this.getPageCache().get("beforeCostAccount");
            if (!CadEmptyUtils.isEmpty((String)beforeCostAccount)) {
                costAccountId = Long.parseLong(beforeCostAccount);
            } else {
                String costAccount = this.getPageCache().get("costaccountId");
                if (!CadEmptyUtils.isEmpty((String)costAccount)) {
                    costAccountId = Long.parseLong(costAccount);
                }
            }
            if (CadEmptyUtils.isEmpty((Long)costAccountId)) {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            } else {
                QFilter costaccountFilter = new QFilter("entry.costaccount", "=", (Object)costAccountId);
                DynamicObject sysCtrlEntity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id,entry.startperiod startperiod,entry.currentperiod currentperiod,entry.calpolicy.periodtype periodtype", (QFilter[])new QFilter[]{costaccountFilter});
                if (sysCtrlEntity != null) {
                    Long startPeriod = sysCtrlEntity.getLong("startperiod");
                    QFilter idQf = new QFilter("id", ">=", (Object)startPeriod);
                    idQf.and("periodtype", "=", (Object)sysCtrlEntity.getLong("periodtype"));
                    args.getQfilters().add(new QFilter("isadjustperiod", "=", (Object)false));
                    args.getQfilters().add(idQf);
                }
            }
        }
        if (fieldName.startsWith("costaccount")) {
            if (!CadEmptyUtils.isEmpty((String)accountOrgId)) {
                QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledFilter(Collections.singletonList(accountOrgId), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
                args.getQfilters().add(enabledCostAccountIdsFilter);
            } else {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        }
        if (fieldName.startsWith("manuorg")) {
            if (!CadEmptyUtils.isEmpty((String)accountOrgId)) {
                List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.parseLong(accountOrgId), (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
                args.getQfilters().add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
            } else {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        }
    }

    private void moveTop(List<ComboItem> acctOrgs, String orgId) {
        String currOrg;
        String string = currOrg = kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)this.getPageCache().get("currOrg")) ? orgId : this.getPageCache().get("currOrg");
        if (CadEmptyUtils.isEmpty(acctOrgs) || CadEmptyUtils.isEmpty((String)currOrg)) {
            return;
        }
        for (int i = 0; i < acctOrgs.size(); ++i) {
            if (!currOrg.equals(acctOrgs.get(i).getValue())) continue;
            ComboItem temp = acctOrgs.get(0);
            acctOrgs.set(0, acctOrgs.get(i));
            acctOrgs.set(i, temp);
        }
        this.getPageCache().put("currOrg", currOrg);
    }

    private String getDefOrg(List<ComboItem> acctOrgs) {
        String orgId = this.getPageCache().get("accountorgId");
        if (CadEmptyUtils.isEmpty((String)orgId)) {
            orgId = this.getCustomParam("org");
            if (!CadEmptyUtils.isEmpty((String)orgId)) {
                return orgId;
            }
            Long currAcctOrg = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)currAcctOrg, (String)"10");
            orgId = isAccounting ? currAcctOrg.toString() : (CadEmptyUtils.isEmpty(acctOrgs) ? "0" : acctOrgs.get(0).getValue());
            this.getPageCache().put("accountorgId", orgId);
        }
        return orgId;
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues;
        List customfilter;
        super.filterContainerSearchClick(args);
        if (this.orgClick) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)args, (String)"costaccount.id");
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)args, (String)"period.id");
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)args, (String)"costcenter.id");
        }
        if (args.getCurrentCommonFilter() != null && "costaccount.id".equals(((List)args.getCurrentCommonFilter().get("FieldName")).get(0))) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)args, (String)"period.id");
        }
        if ((customfilter = (List)(filterValues = args.getSearchClickEvent().getFilterValues()).get("customfilter")) == null || customfilter.isEmpty()) {
            return;
        }
        String accountorgId = "";
        for (int i = 0; i < customfilter.size(); ++i) {
            Map filter = (Map)customfilter.get(i);
            List listFieldName = (List)filter.get("FieldName");
            List listValue = (List)filter.get("Value");
            if (CadEmptyUtils.isEmpty((List)listValue)) continue;
            block13: for (int j = 0; j < listFieldName.size(); ++j) {
                String fieldName;
                switch (fieldName = (String)listFieldName.get(j)) {
                    case "org.id": {
                        accountorgId = (String)listValue.get(j);
                        this.getPageCache().put("accountorgId", accountorgId);
                        this.getPageCache().put("costaccountId", "");
                        this.getPageCache().put("costCenterId", "");
                        this.filterContainerInit(this.filterContainerInitArgs);
                        this.costAccountChangeInit(this.filterContainerInitArgs);
                        continue block13;
                    }
                    case "costaccount.id": {
                        String costaccountId = (String)listValue.get(j);
                        this.getPageCache().put("costaccountId", costaccountId);
                        this.getPageCache().put("beforeCostAccount", costaccountId);
                        this.costAccountChangeInit(this.filterContainerInitArgs);
                        continue block13;
                    }
                    case "costcenter.id": {
                        String costCenterId = (String)listValue.get(j);
                        this.getPageCache().put("costCenterId", costCenterId);
                        continue block13;
                    }
                    case "manuorg.id": {
                        String manuorg = (String)listValue.get(j);
                        this.getPageCache().put("manuorg", manuorg);
                        if (CadEmptyUtils.isEmpty((String)manuorg)) {
                            this.getPageCache().put("mutimanuorg", null);
                        } else {
                            this.getPageCache().put("mutimanuorg", SerializationUtils.toJsonString((Object)listValue));
                        }
                        this.filterContainerInit(this.filterContainerInitArgs);
                    }
                }
            }
        }
        if (!CadEmptyUtils.isEmpty((String)this.getPageCache().get("accountorgId"))) {
            List multiCostCenters = CadUtils.getMultiCostCentersByFilterName((FilterContainerSearchClickArgs)args, (String)"costcenter.id", (Long)Long.parseLong(this.getPageCache().get("accountorgId")));
            this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString((Object)multiCostCenters));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        List userHasPermProOrgsByAccOrg;
        e.getParameter().setCustomParam("accountorgId", (Object)this.getPageCache().get("accountorgId"));
        e.getParameter().setCustomParam("costaccountId", (Object)this.getPageCache().get("costaccountId"));
        e.getParameter().setCustomParam("costCenterId", (Object)this.getPageCache().get("costCenterId"));
        e.getParameter().setCustomParam("manuorg", (Object)this.getPageCache().get("manuorg"));
        String accountorgId = this.getPageCache().get("accountorgId");
        if (!CadEmptyUtils.isEmpty((String)accountorgId) && (userHasPermProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.parseLong(accountorgId), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())).size() == 0) {
            e.getParameter().setCustomParam("manuorg", null);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        switch (operateKey) {
            case "new": {
                this.checkAddWay(e, "new");
                break;
            }
            case "sysimport": {
                this.checkAddWay(e, "sysimport");
                break;
            }
            case "voucherrtpup": {
                this.viewVoucherReport(selectedRows);
                break;
            }
            case "searchup": {
                this.searchUpOriginalBillNew(selectedRows);
                break;
            }
            case "delete": {
                this.deleteTips(e);
            }
        }
    }

    private void viewVoucherReport(ListSelectedRowCollection selectedRows) {
        String orgId = this.getPageCache().get("accountorgId");
        String costAccountId = this.getPageCache().get("costaccountId");
        if (CadEmptyUtils.isEmpty((String)orgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgfeeBillListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        if (CadEmptyUtils.isEmpty((String)costAccountId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"MfgfeeBillListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filterInfo = queryParam.getFilter();
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("cad_mfgfeebilllogarithm");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        filterInfo.addFilterItem("org", (Object)Long.parseLong(orgId), "=");
        filterInfo.addFilterItem("costaccount", (Object)Long.parseLong(costAccountId), "=");
        filterInfo.addFilterItem("srcsys", (Object)"A", "=");
        filterInfo.addFilterItem("isonlyshowdiff", (Object)Boolean.FALSE, "=");
        if (!CadEmptyUtils.isEmpty((ListSelectedRowCollection)selectedRows)) {
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            QFilter idFilter = new QFilter("id", "in", (Object)primaryKeyValues);
            DataSet mfgInfoDs = QueryServiceHelper.queryDataSet((String)"getMfgInfo", (String)"cad_mfgfeebill", (String)"period,account", (QFilter[])idFilter.toArray(), null).distinct();
            long periodId = 0L;
            HashSet<Long> accountIds = new HashSet<Long>(16);
            for (Row row : mfgInfoDs) {
                accountIds.add(row.getLong("account"));
                periodId = row.getLong("period");
            }
            filterInfo.addFilterItem("mulperiod", (Object)periodId, "=");
            filterInfo.addFilterItem("account", accountIds, "=");
        }
        showParameter.setQueryParam(queryParam);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void deleteTips(BeforeDoOperationEventArgs e) {
        String costAccountId;
        ArrayList<String> pkValues = new ArrayList<String>();
        HashSet<Long> checkDeleteIds = new HashSet<Long>(256);
        ArrayList billNumbers = new ArrayList();
        ListSelectedRowCollection selectedRows = e.getListSelectedData();
        for (ListSelectedRow listSelectedRow : selectedRows.getBillListSelectedRowCollection()) {
            String pkValue = listSelectedRow.getPrimaryKeyValue().toString();
            pkValues.add(pkValue);
            if (CadEmptyUtils.isEmpty((String)pkValue)) continue;
            checkDeleteIds.add(Long.parseLong(pkValue));
        }
        Set<Long> billExistIds = this.checkBillExist(checkDeleteIds);
        if (!CadEmptyUtils.isEmpty(billExistIds)) {
            QFilter idQFilter = new QFilter("id", "in", billExistIds);
            DataSet mfgBillDs = QueryServiceHelper.queryDataSet((String)"getMfgBill", (String)"cad_mfgfeebill", (String)"billno", (QFilter[])idQFilter.toArray(), null);
            mfgBillDs.forEach(s -> billNumbers.add(s.getString("billno")));
        }
        if (!CadEmptyUtils.isEmpty((String)(costAccountId = this.getPageCache().get("costaccountId")))) {
            DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)Long.parseLong(costAccountId));
            long currentPeriodId = currentPeriod == null ? 0L : currentPeriod.getLong("id");
            QFilter idQFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
            DataSet queryMfg = QueryServiceHelper.queryDataSet((String)"queryMfg", (String)"cad_mfgfeebill", (String)"id,period", (QFilter[])idQFilter.toArray(), null);
            for (Row row : queryMfg) {
                if (row.getLong("period") == currentPeriodId) continue;
                e.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u975e\u5f53\u524d\u671f\u7684\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5355\u3002", (String)"MfgfeeBillListPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (billNumbers.size() > 0) {
            e.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_DELETE, (IFormPlugin)this);
            String confirmTip = String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u5355%s\u5df2\u7ecf\u751f\u6210\u4e86\u5206\u914d\u5355\uff0c\u5220\u9664\u9700\u8981\u91cd\u65b0\u8fdb\u884c\u8d39\u7528\u5206\u914d\uff0c\u786e\u8ba4\u5220\u9664\uff1f", (String)"MfgfeeBillListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), StringUtils.join(billNumbers, (String)","));
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            this.getPageCache().put("deleteId", SerializationUtils.toJsonString(pkValues));
        }
    }

    private Set<Long> checkBillExist(Set<Long> checkDeleteIds) {
        HashSet<Long> existBillIds = new HashSet<Long>(256);
        QFilter filter = new QFilter("srcbillentry.srcbill", "in", checkDeleteIds);
        DataSet mfgAux = QueryServiceHelper.queryDataSet((String)"getMfgAux", (String)"cad_auxprodalloc", (String)"srcbillentry.srcbill as mfgbillid", (QFilter[])filter.toArray(), null);
        mfgAux.forEach(s -> existBillIds.add(s.getLong("mfgbillid")));
        DataSet mfgNon = QueryServiceHelper.queryDataSet((String)"getMfgNon", (String)"cad_nonprodalloc", (String)"srcbillentry.srcbill as mfgbillid", (QFilter[])filter.toArray(), null);
        mfgNon.forEach(s -> existBillIds.add(s.getLong("mfgbillid")));
        DataSet mfgBasic = QueryServiceHelper.queryDataSet((String)"getMfgBasic", (String)"cad_basicalloc", (String)"srcbillentry.srcbill as mfgbillid", (QFilter[])filter.toArray(), null);
        mfgBasic.forEach(s -> existBillIds.add(s.getLong("mfgbillid")));
        QFilter cooFilter = new QFilter("srcexpentry.expbillid", "in", checkDeleteIds);
        DataSet mfgInner = QueryServiceHelper.queryDataSet((String)"getMfgInner", (String)"cad_mfgfeeallocco", (String)"srcexpentry.expbillid as mfgbillid", (QFilter[])cooFilter.toArray(), null);
        mfgInner.forEach(s -> existBillIds.add(s.getLong("mfgbillid")));
        return existBillIds;
    }

    private void searchUpOriginalBillNew(ListSelectedRowCollection selectedRows) {
        String[] pkidArr;
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        QFilter idFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_mfgfeebill", (String)"srcbilltype,srcbillid", (QFilter[])new QFilter[]{idFilter});
        HashSet<String> voucherIds = new HashSet<String>();
        HashSet<String> apFiIds = new HashSet<String>();
        HashSet<String> apBusIds = new HashSet<String>();
        HashMap<String, Set> billTypeIdsMap = new HashMap<String, Set>(16);
        for (Object dynamicObject : dynamicObjects) {
            String billId = dynamicObject.getString("srcbillid");
            String billType = dynamicObject.getString("srcbilltype");
            if (billId == null || "".equals(billId)) continue;
            if (billType == null || "".equals(billType) || billType.equals("VOUCHER")) {
                voucherIds.add(billId);
                continue;
            }
            if (billType.equals("AP_FI")) {
                apFiIds.add(billId);
                continue;
            }
            if (billType.equals("AP_BUS")) {
                apBusIds.add(billId);
                continue;
            }
            billTypeIdsMap.computeIfAbsent(billType, s -> new HashSet(16)).add(billId);
        }
        if (voucherIds.isEmpty() && apFiIds.isEmpty() && apBusIds.isEmpty() && CadEmptyUtils.isEmpty(billTypeIdsMap)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u6ca1\u6709\u6765\u6e90\u5355\u636e\u53f7\u3002", (String)"MfgfeeBillListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!voucherIds.isEmpty()) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("gl_voucher");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            for (String srcBillId : voucherIds) {
                for (String pkid : pkidArr = srcBillId.split("@")) {
                    showParameter.addLinkQueryPkId((Object)Long.parseLong(pkid));
                }
            }
            showParameter.getCustomParams().put("org", "");
            showParameter.getCustomParams().put("booktype", "");
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if (!apFiIds.isEmpty()) {
            ListShowParameter apFiShowParameter = new ListShowParameter();
            apFiShowParameter.setBillFormId("ap_finapbill");
            apFiShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            apFiShowParameter.setShowFilter(false);
            apFiShowParameter.setShowQuickFilter(false);
            for (String srcBillId : apFiIds) {
                for (String pkid : pkidArr = srcBillId.split("@")) {
                    apFiShowParameter.addLinkQueryPkId((Object)Long.parseLong(pkid));
                }
            }
            this.getView().showForm((FormShowParameter)apFiShowParameter);
        }
        if (!apBusIds.isEmpty()) {
            ListShowParameter apBusShowParameter = new ListShowParameter();
            apBusShowParameter.setBillFormId("ap_busbill");
            apBusShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            apBusShowParameter.setShowFilter(false);
            apBusShowParameter.setShowQuickFilter(false);
            for (String srcBillId : apBusIds) {
                for (String pkid : pkidArr = srcBillId.split("@")) {
                    apBusShowParameter.addLinkQueryPkId((Object)Long.parseLong(pkid));
                }
            }
            this.getView().showForm((FormShowParameter)apBusShowParameter);
        }
        if (!CadEmptyUtils.isEmpty(billTypeIdsMap)) {
            for (Map.Entry billTypeEntry : billTypeIdsMap.entrySet()) {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId((String)billTypeEntry.getKey());
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setShowFilter(false);
                showParameter.setShowQuickFilter(false);
                for (String srcBillId : (Set)billTypeEntry.getValue()) {
                    String[] pkIdArr;
                    for (String pkId : pkIdArr = srcBillId.split("@")) {
                        showParameter.addLinkQueryPkId((Object)Long.parseLong(pkId));
                    }
                }
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
            switch (callBackId) {
                case "delete": {
                    List idList;
                    String deleteId;
                    if (!MessageBoxResult.Yes.equals((Object)e.getResult()) || !kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)(deleteId = this.getPageCache().get("deleteId"))) || CollectionUtils.isEmpty((Collection)(idList = (List)SerializationUtils.fromJsonString((String)deleteId, List.class)))) break;
                    MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"cad_mfgfeebill");
                    DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])idList.toArray());
                    OperateOption operateOption = OperateOption.create();
                    this.getView().invokeOperation(KEY_REFRESH, operateOption);
                    this.getPageCache().remove("deleteId");
                    break;
                }
                case "showReport": {
                    String responseInfoStr = this.getPageCache().get("responseInfo");
                    if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                        return;
                    }
                    ExecuteResult executeResult = (ExecuteResult)SerializationUtils.fromJsonString((String)responseInfoStr, ExecuteResult.class);
                    this.showColReport(executeResult.getReportId());
                }
            }
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        super.beforeCreateListColumns(o);
        List listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            if (!column.toString().equals("billno")) continue;
            column.setFixed(true);
            break;
        }
        this.productGroupVisible(o);
        if (AppIdHelper.isSCA((IFormView)this.getView())) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)o, (Set)Sets.newHashSet((Object[])new String[]{"projectnumber.number", "tracknumber.number", "lot"}));
        }
    }

    public void setFilter(SetFilterEvent e) {
        String accountorgId = this.getPageCache().get("accountorgId");
        if (accountorgId != null) {
            String costAccountId = this.getPageCache().get("costaccountId");
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)costAccountId)) {
                DynamicObject currentPeriodType = PeriodHelper.getCurrentPeriodType((Long)Long.parseLong(costAccountId));
                if (currentPeriodType != null) {
                    PeriodHelper.getPeriodItems((Long)Long.parseLong(currentPeriodType.getPkValue().toString()));
                    QFilter periodFilter = new QFilter("period.periodtype", "=", currentPeriodType.getPkValue());
                    e.getQFilters().add(periodFilter);
                }
            } else {
                e.getQFilters().add(new QFilter("id", "in", (Object)-1));
            }
            QFilter manuOrgQFilter = this.getManuOrgQFilter();
            if (manuOrgQFilter != null) {
                e.getQFilters().add(manuOrgQFilter);
            }
            e.setOrderBy("bookdate desc,billno desc");
        }
    }

    private void checkAddWay(BeforeDoOperationEventArgs e, String opr) {
        boolean hasNullValue = this.checkOrgAndCostAccount();
        if (hasNullValue) {
            e.setCancel(true);
            return;
        }
        String orgId = this.getPageCache().get("accountorgId");
        String costCenterId = this.getPageCache().get("costCenterId");
        String appNum = this.getView().getFormShowParameter().getAppId();
        String addWay = SysParamHelper.getScaSysParamAddType((String)orgId, (String)costCenterId, (String)"mfgfeebilltype", (String)appNum);
        if ("new".equals(opr)) {
            return;
        }
        if ("sysimport".equals(opr)) {
            List<Long> costCenterIdList = new ArrayList<Long>();
            List costCenters = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("multiselectcostcenters"), List.class);
            if (!CadEmptyUtils.isEmpty((List)costCenters) && costCenters.size() > 1) {
                String costCenterString = SerializationUtils.toJsonString((Object)costCenters);
                this.getPageCache().put("costCenterIdList", costCenterString);
                this.openImportWin();
                return;
            }
            if (CadEmptyUtils.isEmpty((String)costCenterId)) {
                boolean enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(orgId));
                if (enableMultiFactory) {
                    String manuorgIds = this.getPageCache().get("mutimanuorg");
                    List<Long> manuList = new ArrayList();
                    if (CadEmptyUtils.isEmpty((String)manuorgIds)) {
                        manuList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.parseLong(orgId), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                    } else {
                        List list = (List)SerializationUtils.fromJsonString((String)manuorgIds, List.class);
                        for (String manuOrgId : list) {
                            manuList.add(Long.parseLong(manuOrgId));
                        }
                    }
                    HashSet<Long> centerIds = new HashSet<Long>(16);
                    DynamicObjectCollection dynamicObjects = OrgHelper.getCenterManyByManuOrgIds((Long)Long.parseLong(orgId), manuList, (String)appNum);
                    if (!dynamicObjects.isEmpty()) {
                        HashMap<Long, Long> centerManuMap = new HashMap<Long, Long>();
                        for (DynamicObject dynamicObject : dynamicObjects) {
                            long centerId = dynamicObject.getLong("costcenterid");
                            centerIds.add(centerId);
                            centerManuMap.put(centerId, dynamicObject.getLong("manuorg"));
                        }
                        this.getPageCache().put("centerManuMap", ((Object)centerManuMap).toString());
                    }
                    if (CadEmptyUtils.isEmpty(centerIds)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u672a\u7ef4\u62a4\u201c\u6210\u672c\u4e2d\u5fc3\u201d\u4e0e\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u7684\u5bf9\u5e94\u5173\u7cfb\u3002", (String)"MfgfeeBillListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    ArrayList costCenterIds = new ArrayList(centerIds);
                    this.getPageCache().put("costCenterIdList", SerializationUtils.toJsonString(costCenterIds));
                } else {
                    ArrayList<QFilter> filters = new ArrayList<QFilter>();
                    Long orgIdLong = kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)orgId) ? 0L : Long.parseLong(orgId);
                    filters.add(new QFilter("accountorg", "=", (Object)orgIdLong));
                    filters.add(new QFilter("status", "=", (Object)"C"));
                    filters.add(new QFilter("enable", "=", (Object)true));
                    costCenterIdList = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
                    costCenterIdList.add(0L);
                    this.getPageCache().put("costCenterIdList", SerializationUtils.toJsonString(costCenterIdList));
                }
                this.openImportWin();
                return;
            }
            costCenterIdList.add(Long.valueOf(costCenterId));
            this.getPageCache().put("costCenterIdList", SerializationUtils.toJsonString(costCenterIdList));
            this.openImportWin();
            return;
        }
    }

    private boolean checkOrgAndCostAccount() {
        String orgId = this.getPageCache().get("accountorgId");
        if (CadEmptyUtils.isEmpty((String)orgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgfeeBillListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return true;
        }
        String costaccountId = this.getPageCache().get("costaccountId");
        if (CadEmptyUtils.isEmpty((String)costaccountId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"MfgfeeBillListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return true;
        }
        FormShowParameter e = this.getView().getFormShowParameter();
        e.setCustomParam("accountorgId", (Object)orgId);
        e.setCustomParam("costaccountId", (Object)costaccountId);
        this.logger.info("checkOrgAndCostAccount accountorgId==>{},costaccountId ==>{}", (Object)orgId, (Object)costaccountId);
        return false;
    }

    private void openImportWin() {
        String orgId = this.getPageCache().get("accountorgId");
        String appNum = this.getView().getFormShowParameter().getAppId();
        Long orgL = Long.parseLong(orgId);
        DynamicObjectCollection costAccounts = StartCostHelper.getCostAccounts((Long)orgL, null, (String)appNum);
        if (costAccounts != null && !costAccounts.isEmpty()) {
            if (costAccounts.size() == 1) {
                QFilter orgFilter = new QFilter("org", "=", (Object)orgL);
                QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
                QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
                enable.and("entryentity.isenabled", "=", (Object)Boolean.TRUE);
                QFilter appNumQf = new QFilter("appnum", "=", (Object)appNum);
                QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, enable, appNumQf};
                DynamicObject[] startStdCosts = BusinessDataServiceHelper.load((String)"sca_startstdcost", (String)"org,entryentity.costaccount,entryentity.isenabled,entryentity.isinit", (QFilter[])filters);
                if (startStdCosts != null && startStdCosts.length == 1) {
                    ArrayList<DynamicObject> selectData = new ArrayList<DynamicObject>();
                    DynamicObject startStdCost = startStdCosts[0];
                    DynamicObject org = startStdCost.getDynamicObject("org");
                    DynamicObjectCollection entryEntity = startStdCost.getDynamicObjectCollection("entryentity");
                    if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
                        for (DynamicObject entity : entryEntity) {
                            boolean isEnabled = entity.getBoolean("isenabled");
                            if (!isEnabled) continue;
                            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sca_matallocimport");
                            DynamicObjectCollection costaccountlist = dynamicObject.getDynamicObjectCollection("costaccountlist");
                            DynamicObject entry = costaccountlist.addNew();
                            DynamicObject costaccount = entity.getDynamicObject("costaccount");
                            if (CadEmptyUtils.isEmpty((DynamicObject)costaccount)) continue;
                            entry.set("costaccount", (Object)costaccount);
                            entry.set("currentperiod", (Object)PeriodHelper.getCurrentPeriod((Long)costaccount.getLong("id")));
                            entry.set("org", (Object)org);
                            selectData.add(entry);
                            this.importMfgFeeBillBySys(selectData);
                        }
                    }
                }
            } else {
                String manuorgId = this.getPageCache().get("manuorg");
                ArrayList<String> orgIdList = new ArrayList<String>(10);
                orgIdList.add(orgId);
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("sca_matallocimport");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCustomParam("org", orgIdList);
                fsp.setCustomParam("manuorg", (Object)manuorgId);
                fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "form"));
                this.getView().showForm(fsp);
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u542f\u7528\u5b9e\u9645\u6210\u672c\u6838\u7b97\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"MfgfeeBillListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        this.getView().hideLoading();
        switch (actionId = e.getActionId()) {
            case "importResult": {
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                ExecuteResult executeResult = (ExecuteResult)SerializationUtils.fromJsonString((String)responseInfoStr, ExecuteResult.class);
                String submitTip = executeResult.getSubmitTip();
                String aduitTip = executeResult.getAduitTip();
                Map falseInfo = executeResult.getFalseInfo();
                if (!executeResult.isSuccess() && !CadEmptyUtils.isEmpty((Map)falseInfo) && falseInfo.containsKey("confirm")) {
                    this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                    this.getView().showConfirm((String)falseInfo.get("confirm"), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("showReport", (IFormPlugin)this));
                    break;
                }
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)submitTip) && kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)aduitTip)) {
                    executeResult.showNotificationSample(this.getView());
                    this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                    break;
                }
                StringBuilder tip = new StringBuilder();
                String successTip = (String)executeResult.getSuccessInfo().get("Success");
                tip.append(successTip).append("\r\n").append(submitTip).append(aduitTip);
                this.getView().showMessage(tip.toString());
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                break;
            }
            case "form": {
                List selectData = (List)e.getReturnData();
                if (selectData == null || selectData.size() == 0) {
                    return;
                }
                this.importMfgFeeBillBySys(selectData);
                this.getView().invokeOperation(KEY_REFRESH);
                break;
            }
        }
    }

    private void showColReport(Long colReportId) {
        if (CadEmptyUtils.isEmpty((Long)colReportId)) {
            return;
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("cad_mfgfee_report");
        billShowParameter.setPkId((Object)colReportId);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void importMfgFeeBillBySys(List<DynamicObject> selectData) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        HashSet<Long> costAccountSet = new HashSet<Long>(16);
        for (DynamicObject selectRow : selectData) {
            DynamicObject costaccount = selectRow.getDynamicObject("costaccount");
            costAccountSet.add(costaccount.getLong("id"));
            paramMap.put(String.valueOf(costaccount.getLong("id")), selectRow.getDynamicObject("currentperiod") == null ? 0L : selectRow.getDynamicObject("currentperiod").getLong("id"));
        }
        DynamicObject selectRow = selectData.get(0);
        Long orgId = selectRow.getDynamicObject("org").getLong("id");
        String manuorgId = this.getPageCache().get("manuorg");
        if (CadEmptyUtils.isEmpty((String)manuorgId)) {
            manuorgId = "0";
        }
        paramMap.put("manuorg", Long.parseLong(manuorgId));
        String costCenterIdListStr = this.getPageCache().get("costCenterIdList");
        List costCenterIdList = (List)SerializationUtils.fromJsonString((String)costCenterIdListStr, List.class);
        IFormView view = this.getView();
        Set dyDataRuleCostCenterIds = ImportServiceHelper.getDyDataRuleCostCenter((Long)Long.parseLong(RequestContext.get().getUserId()), (String)view.getFormShowParameter().getAppId(), (String)this.getEntityName(), (String)"4730fc9f000003ae", Collections.singletonList(orgId));
        if (!CadEmptyUtils.isEmpty((Set)dyDataRuleCostCenterIds)) {
            ArrayList notInDataRules = new ArrayList(10);
            costCenterIdList.forEach(p -> {
                if (!dyDataRuleCostCenterIds.contains(Long.parseLong(p.toString()))) {
                    notInDataRules.add(p);
                }
            });
            if (!CadEmptyUtils.isEmpty((List)costCenterIdList)) {
                costCenterIdList.removeAll(notInDataRules);
            }
        }
        paramMap.put("appnum", view.getFormShowParameter().getAppId());
        MfgFeeImportReport report = this.initializeReport(orgId, view.getFormShowParameter().getAppId());
        String centerManuMapString = this.getPageCache().get("centerManuMap");
        if (centerManuMapString != null) {
            Map<Long, Long> centerManuMap = this.mapStringToMap(centerManuMapString);
            paramMap.put("centerManuMap", centerManuMap);
        }
        paramMap.put("report", report);
        for (Long costAccountId : costAccountSet) {
            String lockErrStr = SimpleMutexHelper.mfgCheckAndRequireXMutex((String)"mfgFeeImport", (Long)costAccountId);
            if (!kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)lockErrStr)) continue;
            this.getView().showErrorNotification(lockErrStr);
            return;
        }
        String progressId = UUID.randomUUID().toString();
        ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"MfgfeeBillListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
            ExecuteResult executeResult = new ExecuteResult();
            try {
                executeResult = MfgfeeBillImportHelper.importMfgFeeBillBySys((Long)orgId, (Set)costAccountSet, (List)costCenterIdList, (Map)paramMap, (String)progressId);
            }
            catch (Exception e) {
                ProgressHelper.showError((String)progressId, (String)e.getMessage());
            }
            finally {
                ProgressHelper.clearProgressParam((String)progressId);
            }
            String responseInfoStr = SerializationUtils.toJsonString((Object)executeResult);
            this.getPageCache().put("responseInfo", responseInfoStr);
        }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_importResult));
        view.invokeOperation(KEY_REFRESH);
    }

    private String getEntityName() {
        return "cad_mfgfeebill";
    }

    public void initialize() {
        super.initialize();
    }

    protected QFilter getManuOrgQFilter() {
        String orgId;
        boolean enableMultiFactory;
        QFilter manuOrgQf = null;
        String manuOrgId = this.getPageCache().get("manuorg");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)manuOrgId) && (enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(orgId = this.getPageCache().get("accountorgId")))) && !kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)orgId)) {
            List userHasPermProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.valueOf(orgId), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (!CadEmptyUtils.isEmpty((List)userHasPermProOrgsByAccOrg)) {
                userHasPermProOrgsByAccOrg.add(0L);
                manuOrgQf = new QFilter("manuorg", "in", (Object)userHasPermProOrgsByAccOrg);
            } else {
                manuOrgQf = new QFilter("manuorg", "=", (Object)0L);
            }
        }
        return manuOrgQf;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        if (rows.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("srcbillid", "!=", (Object)" ");
        filter.and("srcbillid", "is not null", null);
        filter.and("srcbilltype", "=", (Object)"VOUCHER");
        filter.and("id", "in", (Object)rows.getPrimaryKeyValues());
        DynamicObjectCollection cad_mfgfeebill = QueryServiceHelper.query((String)"cad_mfgfeebill", (String)"id,srcbillid", (QFilter[])new QFilter[]{filter});
        if (cad_mfgfeebill.isEmpty()) {
            return;
        }
        HashMap<Long, String> mfgMap = new HashMap<Long, String>(20);
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject dynamicObject : cad_mfgfeebill) {
            String srcBillId = dynamicObject.getString("srcbillid");
            mfgMap.put(dynamicObject.getLong("id"), srcBillId);
            String[] split = srcBillId.split("@");
            for (int i = 0; i < split.length; ++i) {
                ids.add(Long.parseLong(split[i]));
            }
        }
        HashMap<String, String> glMap = new HashMap<String, String>(20);
        DynamicObjectCollection gl_voucher = QueryServiceHelper.query((String)"gl_voucher", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        for (DynamicObject dynamicObject : gl_voucher) {
            glMap.put(dynamicObject.getString("id"), dynamicObject.getString("billno"));
        }
        for (ListSelectedRow row : rows) {
            String value = (String)mfgMap.get(row.getPrimaryKeyValue());
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)value)) continue;
            String[] glIds = value.split("@");
            StringJoiner result = new StringJoiner(",");
            for (int i = 0; i < glIds.length; ++i) {
                String val = (String)glMap.get(glIds[i]);
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)val)) continue;
                result.add(val);
            }
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)result.toString())) continue;
            billList.setCellFieldValue("srcbillnum", row.getRowKey(), (Object)result.toString());
        }
    }

    private void productGroupVisible(BeforeCreateListColumnsArgs args) {
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("sca".equals(appId)) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)args, (Set)Sets.newHashSet((Object[])new String[]{"productgroup.name"}));
        }
    }

    private MfgFeeImportReport initializeReport(Long orgId, String appNum) {
        MfgFeeImportReport report = new MfgFeeImportReport();
        report.setCreator(Long.valueOf(RequestContext.get().getCurrUserId()));
        report.setCreateTime(TimeServiceHelper.now());
        report.setId(Long.valueOf(ID.genLongId()));
        report.setBillNo(ID.genStringId());
        report.setOrgId(orgId);
        report.setAppNum(appNum);
        return report;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "colreport": {
                this.viewColReport();
                break;
            }
            case "searchconfig": {
                this.searchConfig();
                break;
            }
        }
    }

    private void searchConfig() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() == 0) {
            return;
        }
        ImportServiceHelper.seachConfig((Object[])rows.getPrimaryKeyValues(), (String)"cad_mfgfeebill", (IFormView)this.getView());
    }

    private void viewColReport() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"cad_mfgfee_report", (boolean)true, (int)1, (boolean)false);
        String acctOrgId = this.getPageCache().get("accountorgId");
        listShowParameter.setCustomParam("appnum", (Object)this.getView().getFormShowParameter().getAppId());
        listShowParameter.setCustomParam("org", (Object)acctOrgId);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public Map<Long, Long> mapStringToMap(String str) {
        str = str.substring(1, str.length() - 1);
        String[] strs = str.split(",");
        HashMap<Long, Long> map = new HashMap<Long, Long>(16);
        for (String string : strs) {
            String key = string.split("=")[0];
            String value = string.split("=")[1];
            String key1 = key.trim();
            String value1 = value.trim();
            map.put(Long.parseLong(key1), Long.parseLong(value1));
        }
        return map;
    }
}

