/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.oppplugin.feealloc;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.enums.BillBaseEnum;

public class MfgfeeBillAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MfgfeeBillAuditOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                DynamicObject[] res;
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                ArrayList<Long> idList = new ArrayList<Long>(10);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    this.toIdList(dataEntity, idList);
                }
                if (idList.size() == 0) {
                    return;
                }
                MainEntityType mfgFeeBillType = EntityMetadataCache.getDataEntityType((String)"sca_mfgfeebill");
                for (DynamicObject bill : res = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)mfgFeeBillType)) {
                    bill.set("billstatus", (Object)BillBaseEnum.BILL_STATUS_AUDITED.getValue());
                    bill.set("auditor", (Object)RequestContext.get().getUserId());
                    bill.set("auditdate", (Object)new Date());
                }
                SaveServiceHelper.save((DynamicObject[])res);
            }

            private void toIdList(ExtendedDataEntity dataEntity, List<Long> idList) {
                DynamicObject bill = dataEntity.getDataEntity();
                String billStatus = bill.getString("billstatus");
                if (!"B".equalsIgnoreCase(billStatus)) {
                    return;
                }
                Long billId = bill.getLong("id");
                idList.add(billId);
            }
        });
    }
}

