/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.oppplugin.feealloc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MfgfeeBillImportHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MfgfeeBillSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("currency");
        fieldKeys.add("expenseitem");
        fieldKeys.add("period");
        fieldKeys.add("amount");
        fieldKeys.add("srcsys");
        fieldKeys.add("costcenter");
        fieldKeys.add("productgroup");
        fieldKeys.add("allocmold");
        fieldKeys.add("source");
        fieldKeys.add("manuorg");
        fieldKeys.add("seq");
        fieldKeys.add("costobject");
        fieldKeys.add("outsourcetype");
        fieldKeys.add("isoutsource");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                String operateKey = this.getOperateKey();
                String tip = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MfgfeeBillSaveOp_0", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                if ("submit".equals(operateKey)) {
                    tip = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002", (String)"MfgfeeBillSaveOp_1", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                }
                ArrayList<String> orgDutySet = new ArrayList<String>();
                orgDutySet.add("4");
                orgDutySet.add("5");
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    this.checkAllocMold(dataEntity, tip);
                    this.checkAmount(dataEntity, tip);
                    this.checkAllocMoldMatchCostCenter(dataEntity, orgDutySet);
                    this.checkOrgAndManuOrg(dataEntity, tip);
                }
            }

            private void checkAllocMoldMatchCostCenter(ExtendedDataEntity dataEntity, List<String> orgdutySet) {
                DynamicObject mfgFee = dataEntity.getDataEntity();
                if (mfgFee == null) {
                    return;
                }
                String allocMold = mfgFee.getString("allocmold");
                if (StringUtils.isEmpty((CharSequence)allocMold)) {
                    return;
                }
                DynamicObject costCenter = mfgFee.getDynamicObject("costcenter");
                if (costCenter == null) {
                    return;
                }
                String orgDuty = costCenter.getString("orgduty.number");
                DynamicObject productGroup = mfgFee.getDynamicObject("productgroup");
                if (!"4".equals(orgDuty) && productGroup != null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5934\u6210\u672c\u4e2d\u5fc3\u4e0d\u4e3a\u57fa\u672c\u751f\u4ea7\u7c7b\u578b\u4f46\u8bbe\u7f6e\u4e86\u4ea7\u54c1\u7ec4\u3002", (String)"MfgfeeBillSaveOp_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                }
                if ("4".equals(orgDuty) && "C".equals(allocMold) || "5".equals(orgDuty) && "B".equals(allocMold) || !orgdutySet.contains(orgDuty) && "A".equals(allocMold)) {
                    return;
                }
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5934\u6210\u672c\u4e2d\u5fc3\u7c7b\u578b\u548c\u5206\u914d\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"MfgfeeBillSaveOp_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }

            private void checkAmount(ExtendedDataEntity dataEntity, String tip) {
                DynamicObject mfgFee = dataEntity.getDataEntity();
                String srcSysNum = mfgFee.getString("srcsys.number");
                BigDecimal totalAmount = mfgFee.getBigDecimal("totalamount");
                if ("aca".equalsIgnoreCase(srcSysNum) && BigDecimal.ZERO.compareTo(totalAmount) > 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u624b\u5de5\u65b0\u589e\u65f6\u9700\u8981\u6ee1\u8db3\uff1a\u8d39\u7528\u91d1\u989d>0\u3002", (String)"MfgfeeBillSaveOp_7", (String)"macc-cad-formplugin", (Object[])new Object[0]), tip));
                }
            }

            private void checkAllocMold(ExtendedDataEntity dataEntity, String tip) {
                DynamicObject mfgFee = dataEntity.getDataEntity();
                String allocMold = mfgFee.getString("allocmold");
                if (StringUtils.isEmpty((CharSequence)allocMold)) {
                    return;
                }
                DynamicObject costCenter = mfgFee.getDynamicObject("costcenter");
                if (costCenter == null) {
                    switch (allocMold) {
                        case "B": {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5f53\u524d\u5206\u914d\u7c7b\u578b\u4e3a\u8f85\u52a9\u751f\u4ea7\u5206\u914d\uff0c\u6210\u672c\u4e2d\u5fc3\u5fc5\u5f55\u3002", (String)"MfgfeeBillSaveOp_8", (String)"macc-cad-formplugin", (Object[])new Object[0]), tip));
                            break;
                        }
                        case "C": {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5f53\u524d\u5206\u914d\u7c7b\u578b\u4e3a\u57fa\u672c\u751f\u4ea7\u5206\u914d\uff0c\u6210\u672c\u4e2d\u5fc3\u5fc5\u5f55\u3002", (String)"MfgfeeBillSaveOp_9", (String)"macc-cad-formplugin", (Object[])new Object[0]), tip));
                        }
                    }
                }
            }

            private void checkOrgAndManuOrg(ExtendedDataEntity dataEntity, String tip) {
                long org = dataEntity.getDataEntity().getLong("org.id");
                long manuOrg = dataEntity.getDataEntity().getLong("manuorg.id");
                String appNum = dataEntity.getDataEntity().getString("appnum");
                List userHasPermManuorgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org, (String)"cad_mfgfeebill", (String)appNum);
                userHasPermManuorgs.add(0L);
                if (!userHasPermManuorgs.contains(manuOrg)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\uff1a1.\u5f55\u5165\u7684\u751f\u4ea7\u7ec4\u7ec7\u662f\u5426\u5177\u6709\u751f\u4ea7\u804c\u80fd\uff1b2.\u6838\u7b97\u7ec4\u7ec7\u662f\u5426\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5b58\u5728\u59d4\u6258\u5173\u7cfb\uff1b3.\u662f\u5426\u5177\u6709\u5f55\u5165\u751f\u4ea7\u7ec4\u7ec7\u7684\u6743\u9650\u3002", (String)"MfgfeeBillSaveOp_10", (String)"macc-cad-formplugin", (Object[])new Object[0]), tip));
                }
            }
        });
        super.onAddValidators(e);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        ArrayList<Long> expenseitemIdList = new ArrayList<Long>(16);
        for (DynamicObject data : datas) {
            long expenseitemId = data.getLong("expenseitem.id");
            expenseitemIdList.add(expenseitemId);
        }
        Map expenseitemMap = MfgfeeBillImportHelper.expenseitemIdToMasterId(expenseitemIdList);
        for (DynamicObject data : datas) {
            DynamicObject costobject = data.getDynamicObject("costobject");
            String allocmold = data.getString("allocmold");
            if ("C".equals(allocmold)) {
                if (costobject != null) {
                    boolean isoutsource = costobject.getBoolean("isoutsource");
                    if (!isoutsource) {
                        data.set("outsourcetype", null);
                    }
                } else {
                    data.set("outsourcetype", null);
                }
            } else {
                data.set("costobject", null);
                data.set("outsourcetype", null);
            }
            Long expenseitemMasterId = (Long)expenseitemMap.get(data.getLong("expenseitem.id"));
            if (CadEmptyUtils.isEmpty((Long)expenseitemMasterId)) continue;
            data.set("expenseitem_id", (Object)expenseitemMasterId);
        }
    }
}

