/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.planfeealloc;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.business.feealloc.MfgFeeBasicAllocService;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.output.MfgAllocResult;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import kd.macc.cad.formplugin.planfeealloc.PlanFeeAllocBaseListPlugin;
import org.apache.commons.lang.StringUtils;

public class PlanBasicAllocListPlugin
extends PlanFeeAllocBaseListPlugin {
    private static final String CONFIRM_BACK = "doImport";
    private static final String CONFIRMBACK_DOUNCONFIRM = "do_unconfirm";

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("period desc,billno asc");
        if (AppIdHelper.isMacc((IFormView)this.getView())) {
            e.getQFilters().add(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs beforeCreateListColumnsArgs) {
        super.beforeCreateListColumns(beforeCreateListColumnsArgs);
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("sca".equals(appId)) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)beforeCreateListColumnsArgs, (Set)Sets.newHashSet((Object[])new String[]{"productgroup.number", "productgroup.name"}));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        List periodIds = null;
        Object periodSelId = null;
        MfgFeeAllocImportParam importDto = null;
        List<Long> ids = null;
        switch (operate.getOperateKey()) {
            case "importcollc": {
                importDto = this.getPageImportDto();
                if (importDto == null) {
                    args.setCancel(true);
                    return;
                }
                periodIds = PlanFeeAllocHelper.getPlanStartPeriods((Long)importDto.getPlanscheme());
                if (periodIds.isEmpty()) break;
                args.setCancel(true);
                List<Long> periodSelIds = this.getPeriodSelIds();
                if (CadEmptyUtils.isEmpty(periodSelIds)) {
                    for (Long periodId : periodIds) {
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                } else {
                    for (Long periodId : periodSelIds) {
                        if (!periodIds.contains(periodId)) continue;
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                    if (importDto.getCalcPeriodMap().isEmpty()) break;
                }
                this.importCheck(importDto);
                break;
            }
            case "allocation": {
                ids = this.getSelectIds();
                if (!ids.isEmpty()) break;
                args.setCancel(true);
                importDto = this.getPageImportDto();
                if (importDto == null) {
                    return;
                }
                periodIds = PlanFeeAllocHelper.getPlanStartPeriods((Long)importDto.getPlanscheme());
                if (periodIds.isEmpty()) break;
                List<Long> periodSelIds = this.getPeriodSelIds();
                if (CadEmptyUtils.isEmpty(periodSelIds)) {
                    for (Long periodId : periodIds) {
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                } else {
                    for (Long periodId : periodSelIds) {
                        if (!periodIds.contains(periodId)) continue;
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                    if (importDto.getCalcPeriodMap().isEmpty()) break;
                }
                MfgFeeBasicAllocService service = new MfgFeeBasicAllocService();
                Map periodIdMap = service.getEntityBillIdsFromStatus(importDto, "cad_planbasicalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue()});
                if (periodIdMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u672a\u5206\u914d\u7684\u5355\u636e\u3002", (String)"PlanBasicAllocListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    break;
                }
                ArrayList<Long> allocIds = new ArrayList<Long>(10);
                for (List idList : periodIdMap.values()) {
                    allocIds.addAll(idList);
                }
                this.doAlloc(allocIds, this.getView().getFormShowParameter().getAppId());
                break;
            }
            case "op_confirm": {
                ids = this.getSelectIds();
                args.setCancel(true);
                if (ids.isEmpty()) {
                    importDto = this.getPageImportDto();
                    if (importDto == null) {
                        return;
                    }
                    periodIds = PlanFeeAllocHelper.getPlanStartPeriods((Long)importDto.getPlanscheme());
                    if (periodIds.isEmpty()) break;
                    List<Long> periodSelIds = this.getPeriodSelIds();
                    if (CadEmptyUtils.isEmpty(periodSelIds)) {
                        for (Long periodId : periodIds) {
                            importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                        }
                    } else {
                        for (Long periodId : periodSelIds) {
                            if (!periodIds.contains(periodId)) continue;
                            importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                        }
                        if (importDto.getCalcPeriodMap().isEmpty()) break;
                    }
                    Iterator<Object> service = new MfgFeeBasicAllocService();
                    Map periodIdMap = service.getEntityBillIdsFromStatus(importDto, "cad_planbasicalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue()});
                    if (periodIdMap.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u5df2\u5206\u914d\u7684\u5355\u636e\u3002", (String)"PlanBasicAllocListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.doConfirm(periodIdMap);
                    break;
                }
                MfgFeeBasicAllocService service = new MfgFeeBasicAllocService();
                importDto = this.getPageImportDto();
                if (importDto == null) {
                    args.setCancel(true);
                    return;
                }
                DataSet resultDs = service.getBasicProdBillByDs(ids, "cad_planbasicalloc");
                LinkedHashMap<Long, List<Long>> periodBillIdsMap = new LinkedHashMap<Long, List<Long>>();
                for (Row dyn : resultDs) {
                    periodBillIdsMap.computeIfAbsent(dyn.getLong("period"), t -> new ArrayList(10)).add(dyn.getLong("id"));
                }
                for (Long periodId : periodBillIdsMap.keySet()) {
                    importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                }
                this.doConfirm(periodBillIdsMap);
                break;
            }
            case "op_unconfirm": {
                Map periodIdMap;
                args.setCancel(true);
                MfgFeeBasicAllocService service = new MfgFeeBasicAllocService();
                importDto = this.getPageImportDto();
                if (importDto == null) {
                    return;
                }
                ids = this.getSelectIds();
                if (!ids.isEmpty()) {
                    DataSet resultDs = service.getBasicProdBillByDs(ids, "cad_planbasicalloc");
                    LinkedHashMap<Long, List<Long>> periodBillIdsMap = new LinkedHashMap<Long, List<Long>>();
                    for (Row dyn : resultDs) {
                        periodBillIdsMap.computeIfAbsent(dyn.getLong("period"), t -> new ArrayList(10)).add(dyn.getLong("id"));
                    }
                    this.doUnconfirm(periodBillIdsMap);
                    break;
                }
                periodIds = PlanFeeAllocHelper.getPlanStartPeriods((Long)importDto.getPlanscheme());
                if (periodIds.isEmpty()) break;
                List<Long> periodSelIds = this.getPeriodSelIds();
                if (CadEmptyUtils.isEmpty(periodSelIds)) {
                    for (Long periodId : periodIds) {
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                } else {
                    for (Long periodId : periodSelIds) {
                        if (!periodIds.contains(periodId)) continue;
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                    if (importDto.getCalcPeriodMap().isEmpty()) break;
                }
                if ((periodIdMap = service.getEntityBillIdsFromStatus(importDto, "cad_planbasicalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue()})).isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u5df2\u786e\u8ba4\u7684\u5355\u636e\u3002", (String)"PlanBasicAllocListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.doUnconfirm(periodIdMap);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "importcollc": {
                break;
            }
            case "op_confirm": {
                this.getView().invokeOperation("refresh", OperateOption.create());
                break;
            }
            case "op_unconfirm": {
                this.getView().invokeOperation("refresh", OperateOption.create());
                break;
            }
            case "allocation": {
                List<Long> ids;
                if (!e.getOperationResult().isSuccess() || (ids = this.getSelectIds()).isEmpty()) break;
                this.doAlloc(ids, this.getView().getFormShowParameter().getAppId());
                break;
            }
            case "allocreport": {
                String org = this.getPageCache().get(this.ORG_FIELD);
                if (org == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanBasicAllocListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                List list = (List)SerializationUtils.fromJsonString((String)org, List.class);
                String OrgId = (String)list.get(0);
                String accountId = this.getPageCache().get("costaccount");
                String planschemeId = this.getPageCache().get("planscheme");
                this.openAllocReportPage("7", OrgId, accountId, planschemeId);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        MfgFeeAllocImportParam importDto = null;
        List selectData = null;
        switch (actionId) {
            case "importselect": {
                selectData = (List)e.getReturnData();
                if (selectData == null || selectData.isEmpty()) {
                    return;
                }
                importDto = this.getPageImportDto();
                if (importDto == null) break;
                importDto.getCalcPeriodMap().putAll(this.getSelectCurrentPeriods(selectData));
                this.importCheck(importDto);
                break;
            }
            case "allocselect": {
                selectData = (List)e.getReturnData();
                if (selectData == null || selectData.isEmpty()) {
                    return;
                }
                importDto = this.getPageImportDto();
                if (importDto == null) break;
                importDto.getCalcPeriodMap().putAll(this.getSelectCurrentPeriods(selectData));
                MfgFeeBasicAllocService service = this.getService();
                Map periodIdMap = service.getEntityBillIdsFromStatus(importDto, "cad_planbasicalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue()});
                if (periodIdMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u672a\u5206\u914d\u7684\u5355\u636e\u3002", (String)"PlanBasicAllocListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    break;
                }
                ArrayList<Long> ids = new ArrayList<Long>(10);
                for (List idList : periodIdMap.values()) {
                    ids.addAll(idList);
                }
                this.doAlloc(ids, this.getView().getFormShowParameter().getAppId());
                break;
            }
            case "confirmselect": {
                selectData = (List)e.getReturnData();
                if (selectData == null || selectData.isEmpty()) {
                    return;
                }
                importDto = this.getPageImportDto();
                if (importDto == null) break;
                importDto.getCalcPeriodMap().putAll(this.getSelectCurrentPeriods(selectData));
                MfgFeeBasicAllocService service = this.getService();
                Map periodIdMap = service.getEntityBillIdsFromStatus(importDto, "cad_planbasicalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue()});
                if (periodIdMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u5df2\u5206\u914d\u7684\u5355\u636e\u3002", (String)"PlanBasicAllocListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.doConfirm(periodIdMap);
                break;
            }
            case "unconfirmselect": {
                selectData = (List)e.getReturnData();
                if (selectData == null || selectData.isEmpty()) {
                    return;
                }
                importDto = this.getPageImportDto();
                if (importDto == null) break;
                MfgFeeBasicAllocService service = this.getService();
                importDto.getCalcPeriodMap().putAll(this.getSelectCurrentPeriods(selectData));
                Map periodIdMap = service.getEntityBillIdsFromStatus(importDto, "cad_planbasicalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue()});
                importDto.getCalcPeriodMap().clear();
                for (Long periodId : periodIdMap.keySet()) {
                    importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                }
                if (periodIdMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u5df2\u786e\u8ba4\u7684\u5355\u636e\u3002", (String)"PlanBasicAllocListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.doUnconfirm(periodIdMap);
                break;
            }
        }
    }

    private void doUnconfirm(Map<Long, List<Long>> periodIdMap) {
        try {
            MfgFeeBasicAllocService service = this.getService();
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u53cd\u786e\u8ba4", (String)"PlanBasicAllocListPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                MfgAllocResult allocResult = new MfgAllocResult();
                try {
                    allocResult = service.doUnConfirmByPlanPeriod(periodIdMap, this.getView().getFormShowParameter().getAppId(), progressId, true);
                }
                catch (Exception e) {
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                String responseInfoStr = SerializationUtils.toJsonString((Object)allocResult);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), "unconfirmResult"));
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private void doConfirm(Map<Long, List<Long>> periodIdMap) {
        try {
            Long planschemeId = Long.valueOf(this.getPageCache().get("planscheme"));
            String lockErrStr = SimpleMutexHelper.planmfgCheckAndRequireXMutex((String)"planbasicConfirm", (Long)planschemeId);
            if (StringUtils.isNotEmpty((String)lockErrStr)) {
                this.getView().showErrorNotification(lockErrStr);
                return;
            }
            MfgFeeBasicAllocService service = this.getService();
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u786e\u8ba4", (String)"PlanBasicAllocListPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                MfgAllocResult allocResult = new MfgAllocResult();
                try {
                    allocResult = service.doConfirmByPlanPeriod(periodIdMap, this.getView().getFormShowParameter().getAppId(), progressId, true);
                }
                catch (Exception e) {
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                finally {
                    SimpleMutexHelper.releaseXMutex((String)"planbasicConfirm", (Object)(planschemeId + "planbasicConfirm"));
                }
                String responseInfoStr = SerializationUtils.toJsonString((Object)allocResult);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), "confirmResult"));
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private void doAlloc(List<Long> ids, String appId) {
        try {
            String planscheme = this.getPageCache().get("planscheme");
            if (CadEmptyUtils.isEmpty((String)planscheme)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u65b9\u6848\u3002", (String)"PlanBasicAllocListPlugin_18", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            Long planschemeId = Long.valueOf(this.getPageCache().get("planscheme"));
            String lockErrStr = SimpleMutexHelper.planmfgCheckAndRequireXMutex((String)"planbasicAlloc", (Long)planschemeId);
            if (StringUtils.isNotEmpty((String)lockErrStr)) {
                this.getView().showErrorNotification(lockErrStr);
                return;
            }
            MfgFeeBasicAllocService service = new MfgFeeBasicAllocService();
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d", (String)"PlanBasicAllocListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                MfgAllocResult allocResult = new MfgAllocResult();
                try {
                    allocResult = service.doAllocByPlanPeriod(ids, appId, progressId, true, Long.valueOf(Long.parseLong(planscheme)));
                }
                catch (Exception e) {
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                finally {
                    SimpleMutexHelper.releaseXMutex((String)"planbasicAlloc", (Object)(planschemeId + "planbasicAlloc"));
                }
                String responseInfoStr = SerializationUtils.toJsonString((Object)allocResult);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), "allocResult"));
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
        this.getView().invokeOperation("refresh", OperateOption.create());
    }

    private void importCheck(MfgFeeAllocImportParam importParam) {
        MfgFeeBasicAllocService allocService = new MfgFeeBasicAllocService();
        ArrayList<Long> errorAuxPeriods = new ArrayList<Long>(10);
        ArrayList<Long> errorBasicPeriods = new ArrayList<Long>(10);
        for (Long periodId : importParam.getCalcPeriodMap().keySet()) {
            importParam.setPeriod(periodId);
            if (allocService.getAuxProdBillIsAllConfirm(importParam)) {
                errorAuxPeriods.add(periodId);
                continue;
            }
            if (!allocService.isBillHasData(importParam, "cad_planbasicalloc", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) continue;
            errorBasicPeriods.add(periodId);
        }
        StringBuilder msgStr = new StringBuilder();
        if (!errorAuxPeriods.isEmpty() || !errorBasicPeriods.isEmpty()) {
            for (Long periodId : errorAuxPeriods) {
                if (msgStr.length() > 0) {
                    msgStr.append(",");
                }
                msgStr.append((String)importParam.getCalcPeriodMap().get(periodId));
            }
            if (msgStr.length() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355\u672a\u5168\u90e8\u786e\u8ba4\uff0c\u8bf7\u8fdb\u884c\u5904\u7406", (String)"PlanBasicAllocListPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]), msgStr.toString()));
                msgStr.delete(0, msgStr.length());
            }
            for (Long periodId : errorBasicPeriods) {
                if (msgStr.length() > 0) {
                    msgStr.append(",");
                }
                msgStr.append((String)importParam.getCalcPeriodMap().get(periodId));
            }
            if (msgStr.length() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5f15\u5165\u6570\u636e\u5931\u8d25\u3002\u5f53\u524d\u5206\u914d\u5355\u9700\u8981\u5168\u90e8\u53cd\u786e\u8ba4\uff0c\u624d\u80fd\u91cd\u65b0\u5f15\u5165\u6570\u636e\u3002\u8bf7\u5148\u8fdb\u884c\u53cd\u786e\u8ba4\u64cd\u4f5c\u3002", (String)"PlanBasicAllocListPlugin_17", (String)"macc-cad-formplugin", (Object[])new Object[0]), msgStr.toString()));
            }
            for (Long periodId : errorAuxPeriods) {
                importParam.getCalcPeriodMap().remove(periodId);
            }
            for (Long periodId : errorBasicPeriods) {
                importParam.getCalcPeriodMap().remove(periodId);
            }
        }
        for (Long periodId : importParam.getCalcPeriodMap().keySet()) {
            importParam.setPeriod(periodId);
            allocService.delRelateBills(importParam, Boolean.valueOf(false));
        }
        if (!importParam.getCalcPeriodMap().isEmpty()) {
            this.doImport(importParam);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes) {
            if (StringUtils.equals((String)CONFIRM_BACK, (String)e.getCallBackId())) {
                MfgFeeAllocImportParam importParam = (MfgFeeAllocImportParam)JSON.parseObject((String)this.getPageCache().get("importParams"), MfgFeeAllocImportParam.class);
                MfgFeeBasicAllocService allocService = new MfgFeeBasicAllocService();
                allocService.delRelateBills(importParam, Boolean.valueOf(false));
                this.doImport(importParam);
            } else if (StringUtils.equals((String)CONFIRMBACK_DOUNCONFIRM, (String)e.getCallBackId())) {
                OperateOption operationOption = OperateOption.create();
                operationOption.setVariableValue(CONFIRMBACK_DOUNCONFIRM, "true");
                this.getView().invokeOperation("op_unconfirm", operationOption);
            }
        }
    }

    private void doImport(MfgFeeAllocImportParam importParam) {
        String progressId = UUID.randomUUID().toString();
        MfgFeeBasicAllocService service = new MfgFeeBasicAllocService();
        Long planschemeId = Long.valueOf(this.getPageCache().get("planscheme"));
        String lockErrStr = SimpleMutexHelper.planmfgCheckAndRequireXMutex((String)"planbasicImport", (Long)planschemeId);
        if (StringUtils.isNotEmpty((String)lockErrStr)) {
            this.getView().showErrorNotification(lockErrStr);
            return;
        }
        ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"PlanBasicAllocListPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
            ArrayList<ExecuteResult> results = new ArrayList<ExecuteResult>(10);
            try {
                int index = 1;
                for (Long periodId : importParam.getCalcPeriodMap().keySet()) {
                    String periodName = (String)importParam.getCalcPeriodMap().get(periodId);
                    importParam.setPeriod(periodId);
                    ExecuteResult result = service.doImport(importParam, progressId, periodName, index++);
                    results.add(result);
                }
            }
            catch (Exception e) {
                ProgressHelper.showError((String)progressId, (String)e.getMessage());
            }
            finally {
                SimpleMutexHelper.releaseXMutex((String)"planbasicImport", (Object)(planschemeId + "planbasicImport"));
            }
            String responseInfoStr = SerializationUtils.toJsonString(results);
            this.getPageCache().put("importresponseInfo", responseInfoStr);
        }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), "importResult"));
    }

    private MfgFeeBasicAllocService getService() {
        return new MfgFeeBasicAllocService();
    }

    @Override
    protected List<ComboItem> getORGComboItemList() {
        return OrgHelper.getOrgComboItems((String)"cad_planbasicalloc", (String)"47150e89000000ac", (String)this.getView().getFormShowParameter().getAppId());
    }
}

