/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.planfeealloc;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.algox.constants.AllocResultEnum;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.output.MfgAllocResult;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MessgeBoxUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.cad.formplugin.planfeealloc.PlanOrgAndCostAccountListPlugin;

public class PlanFeeAllocBaseListPlugin
extends PlanOrgAndCostAccountListPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    public static final String CLOSEBACK_ALLOCRESULT = "allocResult";
    public static final String CLOSEBACK_CONFIRMRESULT = "confirmResult";
    public static final String CLOSEBACK_UNCONFIRMRESULT = "unconfirmResult";
    public static final String CLOSEBACK_IMPORTRESULT = "importResult";
    public static final String CLOSEBACK_IMPORTSELECT = "importselect";
    public static final String CLOSEBACK_ALLOCSELECT = "allocselect";
    public static final String CLOSEBACK_CONFIRMSELECT = "confirmselect";
    public static final String CLOSEBACK_UNCONFIRMSELECT = "unconfirmselect";
    public static final String OP_IMPORTCOLLC = "importcollc";
    public static final String OP_ALLOCATION = "allocation";
    public static final String OP_CONFIRM = "op_confirm";
    public static final String OP_UNCONFIRM = "op_unconfirm";
    public static final String KEY_REFRESH = "refresh";

    public void insertOperLog(String opType, String checkType) {
        String typeName = opType;
        switch (opType) {
            case "importcollc": {
                typeName = ResManager.loadKDString((String)"\u5f15\u5165", (String)"PlanFeeAllocBaseListPlugin_22", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                break;
            }
            case "allocation": {
                typeName = ResManager.loadKDString((String)"\u5206\u914d", (String)"PlanFeeAllocBaseListPlugin_18", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                break;
            }
            case "op_confirm": {
                typeName = ResManager.loadKDString((String)"\u786e\u8ba4", (String)"PlanFeeAllocBaseListPlugin_19", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                break;
            }
            case "op_unconfirm": {
                typeName = ResManager.loadKDString((String)"\u53cd\u786e\u8ba4", (String)"PlanFeeAllocBaseListPlugin_20", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            }
        }
        String checkName = checkType;
        switch (checkType) {
            case "00": {
                checkName = ResManager.loadKDString((String)"\u6210\u529f\u3002", (String)"PlanFeeAllocBaseListPlugin_32", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                checkName = typeName + checkName;
                break;
            }
            case "01": {
                checkName = ResManager.loadKDString((String)"\u5931\u8d25\u3002", (String)"PlanFeeAllocBaseListPlugin_33", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                checkName = typeName + checkName;
            }
        }
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)typeName, (String)checkName, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        BeforeItemClickEvent event = evt;
        Object periodIds = null;
        Long planSchemeId = null;
        Long costaccountId = null;
        List<Long> ids = null;
        block10 : switch (event.getOperationKey()) {
            case "previewvoucher": 
            case "tracevoucher": 
            case "deletevoucher": 
            case "generatevoucher": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selRowCols = billList.getSelectedRows();
                for (ListSelectedRow row : selRowCols) {
                    if (StringUtils.equals((CharSequence)"C", (CharSequence)row.getBillStatus())) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u5df2\u786e\u8ba4\u7684\u5355\u636e\u3002", (String)"PlanFeeAllocBaseListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break block10;
                }
                break;
            }
            case "importcollc": {
                if (CadEmptyUtils.isEmpty((String)this.getPageCache().get("costaccount"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f", (String)"PlanFeeAllocBaseListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                if (CadEmptyUtils.isEmpty((String)this.getPageCache().get("planscheme"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u65b9\u6848", (String)"PlanFeeAllocBaseListPlugin_31", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                planSchemeId = Long.valueOf(this.getPageCache().get("planscheme"));
                String errorMsg = PlanFeeAllocHelper.checkPlanLastEnablePeriodClosed((Long)planSchemeId);
                if (CadEmptyUtils.isEmpty((String)errorMsg)) break;
                this.getView().showTipNotification(errorMsg);
                evt.setCancel(true);
                break;
            }
            case "allocation": {
                String allocErrorMsg;
                if (CadEmptyUtils.isEmpty((String)this.getPageCache().get("costaccount"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f", (String)"PlanFeeAllocBaseListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                if (CadEmptyUtils.isEmpty((String)this.getPageCache().get("planscheme"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u65b9\u6848", (String)"PlanFeeAllocBaseListPlugin_31", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                ids = this.getSelectIds();
                planSchemeId = Long.valueOf(this.getPageCache().get("planscheme"));
                if (!ids.isEmpty() || CadEmptyUtils.isEmpty((String)(allocErrorMsg = PlanFeeAllocHelper.checkPlanLastEnablePeriodClosed((Long)planSchemeId)))) break;
                this.getView().showTipNotification(allocErrorMsg);
                evt.setCancel(true);
                break;
            }
            case "op_confirm": {
                String confirmErrorMsg;
                if (!this.permItemCheck("confirm", this.getBillEntityId(), "4730fc9f000000ad", "sca")) {
                    evt.setCancel(true);
                    return;
                }
                if (CadEmptyUtils.isEmpty((String)this.getPageCache().get("costaccount"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f", (String)"PlanFeeAllocBaseListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                if (CadEmptyUtils.isEmpty((String)this.getPageCache().get("planscheme"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u65b9\u6848", (String)"PlanFeeAllocBaseListPlugin_31", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                ids = this.getSelectIds();
                planSchemeId = Long.valueOf(this.getPageCache().get("planscheme"));
                if (!ids.isEmpty() || CadEmptyUtils.isEmpty((String)(confirmErrorMsg = PlanFeeAllocHelper.checkPlanLastEnablePeriodClosed((Long)planSchemeId)))) break;
                this.getView().showTipNotification(confirmErrorMsg);
                evt.setCancel(true);
                break;
            }
            case "op_unconfirm": {
                String unConfirmErrorMsg;
                ids = this.getSelectIds();
                if (!this.permItemCheck("unconfirm", this.getBillEntityId(), "1GPB1I7J+IT0", "sca")) {
                    evt.setCancel(true);
                    return;
                }
                if (CadEmptyUtils.isEmpty((String)this.getPageCache().get("costaccount"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f", (String)"PlanFeeAllocBaseListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                if (CadEmptyUtils.isEmpty((String)this.getPageCache().get("planscheme"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u65b9\u6848", (String)"PlanFeeAllocBaseListPlugin_31", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                costaccountId = Long.valueOf(this.getPageCache().get("costaccount"));
                planSchemeId = Long.valueOf(this.getPageCache().get("planscheme"));
                if (!ids.isEmpty() || CadEmptyUtils.isEmpty((String)(unConfirmErrorMsg = PlanFeeAllocHelper.checkPlanLastEnablePeriodClosed((Long)planSchemeId)))) break;
                this.getView().showTipNotification(unConfirmErrorMsg);
                evt.setCancel(true);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "allocResult": 
            case "confirmResult": 
            case "unconfirmResult": {
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                MfgAllocResult allocResult = (MfgAllocResult)SerializationUtils.fromJsonString((String)responseInfoStr, MfgAllocResult.class);
                String opertionName = ResManager.loadKDString((String)"\u5206\u914d", (String)"PlanFeeAllocBaseListPlugin_18", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                if (actionId.equals(CLOSEBACK_CONFIRMRESULT)) {
                    opertionName = ResManager.loadKDString((String)"\u786e\u8ba4", (String)"PlanFeeAllocBaseListPlugin_19", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                } else if (actionId.equals(CLOSEBACK_UNCONFIRMRESULT)) {
                    opertionName = ResManager.loadKDString((String)"\u53cd\u786e\u8ba4", (String)"PlanFeeAllocBaseListPlugin_20", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                }
                if (CadEmptyUtils.isEmpty((List)allocResult.getVerifyMsgs()) && (actionId.equals(CLOSEBACK_CONFIRMRESULT) || actionId.equals(CLOSEBACK_UNCONFIRMRESULT))) {
                    this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u64cd\u4f5c\u6210\u529f", (String)"PlanFeeAllocBaseListPlugin_21", (String)"macc-cad-formplugin", (Object[])new Object[0]), opertionName));
                } else {
                    PlanFeeAllocBaseListPlugin.viewAllocResult(allocResult, this.getView(), opertionName);
                }
                if (CadEmptyUtils.isEmpty((List)allocResult.getVerifyMsgs())) {
                    this.insertOperLog(opertionName, "00");
                } else {
                    this.insertOperLog(opertionName, "01");
                }
                this.getView().invokeOperation(KEY_REFRESH);
                break;
            }
            case "importResult": {
                String importResponseInfoStr = this.getPageCache().get("importresponseInfo");
                if (CadEmptyUtils.isEmpty((String)importResponseInfoStr)) {
                    return;
                }
                List results = SerializationUtils.fromJsonStringToList((String)importResponseInfoStr, ExecuteResult.class);
                StringBuilder sbSucMsg = new StringBuilder();
                ArrayList errorList = Lists.newArrayList();
                String operateName = ResManager.loadKDString((String)"\u5f15\u5165", (String)"PlanFeeAllocBaseListPlugin_22", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                for (ExecuteResult result : results) {
                    if (result.isSuccess()) {
                        String successTip = (String)result.getSuccessInfo().get("Success");
                        sbSucMsg.append(result.getPeriodName());
                        if (StringUtils.isEmpty((CharSequence)successTip)) {
                            if (result.getSuccessQty() > 0) {
                                String successMsg = ResManager.loadKDString((String)"\u6210\u529f\u751f\u6210%s\u5f20\u5355\u636e\u3002", (String)"PlanFeeAllocBaseListPlugin_23", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                                sbSucMsg.append(String.format(successMsg, result.getSuccessQty()));
                                sbSucMsg.append("\r\n");
                                continue;
                            }
                            sbSucMsg.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"PlanFeeAllocBaseListPlugin_24", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                            sbSucMsg.append("\r\n");
                            continue;
                        }
                        sbSucMsg.append(result.getPeriodName());
                        sbSucMsg.append(successTip);
                        sbSucMsg.append("\r\n");
                        continue;
                    }
                    Map.Entry info = result.getFalseInfo().entrySet().iterator().next();
                    if (result.getFalseInfo().isEmpty()) continue;
                    if ("Error".equals(info.getKey())) {
                        if (((String)info.getValue()).contains("\r\n") || ((String)info.getValue()).length() > 50) {
                            Set errorInfo = result.getErrorInfo();
                            if (!CadEmptyUtils.isEmpty((Set)errorInfo)) {
                                errorInfo.forEach(s -> errorList.add(new String[]{operateName, "Error", result.getPeriodName() + s}));
                                continue;
                            }
                            errorList.add(new String[]{operateName, "Error", result.getPeriodName() + (String)info.getValue()});
                            continue;
                        }
                        errorList.add(new String[]{operateName, "Error", result.getPeriodName() + (String)info.getValue()});
                        continue;
                    }
                    if (!"False".equals(info.getKey())) continue;
                    errorList.add(new String[]{operateName, "Info", result.getPeriodName() + (String)info.getValue()});
                }
                if (sbSucMsg.length() > 0) {
                    this.getView().showMessage(sbSucMsg.toString());
                    this.insertOperLog(OP_IMPORTCOLLC, sbSucMsg.toString());
                }
                if (!errorList.isEmpty()) {
                    MessgeBoxUtils.showDetailsMessageBox((IFormView)this.getView(), (String)operateName, (String)ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25", (String)"PlanFeeAllocBaseListPlugin_25", (String)"macc-cad-formplugin", (Object[])new Object[0]), (List)errorList);
                    this.insertOperLog(OP_IMPORTCOLLC, ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25", (String)"PlanFeeAllocBaseListPlugin_25", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
            }
        }
    }

    private void showImportPage(Long costaccount, Long planscheme, String closeBack) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("sca_matallocimport");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("costaccount", (Object)costaccount);
        fsp.setCustomParam("planscheme", (Object)planscheme);
        fsp.setCustomParam("type", (Object)"1");
        fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack));
        fsp.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u671f\u95f4", (String)"PlanFeeAllocBaseListPlugin_28", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        this.getView().showForm(fsp);
    }

    protected void openAllocReportPage(String taskname, String orgId, String accountId, String planscheme) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("cad_allocreport");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        showParameter.getCustomParams().put("taskname", taskname);
        showParameter.getCustomParams().put("orgId", orgId);
        showParameter.getCustomParams().put("accountId", accountId);
        showParameter.getCustomParams().put("isplandata", true);
        showParameter.getCustomParams().put("planscheme", planscheme);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u5212\u5206\u914d\u62a5\u544a", (String)"PlanFeeAllocBaseListPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected List<Long> getSelectIds() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        ArrayList<Long> ids = new ArrayList<Long>(rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            Long id = (Long)rows.get(i).getPrimaryKeyValue();
            if (ids.contains(id)) continue;
            ids.add(id);
        }
        return ids;
    }

    protected MfgFeeAllocImportParam getPageImportDto() {
        MfgFeeAllocImportParam importDto = new MfgFeeAllocImportParam();
        importDto.setEntityType(this.getBillEntityId());
        importDto.setAppnum(this.getView().getFormShowParameter().getAppId());
        if (CadEmptyUtils.isEmpty((String)this.getPageCache().get("costaccount"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f", (String)"PlanFeeAllocBaseListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return null;
        }
        List<Object> orgIds = this.getOrgCache();
        Long curOrgid = Long.valueOf(orgIds.get(0).toString());
        Long costaccount = Long.valueOf(this.getPageCache().get("costaccount"));
        List<Long> manuorgs = this.getSelectManuOrg(curOrgid);
        List<ComboItem> comboItems = this.getCostAccountComboItemListBy(orgIds);
        boolean isExistCostaccount = false;
        for (ComboItem item : comboItems) {
            if (!item.getValue().equals(this.getPageCache().get("costaccount"))) continue;
            isExistCostaccount = true;
            break;
        }
        if (!isExistCostaccount && CadEmptyUtils.isEmpty((String)this.getPageCache().get("costaccount"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f", (String)"PlanFeeAllocBaseListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (CadEmptyUtils.isEmpty((String)this.getPageCache().get("planscheme"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u65b9\u6848", (String)"PlanFeeAllocBaseListPlugin_31", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return null;
        }
        importDto.setOrg(curOrgid);
        importDto.setCostaccount(costaccount);
        importDto.setManuorg(manuorgs);
        importDto.setPlanscheme(Long.valueOf(this.getPageCache().get("planscheme")));
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)curOrgid);
        importDto.setEnableFactory(enableMulFactory);
        if (enableMulFactory) {
            List<Long> manuList = manuorgs.isEmpty() ? ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)curOrgid, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId()) : new ArrayList<Long>(manuorgs);
            Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)curOrgid, manuList, (String)this.getView().getFormShowParameter().getAppId());
            if (CadEmptyUtils.isEmpty((Set)centerIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u672a\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u5173\u7cfb!", (String)"PlanFeeAllocBaseListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return null;
            }
            centerIds.add(0L);
            importDto.setCostCenterIds(centerIds);
        }
        return importDto;
    }

    protected List<MfgFeeAllocImportParam> wrapImportDto(MfgFeeAllocImportParam importDto) {
        ArrayList<MfgFeeAllocImportParam> importDtos = new ArrayList<MfgFeeAllocImportParam>();
        importDtos.add(importDto);
        return importDtos;
    }

    private List<Long> getSelectManuOrg(Long orgId) {
        ArrayList<Long> manuorg = null;
        String manuorgStr = this.getPageCache().get("manuorg");
        if (StringUtils.isNotEmpty((CharSequence)manuorgStr)) {
            manuorg = JSON.parseArray((String)manuorgStr, Long.class);
        }
        if (manuorg == null || manuorg.size() == 0 || manuorg.get(0) == null) {
            manuorg = new ArrayList<Long>(16);
            for (ComboItem item : ImportServiceHelper.getPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())) {
                manuorg.add(Long.valueOf(item.getValue()));
            }
        }
        return manuorg;
    }

    public static void viewAllocResult(MfgAllocResult allocResult, IFormView view, String operateName) {
        if (allocResult.getVerifyMsgs() != null && !allocResult.getVerifyMsgs().isEmpty()) {
            if (allocResult.getVerifyMsgs().size() == 1 && ((String)allocResult.getVerifyMsgs().get(0)).length() <= 50) {
                view.showErrorNotification((String)allocResult.getVerifyMsgs().get(0));
            } else {
                ArrayList<String[]> errorList = new ArrayList<String[]>(10);
                for (String verifyMsg : allocResult.getVerifyMsgs()) {
                    errorList.add(new String[]{operateName, "Error", verifyMsg});
                }
                MessgeBoxUtils.showDetailsMessageBox((IFormView)view, (String)operateName, (String)String.format(ResManager.loadKDString((String)"%s\u5931\u8d25", (String)"PlanFeeAllocBaseListPlugin_27", (String)"macc-cad-formplugin", (Object[])new Object[0]), operateName), errorList);
            }
        }
        if (AllocResultEnum.ALLSUCCESS.getResult().equals(allocResult.getAllocStatus())) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f", (String)"PlanFeeAllocBaseListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        } else if (AllocResultEnum.PartSUCCESS.getResult().equals(allocResult.getAllocStatus())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5206\u914d\u5b8c\u6bd5\uff0c\u6709\u90e8\u5206\u5355\u636e\u5206\u914d\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u70b9\u51fb\u5206\u914d\u62a5\u544a\u67e5\u8be2\u3002", (String)"PlanFeeAllocBaseListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        } else if (AllocResultEnum.Failure.getResult().equals(allocResult.getAllocStatus())) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u70b9\u51fb\u5206\u914d\u62a5\u544a\u67e5\u8be2\u3002", (String)"PlanFeeAllocBaseListPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }

    public boolean permItemCheck(String type, String entityName, String permItemKey, String appId) {
        String tips = null;
        String opType = "";
        if (type.equals("import")) {
            opType = OP_IMPORTCOLLC;
            tips = String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u5f15\u5165\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PlanFeeAllocBaseListPlugin_34", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getTipsEntityName(entityName));
        } else if (type.equals("alloc")) {
            opType = OP_ALLOCATION;
            tips = String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u5206\u914d\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PlanFeeAllocBaseListPlugin_35", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getTipsEntityName(entityName));
        } else if (type.equals("confirm")) {
            opType = OP_CONFIRM;
            tips = String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u786e\u8ba4\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PlanFeeAllocBaseListPlugin_36", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getTipsEntityName(entityName));
        } else if (type.equals("unconfirm")) {
            opType = OP_UNCONFIRM;
            tips = String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u53cd\u786e\u8ba4\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PlanFeeAllocBaseListPlugin_37", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getTipsEntityName(entityName));
        }
        List<Object> orgIds = this.getOrgCache();
        if (orgIds == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanFeeAllocBaseListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long orgId = Long.valueOf(orgIds.get(0).toString());
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityName, (String)permItemKey);
        if (rs.hasAllOrgPerm()) {
            return true;
        }
        if (rs.getHasPermOrgs().contains(orgId)) {
            return true;
        }
        this.getView().showErrorNotification(tips);
        this.insertOperLog(opType, String.format(ResManager.loadKDString((String)"\u8d8a\u6743\u8bbf\u95ee\uff1a%s", (String)"PlanFeeAllocBaseListPlugin_38", (String)"macc-cad-formplugin", (Object[])new Object[0]), tips));
        return false;
    }

    private String getTipsEntityName(String entityName) {
        if (entityName.equals("cad_planbasicalloc")) {
            return ResManager.loadKDString((String)"\u8ba1\u5212\u57fa\u672c\u751f\u4ea7\u5206\u914d", (String)"PlanFeeAllocBaseListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        }
        if (entityName.equals("cad_planauxprodalloc")) {
            return ResManager.loadKDString((String)"\u8ba1\u5212\u8f85\u52a9\u751f\u4ea7\u5206\u914d", (String)"PlanFeeAllocBaseListPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u8ba1\u5212\u975e\u751f\u4ea7\u5206\u914d", (String)"PlanFeeAllocBaseListPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0]);
    }

    public void setFilter(SetFilterEvent e) {
        QFilter manuOrgQFilter = this.getManuOrgQFilter();
        if (manuOrgQFilter != null) {
            e.getQFilters().add(manuOrgQFilter);
        }
    }

    @Override
    protected QFilter getManuOrgQFilter() {
        String orgId;
        boolean enableMultiFactory;
        QFilter manuOrgQf = null;
        List<Object> orgIdList = this.getOrgCache();
        if (orgIdList != null && (enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(orgId = String.valueOf(orgIdList.get(0))))) && !StringUtils.isEmpty((CharSequence)orgId)) {
            List<Long> userHasPermProOrgsByAccOrg = this.getSelectManuOrg(Long.parseLong(orgId));
            if (!CadEmptyUtils.isEmpty(userHasPermProOrgsByAccOrg)) {
                userHasPermProOrgsByAccOrg.add(0L);
                manuOrgQf = new QFilter("manuorg", "in", userHasPermProOrgsByAccOrg);
            } else {
                manuOrgQf = new QFilter("manuorg", "=", (Object)0L);
            }
        }
        return manuOrgQf;
    }

    protected Map<Long, String> getSelectCurrentPeriods(List<DynamicObject> returnDatas) {
        LinkedHashMap<Long, String> hashMap = new LinkedHashMap<Long, String>();
        List<DynamicObject> allocSelectData = returnDatas;
        for (DynamicObject data : allocSelectData) {
            DynamicObject currentperiod = data.getDynamicObject("currentperiod");
            if (currentperiod == null) continue;
            hashMap.put(currentperiod.getLong("id"), currentperiod.getString("name"));
        }
        return hashMap;
    }

    protected String getPeriodName(Long periodId) {
        DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
        if (periodDyn != null) {
            return periodDyn.getString("name");
        }
        return "";
    }

    protected List<Long> getPeriodSelIds() {
        Long periodSelId;
        ArrayList<Long> periodSelIds = new ArrayList<Long>(10);
        if (!CadEmptyUtils.isEmpty((String)this.getPageCache().get("periodmul"))) {
            List list = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("periodmul"), List.class);
            if (!CadEmptyUtils.isEmpty((List)list)) {
                for (String period : list) {
                    if (CadEmptyUtils.isEmpty((String)period)) continue;
                    periodSelIds.add(Long.valueOf(period));
                }
            }
        } else if (!CadEmptyUtils.isEmpty((String)this.getPageCache().get("period")) && !CadEmptyUtils.isEmpty((Long)(periodSelId = Long.valueOf(this.getPageCache().get("period"))))) {
            periodSelIds.add(periodSelId);
        }
        return periodSelIds;
    }
}

