/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.planfeealloc;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.business.feealloc.MfgFeeAuxProdAllocService;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.output.MfgAllocResult;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.planfeealloc.PlanFeeAllocBaseListPlugin;

public class PlanFeeAuxProdAllocListPlugin
extends PlanFeeAllocBaseListPlugin {
    private static final String CONFIRMBACK_DOIMPORT = "do_import";
    private static final String CONFIRMBACK_DOUNCONFIRM = "do_unconfirm";
    private static final String KEY_IMPORT_JSON = "importdtos";

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("period desc,billno asc");
        if (AppIdHelper.isMacc((IFormView)this.getView())) {
            e.getQFilters().add(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        List periodIds = null;
        MfgFeeAllocImportParam importDto = null;
        List<Long> ids = null;
        switch (operate.getOperateKey()) {
            case "importcollc": {
                importDto = this.getPageImportDto();
                if (importDto == null) {
                    args.setCancel(true);
                    return;
                }
                periodIds = PlanFeeAllocHelper.getPlanStartPeriods((Long)importDto.getPlanscheme());
                if (periodIds.isEmpty()) break;
                args.setCancel(true);
                List<Long> periodSelIds = this.getPeriodSelIds();
                if (CadEmptyUtils.isEmpty(periodSelIds)) {
                    for (Long periodId : periodIds) {
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                } else {
                    for (Long periodId : periodSelIds) {
                        if (!periodIds.contains(periodId)) continue;
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                    if (importDto.getCalcPeriodMap().isEmpty()) break;
                }
                this.doSearchImport(importDto);
                break;
            }
            case "allocation": {
                MfgFeeAuxProdAllocService service;
                Map periodIdMap;
                ids = this.getSelectIds();
                if (!ids.isEmpty()) break;
                args.setCancel(true);
                importDto = this.getPageImportDto();
                if (importDto == null) {
                    return;
                }
                periodIds = PlanFeeAllocHelper.getPlanStartPeriods((Long)importDto.getPlanscheme());
                if (periodIds.isEmpty()) break;
                List<Long> periodSelIds = this.getPeriodSelIds();
                if (CadEmptyUtils.isEmpty(periodSelIds)) {
                    for (Long periodId : periodIds) {
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                } else {
                    for (Long periodId : periodSelIds) {
                        if (!periodIds.contains(periodId)) continue;
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                    if (importDto.getCalcPeriodMap().isEmpty()) {
                        return;
                    }
                }
                if ((periodIdMap = (service = this.getService()).getEntityBillIdsFromStatus(importDto, "cad_planauxprodalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue()})).isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u672a\u5206\u914d\u7684\u5355\u636e\u3002", (String)"PlanFeeAuxProdAllocListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    break;
                }
                ArrayList<Long> allocIds = new ArrayList<Long>(10);
                for (List idList : periodIdMap.values()) {
                    allocIds.addAll(idList);
                }
                this.doAlloc(allocIds);
                break;
            }
            case "op_confirm": {
                Map periodIdMap;
                Long periodId;
                Iterator<Object> service;
                ids = this.getSelectIds();
                if (!ids.isEmpty()) break;
                args.setCancel(true);
                importDto = this.getPageImportDto();
                if (importDto == null) {
                    return;
                }
                periodIds = PlanFeeAllocHelper.getPlanStartPeriods((Long)importDto.getPlanscheme());
                if (periodIds.isEmpty()) break;
                List<Long> periodSelIds = this.getPeriodSelIds();
                if (CadEmptyUtils.isEmpty(periodSelIds)) {
                    service = periodIds.iterator();
                    while (service.hasNext()) {
                        periodId = (Long)service.next();
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                } else {
                    service = periodSelIds.iterator();
                    while (service.hasNext()) {
                        periodId = (Long)service.next();
                        if (!periodIds.contains(periodId)) continue;
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                    if (importDto.getCalcPeriodMap().isEmpty()) break;
                }
                if ((periodIdMap = (service = this.getService()).getEntityBillIdsFromStatus(importDto, "cad_planauxprodalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue()})).isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u5df2\u5206\u914d\u7684\u5355\u636e\u3002", (String)"PlanFeeAuxProdAllocListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    break;
                }
                ArrayList allocIds = new ArrayList(10);
                for (List idList : periodIdMap.values()) {
                    allocIds.addAll(idList);
                }
                List errorMsgs = service.doSelectConfirm(allocIds, this.getView().getFormShowParameter().getAppId(), "cad_planauxprodalloc");
                this.showErrorMsg(errorMsgs);
                if (errorMsgs == null || errorMsgs.size() == 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u201c\u786e\u8ba4\u201d\u6210\u529f\u3002", (String)"PlanFeeAuxProdAllocListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    this.insertOperLog("op_confirm", "00");
                } else {
                    this.insertOperLog("op_confirm", "01");
                }
                this.getView().invokeOperation("refresh", OperateOption.create());
                break;
            }
            case "op_unconfirm": {
                MfgFeeAuxProdAllocService service = this.getService();
                importDto = this.getPageImportDto();
                args.setCancel(true);
                if (importDto == null) {
                    return;
                }
                ids = this.getSelectIds();
                if (!ids.isEmpty()) {
                    DynamicObjectCollection cols = service.getAuxProdBill(ids, "cad_planauxprodalloc");
                    LinkedHashMap<Long, List<Long>> periodBillIdsMap = new LinkedHashMap<Long, List<Long>>();
                    for (DynamicObject dyn : cols) {
                        periodBillIdsMap.computeIfAbsent(dyn.getLong("period"), t -> new ArrayList(10)).add(dyn.getLong("id"));
                    }
                    for (Long periodId : periodBillIdsMap.keySet()) {
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                    this.doSearchUnConfirm(importDto, periodBillIdsMap);
                    break;
                }
                periodIds = PlanFeeAllocHelper.getPlanStartPeriods((Long)importDto.getPlanscheme());
                if (periodIds.isEmpty()) break;
                List<Long> periodSelIds = this.getPeriodSelIds();
                if (CadEmptyUtils.isEmpty(periodSelIds)) {
                    for (Long periodId : periodIds) {
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                } else {
                    for (Long periodId : periodSelIds) {
                        if (!periodIds.contains(periodId)) continue;
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                    if (importDto.getCalcPeriodMap().isEmpty()) break;
                }
                Map periodIdMap = service.getEntityBillIdsFromStatus(importDto, "cad_planauxprodalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue()});
                importDto.getCalcPeriodMap().clear();
                for (Long periodId : periodIdMap.keySet()) {
                    importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                }
                if (periodIdMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u5df2\u786e\u8ba4\u7684\u5355\u636e\u3002", (String)"PlanFeeAuxProdAllocListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                this.doSearchUnConfirm(importDto, periodIdMap);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        switch (e.getOperateKey()) {
            case "importcollc": {
                break;
            }
            case "allocation": {
                if (!e.getOperationResult().isSuccess()) break;
                if (!this.permItemCheck("alloc", "cad_planauxprodalloc", "80513208000000ac", appId)) {
                    return;
                }
                this.doAllocOperation(e);
                this.getView().invokeOperation("refresh", OperateOption.create());
                break;
            }
            case "op_confirm": {
                MfgFeeAuxProdAllocService service = this.getService();
                List errorMsgs = service.doSelectConfirm(this.getSelectIds(), this.getView().getFormShowParameter().getAppId(), "cad_planauxprodalloc");
                this.showErrorMsg(errorMsgs);
                if (errorMsgs == null || errorMsgs.size() == 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u201c\u786e\u8ba4\u201d\u6210\u529f\u3002", (String)"PlanFeeAuxProdAllocListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation("refresh", OperateOption.create());
                break;
            }
            case "op_unconfirm": {
                break;
            }
            case "allocreport": {
                String org = this.getPageCache().get(this.ORG_FIELD);
                if (org == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanFeeAuxProdAllocListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                List list = (List)SerializationUtils.fromJsonString((String)org, List.class);
                String OrgId = (String)list.get(0);
                String accountId = this.getPageCache().get("costaccount");
                String planschemeId = this.getPageCache().get("planscheme");
                this.openAllocReportPage("6", OrgId, accountId, planschemeId);
            }
        }
    }

    private void showErrorMsg(List<String> errorMsgs) {
        if (errorMsgs != null && !errorMsgs.isEmpty()) {
            if (errorMsgs.size() == 1) {
                this.getView().showErrorNotification(errorMsgs.get(0));
            } else {
                StringBuilder sb = new StringBuilder();
                errorMsgs.forEach(t -> sb.append((String)t).append("\r\n"));
                this.getView().showMessage(sb.toString());
            }
        }
    }

    private void doAllocOperation(AfterDoOperationEventArgs e) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        if (rows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u914d\u64cd\u4f5c\u524d\uff0c\u8bf7\u5148\u6309\u6761\u4ef6\u67e5\u8be2\u51fa\u6570\u636e", (String)"PlanFeeAuxProdAllocListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> ids = this.getSelectIds();
        if (!ids.isEmpty()) {
            this.doAlloc(ids);
        }
    }

    private void doAlloc(List<Long> ids) {
        MfgFeeAuxProdAllocService service = this.getService();
        String progressId = UUID.randomUUID().toString();
        Long planschemeId = Long.valueOf(this.getPageCache().get("planscheme"));
        String lockErrStr = SimpleMutexHelper.planmfgCheckAndRequireXMutex((String)"planauxAlloc", (Long)planschemeId);
        if (StringUtils.isNotEmpty((CharSequence)lockErrStr)) {
            this.getView().showErrorNotification(lockErrStr);
            return;
        }
        if (ids == null) {
            MfgFeeAllocImportParam importDto = this.getPageImportDto();
            if (importDto == null) {
                SimpleMutexHelper.releaseXMutex((String)"planauxAlloc", (Object)(planschemeId + "planauxAlloc"));
                return;
            }
            ArrayList<MfgFeeAllocImportParam> importDtos = new ArrayList<MfgFeeAllocImportParam>();
            importDtos.add(importDto);
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d", (String)"PlanFeeAuxProdAllocListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                MfgAllocResult allocResult = new MfgAllocResult();
                try {
                    allocResult = service.doAlloc(importDtos, progressId, true);
                }
                catch (Exception e) {
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                finally {
                    SimpleMutexHelper.releaseXMutex((String)"planauxAlloc", (Object)(planschemeId + "planauxAlloc"));
                }
                String responseInfoStr = SerializationUtils.toJsonString((Object)allocResult);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), "allocResult"));
        } else {
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d", (String)"PlanFeeAuxProdAllocListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                MfgAllocResult allocResult = new MfgAllocResult();
                try {
                    allocResult = service.doSelectAlloc(ids, this.getView().getFormShowParameter().getAppId(), progressId, true);
                }
                catch (Exception e) {
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                finally {
                    SimpleMutexHelper.releaseXMutex((String)"planauxAlloc", (Object)(planschemeId + "planauxAlloc"));
                }
                String responseInfoStr = SerializationUtils.toJsonString((Object)allocResult);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), "allocResult"));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        this.getView().hideLoading();
        String actionId = e.getActionId();
        MfgFeeAllocImportParam importDto = null;
        List selectData = null;
        switch (actionId) {
            case "importselect": {
                selectData = (List)e.getReturnData();
                if (selectData == null || selectData.isEmpty()) {
                    return;
                }
                importDto = this.getPageImportDto();
                if (importDto == null) break;
                importDto.getCalcPeriodMap().putAll(this.getSelectCurrentPeriods(selectData));
                this.doSearchImport(importDto);
                break;
            }
            case "allocselect": {
                selectData = (List)e.getReturnData();
                if (selectData == null || selectData.isEmpty()) {
                    return;
                }
                importDto = this.getPageImportDto();
                if (importDto == null) break;
                importDto.getCalcPeriodMap().putAll(this.getSelectCurrentPeriods(selectData));
                MfgFeeAuxProdAllocService service = this.getService();
                Map periodIdMap = service.getEntityBillIdsFromStatus(importDto, "cad_planauxprodalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue()});
                if (periodIdMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u672a\u5206\u914d\u7684\u5355\u636e\u3002", (String)"PlanFeeAuxProdAllocListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    break;
                }
                ArrayList<Long> ids = new ArrayList<Long>(10);
                for (List idList : periodIdMap.values()) {
                    ids.addAll(idList);
                }
                this.doAlloc(ids);
                break;
            }
            case "confirmselect": {
                selectData = (List)e.getReturnData();
                if (selectData == null || selectData.isEmpty()) {
                    return;
                }
                importDto = this.getPageImportDto();
                if (importDto == null) break;
                importDto.getCalcPeriodMap().putAll(this.getSelectCurrentPeriods(selectData));
                MfgFeeAuxProdAllocService service = this.getService();
                Map periodIdMap = service.getEntityBillIdsFromStatus(importDto, "cad_planauxprodalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue()});
                if (periodIdMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u5df2\u5206\u914d\u7684\u5355\u636e\u3002", (String)"PlanFeeAuxProdAllocListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    break;
                }
                ArrayList ids = new ArrayList(10);
                for (List periodIds : periodIdMap.values()) {
                    ids.addAll(periodIds);
                }
                List errorMsgs = service.doSelectConfirm(ids, this.getView().getFormShowParameter().getAppId(), "cad_planauxprodalloc");
                this.showErrorMsg(errorMsgs);
                if (errorMsgs == null || errorMsgs.isEmpty()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u201c\u786e\u8ba4\u201d\u6210\u529f\u3002", (String)"PlanFeeAuxProdAllocListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation("refresh", OperateOption.create());
                break;
            }
            case "unconfirmselect": {
                selectData = (List)e.getReturnData();
                if (selectData == null || selectData.isEmpty()) {
                    return;
                }
                importDto = this.getPageImportDto();
                if (importDto == null) break;
                MfgFeeAuxProdAllocService service = this.getService();
                importDto.getCalcPeriodMap().putAll(this.getSelectCurrentPeriods(selectData));
                Map periodIdMap = service.getEntityBillIdsFromStatus(importDto, "cad_planauxprodalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue()});
                importDto.getCalcPeriodMap().clear();
                for (Long periodId : periodIdMap.keySet()) {
                    importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                }
                if (periodIdMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u5df2\u786e\u8ba4\u7684\u5355\u636e\u3002", (String)"PlanFeeAuxProdAllocListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.doSearchUnConfirm(importDto, periodIdMap);
                break;
            }
        }
    }

    private void doSearchUnConfirm(MfgFeeAllocImportParam importDto, Map<Long, List<Long>> periodIdMap) {
        MfgFeeAuxProdAllocService service = this.getService();
        ArrayList<Object> errorBacicPeriods = new ArrayList<Object>(10);
        for (Object periodId : importDto.getCalcPeriodMap().keySet()) {
            importDto.setPeriod((Long)periodId);
            if (!service.isBillHasData(importDto, "cad_basicalloc", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) continue;
            errorBacicPeriods.add(periodId);
        }
        StringBuilder msgStr = new StringBuilder();
        if (!errorBacicPeriods.isEmpty()) {
            for (Object periodId : errorBacicPeriods) {
                if (msgStr.length() > 0) {
                    msgStr.append(",");
                }
                msgStr.append((String)importDto.getCalcPeriodMap().get(periodId));
                periodIdMap.remove(periodId);
            }
            if (msgStr.length() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u53cd\u786e\u8ba4\u5931\u8d25\u3002\u4e0b\u6e38\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u5df2\u7ecf\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", (String)"PlanFeeAuxProdAllocListPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]), msgStr.toString()));
            }
        }
        if (periodIdMap.isEmpty()) {
            return;
        }
        ArrayList ids = new ArrayList(10);
        for (List list : periodIdMap.values()) {
            ids.addAll(list);
        }
        List errorMsgs1 = service.doSelectUnConfirm(ids, this.getView().getFormShowParameter().getAppId(), "cad_planauxprodalloc");
        this.showErrorMsg(errorMsgs1);
        if (errorMsgs1 == null || errorMsgs1.isEmpty()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u201c\u53cd\u786e\u8ba4\u201d\u6210\u529f\u3002", (String)"PlanFeeAuxProdAllocListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            this.insertOperLog("op_unconfirm", "00");
        } else {
            this.insertOperLog("op_unconfirm", "01");
        }
        this.getView().invokeOperation("refresh", OperateOption.create());
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes) {
            if (StringUtils.equals((CharSequence)CONFIRMBACK_DOIMPORT, (CharSequence)e.getCallBackId())) {
                MfgFeeAllocImportParam importDto = (MfgFeeAllocImportParam)JSON.parseObject((String)this.getPageCache().get(KEY_IMPORT_JSON), MfgFeeAllocImportParam.class);
                MfgFeeAuxProdAllocService service = this.getService();
                service.deleteAuxProdAndRelaBills(importDto, true);
                this.doImport(importDto);
            } else if (StringUtils.equals((CharSequence)CONFIRMBACK_DOUNCONFIRM, (CharSequence)e.getCallBackId())) {
                OperateOption operationOption = OperateOption.create();
                operationOption.setVariableValue(CONFIRMBACK_DOUNCONFIRM, "true");
                this.getView().invokeOperation("op_unconfirm", operationOption);
            }
        }
    }

    private void doSearchImport(MfgFeeAllocImportParam importDto) {
        MfgFeeAuxProdAllocService service = this.getService();
        ArrayList<Long> errorPeriods = new ArrayList<Long>(10);
        for (Long periodId : importDto.getCalcPeriodMap().keySet()) {
            importDto.setPeriod(periodId);
            if (service.isBillHasData(importDto, "cad_planauxprodalloc", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) {
                errorPeriods.add(periodId);
                continue;
            }
            service.deleteAuxProdAndRelaBills(importDto, true);
        }
        StringBuilder msgStr = new StringBuilder();
        if (!errorPeriods.isEmpty()) {
            for (Long periodId : errorPeriods) {
                if (msgStr.length() > 0) {
                    msgStr.append(",");
                }
                String periodName = (String)importDto.getCalcPeriodMap().remove(periodId);
                msgStr.append(periodName);
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5f15\u5165\u6570\u636e\u5931\u8d25\u3002\u5f53\u524d\u5206\u914d\u5355\u9700\u8981\u5168\u90e8\u53cd\u786e\u8ba4\uff0c\u624d\u80fd\u91cd\u65b0\u5f15\u5165\u6570\u636e\u3002\u8bf7\u5148\u8fdb\u884c\u53cd\u786e\u8ba4\u64cd\u4f5c\u3002", (String)"PlanFeeAuxProdAllocListPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0]), msgStr.toString()));
        }
        if (!importDto.getCalcPeriodMap().isEmpty()) {
            this.doImport(importDto);
        }
    }

    private void doImport(MfgFeeAllocImportParam importDto) {
        if (importDto == null) {
            return;
        }
        Long planschemeId = Long.valueOf(this.getPageCache().get("planscheme"));
        String lockErrStr = SimpleMutexHelper.planmfgCheckAndRequireXMutex((String)"planauxImport", (Long)planschemeId);
        if (StringUtils.isNotEmpty((CharSequence)lockErrStr)) {
            this.getView().showErrorNotification(lockErrStr);
            return;
        }
        MfgFeeAuxProdAllocService service = this.getService();
        String progressId = UUID.randomUUID().toString();
        ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"PlanFeeAuxProdAllocListPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
            ArrayList<ExecuteResult> results = new ArrayList<ExecuteResult>(10);
            try {
                int index = 1;
                for (Long periodId : importDto.getCalcPeriodMap().keySet()) {
                    importDto.setPeriod(periodId);
                    String periodName = (String)importDto.getCalcPeriodMap().get(periodId);
                    ExecuteResult result = service.feeAllocAuxProdImport(importDto, progressId, periodName, index++);
                    result.setPeriodName(periodName);
                    results.add(result);
                }
            }
            catch (Exception e) {
                ProgressHelper.showError((String)progressId, (String)e.getMessage());
            }
            finally {
                SimpleMutexHelper.releaseXMutex((String)"planauxImport", (Object)(planschemeId + "planauxImport"));
            }
            String responseInfoStr = SerializationUtils.toJsonString(results);
            this.getPageCache().put("importresponseInfo", responseInfoStr);
        }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), "importResult"));
    }

    private MfgFeeAuxProdAllocService getService() {
        return new MfgFeeAuxProdAllocService();
    }

    @Override
    protected List<ComboItem> getORGComboItemList() {
        return OrgHelper.getOrgComboItems((String)"cad_planauxprodalloc", (String)"47150e89000000ac", (String)this.getView().getFormShowParameter().getAppId());
    }
}

