/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.planfeealloc;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.macc.cad.business.feealloc.MfgFeeNonProdAllocService;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.output.MfgAllocResult;
import kd.macc.cad.formplugin.feealloc.MfgAllocBaseListPlugin;
import kd.macc.cad.formplugin.planfeealloc.PlanFeeAllocBaseEditPlugin;
import org.apache.commons.lang.StringUtils;

public class PlanFeeNonProdAllocEditPlugin
extends PlanFeeAllocBaseEditPlugin {
    private static final String KEY_REFRESH = "refresh";
    private static final String KEY_IS_AUTOALLOC = "isAutoAlloc";
    private static final String CONFIRMBACK_DOUNCONFIRM = "do_unconfirm";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "op_unconfirm": {
                MfgFeeNonProdAllocService service = new MfgFeeNonProdAllocService();
                MfgFeeAllocImportParam importDto = this.getPageImportDto();
                if (importDto == null) {
                    args.setCancel(true);
                    return;
                }
                if (service.isBillHasData(importDto, "cad_planauxprodalloc", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53cd\u786e\u8ba4\u5931\u8d25\u3002\u4e0b\u6e38\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355\u5df2\u7ecf\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", (String)"PlanFeeNonProdAllocEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (!service.isBillHasData(importDto, "cad_planbasicalloc", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53cd\u786e\u8ba4\u5931\u8d25\u3002\u4e0b\u6e38\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u5df2\u7ecf\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", (String)"PlanFeeNonProdAllocEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    @Override
    public MfgFeeAllocImportParam getPageImportDto() {
        MfgFeeAllocImportParam param = new MfgFeeAllocImportParam();
        param.setOrg(Long.valueOf(this.getModel().getDataEntity().getLong("org.id")));
        param.setCostaccount(Long.valueOf(this.getModel().getDataEntity().getLong("costaccount.id")));
        param.setPeriod(Long.valueOf(this.getModel().getDataEntity().getLong("period.id")));
        param.setPlanscheme(Long.valueOf(this.getModel().getDataEntity().getLong("planscheme.id")));
        Long manuorg = this.getModel().getDataEntity().getLong("manuorg.id");
        if (manuorg == 0L) {
            param.setEnableFactory(false);
        } else {
            param.setEnableFactory(true);
        }
        if (param.isEnableFactory()) {
            param.setCostCenterIds(OrgHelper.getCenterIdsByManuOrgIds((Long)param.getOrg(), (List)param.getManuorg(), (String)"sca"));
        }
        param.setEntityType(this.getView().getEntityId());
        return param;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        switch (e.getOperateKey()) {
            case "op_confirm": 
            case "op_unconfirm": {
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                break;
            }
            case "allocation": {
                Long id = this.getModel().getDataEntity().getLong("id");
                ArrayList<Long> ids = new ArrayList<Long>();
                ids.add(id);
                this.doAlloc(ids);
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
            }
        }
    }

    public void afterBindData(EventObject e) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            return;
        }
        super.afterBindData(e);
        this.setManuOrg();
        String allocstatus = this.getModel().getDataEntity().getString("allocstatus");
        Long id = this.getModel().getDataEntity().getLong("id");
        String cacheId = this.getPageCache().get(KEY_IS_AUTOALLOC);
        if (ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue().equals(allocstatus) && (cacheId == null || !StringUtils.equals((String)id.toString(), (String)cacheId))) {
            this.getPageCache().put(KEY_IS_AUTOALLOC, id.toString());
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(id);
            this.doAlloc(ids);
            this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes && StringUtils.equals((String)CONFIRMBACK_DOUNCONFIRM, (String)e.getCallBackId())) {
            OperateOption operationOption = OperateOption.create();
            operationOption.setVariableValue(CONFIRMBACK_DOUNCONFIRM, "true");
            this.getView().invokeOperation("op_unconfirm", operationOption);
        }
    }

    private void setManuOrg() {
        String costAccount = this.getModel().getDataEntity().getString("costaccount.id");
        boolean enableMulFactory = costAccount != null && CostAccountHelper.isEnableMulFactory((Long)Long.valueOf(costAccount));
        this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
    }

    private void doAlloc(List<Long> ids) {
        try {
            MfgFeeNonProdAllocService service = new MfgFeeNonProdAllocService();
            MfgAllocResult allocResult = service.doAlloc(ids, this.getView().getFormShowParameter().getAppId(), null, true, Long.valueOf(this.getModel().getDataEntity().getLong("planscheme.id")));
            MfgAllocBaseListPlugin.viewAllocResult(allocResult, this.getView());
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }
}

