/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.planfeealloc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.business.feealloc.MfgFeeNonProdAllocService;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.output.MfgAllocResult;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.planfeealloc.PlanFeeAllocBaseListPlugin;

public class PlanFeeNonProdAllocListPlugin
extends PlanFeeAllocBaseListPlugin {
    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("period desc,billno asc");
        if (AppIdHelper.isMacc((IFormView)this.getView())) {
            e.getQFilters().add(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        List periodIds = null;
        Long planschemeId = null;
        MfgFeeAllocImportParam importDto = null;
        List<Long> ids = null;
        switch (operate.getOperateKey()) {
            case "importcollc": {
                importDto = this.getPageImportDto();
                if (importDto == null) {
                    args.setCancel(true);
                    return;
                }
                planschemeId = Long.valueOf(this.getPageCache().get("planscheme"));
                periodIds = PlanFeeAllocHelper.getPlanStartPeriods((Long)planschemeId);
                if (periodIds.isEmpty()) break;
                args.setCancel(true);
                List<Long> periodSelIds = this.getPeriodSelIds();
                if (CadEmptyUtils.isEmpty(periodSelIds)) {
                    for (Long periodId : periodIds) {
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                } else {
                    for (Long periodId : periodSelIds) {
                        if (!periodIds.contains(periodId)) continue;
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                    if (importDto.getCalcPeriodMap().isEmpty()) break;
                }
                this.doSearchImport(importDto);
                break;
            }
            case "allocation": {
                ids = this.getSelectIds();
                if (!ids.isEmpty()) break;
                args.setCancel(true);
                importDto = this.getPageImportDto();
                if (importDto == null) {
                    args.setCancel(true);
                    return;
                }
                planschemeId = Long.valueOf(this.getPageCache().get("planscheme"));
                periodIds = PlanFeeAllocHelper.getPlanStartPeriods((Long)planschemeId);
                if (periodIds.isEmpty()) break;
                args.setCancel(true);
                List<Long> periodSelIds = this.getPeriodSelIds();
                if (CadEmptyUtils.isEmpty(periodSelIds)) {
                    for (Long periodId : periodIds) {
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                } else {
                    for (Long periodId : periodSelIds) {
                        if (!periodIds.contains(periodId)) continue;
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                    if (importDto.getCalcPeriodMap().isEmpty()) {
                        return;
                    }
                }
                MfgFeeNonProdAllocService service = this.getService();
                Map periodIdMap = service.getEntityBillIdsFromStatus(importDto, "cad_plannonprodalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue()});
                if (periodIdMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u672a\u5206\u914d\u7684\u5355\u636e\u3002", (String)"PlanFeeNonProdAllocListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    break;
                }
                ArrayList<Long> allocIds = new ArrayList<Long>(10);
                for (List idList : periodIdMap.values()) {
                    allocIds.addAll(idList);
                }
                this.doAlloc(allocIds);
                break;
            }
            case "op_confirm": {
                ids = this.getSelectIds();
                args.setCancel(true);
                if (ids.isEmpty()) {
                    importDto = this.getPageImportDto();
                    if (importDto == null) {
                        return;
                    }
                    planschemeId = Long.valueOf(this.getPageCache().get("planscheme"));
                    periodIds = PlanFeeAllocHelper.getPlanStartPeriods((Long)planschemeId);
                    if (periodIds.isEmpty()) break;
                    List<Long> periodSelIds = this.getPeriodSelIds();
                    if (CadEmptyUtils.isEmpty(periodSelIds)) {
                        for (Long periodId : periodIds) {
                            importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                        }
                    } else {
                        for (Long periodId : periodSelIds) {
                            if (!periodIds.contains(periodId)) continue;
                            importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                        }
                        if (importDto.getCalcPeriodMap().isEmpty()) break;
                    }
                    Iterator<Object> service = this.getService();
                    Map periodIdMap = service.getEntityBillIdsFromStatus(importDto, "cad_plannonprodalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue()});
                    if (periodIdMap.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u5df2\u5206\u914d\u7684\u5355\u636e\u3002", (String)"PlanFeeNonProdAllocListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.doConfirm(periodIdMap);
                    break;
                }
                MfgFeeNonProdAllocService service = this.getService();
                importDto = this.getPageImportDto();
                if (importDto == null) {
                    return;
                }
                DataSet resultDs = service.getNonProdBillByDs(ids, "cad_plannonprodalloc");
                LinkedHashMap<Long, List<Long>> periodBillIdsMap = new LinkedHashMap<Long, List<Long>>();
                for (Row dyn : resultDs) {
                    periodBillIdsMap.computeIfAbsent(dyn.getLong("period"), t -> new ArrayList(10)).add(dyn.getLong("id"));
                }
                for (Long periodId : periodBillIdsMap.keySet()) {
                    importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                }
                this.doConfirm(periodBillIdsMap);
                break;
            }
            case "op_unconfirm": {
                MfgFeeNonProdAllocService service = this.getService();
                importDto = this.getPageImportDto();
                if (importDto == null) {
                    args.setCancel(true);
                    return;
                }
                ids = this.getSelectIds();
                if (!ids.isEmpty()) {
                    DataSet resultDs = service.getNonProdBillByDs(ids, "cad_plannonprodalloc");
                    LinkedHashMap<Long, List<Long>> periodBillIdsMap = new LinkedHashMap<Long, List<Long>>();
                    for (Row dyn : resultDs) {
                        periodBillIdsMap.computeIfAbsent(dyn.getLong("period"), t -> new ArrayList(10)).add(dyn.getLong("id"));
                    }
                    for (Long periodId : periodBillIdsMap.keySet()) {
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                    this.doSearchUnConfirm(importDto, periodBillIdsMap);
                } else {
                    periodIds = PlanFeeAllocHelper.getPlanStartPeriods((Long)importDto.getPlanscheme());
                    if (!periodIds.isEmpty()) {
                        args.setCancel(true);
                        List<Long> periodSelIds = this.getPeriodSelIds();
                        if (CadEmptyUtils.isEmpty(periodSelIds)) {
                            for (Long periodId : periodIds) {
                                importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                            }
                        } else {
                            for (Long periodId : periodSelIds) {
                                if (!periodIds.contains(periodId)) continue;
                                importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                            }
                            if (importDto.getCalcPeriodMap().isEmpty()) break;
                        }
                        Map periodIdMap = service.getEntityBillIdsFromStatus(importDto, "cad_plannonprodalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue()});
                        importDto.getCalcPeriodMap().clear();
                        for (Long periodId : periodIdMap.keySet()) {
                            importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                        }
                        if (periodIdMap.isEmpty()) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u5df2\u786e\u8ba4\u7684\u5355\u636e\u3002", (String)"PlanFeeNonProdAllocListPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            break;
                        }
                        this.doSearchUnConfirm(importDto, periodIdMap);
                    }
                }
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        switch (e.getOperateKey()) {
            case "op_confirm": 
            case "op_unconfirm": {
                this.getView().invokeOperation("refresh", OperateOption.create());
                break;
            }
            case "allocation": {
                List<Long> ids;
                if (!e.getOperationResult().isSuccess() || (ids = this.getSelectIds()).isEmpty()) break;
                this.doAlloc(ids);
                break;
            }
            case "allocreport": {
                String org = this.getPageCache().get(this.ORG_FIELD);
                if (org == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanFeeNonProdAllocListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                List list = (List)SerializationUtils.fromJsonString((String)org, List.class);
                String OrgId = (String)list.get(0);
                String accountId = this.getPageCache().get("costaccount");
                String planschemeId = this.getPageCache().get("planscheme");
                this.openAllocReportPage("5", OrgId, accountId, planschemeId);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        MfgFeeAllocImportParam importDto = null;
        List selectData = null;
        switch (actionId) {
            case "importselect": {
                selectData = (List)e.getReturnData();
                if (selectData == null || selectData.isEmpty()) {
                    return;
                }
                importDto = this.getPageImportDto();
                if (importDto == null) break;
                importDto.getCalcPeriodMap().putAll(this.getSelectCurrentPeriods(selectData));
                this.doSearchImport(importDto);
                break;
            }
            case "allocselect": {
                selectData = (List)e.getReturnData();
                if (selectData == null || selectData.isEmpty()) {
                    return;
                }
                importDto = this.getPageImportDto();
                if (importDto == null) break;
                importDto.getCalcPeriodMap().putAll(this.getSelectCurrentPeriods(selectData));
                MfgFeeNonProdAllocService service = this.getService();
                Map periodIdMap = service.getEntityBillIdsFromStatus(importDto, "cad_plannonprodalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue()});
                if (periodIdMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u672a\u5206\u914d\u7684\u5355\u636e\u3002", (String)"PlanFeeNonProdAllocListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    break;
                }
                ArrayList<Long> ids = new ArrayList<Long>(10);
                for (List idList : periodIdMap.values()) {
                    ids.addAll(idList);
                }
                this.doAlloc(ids);
                break;
            }
            case "confirmselect": {
                selectData = (List)e.getReturnData();
                if (selectData == null || selectData.isEmpty()) {
                    return;
                }
                importDto = this.getPageImportDto();
                if (importDto == null) break;
                importDto.getCalcPeriodMap().putAll(this.getSelectCurrentPeriods(selectData));
                MfgFeeNonProdAllocService service = this.getService();
                Map periodIdMap = service.getEntityBillIdsFromStatus(importDto, "cad_plannonprodalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue()});
                if (periodIdMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u5df2\u5206\u914d\u7684\u5355\u636e\u3002", (String)"PlanFeeNonProdAllocListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.doConfirm(periodIdMap);
                break;
            }
            case "unconfirmselect": {
                selectData = (List)e.getReturnData();
                if (selectData == null || selectData.isEmpty()) {
                    return;
                }
                importDto = this.getPageImportDto();
                if (importDto == null) break;
                MfgFeeNonProdAllocService service = this.getService();
                importDto.getCalcPeriodMap().putAll(this.getSelectCurrentPeriods(selectData));
                Map periodIdMap = service.getEntityBillIdsFromStatus(importDto, "cad_plannonprodalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue()});
                importDto.getCalcPeriodMap().clear();
                for (Long periodId : periodIdMap.keySet()) {
                    importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                }
                if (periodIdMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u672a\u627e\u5230\u5df2\u786e\u8ba4\u7684\u5355\u636e\u3002", (String)"PlanFeeNonProdAllocListPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.doSearchUnConfirm(importDto, periodIdMap);
                break;
            }
        }
    }

    private void doConfirm(Map<Long, List<Long>> periodIdMap) {
        try {
            Long planschemeId = Long.valueOf(this.getPageCache().get("planscheme"));
            String lockErrStr = SimpleMutexHelper.planmfgCheckAndRequireXMutex((String)"plannonConfirm", (Long)planschemeId);
            if (StringUtils.isNotEmpty((CharSequence)lockErrStr)) {
                this.getView().showErrorNotification(lockErrStr);
                return;
            }
            MfgFeeNonProdAllocService service = this.getService();
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5355\u786e\u8ba4", (String)"PlanFeeNonProdAllocListPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                MfgAllocResult allocResult = new MfgAllocResult();
                try {
                    allocResult = service.doConfirmByPlanPeriod(periodIdMap, this.getView().getFormShowParameter().getAppId(), progressId, true);
                }
                catch (Exception e) {
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                finally {
                    SimpleMutexHelper.releaseXMutex((String)"plannonConfirm", (Object)(planschemeId + "plannonConfirm"));
                }
                String responseInfoStr = SerializationUtils.toJsonString((Object)allocResult);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), "confirmResult"));
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private void doAlloc(List<Long> ids) {
        try {
            String planscheme = this.getPageCache().get("planscheme");
            if (CadEmptyUtils.isEmpty((String)planscheme)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u65b9\u6848\u3002", (String)"PlanFeeNonProdAllocListPlugin_20", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            Long planschemeId = Long.valueOf(this.getPageCache().get("planscheme"));
            String lockErrStr = SimpleMutexHelper.planmfgCheckAndRequireXMutex((String)"plannonAlloc", (Long)planschemeId);
            if (StringUtils.isNotEmpty((CharSequence)lockErrStr)) {
                this.getView().showErrorNotification(lockErrStr);
                return;
            }
            MfgFeeNonProdAllocService service = this.getService();
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d", (String)"PlanFeeNonProdAllocListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                MfgAllocResult allocResult = new MfgAllocResult();
                try {
                    allocResult = service.doAllocByPlanPeriod(ids, this.getView().getFormShowParameter().getAppId(), progressId, true, Long.valueOf(Long.parseLong(planscheme)));
                }
                catch (Exception e) {
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                finally {
                    SimpleMutexHelper.releaseXMutex((String)"plannonAlloc", (Object)(planschemeId + "plannonAlloc"));
                }
                String responseInfoStr = SerializationUtils.toJsonString((Object)allocResult);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), "allocResult"));
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private void doSearchImport(MfgFeeAllocImportParam importDto) {
        MfgFeeNonProdAllocService service = this.getService();
        ArrayList<Long> errorPeriods = new ArrayList<Long>(10);
        for (Long periodId : importDto.getCalcPeriodMap().keySet()) {
            importDto.setPeriod(periodId);
            if (!service.isBillHasData(importDto, "cad_nonprodalloc")) continue;
            if (service.isBillHasData(importDto, "cad_nonprodalloc", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) {
                errorPeriods.add(periodId);
                continue;
            }
            service.deleteNonProdAndRelaBills(importDto, true);
        }
        StringBuilder msgStr = new StringBuilder();
        if (!errorPeriods.isEmpty()) {
            for (Long periodId : errorPeriods) {
                if (msgStr.length() > 0) {
                    msgStr.append(",");
                }
                String periodName = (String)importDto.getCalcPeriodMap().remove(periodId);
                msgStr.append(periodName);
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5f15\u5165\u6570\u636e\u5931\u8d25\u3002\u5f53\u524d\u5206\u914d\u5355\u9700\u8981\u5168\u90e8\u53cd\u786e\u8ba4\uff0c\u624d\u80fd\u91cd\u65b0\u5f15\u5165\u6570\u636e\u3002\u8bf7\u5148\u8fdb\u884c\u53cd\u786e\u8ba4\u64cd\u4f5c\u3002", (String)"PlanFeeNonProdAllocListPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]), msgStr.toString()));
        }
        if (!importDto.getCalcPeriodMap().isEmpty()) {
            this.doImport(importDto);
        }
    }

    private void doSearchUnConfirm(MfgFeeAllocImportParam importDto, Map<Long, List<Long>> periodIdMap) {
        MfgFeeNonProdAllocService service = this.getService();
        ArrayList<Long> errorAuxPeriods = new ArrayList<Long>(10);
        ArrayList<Long> errorBacicPeriods = new ArrayList<Long>(10);
        for (Long periodId : importDto.getCalcPeriodMap().keySet()) {
            importDto.setPeriod(periodId);
            if (service.isBillHasData(importDto, "cad_auxprodalloc", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) {
                errorAuxPeriods.add(periodId);
            }
            if (!service.isBillHasData(importDto, "cad_basicalloc", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) continue;
            errorBacicPeriods.add(periodId);
        }
        StringBuilder msgStr = new StringBuilder();
        if (!errorAuxPeriods.isEmpty() || !errorBacicPeriods.isEmpty()) {
            for (Long periodId : errorAuxPeriods) {
                if (msgStr.length() > 0) {
                    msgStr.append(",");
                }
                msgStr.append((String)importDto.getCalcPeriodMap().get(periodId));
                periodIdMap.remove(periodId);
            }
            if (msgStr.length() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u53cd\u786e\u8ba4\u5931\u8d25\u3002\u4e0b\u6e38\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355\u5df2\u7ecf\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", (String)"PlanFeeNonProdAllocListPlugin_17", (String)"macc-cad-formplugin", (Object[])new Object[0]), msgStr.toString()));
                msgStr.delete(0, msgStr.length());
            }
            for (Long periodId : errorBacicPeriods) {
                if (msgStr.length() > 0) {
                    msgStr.append(",");
                }
                msgStr.append((String)importDto.getCalcPeriodMap().get(periodId));
                periodIdMap.remove(periodId);
            }
            if (msgStr.length() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u53cd\u786e\u8ba4\u5931\u8d25\u3002\u4e0b\u6e38\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u5df2\u7ecf\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", (String)"PlanFeeNonProdAllocListPlugin_18", (String)"macc-cad-formplugin", (Object[])new Object[0]), msgStr.toString()));
            }
        }
        if (!periodIdMap.isEmpty()) {
            this.doUnconfirm(periodIdMap);
        }
    }

    private void doUnconfirm(Map<Long, List<Long>> periodIdMap) {
        try {
            MfgFeeNonProdAllocService service = this.getService();
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5355\u53cd\u786e\u8ba4", (String)"PlanFeeNonProdAllocListPlugin_19", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                MfgAllocResult allocResult = new MfgAllocResult();
                try {
                    allocResult = service.doUnConfirmByPlanPeriod(periodIdMap, this.getView().getFormShowParameter().getAppId(), progressId, true);
                }
                catch (Exception e) {
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                String responseInfoStr = SerializationUtils.toJsonString((Object)allocResult);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), "unconfirmResult"));
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private void doImport(MfgFeeAllocImportParam importDto) {
        if (importDto == null) {
            return;
        }
        String lockErrStr = SimpleMutexHelper.planmfgCheckAndRequireXMutex((String)"plannonImport", (Long)importDto.getPlanscheme());
        if (StringUtils.isNotEmpty((CharSequence)lockErrStr)) {
            this.getView().showErrorNotification(lockErrStr);
            return;
        }
        String progressId = UUID.randomUUID().toString();
        MfgFeeNonProdAllocService service = this.getService();
        ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"PlanFeeNonProdAllocListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
            ArrayList<ExecuteResult> results = new ArrayList<ExecuteResult>(10);
            try {
                int index = 1;
                for (Long periodId : importDto.getCalcPeriodMap().keySet()) {
                    importDto.setPeriod(periodId);
                    String periodName = (String)importDto.getCalcPeriodMap().get(periodId);
                    ExecuteResult result = service.feeAllocNonProdImport(importDto, progressId, periodName, index++);
                    result.setPeriodName(periodName);
                    results.add(result);
                }
            }
            catch (Exception e) {
                ProgressHelper.showError((String)progressId, (String)e.getMessage());
            }
            finally {
                SimpleMutexHelper.releaseXMutex((String)"plannonImport", (Object)(importDto.getPlanscheme() + "plannonImport"));
            }
            String responseInfoStr = SerializationUtils.toJsonString(results);
            this.getPageCache().put("importresponseInfo", responseInfoStr);
        }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), "importResult"));
    }

    private MfgFeeNonProdAllocService getService() {
        return new MfgFeeNonProdAllocService();
    }

    @Override
    protected List<ComboItem> getORGComboItemList() {
        return OrgHelper.getOrgComboItems((String)"cad_plannonprodalloc", (String)"47150e89000000ac", (String)this.getView().getFormShowParameter().getAppId());
    }
}

