/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.planfeealloc;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ClickEventHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadUtils;
import kd.macc.cad.formplugin.base.BaseListPlugin;
import net.sf.json.JSONArray;

public abstract class PlanOrgAndCostAccountListPlugin
extends BaseListPlugin {
    protected static final Log logger = LogFactory.getLog(PlanOrgAndCostAccountListPlugin.class);
    protected Boolean isCostAccountDef = Boolean.FALSE;
    protected static final String ACCTORG = "org";
    protected static final String COSTCENTER = "costcenter";
    private volatile boolean orgClick = false;
    private volatile boolean manuOrgClick = false;
    private volatile boolean costaccountClick = false;
    private List<ComboItem> comboItems;

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        this.initClickEvent(args);
        this.filterContainerInit(args, null);
    }

    private void initClickEvent(FilterContainerInitArgs args) {
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Iterator var3 = filterColumns.iterator();
        String org = this.getPageCache().get(this.ORG_FIELD);
        String manuorg = this.getPageCache().get("manuorg");
        String planscheme = this.getPageCache().get("planscheme");
        String costaccount = this.getPageCache().get("costaccount");
        while (var3.hasNext()) {
            String oldOrgId;
            List list;
            FilterColumn filterColumn = (FilterColumn)var3.next();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List selectValue = (List)ClickEventHelper.getSelectValue(commonFilterColumn.getClass(), (Object)commonFilterColumn);
            boolean selNotNull = selectValue != null && selectValue.size() > 0;
            String defaultValue = "";
            if (selNotNull) {
                defaultValue = selectValue.get(0);
            }
            if (fieldName.startsWith("org.") && org != null && !"".equals(org)) {
                list = (List)SerializationUtils.fromJsonString((String)org, List.class);
                oldOrgId = (String)list.get(0);
                this.orgClick = !defaultValue.equals(oldOrgId);
            }
            if (fieldName.startsWith("manuorg.") && manuorg != null && !"".equals(manuorg)) {
                list = (List)SerializationUtils.fromJsonString((String)manuorg, List.class);
                oldOrgId = (String)list.get(0);
                this.manuOrgClick = !defaultValue.equals(oldOrgId);
            }
            if (!fieldName.startsWith("costaccount.") || CadEmptyUtils.isEmpty((String)costaccount)) continue;
            if (!defaultValue.equals(costaccount)) {
                this.costaccountClick = true;
                continue;
            }
            this.costaccountClick = false;
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("costaccount")) {
            List<Object> orgIdList = this.getOrgCache();
            if (orgIdList == null) {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            } else {
                List<Long> costAccounts = this.getCostAccounts(orgIdList);
                QFilter idQf = new QFilter("id", "in", costAccounts);
                args.getQfilters().add(idQf);
            }
        } else if (fieldName.startsWith(String.format("%s.", this.ORG_FIELD))) {
            List<ComboItem> acctOrgs = this.getORGComboItemList();
            if (CadEmptyUtils.isEmpty(acctOrgs)) {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        } else if (fieldName.startsWith("period")) {
            List<Object> orgIdList = this.getOrgCache();
            if (orgIdList != null) {
                String planSchemeSel = this.getPageCache().get("planscheme");
                if (CadEmptyUtils.isEmpty((String)planSchemeSel)) {
                    List<Long> costAccounts = this.getCostAccounts(orgIdList);
                    Long startPeriod = Long.MAX_VALUE;
                    Long perildType = 0L;
                    for (Long costaccountId : costAccounts) {
                        DynamicObject sysCtrlEntity = this.getPeriodSetDynamicObject(costaccountId);
                        if (sysCtrlEntity == null) continue;
                        Long cperiod = sysCtrlEntity.getLong("startperiod");
                        if (startPeriod <= cperiod) continue;
                        startPeriod = cperiod;
                        perildType = sysCtrlEntity.getLong("periodtype");
                    }
                    if (startPeriod == Long.MAX_VALUE) {
                        args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
                    } else {
                        QFilter idQf = new QFilter("id", ">=", (Object)startPeriod);
                        idQf.and("periodtype", "=", (Object)perildType);
                        args.getQfilters().add(idQf);
                    }
                } else {
                    QFilter idQf = new QFilter("id", "in", (Object)PlanFeeAllocHelper.getPlanStartAllPeriods((Long)Long.valueOf(planSchemeSel)));
                    args.getQfilters().add(idQf);
                }
            } else {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        } else if (fieldName.startsWith("costcenter.")) {
            QFilter filter;
            Long orgId = this.getSelectOrgId(this.ORG_FIELD);
            if (!CadEmptyUtils.isEmpty((Long)orgId)) {
                Long manuOrgId = this.getSelectOrgId("manuorg");
                ArrayList<Long> manuOrgList = new ArrayList<Long>();
                if (!CadEmptyUtils.isEmpty((Long)manuOrgId)) {
                    manuOrgList.add(manuOrgId);
                }
                filter = CostCenterHelper.getCostCenterByMultFactoryForList((long)orgId, manuOrgList, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
            } else {
                List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId()).getHasPermOrgs();
                List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
                filter = new QFilter("accountorg", "in", (Object)orgIds);
            }
            String entityId = this.getBillEntityId();
            if ("cad_resourcplanrate".equals(entityId)) {
                filter.and("orgduty", "=", (Object)4L);
            }
            args.getQfilters().add(filter);
        } else if (fieldName.startsWith("manuorg.")) {
            List<Object> orgIdList = this.getOrgCache();
            if (orgIdList == null) {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            } else {
                Long orgId = Long.valueOf(String.valueOf(orgIdList.get(0)));
                List comboItems = ImportServiceHelper.getPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                ArrayList<Long> ids = new ArrayList<Long>(10);
                for (ComboItem item : comboItems) {
                    ids.add(Long.valueOf(item.getValue()));
                }
                args.getQfilters().add(new QFilter("id", "in", ids));
            }
        } else if (fieldName.startsWith("planscheme.")) {
            List<Object> orgIdList = this.getOrgCache();
            if (orgIdList == null) {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            } else {
                String costaccountSel = this.getPageCache().get("costaccount");
                ArrayList ids = new ArrayList(10);
                if (CadEmptyUtils.isEmpty((String)costaccountSel)) {
                    List<Long> costAccounts = this.getCostAccounts(orgIdList);
                    for (Long costaccount : costAccounts) {
                        ids.addAll(PlanFeeAllocHelper.getPlanEnableSchemeList((Long)costaccount));
                    }
                } else {
                    ids.addAll(PlanFeeAllocHelper.getPlanEnableSchemeList((Long)Long.valueOf(costaccountSel)));
                }
                args.getQfilters().add(new QFilter("id", "in", ids));
            }
        }
    }

    private DynamicObject getPeriodSetDynamicObject(Long costaccountId) {
        QFilter costaccountFilter = new QFilter("entry.costaccount", "=", (Object)costaccountId);
        return QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id,entry.startperiod startperiod,entry.currentperiod currentperiod,entry.calpolicy.periodtype periodtype", (QFilter[])new QFilter[]{costaccountFilter});
    }

    private void filterContainerInit(FilterContainerInitArgs args, String initName) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            Long manuOrgId;
            List<Object> orgIdList = this.getOrgCache();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (kd.bos.util.StringUtils.isNotEmpty((String)initName) && !fieldName.contains(initName)) continue;
            if (fieldName.startsWith(String.format("%s.", this.ORG_FIELD))) {
                this.resetOrg(commonFilterColumn, orgIdList);
                continue;
            }
            if (fieldName.startsWith("costaccount.")) {
                this.resetCostAccount(commonFilterColumn, orgIdList);
                continue;
            }
            if (fieldName.startsWith("manuorg.")) {
                if (orgIdList == null) continue;
                this.resetManuorg(commonFilterColumn, orgIdList);
                continue;
            }
            if (fieldName.startsWith("planscheme.")) {
                String costaccount = this.getPageCache().get("costaccount");
                this.resetPlanScheme(commonFilterColumn, costaccount);
                continue;
            }
            if (fieldName.startsWith("period.")) {
                String planschemeId = this.getPageCache().get("planscheme");
                this.resetPeriod(commonFilterColumn, planschemeId);
                continue;
            }
            if (!fieldName.startsWith("costcenter.")) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            Long orgId = this.getSelectOrgId(this.ORG_FIELD);
            List<ComboItem> comboItems = this.getCostCenterComboItemListByManuOrg(orgId == null ? "" : String.valueOf(orgId), (manuOrgId = this.getSelectOrgId("manuorg")) == null ? "" : String.valueOf(manuOrgId));
            if (CollectionUtils.isEmpty(comboItems)) continue;
            commonFilterColumn.setComboItems(comboItems);
            ComboItem item = comboItems.get(0);
            String defVal = ACCTORG.equals(this.ORG_FIELD) ? "" : item.getValue();
            commonFilterColumn.setDefaultValue(defVal);
        }
        this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString(new ArrayList()));
    }

    @Override
    protected List<ComboItem> getCostCenterComboItemListByManuOrg(String orgId, String manuOrgId) {
        DynamicObjectCollection ccs;
        QFilter filter;
        if (!kd.bos.util.StringUtils.isEmpty((String)orgId) && !"0".equals(orgId)) {
            ArrayList<Long> manuOrgList = new ArrayList<Long>();
            if (!CadEmptyUtils.isEmpty((String)manuOrgId)) {
                manuOrgList.add(Long.parseLong(manuOrgId));
            }
            filter = CostCenterHelper.getCostCenterByMultFactoryForList((long)Long.parseLong(orgId), manuOrgList, (String)this.getAppId(), (String)this.getBillEntityId());
        } else {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getAppId());
            filter = new QFilter("accountorg", "in", (Object)orgIds);
        }
        String entityId = this.getBillEntityId();
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        if ("cad_resourcplanrate".equals(entityId)) {
            filter.and("orgduty", "=", (Object)4L);
        }
        if (CollectionUtils.isEmpty((Collection)(ccs = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])new QFilter[]{filter, enableFilter})))) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    private void resetManuorg(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        if (orgIdList.get(0) != null) {
            List comboItems;
            Long orgId = Long.valueOf(String.valueOf(orgIdList.get(0)));
            String costAccoutId = this.getPageCache().get("costaccount");
            boolean enableMulFactory = false;
            if (costAccoutId != null && !"".equals(costAccoutId)) {
                enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)Long.valueOf(costAccoutId));
            }
            if (enableMulFactory && !CollectionUtils.isEmpty((Collection)(comboItems = ImportServiceHelper.getPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())))) {
                commonFilterColumn.setComboItems(comboItems);
                ComboItem item = (ComboItem)comboItems.get(0);
                String defVal = ACCTORG.equals(this.ORG_FIELD) ? "" : item.getValue();
                Long manuOrgId = this.getSelectOrgId("manuorg");
                if (!CadEmptyUtils.isEmpty((Long)manuOrgId)) {
                    String manuorgSel = manuOrgId.toString();
                    for (ComboItem cbItem : comboItems) {
                        if (!cbItem.getValue().equals(manuorgSel)) continue;
                        defVal = manuorgSel;
                        break;
                    }
                }
                commonFilterColumn.setDefaultValue(defVal);
                if (!CadEmptyUtils.isEmpty((String)defVal)) {
                    this.getPageCache().put("manuorg", JSON.toJSONString((Object)Lists.newArrayList((Object[])new String[]{defVal})));
                }
            }
        }
    }

    protected void resetOrg(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        String org;
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        List<ComboItem> acctOrgs = this.getORGComboItemList();
        if (CadEmptyUtils.isEmpty(acctOrgs)) {
            return;
        }
        String defOrgId = null;
        commonFilterColumn.setComboItems(acctOrgs);
        ComboItem item = acctOrgs.get(0);
        String defVal = item.getValue();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String source = (String)formShowParameter.getCustomParam("source");
        if ("HyperLink".equals(source) && !CadEmptyUtils.isEmpty((String)(org = formShowParameter.getCustomParam(ACCTORG) + ""))) {
            defVal = org;
        }
        String string = defOrgId = kd.bos.util.StringUtils.isEmpty((String)(defOrgId = this.getCustomParam(ACCTORG))) ? defVal : defOrgId;
        if (CadEmptyUtils.isEmpty(orgIdList)) {
            orgIdList = Collections.singletonList(defOrgId);
        }
        commonFilterColumn.setDefaultValues(orgIdList);
        String costaccount = this.getPageCache().get("costaccount");
        this.putOrgCache(orgIdList);
        if (!CadEmptyUtils.isEmpty((String)costaccount)) {
            List<ComboItem> accountItems = this.getCostAccountComboItemListBy(orgIdList);
            for (ComboItem cbitem : accountItems) {
                if (!cbitem.getValue().equals(costaccount)) continue;
                this.getPageCache().put("costaccount", costaccount);
                break;
            }
        }
    }

    protected void resetCostAccount(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        String costaccount;
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        List<ComboItem> comboItems = this.getCostAccountComboItemListBy(orgIdList);
        if (CollectionUtils.isEmpty(comboItems)) {
            this.getPageCache().remove("costaccount");
            commonFilterColumn.setDefaultValue("0");
            return;
        }
        commonFilterColumn.setComboItems(comboItems);
        ComboItem item = comboItems.get(0);
        String defVal = this.getCustomParam("costaccount");
        if (CadEmptyUtils.isEmpty((String)defVal)) {
            String costaccount2 = this.getPageCache().get("costaccount");
            for (ComboItem cbitem : comboItems) {
                if (!cbitem.getValue().equals(costaccount2)) continue;
                defVal = costaccount2;
                break;
            }
            if (CadEmptyUtils.isEmpty((String)defVal)) {
                defVal = item.getValue();
            }
        }
        defVal = this.isCostAccountDef != false ? "" : defVal;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String source = (String)formShowParameter.getCustomParam("source");
        if ("HyperLink".equals(source) && !CadEmptyUtils.isEmpty((String)(costaccount = formShowParameter.getCustomParam("costaccount") + "")) && !"null".equals(costaccount)) {
            defVal = costaccount;
        }
        commonFilterColumn.setDefaultValue(defVal);
        this.getPageCache().put("costaccount", defVal);
    }

    protected List<ComboItem> getPeriodComboItemsPlanStart(Long schemeId) {
        List periodIds = PlanFeeAllocHelper.getPlanLastEnablePeriods((Long)schemeId);
        QFilter periodFilter = new QFilter("id", "in", (Object)periodIds);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id,name", (QFilter[])periodFilter.toArray());
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        for (DynamicObject dyn : periods) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(dyn.getString("name")));
            item.setValue(dyn.getString("id"));
            items.add(item);
        }
        return items;
    }

    protected void resetPlanScheme(CommonFilterColumn commonFilterColumn, String costaccount) {
        String period;
        FormShowParameter formShowParameter;
        String source;
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        Long costaccountId = 0L;
        if (kd.bos.util.StringUtils.isNotEmpty((String)costaccount)) {
            costaccountId = Long.parseLong(costaccount);
        }
        this.comboItems = this.getPlanSchemeComboItemsPlanStart(costaccountId);
        if (CollectionUtils.isEmpty(this.comboItems)) {
            commonFilterColumn.setDefaultValue("");
            this.getPageCache().put("planscheme", "");
            return;
        }
        commonFilterColumn.setComboItems(this.comboItems);
        String defVal = null;
        String planSchemeSel = this.getPageCache().get("planscheme");
        for (ComboItem cbitem : this.comboItems) {
            if (!cbitem.getValue().equals(planSchemeSel)) continue;
            defVal = planSchemeSel;
            break;
        }
        if (CadEmptyUtils.isEmpty(defVal)) {
            defVal = this.comboItems.get(0).getValue();
        }
        if ("HyperLink".equals(source = (String)(formShowParameter = this.getView().getFormShowParameter()).getCustomParam("source")) && !CadEmptyUtils.isEmpty((String)(period = formShowParameter.getCustomParam("planscheme") + "")) && !"null".equals(period)) {
            defVal = period;
        }
        commonFilterColumn.setDefaultValue(defVal);
        this.getPageCache().put("planscheme", defVal);
    }

    private List<ComboItem> getPlanSchemeComboItemsPlanStart(Long costaccountId) {
        List schemeIds = PlanFeeAllocHelper.getPlanEnableSchemeList((Long)costaccountId);
        QFilter periodFilter = new QFilter("id", "in", (Object)schemeIds);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"cad_planscheme", (String)"id,name", (QFilter[])periodFilter.toArray());
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        for (DynamicObject dyn : periods) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(dyn.getString("name")));
            item.setValue(dyn.getString("id"));
            items.add(item);
        }
        return items;
    }

    protected void resetPeriod(CommonFilterColumn commonFilterColumn, String planSchemeId) {
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        Long planScheme = 0L;
        if (kd.bos.util.StringUtils.isNotEmpty((String)planSchemeId)) {
            planScheme = Long.parseLong(planSchemeId);
        }
        this.comboItems = this.getPeriodComboItemsPlanStart(planScheme);
        if (CollectionUtils.isEmpty(this.comboItems)) {
            return;
        }
        commonFilterColumn.setComboItems(this.comboItems);
        String defVal = this.comboItems.get(0).getValue();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        boolean linkQuery = false;
        try {
            LinkQueryPkIdCollection linkQueryPkIdCollection = ((ListShowParameter)formShowParameter).getLinkQueryPkIdCollection();
            linkQuery = !CadEmptyUtils.isEmpty((List)linkQueryPkIdCollection);
        }
        catch (Exception e) {
            logger.error("getLinkQueryPkIdCollection error -> {}", (Object)e.getMessage());
        }
        if (linkQuery) {
            defVal = "";
        } else {
            String period;
            String source = (String)formShowParameter.getCustomParam("source");
            if ("HyperLink".equals(source) && !CadEmptyUtils.isEmpty((String)(period = formShowParameter.getCustomParam("period") + "")) && !"null".equals(period)) {
                defVal = period;
            }
        }
        commonFilterColumn.setDefaultValue(defVal);
        this.getPageCache().put("period", defVal);
        this.getPageCache().put("periodmul", JSON.toJSONString((Object)Lists.newArrayList((Object[])new String[]{defVal})));
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "new": {
                boolean hasNullValue = this.checkNullValue();
                if (hasNullValue) {
                    e.setCancel(true);
                    return;
                }
                if (!this.validatePeriodClosed()) break;
                e.setCancel(true);
                return;
            }
            case "delete": {
                if (!this.validatePeriodClosed()) break;
                e.setCancel(true);
                return;
            }
        }
    }

    private boolean validatePeriodClosed() {
        String planSchemeId = this.getPageCache().get("planscheme");
        String errorMsg = PlanFeeAllocHelper.checkPlanLastEnablePeriodClosed((Long)Long.parseLong(planSchemeId));
        if (!CadEmptyUtils.isEmpty((String)errorMsg)) {
            this.getView().showTipNotification(errorMsg);
            return true;
        }
        return false;
    }

    private boolean checkNullValue() {
        Long orgId = this.getSelectOrgId(this.ORG_FIELD);
        if (CadEmptyUtils.isEmpty((Long)orgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PlanOrgAndCostAccountListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return true;
        }
        String costaccountId = this.getPageCache().get("costaccount");
        if (CadEmptyUtils.isEmpty((String)costaccountId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PlanOrgAndCostAccountListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return true;
        }
        String planSchemeId = this.getPageCache().get("planscheme");
        if (CadEmptyUtils.isEmpty((String)planSchemeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u65b9\u6848\u3002", (String)"PlanOrgAndCostAccountListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return true;
        }
        logger.info("checkOrgAndCostAccount accountorgId==>{},costaccountId ==>{}", (Object)orgId, (Object)costaccountId);
        return false;
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        Map filterValues;
        List customfilter;
        super.filterContainerSearchClick(e);
        if (this.orgClick) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"costcenter.id");
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"costaccount.id");
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"planscheme.id");
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"period.id");
        }
        if (this.manuOrgClick) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"costcenter.id");
        }
        if ((customfilter = (List)(filterValues = e.getSearchClickEvent().getFilterValues()).get("customfilter")) == null || customfilter.isEmpty()) {
            return;
        }
        Long costaccountId = 0L;
        Long planschemeId = 0L;
        for (int i = 0; i < customfilter.size(); ++i) {
            Map map = (Map)customfilter.get(i);
            List names = (List)map.get("FieldName");
            List vals = (List)map.get("Value");
            if (vals == null || vals.isEmpty()) continue;
            String val = String.valueOf(vals.get(0));
            if (CadEmptyUtils.isEmpty((String)val)) {
                if (!"planscheme.id".equals(String.valueOf(names.get(0)))) continue;
                ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"planscheme.id");
                ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"period.id");
                continue;
            }
            if ("costaccount.id".equals(String.valueOf(names.get(0)))) {
                costaccountId = Long.valueOf(val);
                continue;
            }
            if (!"planscheme.id".equals(String.valueOf(names.get(0)))) continue;
            planschemeId = Long.valueOf(val);
        }
        if (!(CadEmptyUtils.isEmpty((Long)planschemeId) || !CadEmptyUtils.isEmpty((Long)costaccountId) && PlanFeeAllocHelper.getPlanEnableSchemeList((Long)costaccountId).contains(planschemeId))) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"planscheme.id");
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"period.id");
        }
        Map nowPeriodMap = Maps.newHashMapWithExpectedSize((int)16);
        String orgIdStr = "";
        for (int i = 0; i < customfilter.size(); ++i) {
            String val;
            List vals;
            Map map = (Map)customfilter.get(i);
            List names = (List)map.get("FieldName");
            if (String.format("%s.id", this.ORG_FIELD).equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (CadEmptyUtils.isEmpty((List)vals)) continue;
                orgIdStr = (String)vals.get(0);
                List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
                if (CadEmptyUtils.isEmpty((String)orgIdStr) || !hasPermAccountOrgIds.contains(Long.parseLong(orgIdStr))) {
                    this.getPageCache().put(this.ORG_FIELD, SerializationUtils.toJsonString(new ArrayList()));
                    this.getPageCache().put("costaccount", "");
                    this.getPageCache().remove(COSTCENTER);
                    ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"org.id");
                    this.filterContainerInit(this.filterContainerInitArgs, null);
                    continue;
                }
                this.putOrgCache(vals);
                this.filterContainerInit(this.filterContainerInitArgs, null);
                continue;
            }
            if ("costaccount.id".equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) continue;
                val = String.valueOf(vals.get(0));
                this.getPageCache().put("costaccount", val);
                this.filterContainerInit(this.filterContainerInitArgs, "planscheme");
                this.filterContainerInit(this.filterContainerInitArgs, "period");
                this.filterContainerInit(this.filterContainerInitArgs, "manuorg");
                continue;
            }
            if ("manuorg.id".equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) continue;
                this.getPageCache().put("manuorg", JSON.toJSONString((Object)vals));
                this.filterContainerInit(this.filterContainerInitArgs, COSTCENTER);
                continue;
            }
            if ("planscheme.id".equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) continue;
                val = String.valueOf(vals.get(0));
                this.getPageCache().put("planscheme", val);
                this.filterContainerInit(this.filterContainerInitArgs, "period");
                continue;
            }
            if ("period.id".equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) continue;
                nowPeriodMap = map;
                val = String.valueOf(vals.get(0));
                this.getPageCache().put("period", val);
                this.getPageCache().put("periodmul", JSON.toJSONString((Object)vals));
                continue;
            }
            if (!"costcenter.id".equals(String.valueOf(names.get(0))) || (vals = (List)map.get("Value")) == null || vals.isEmpty()) continue;
            this.getPageCache().put(COSTCENTER, String.valueOf(vals));
        }
        this.setPeriodValue(nowPeriodMap);
        Long orgId = this.getSelectOrgId(this.ORG_FIELD);
        if (!CadEmptyUtils.isEmpty((Long)orgId)) {
            List multiCostCenters = CadUtils.getMultiCostCentersByFilterName((FilterContainerSearchClickArgs)e, (String)"costcenter.id", (Long)orgId);
            this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString((Object)multiCostCenters));
        }
    }

    private void setPeriodValue(Map<String, List<Object>> nowPeriodMap) {
        if (CadEmptyUtils.isEmpty(nowPeriodMap)) {
            return;
        }
        if (CadEmptyUtils.isEmpty(this.comboItems)) {
            List<Object> value = nowPeriodMap.get("Value");
            if (!CadEmptyUtils.isEmpty(value)) {
                value.clear();
                value.add("");
                this.getPageCache().put("period", "");
                this.getPageCache().put("periodmul", SerializationUtils.toJsonString(new ArrayList()));
            }
        } else {
            List<Object> values = nowPeriodMap.get("Value");
            if (!CadEmptyUtils.isEmpty(values)) {
                Set collect = this.comboItems.stream().map(o -> o.getValue()).collect(Collectors.toSet());
                if ("".equals(values.get(0))) {
                    this.getView().getPageCache().put("period", "");
                    this.getPageCache().put("periodmul", SerializationUtils.toJsonString(new ArrayList()));
                } else if (!collect.contains(values.get(0))) {
                    values.clear();
                    values.add(this.comboItems.get(0).getValue());
                    this.getView().getPageCache().put("period", this.comboItems.get(0).getValue());
                    this.getPageCache().put("periodmul", JSON.toJSONString((Object)Lists.newArrayList((Object[])new String[]{this.comboItems.get(0).getValue()})));
                }
            }
        }
    }

    protected void putOrgCache(List<Object> vals) {
        this.getPageCache().put(this.ORG_FIELD, SerializationUtils.toJsonString(vals));
        this.getPageCache().put("costaccount", "");
        this.getPageCache().remove(COSTCENTER);
    }

    protected List<Object> getOrgCache() {
        String orgId = this.getPageCache().get(this.ORG_FIELD);
        if (kd.bos.util.StringUtils.isNotEmpty((String)orgId)) {
            return (List)SerializationUtils.fromJsonString((String)orgId, List.class);
        }
        return null;
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter bsp = e.getParameter();
        String acctOrg = this.getPageCache().get(this.ORG_FIELD);
        String costCenter = this.getPageCache().get("costaccount");
        String manuorg = this.getPageCache().get("manuorg");
        bsp.setCustomParam(this.ORG_FIELD, (Object)acctOrg);
        bsp.setCustomParam("costaccount", (Object)costCenter);
        bsp.setCustomParam("manuorg", (Object)manuorg);
    }

    protected QFilter getManuOrgQFilter() {
        String orgId;
        boolean enableMultiFactory;
        List<Object> orgCache;
        QFilter manuOrgQf = null;
        String manuOrgId = this.getPageCache().get("manuorg");
        if (StringUtils.isEmpty((CharSequence)manuOrgId) && (orgCache = this.getOrgCache()) != null && (enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(orgId = String.valueOf(orgCache.get(0))))) && !StringUtils.isEmpty((CharSequence)orgId)) {
            List userHasPermProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.valueOf(orgId), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (!CadEmptyUtils.isEmpty((List)userHasPermProOrgsByAccOrg)) {
                userHasPermProOrgsByAccOrg.add(0L);
                manuOrgQf = new QFilter("manuorg", "in", (Object)userHasPermProOrgsByAccOrg);
            } else {
                manuOrgQf = new QFilter("manuorg", "=", (Object)0L);
            }
        }
        return manuOrgQf;
    }

    @Override
    protected String getCustomParam(String key) {
        try {
            Object pageOrg = this.getView().getFormShowParameter().getCustomParam(key);
            if (pageOrg != null && !CadEmptyUtils.isEmpty((String)pageOrg.toString())) {
                return String.valueOf(pageOrg);
            }
        }
        catch (Exception ex) {
            logger.error("\u8f6c\u6362\u62a5\u9519\uff1a", (Throwable)ex);
        }
        return null;
    }

    protected Long getSelectOrgId(String key) {
        String orgId = this.getPageCache().get(key);
        if (CadEmptyUtils.isEmpty((String)orgId)) {
            return null;
        }
        JSONArray orgArr = JSONArray.fromObject((Object)orgId);
        if (!orgArr.isEmpty()) {
            if (CadEmptyUtils.isEmpty((String)orgArr.getString(0))) {
                return null;
            }
            return Long.valueOf(orgArr.getString(0));
        }
        return null;
    }
}

