/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.price;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.macc.cad.algox.calc.helper.CalcMutexHelper;
import kd.macc.cad.business.update.BatModifyCostUpdateService;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.ConfigTrackHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ElementHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BatModifyCostEditPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private Log logger = LogFactory.getLog(BatModifyCostEditPlugin.class);
    private Map<String, DynamicObject> storageorgunitCache = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> materialCache = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> configuredcodeCache = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> tracknumberCache = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> elementCache = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> subelementCache = new HashMap<String, DynamicObject>(16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"toolbarap", "barimport", "barsave", "advcontoolbarap"});
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit storageOrg = (MulBasedataEdit)this.getControl("storageorg");
        storageOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit entryStorageOrg = (BasedataEdit)this.getControl("entrystorageorg");
        entryStorageOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit element = (BasedataEdit)this.getControl("element");
        element.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit subelement = (BasedataEdit)this.getControl("subelement");
        subelement.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit configuredCode = (BasedataEdit)this.getControl("configuredcode");
        configuredCode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit trackNumber = (BasedataEdit)this.getControl("tracknumber");
        trackNumber.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costType = (BasedataEdit)this.getControl("costtype");
        costType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (name) {
            case "org": {
                List filters = listShowParameter.getListFilterParameter().getQFilters();
                List orgIds = OrgHelper.getHasPermAccountOrgIds((String)"cad_batmodifypricerpt", (String)this.getView().getFormShowParameter().getAppId());
                filters.add(new QFilter("id", "in", (Object)orgIds));
                break;
            }
            case "storageorg": {
                DynamicObject dyOrg = (DynamicObject)this.getModel().getValue("org");
                if (dyOrg == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"BatModifyCostEditPlugin_25", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                Long orgId = dyOrg.getLong("id");
                boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
                if (!isOrgEnableMultiFactory) break;
                List storeOrgIds = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)orgId, (boolean)false);
                QFilter filter = null;
                filter = CadEmptyUtils.isEmpty((List)storeOrgIds) ? new QFilter("id", "=", (Object)0L) : new QFilter("id", "in", (Object)storeOrgIds);
                listShowParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "costaccount": {
                DynamicObject dyOrg = (DynamicObject)this.getModel().getValue("org");
                if (dyOrg == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"BatModifyCostEditPlugin_25", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter filter = StartCostHelper.getEndInitCostAccountIdsFilter((Long)dyOrg.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
                listShowParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "entrystorageorg": {
                DynamicObjectCollection entryStorageOrgs = (DynamicObjectCollection)this.getModel().getValue("storageorg");
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryStorageOrgs)) {
                    DynamicObject dyOrg = (DynamicObject)this.getModel().getValue("org");
                    if (dyOrg == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"BatModifyCostEditPlugin_25", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                        beforeF7SelectEvent.setCancel(true);
                        return;
                    }
                    Long orgId = dyOrg.getLong("id");
                    boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
                    if (!isOrgEnableMultiFactory) break;
                    List storeOrgIds = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)orgId, (boolean)false);
                    QFilter filter = CadEmptyUtils.isEmpty((List)storeOrgIds) ? new QFilter("id", "=", (Object)0L) : new QFilter("id", "in", (Object)storeOrgIds);
                    listShowParameter.getListFilterParameter().getQFilters().add(filter);
                    break;
                }
                ArrayList<Long> storageOrgIds = new ArrayList<Long>(16);
                for (DynamicObject entryStorageOrg : entryStorageOrgs) {
                    storageOrgIds.add(entryStorageOrg.getDynamicObject("fbasedataid").getLong("id"));
                }
                QFilter filter = CadEmptyUtils.isEmpty(storageOrgIds) ? new QFilter("id", "=", (Object)0L) : new QFilter("id", "in", storageOrgIds);
                listShowParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "element": {
                DynamicObject subElement = (DynamicObject)this.getModel().getValue("subelement", beforeF7SelectEvent.getRow());
                if (subElement == null) break;
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)this.getElement(subElement.getLong("id"))));
                break;
            }
            case "subelement": {
                int rowIndex = beforeF7SelectEvent.getRow();
                Long pid = (Long)this.getModel().getValue("pid", rowIndex);
                if (CadEmptyUtils.isEmpty((Long)pid)) break;
                ArrayList<Long> subElementIds = new ArrayList<Long>(16);
                DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
                for (DynamicObject entry : entrys) {
                    Long subElementId = entry.getLong("subelement.id");
                    if (pid.longValue() != entry.getLong("pid") || CadEmptyUtils.isEmpty((Long)subElementId)) continue;
                    subElementIds.add(subElementId);
                }
                if (CadEmptyUtils.isEmpty(subElementIds)) break;
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "not in", subElementIds));
                break;
            }
            case "configuredcode": {
                List configCodeIds;
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", beforeF7SelectEvent.getRow());
                if (material == null || CadEmptyUtils.isEmpty((List)(configCodeIds = ConfigTrackHelper.getConfigCodeIdsByMaterial(Collections.singleton(material.getLong("id")))))) break;
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)configCodeIds));
                break;
            }
            case "costtype": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"BatModifyCostEditPlugin_25", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
                List<Object> costTypeIds = new ArrayList(10);
                if (isOrgEnableMultiFactory) {
                    ArrayList<Long> storeOrgIds;
                    DynamicObjectCollection objs = (DynamicObjectCollection)this.getModel().getValue("storageorg");
                    if (CadEmptyUtils.isEmpty((DynamicObjectCollection)objs)) {
                        storeOrgIds = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)org.getLong("id"), (boolean)false);
                        costTypeIds = this.getCostTypeIds(org.getLong("id"), storeOrgIds);
                    } else {
                        storeOrgIds = new ArrayList(10);
                        for (DynamicObject obj : objs) {
                            long storeOrgId = obj.getLong("fbasedataid.id");
                            storeOrgIds.add(storeOrgId);
                        }
                        costTypeIds = this.getCostTypeIds(org.getLong("id"), storeOrgIds);
                    }
                } else {
                    costTypeIds = this.getCostTypeIds(org.getLong("id"), null);
                }
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                List mnCostTypeIds = CostTypeHelper.getMnCostByHs(costTypeIds);
                if (!CadEmptyUtils.isEmpty((List)mnCostTypeIds)) {
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)mnCostTypeIds));
                    break;
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("type", "=", (Object)"1"));
                break;
            }
        }
    }

    private List<Long> getCostTypeIds(Long orgId, List<Long> storeOrgIds) {
        QFilter filter = new QFilter("calorg", "=", (Object)orgId);
        if (CadEmptyUtils.isEmpty(storeOrgIds)) {
            filter.and(new QFilter("storageorgunit", "=", (Object)0L));
        } else {
            filter.and(new QFilter("storageorgunit", "in", storeOrgIds));
        }
        filter.and(new QFilter("bizstatus", "=", (Object)"1"));
        filter.and(new QFilter("effectdate", "<=", (Object)new Date()));
        filter.and(new QFilter("invaliddate", ">=", (Object)new Date()));
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"costtype", (QFilter[])new QFilter[]{filter});
        return DynamicObjectHelper.getIdList((DynamicObjectCollection)objs, (String)"costtype");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap", "toolbarap"});
        this.initStorageOrgData();
        this.reloadEntryData();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
        this.reloadEntryData();
        this.initEntryStorageOrg();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatModifyCostEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6210\u672c\u8d26\u7c3f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatModifyCostEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5e01\u79cd\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatModifyCostEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.reloadEntryData();
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap", "toolbarap"});
        return super.verifyQuery(queryParam);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
        switch (operateKey) {
            case "importdata": {
                this.importData(operateKey);
                break;
            }
            case "exportlist": {
                this.exportData();
                break;
            }
            case "save": {
                this.deleteSubEntryEmptyRows();
                String repeatMsg = this.volidate();
                if (!CadEmptyUtils.isEmpty((String)repeatMsg)) {
                    args.setCancel(true);
                    this.getView().showMessage(repeatMsg);
                    return;
                }
                String msg = this.checkData();
                if (!CadEmptyUtils.isEmpty((String)msg)) {
                    args.setCancel(true);
                    this.getView().showMessage(msg);
                    return;
                }
                boolean result = this.saveDataToBill();
                if (result) break;
                args.setCancel(true);
                break;
            }
            case "clear": {
                this.clear();
                break;
            }
            case "updatewizard": {
                this.showFormByPeriod("updatewizard", args);
                break;
            }
            case "directupdate": {
                this.showFormByPeriod("directupdate", args);
                break;
            }
            case "updatereport": {
                this.showUpdateReport();
                break;
            }
            case "refresh": {
                this.reloadEntryData();
                break;
            }
            case "newentry": {
                DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entrys)) {
                    long pid = ((DynamicObject)entrys.get(rowIndex)).getLong("pid");
                    if (!CadEmptyUtils.isEmpty((Long)pid)) {
                        int parentIndex = this.getParentIndex(rowIndex);
                        int newRowIndex = this.getModel().insertEntryRow("treeentryentity", parentIndex);
                        this.getView().setEnable(Boolean.valueOf(false), newRowIndex, new String[]{"material", "configuredcode", "tracknumber", "entrystorageorg", "costtype", "oldprice"});
                        args.setCancel(true);
                    }
                    this.getView().setEnable(Boolean.valueOf(CadEmptyUtils.isEmpty((Long)pid)), new String[]{"addsubelement"});
                }
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"oldprice"});
                break;
            }
            case "deleteentry": {
                int[] subRowIndexs;
                DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
                long pid = ((DynamicObject)entrys.get(rowIndex)).getLong("pid");
                if (!CadEmptyUtils.isEmpty((Long)pid) || CadEmptyUtils.isEmpty((int[])(subRowIndexs = this.getSubRowIndexs(rowIndex)))) break;
                this.getModel().deleteEntryRows("treeentryentity", subRowIndexs);
                break;
            }
            case "insertentry": {
                long pid = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity").get(rowIndex)).getLong("pid");
                if (CadEmptyUtils.isEmpty((Long)pid)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5df2\u7ecf\u4e3a\u6210\u672c\u5b50\u8981\u7d20\u884c\uff0c\u8bf7\u9009\u62e9\u201c\u589e\u884c\u201d\u3002", (String)"BatModifyCostEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"treeentryentity", (CharSequence)source.getKey())) {
            int rowIndex = evt.getRow();
            if (-1 == rowIndex) {
                return;
            }
            DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entrys)) {
                long pid = ((DynamicObject)entrys.get(rowIndex)).getLong("pid");
                this.getView().setEnable(Boolean.valueOf(CadEmptyUtils.isEmpty((Long)pid)), new String[]{"addsubelement"});
                if (!CadEmptyUtils.isEmpty((Long)pid)) {
                    boolean isSourceMatCostInfo = this.isSourceMatCostInfo(entrys, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(!isSourceMatCostInfo), new String[]{"advconbardelrow"});
                } else {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"advconbardelrow"});
                }
            }
        }
    }

    private boolean isSourceMatCostInfo(DynamicObjectCollection entrys, int rowIndex) {
        long pid = ((DynamicObject)entrys.get(rowIndex)).getLong("pid");
        Long keyColId = 0L;
        Long entryStorageOrgId = this.getEntryStorageOrg();
        for (int i = 0; i < entrys.size(); ++i) {
            if (pid != ((DynamicObject)entrys.get(i)).getLong("id")) continue;
            HashMap<String, Long> values = new HashMap<String, Long>(7);
            values.put("material", ((DynamicObject)entrys.get(i)).getLong("material.id"));
            values.put("configuredcode", ((DynamicObject)entrys.get(i)).getLong("configuredcode.id"));
            values.put("tracknumber", ((DynamicObject)entrys.get(i)).getLong("tracknumber.id"));
            keyColId = CalcKeyHelper.getCalcKey(values, new ArrayList(1), (boolean)true).getId();
            if (!CadEmptyUtils.isEmpty((Long)entryStorageOrgId)) break;
            entryStorageOrgId = ((DynamicObject)entrys.get(i)).getLong("entrystorageorg.id");
            break;
        }
        Long targetCostTypeId = this.getTargetCostTypeId(entryStorageOrgId);
        ArrayList<Long> targetCostTypeIds = new ArrayList<Long>(16);
        targetCostTypeIds.add(targetCostTypeId);
        Map<String, BigDecimal> oldPrices = this.getOldPrices(targetCostTypeIds);
        if (CadEmptyUtils.isEmpty(oldPrices)) {
            return false;
        }
        Long subElementId = ((DynamicObject)entrys.get(rowIndex)).getLong("subelement.id");
        Set<String> keys = oldPrices.keySet();
        String key = String.valueOf(targetCostTypeId) + "@" + String.valueOf(keyColId) + "@" + String.valueOf(subElementId);
        return keys.contains(key);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "save": {
                if (afterDoOperationEventArgs.getOperationResult() == null || !afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                this.reloadEntryData();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BatModifyCostEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                break;
            }
            case "newentry": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
                long pid = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity").get(rowIndex)).getLong("pid");
                if (!CadEmptyUtils.isEmpty((Long)pid)) break;
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"element", "subelement", "price", "oldprice"});
                DynamicObjectCollection storageOrgs = (DynamicObjectCollection)this.getModel().getValue("storageorg");
                if (storageOrgs.size() != 1) break;
                Long storageOrgId = ((DynamicObject)storageOrgs.get(0)).getDynamicObject("fbasedataid").getLong("id");
                this.getModel().setValue("entrystorageorg", (Object)storageOrgId, rowIndex);
                break;
            }
            case "insertentry": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
                long pid = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity").get(rowIndex)).getLong("pid");
                if (CadEmptyUtils.isEmpty((Long)pid)) break;
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"material", "configuredcode", "tracknumber", "entrystorageorg", "costtype", "oldprice"});
                this.setElement(rowIndex);
                break;
            }
        }
    }

    private void setElement(int rowIndex) {
        Object[] eleArr;
        DynamicObject org;
        Object subElementId = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity").get(rowIndex)).getLong("subelement.id");
        if (!CadEmptyUtils.isEmpty((Long)subElementId)) {
            return;
        }
        Long pid = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity").get(rowIndex)).getLong("pid");
        Long materialId = 0L;
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        for (DynamicObject entry : entrys) {
            if (pid.longValue() != entry.getLong("id")) continue;
            materialId = entry.getLong("material.id");
            break;
        }
        if ((org = (DynamicObject)this.getModel().getValue("org")) == null) {
            return;
        }
        if (!CadEmptyUtils.isEmpty((Long)materialId) && !CadEmptyUtils.isEmpty((Object[])(eleArr = this.getSubElementIdbyMaterial(materialId, org.getLong("id")))) && this.enableAddSubElement(pid, (Long)eleArr[1])) {
            subElementId = eleArr[1];
            Object elementId = eleArr[0];
            this.getModel().setValue("subelement", subElementId, rowIndex);
            if (CadEmptyUtils.isEmpty((Long)elementId)) {
                this.getModel().setValue("element", null, rowIndex);
            } else {
                this.getModel().setValue("element", elementId, rowIndex);
            }
        }
    }

    private boolean enableAddSubElement(long pid, Long subElementId) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        for (DynamicObject entry : entrys) {
            if (pid != entry.getLong("pid") || subElementId.longValue() != entry.getLong("subelement.id")) continue;
            return false;
        }
        return true;
    }

    private void setOldPrice(int rowIndex) {
        Long pid = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity").get(rowIndex)).getLong("pid");
        String subElementId = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity").get(rowIndex)).getString("subelement.id");
        Long entryStorageOrgId = 0L;
        Long keyColId = 0L;
        int i = 0;
        int parentIndex = 0;
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        for (DynamicObject entry : entrys) {
            ++i;
            if (pid.longValue() != entry.getLong("id")) continue;
            entryStorageOrgId = entry.getLong("entrystorageorg.id");
            HashMap<String, Long> values = new HashMap<String, Long>(7);
            values.put("material", entry.getLong("material.id"));
            values.put("configuredcode", entry.getLong("configuredcode.id"));
            values.put("tracknumber", entry.getLong("tracknumber.id"));
            keyColId = CalcKeyHelper.getCalcKey(values, new ArrayList(1), (boolean)true).getId();
            parentIndex = i - 1;
            break;
        }
        Long targetCostTypeId = this.getTargetCostTypeId(entryStorageOrgId);
        ArrayList<Long> targetCostTypeIds = new ArrayList<Long>(16);
        targetCostTypeIds.add(targetCostTypeId);
        Map<String, BigDecimal> oldPrices = this.getOldPrices(targetCostTypeIds);
        if (!CadEmptyUtils.isEmpty(targetCostTypeIds)) {
            BigDecimal oldPrice = oldPrices.get(String.valueOf(targetCostTypeId) + "@" + String.valueOf(keyColId) + "@" + subElementId);
            if (oldPrice != null) {
                this.getModel().setValue("oldprice", (Object)oldPrice, rowIndex);
            } else {
                this.getModel().setValue("oldprice", null, rowIndex);
            }
        }
        BigDecimal sumOldPrice = BigDecimal.ZERO;
        for (DynamicObject entry : entrys) {
            if (pid.longValue() != entry.getLong("pid")) continue;
            sumOldPrice = sumOldPrice.add(entry.getBigDecimal("oldprice"));
        }
        this.getModel().setValue("oldprice", (Object)sumOldPrice, parentIndex);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propertyName) {
            case "org": {
                this.initData();
                this.reloadEntryData();
                break;
            }
            case "storageorg": 
            case "costaccount": {
                this.initEntryStorageOrg();
                this.reloadEntryData();
                break;
            }
            case "material": 
            case "configuredcode": 
            case "tracknumber": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org == null) {
                    return;
                }
                DynamicObjectCollection storageOrgs = (DynamicObjectCollection)this.getModel().getValue("storageorg");
                if (storageOrgs.size() == 1) {
                    Map<Long, Long> orgAndCostTypes = this.getSrcCostTypes();
                    boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
                    if (isOrgEnableMultiFactory) {
                        Long storageOrgId = ((DynamicObject)storageOrgs.get(0)).getDynamicObject("fbasedataid").getLong("id");
                        this.getModel().setValue("costtype", (Object)orgAndCostTypes.get(storageOrgId), rowIndex);
                    } else {
                        this.getModel().setValue("costtype", (Object)orgAndCostTypes.get(org.getLong("id")), rowIndex);
                    }
                }
                this.deleteSubEntryRows(rowIndex);
                this.clearOldPrice(rowIndex);
                this.fillSubElementInfo(rowIndex);
                if (!"material".equals(propertyName) || this.getModel().getValue("material", rowIndex) != null) break;
                this.getModel().beginInit();
                this.getModel().setValue("configuredcode", null, rowIndex);
                this.getModel().setValue("tracknumber", null, rowIndex);
                this.getModel().endInit();
                break;
            }
            case "entrystorageorg": {
                Map<Long, Long> orgAndCostTypes = this.getSrcCostTypes();
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org == null) {
                    return;
                }
                boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
                if (isOrgEnableMultiFactory) {
                    DynamicObject entryStorageOrg = (DynamicObject)this.getModel().getValue("entrystorageorg");
                    if (entryStorageOrg == null) {
                        this.getModel().setValue("costtype", null, rowIndex);
                        return;
                    }
                    this.getModel().setValue("costtype", (Object)orgAndCostTypes.get(entryStorageOrg.getLong("id")), rowIndex);
                } else {
                    this.getModel().setValue("costtype", (Object)orgAndCostTypes.get(org.getLong("id")), rowIndex);
                }
                this.fillSubElementInfo(rowIndex);
                break;
            }
            case "element": {
                DynamicObject element = (DynamicObject)this.getModel().getValue("element", rowIndex);
                if (element != null) break;
                this.getModel().setValue("subelement", null, rowIndex);
                break;
            }
            case "subelement": {
                DynamicObject subElement = (DynamicObject)this.getModel().getValue("subelement", rowIndex);
                if (subElement != null) {
                    Long elementId = this.getElement(subElement.getLong("id"));
                    if (CadEmptyUtils.isEmpty((Long)elementId)) {
                        this.getModel().setValue("element", null, rowIndex);
                    } else {
                        this.getModel().setValue("element", (Object)elementId, rowIndex);
                    }
                }
                this.setOldPrice(rowIndex);
                break;
            }
            case "price": {
                this.updatePrice(rowIndex);
                break;
            }
        }
    }

    private void updatePrice(int rowIndex) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        Long pid = ((DynamicObject)entrys.get(rowIndex)).getLong("pid");
        if (!CadEmptyUtils.isEmpty((Long)pid)) {
            int parentIndex = 0;
            int i = 0;
            BigDecimal sumPrice = BigDecimal.ZERO;
            for (DynamicObject entry : entrys) {
                ++i;
                if (pid.longValue() == entry.getLong("pid")) {
                    sumPrice = sumPrice.add(entry.getBigDecimal("price") == null ? BigDecimal.ZERO : entry.getBigDecimal("price"));
                }
                if (pid.longValue() != entry.getLong("id")) continue;
                parentIndex = i;
            }
            this.getModel().setValue("price", (Object)sumPrice, parentIndex - 1);
        }
    }

    private void importData(String operateKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importstart");
        showParameter.setCustomParam("ServiceAppId", (Object)"sca");
        showParameter.setCustomParam("CheckRightAppId", (Object)"sca");
        showParameter.setCustomParam("BillFormId", (Object)"cad_batmodifyprice");
        showParameter.setCustomParam("ListName", null);
        showParameter.setCustomParam("OperateKey", (Object)operateKey);
        showParameter.setCustomParam("PermissionItemId", null);
        showParameter.setCustomParam("RealPermissionEntityId", (Object)"cad_batmodifyprice");
        showParameter.setCustomParam("OperateName", (Object)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"BatModifyCostEditPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "batmodifyprice_import");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void exportData() {
        String billFormId = "cad_batmodifyprice";
        Long templateId = 1623811133456850944L;
        try {
            FormView formView = (FormView)this.getView();
            String routeAppId = formView.getFormShowParameter().getServiceAppId();
            String url = this.export(routeAppId, billFormId, templateId);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.getView().download(url);
                this.getView().sendFormAction((IFormView)this.getView());
            }
        }
        catch (IOException e) {
            throw new KDBizException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private String export(String routeAppId, String formId, Long template) throws IOException {
        ExportWriterFormat format;
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(Boolean.TRUE.booleanValue());
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        HashMap<String, DynamicObject> orgAccountCache = new HashMap<String, DynamicObject>(2);
        if (org != null) {
            orgAccountCache.put(org.getString("number"), org);
        }
        if (costAccount != null) {
            orgAccountCache.put(costAccount.getString("number"), costAccount);
        }
        if ((format = BatModifyCostEditPlugin.getExportWriterFormatAndWriteHead(wb, sheet, styles, routeAppId, formId, template, null)) == null) {
            return null;
        }
        int rowIndex = 4;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection pageDataList = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        Long storageOrgId = this.getEntryStorageOrg();
        ArrayList<DynamicObject> exportList = new ArrayList<DynamicObject>(pageDataList.size());
        for (DynamicObject rowData : pageDataList) {
            long material;
            DynamicObject exportRow = BusinessDataServiceHelper.newDynamicObject((String)"cad_batmodifyprice");
            DynamicObject entry = exportRow.getDynamicObjectCollection("entryentity").addNew();
            Long entryStorageOrgId = rowData.getLong("entrystorageorg.id");
            if (CadEmptyUtils.isEmpty((Long)entryStorageOrgId) && !CadEmptyUtils.isEmpty((Long)storageOrgId)) {
                rowData.set("entrystorageorg", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)storageOrgId, (String)"bos_org"));
            }
            if (!CadEmptyUtils.isEmpty((Long)(material = rowData.getLong("material.id"))) && !CadEmptyUtils.isEmpty(orgAccountCache)) {
                this.setEntryDynamicObjValue(dataEntity, exportRow, "org.number", "org.name", "bos_org", "org", orgAccountCache);
                this.setEntryDynamicObjValue(dataEntity, exportRow, "costaccount.number", "costaccount.name", "cal_bd_costaccount", "costaccount", orgAccountCache);
                exportRow.set("source", (Object)"A");
            }
            this.setEntryDynamicObjValue(rowData, exportRow, "entrystorageorg.number", "entrystorageorg.name", "bos_org", "storageorg", this.storageorgunitCache);
            this.setEntryDynamicObjValue(rowData, exportRow, "material.number", "material.name", "bd_material", "material", this.materialCache);
            this.setEntryDynamicObjValue(rowData, exportRow, "configuredcode.number", "configuredcode.description", "bd_configuredcode", "configuredcode", this.configuredcodeCache);
            this.setEntryDynamicObjValue(rowData, exportRow, "tracknumber.number", "tracknumber.description", "bd_tracknumber", "tracknumber", this.tracknumberCache);
            this.setEntryDynamicObjValue(rowData, entry, "element.number", "element.name", "cad_element", "element", this.elementCache);
            this.setEntryDynamicObjValue(rowData, entry, "subelement.number", "subelement.name", "cad_subelement", "subelement", this.subelementCache);
            entry.set("price", (Object)rowData.getBigDecimal("price"));
            exportList.add(exportRow);
        }
        String json = SerializationUtils.toJsonString(exportList);
        JSONArray billArr = JSONArray.parseArray((String)json);
        LocalDate now = LocalDate.now();
        DynamicObject templateData = BusinessDataServiceHelper.loadSingle((Object)template, (String)"bos_importtemplate");
        String content = String.format(ResManager.loadKDString((String)"\u9884\u7f6e_%1$s", (String)"BatModifyCostEditPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]), templateData.get("name"));
        String fileName = content + "_" + now.getMonthValue() + now.getDayOfMonth() + ".xlsx";
        for (int i = 0; i < billArr.size(); ++i) {
            JSONObject bill = billArr.getJSONObject(i);
            int offset = ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONObject)bill, (int)rowIndex, (ExportWriterFormat)format, (boolean)Boolean.FALSE, (String)fileName, (boolean)Boolean.TRUE);
            if (offset > 1) {
                rowIndex += offset;
                continue;
            }
            ++rowIndex;
        }
        return this.writeFile(wb, fileName);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "batmodifyprice_import": {
                this.dealImportData();
                break;
            }
            case "batmodifyprice_period": {
                Map returns = (Map)closedCallBackEvent.getReturnData();
                if (CadEmptyUtils.isEmpty((Map)returns)) {
                    return;
                }
                this.doUpdate(closedCallBackEvent);
                break;
            }
        }
    }

    private void initData() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            long orgId;
            List permCalOrgIds = OrgHelper.getHasPermAccountOrgIds((String)"cad_batmodifypricerpt", (String)this.getView().getFormShowParameter().getAppId());
            if (permCalOrgIds.contains(orgId = RequestContext.get().getOrgId())) {
                this.getModel().setValue("org", (Object)orgId);
            } else if (!CadEmptyUtils.isEmpty((List)permCalOrgIds)) {
                List orgIds = OrgHelper.getOrgOrderByNumber((List)permCalOrgIds);
                this.getModel().setValue("org", orgIds.get(0));
            }
        }
        this.getView().updateView("org");
        org = (DynamicObject)this.getModel().getValue("org");
        this.getModel().setValue("storageorg", null);
        if (org == null) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"storageorg"});
        } else {
            boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
            this.getView().setVisible(Boolean.valueOf(isOrgEnableMultiFactory), new String[]{"storageorg"});
        }
        this.getView().updateView("storageorg");
        if (org == null) {
            this.getModel().setValue("costaccount", null);
        } else {
            Long mainAccountId = OrgHelper.getCostAccountByOrg((Long)org.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
            this.getModel().setValue("costaccount", (Object)(CadEmptyUtils.isEmpty((Long)mainAccountId) ? null : mainAccountId));
        }
        this.getView().updateView("costaccount");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("currency", null);
        } else {
            this.getModel().setValue("currency", (Object)CalcRptHelper.getCurrency((DynamicObject)costAccount));
        }
        this.getView().updateView("currency");
    }

    private void initStorageOrgData() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"storageorg", "entrystorageorg"});
        } else {
            boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
            this.getView().setVisible(Boolean.valueOf(isOrgEnableMultiFactory), new String[]{"storageorg"});
            DynamicObjectCollection storageorg = (DynamicObjectCollection)this.getModel().getValue("storageorg");
            if (storageorg != null && storageorg.size() != 1) {
                this.getView().setVisible(Boolean.valueOf(isOrgEnableMultiFactory), new String[]{"entrystorageorg"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"entrystorageorg"});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveDataToBill() {
        boolean result = true;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatModifyCostEditPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6210\u672c\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatModifyCostEditPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        Long currencyId = 0L;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency != null) {
            currencyId = currency.getLong("id");
        }
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        ArrayList<DynamicObject> costBills = new ArrayList<DynamicObject>(entrys.size());
        Long storageOrgId = this.getEntryStorageOrg();
        for (DynamicObject entry : entrys) {
            if (entry.getLong("pid") != 0L) continue;
            Long materialId = entry.getLong("material.id");
            Long configuredCodeId = entry.getLong("configuredcode.id");
            Long trackNumberId = entry.getLong("tracknumber.id");
            HashMap<String, Long> values = new HashMap<String, Long>(7);
            values.put("material", materialId);
            values.put("configuredcode", configuredCodeId);
            values.put("tracknumber", trackNumberId);
            Keycol keyCol = CalcKeyHelper.getCalcKey(values, new ArrayList(1), (boolean)true);
            String keycol = keyCol.getKeycol();
            Long keyColId = keyCol.getId();
            DynamicObject costBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_batmodifyprice");
            costBill.set("org", (Object)orgId);
            if (storageOrgId == null) {
                costBill.set("storageorg", (Object)entry.getLong("entrystorageorg.id"));
            } else if (storageOrgId != 0L && storageOrgId > 0L) {
                costBill.set("storageorg", (Object)storageOrgId);
            }
            costBill.set("costtype", (Object)entry.getLong("costtype.id"));
            costBill.set("costaccount", (Object)costAccountId);
            costBill.set("currency", (Object)currencyId);
            costBill.set("material", (Object)materialId);
            costBill.set("configuredcode", (Object)configuredCodeId);
            costBill.set("tracknumber", (Object)trackNumberId);
            costBill.set("keycol", (Object)keycol);
            costBill.set("keycolid", (Object)keyColId);
            costBill.set("datasrc", (Object)"manual");
            costBill.set("source", (Object)"A");
            costBill.set("pricerule", (Object)PriceRuleConstants.PUR_MANUALLY_ID);
            List<DynamicObject> newEntrys = this.getNextLevelByParentId(entry.getLong("id"), entrys);
            if (CadEmptyUtils.isEmpty(newEntrys)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u7269\u6599\u6ca1\u6709\u6210\u672c\u5b50\u8981\u7d20\u4fe1\u606f\uff0c\u8bf7\u8865\u5145\u6210\u672c\u5b50\u8981\u7d20\u3002", (String)"BatModifyCostEditPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return false;
            }
            BigDecimal sumAmount = BigDecimal.ZERO;
            DynamicObjectCollection priceEntrys = costBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject newEntry : newEntrys) {
                DynamicObject priceEntry = priceEntrys.addNew();
                priceEntry.set("element", (Object)newEntry.getLong("element.id"));
                priceEntry.set("subelement", (Object)newEntry.getLong("subelement.id"));
                priceEntry.set("oldprice", (Object)this.getBigDcimalNotnull(newEntry.getBigDecimal("oldprice")));
                priceEntry.set("price", (Object)this.getBigDcimalNotnull(newEntry.getBigDecimal("price")));
                sumAmount = sumAmount.add(this.getBigDcimalNotnull(newEntry.getBigDecimal("price")));
            }
            costBill.set("amount", (Object)sumAmount);
            costBills.add(costBill);
        }
        try (TXHandle txHandle = TX.required();){
            QFilter filter = this.getCurDataFilter();
            if (filter != null) {
                DeleteServiceHelper.delete((String)"cad_batmodifyprice", (QFilter[])new QFilter[]{filter});
            }
            if (!CadEmptyUtils.isEmpty(costBills)) {
                SaveServiceHelper.save((DynamicObject[])costBills.toArray(new DynamicObject[0]));
            }
        }
        return result;
    }

    private String volidate() {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entrys)) {
            return " ";
        }
        HashSet<String> existMats = new HashSet<String>(10);
        HashSet<String> repeatMats = new HashSet<String>(10);
        for (DynamicObject entry : entrys) {
            long entryStorageOrg = entry.getLong("entrystorageorg.id");
            long costType = entry.getLong("costtype.id");
            long material = entry.getLong("material.id");
            long configuredcode = entry.getLong("configuredcode.id");
            long tracknumber = entry.getLong("tracknumber.id");
            String matStr = entryStorageOrg + "@" + costType + "@" + material + "@" + configuredcode + "@" + tracknumber;
            if (existMats.contains(matStr)) {
                repeatMats.add(matStr);
                continue;
            }
            existMats.add(matStr);
        }
        if (CadEmptyUtils.isEmpty(repeatMats)) {
            return " ";
        }
        String msg = " ";
        for (DynamicObject entry : entrys) {
            String strs;
            String orgStr;
            long entryStorageOrg = entry.getLong("entrystorageorg.id");
            long costType = entry.getLong("costtype.id");
            long material = entry.getLong("material.id");
            long configuredcode = entry.getLong("configuredcode.id");
            long tracknumber = entry.getLong("tracknumber.id");
            String matStr = entryStorageOrg + "@" + costType + "@" + material + "@" + configuredcode + "@" + tracknumber;
            if (CadEmptyUtils.isEmpty((Long)material) || !repeatMats.contains(matStr)) continue;
            repeatMats.remove(matStr);
            String entryStorageOrgName = entry.getString("entrystorageorg.name");
            String costTypeName = entry.getString("costtype.name");
            String materialName = entry.getString("material.name");
            String confignum = entry.getString("configuredcode.number");
            String tracknum = entry.getString("tracknumber.number");
            String orgMsg = "";
            if (!CadEmptyUtils.isEmpty((String)entryStorageOrgName) && !CadEmptyUtils.isEmpty((String)costTypeName)) {
                orgStr = ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7[%1$s]+\u6210\u672c\u7c7b\u578b[%2$s]", (String)"BatModifyCostEditPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                orgMsg = String.format(orgStr, entryStorageOrgName, costTypeName);
            } else if (!CadEmptyUtils.isEmpty((String)entryStorageOrgName)) {
                orgStr = ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7[%1$s]", (String)"BatModifyCostEditPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                orgMsg = String.format(orgStr, entryStorageOrgName, costTypeName);
            } else if (!CadEmptyUtils.isEmpty((String)costTypeName)) {
                orgStr = ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b[%1$s]", (String)"BatModifyCostEditPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                orgMsg = String.format(orgStr, entryStorageOrgName, costTypeName);
            }
            if (!CadEmptyUtils.isEmpty((String)confignum) && !CadEmptyUtils.isEmpty((String)tracknum)) {
                strs = ResManager.loadKDString((String)"\u7269\u6599[%1$s]+\u914d\u7f6e\u53f7[%2$s]+\u8ddf\u8e2a\u53f7[%3$s]", (String)"BatModifyCostEditPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                if (CadEmptyUtils.isEmpty((String)msg)) {
                    msg = (CadEmptyUtils.isEmpty((String)orgMsg) ? orgMsg : orgMsg + "+") + String.format(strs, materialName, confignum, tracknum);
                    continue;
                }
                msg = msg + "," + (CadEmptyUtils.isEmpty((String)orgMsg) ? orgMsg : orgMsg + "+") + String.format(strs, materialName, confignum, tracknum);
                continue;
            }
            if (!CadEmptyUtils.isEmpty((String)confignum)) {
                strs = ResManager.loadKDString((String)"\u7269\u6599[%1$s]+\u914d\u7f6e\u53f7[%2$s]", (String)"BatModifyCostEditPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                if (CadEmptyUtils.isEmpty((String)msg)) {
                    msg = (CadEmptyUtils.isEmpty((String)orgMsg) ? orgMsg : orgMsg + "+") + String.format(strs, materialName, confignum);
                    continue;
                }
                msg = msg + "," + (CadEmptyUtils.isEmpty((String)orgMsg) ? orgMsg : orgMsg + "+") + String.format(strs, materialName, confignum);
                continue;
            }
            if (!CadEmptyUtils.isEmpty((String)tracknum)) {
                strs = ResManager.loadKDString((String)"\u7269\u6599[%1$s]+\u8ddf\u8e2a\u53f7[%2$s]", (String)"BatModifyCostEditPlugin_17", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                if (CadEmptyUtils.isEmpty((String)msg)) {
                    msg = (CadEmptyUtils.isEmpty((String)orgMsg) ? orgMsg : orgMsg + "+") + String.format(strs, materialName, tracknum);
                    continue;
                }
                msg = msg + "," + (CadEmptyUtils.isEmpty((String)orgMsg) ? orgMsg : orgMsg + "+") + String.format(strs, materialName, tracknum);
                continue;
            }
            strs = ResManager.loadKDString((String)"\u7269\u6599[%1$s]", (String)"BatModifyCostEditPlugin_18", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            if (CadEmptyUtils.isEmpty((String)msg)) {
                msg = (CadEmptyUtils.isEmpty((String)orgMsg) ? orgMsg : orgMsg + "+") + String.format(strs, materialName);
                continue;
            }
            msg = msg + "," + (CadEmptyUtils.isEmpty((String)orgMsg) ? orgMsg : orgMsg + "+") + String.format(strs, materialName);
        }
        if (CadEmptyUtils.isEmpty((String)msg)) {
            return msg;
        }
        return String.format(ResManager.loadKDString((String)"%s\u91cd\u590d\uff0c\u8bf7\u5220\u9664\u91cd\u590d\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"BatModifyCostEditPlugin_19", (String)"macc-cad-formplugin", (Object[])new Object[0]), msg);
    }

    private BigDecimal getBigDcimalNotnull(BigDecimal cost) {
        if (cost == null) {
            cost = BigDecimal.ZERO;
        }
        return cost;
    }

    private List<DynamicObject> getNextLevelByParentId(Long parentId, DynamicObjectCollection entrys) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        for (DynamicObject entry : entrys) {
            if (parentId.longValue() != entry.getLong("pid")) continue;
            result.add(entry);
        }
        return result;
    }

    private QFilter getCurDataFilter() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return null;
        }
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            return null;
        }
        QFilter filter = new QFilter("org", "=", (Object)org.getLong("id"));
        filter.and("costaccount", "=", (Object)costAccount.getLong("id"));
        DynamicObjectCollection storageOrgs = (DynamicObjectCollection)this.getModel().getValue("storageorg");
        ArrayList storageOrgIds = new ArrayList(storageOrgs.size());
        storageOrgs.forEach(p -> storageOrgIds.add(p.getDynamicObject("fbasedataid").getLong("id")));
        if (!CadEmptyUtils.isEmpty(storageOrgIds)) {
            filter.and("storageorg", "in", storageOrgIds);
        }
        filter.and("isupdate", "=", (Object)"0");
        filter.and("source", "=", (Object)"A");
        return filter;
    }

    private void reloadEntryData() {
        this.getModel().deleteEntryData("treeentryentity");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        QFilter filter = this.getCurDataFilter();
        if (filter == null) {
            this.getView().updateView("treeentryentity");
            return;
        }
        String selectFields = "storageorg,costtype,material,configuredcode,tracknumber,keycolid,entryentity.element,entryentity.subelement,entryentity.oldprice,entryentity.price,entryentity.nodeid,entryentity.parentnodeid";
        Object[] batModifyPrices = BusinessDataServiceHelper.load((String)"cad_batmodifyprice", (String)selectFields, (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((Object[])batModifyPrices)) {
            this.getView().updateView("treeentryentity");
            return;
        }
        boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
        Map<Long, Long> orgAndCostTypes = this.getSrcCostTypes();
        Map<Long, Long> orgTargetCostTypes = this.getTargetCostTypeIds((DynamicObject[])batModifyPrices);
        ArrayList<Long> targetCostTypeIds = new ArrayList<Long>(16);
        orgTargetCostTypes.values().forEach(p -> targetCostTypeIds.add((Long)p));
        Map<String, BigDecimal> oldPrices = this.getOldPrices(targetCostTypeIds);
        this.getModel().beginInit();
        for (Object batModifyPrice : batModifyPrices) {
            int curIndex = this.getModel().createNewEntryRow("treeentryentity");
            this.getModel().setValue("material", (Object)batModifyPrice.getLong("material.id"), curIndex);
            this.getModel().setValue("configuredcode", (Object)batModifyPrice.getLong("configuredcode.id"), curIndex);
            this.getModel().setValue("tracknumber", (Object)batModifyPrice.getLong("tracknumber.id"), curIndex);
            this.getModel().setValue("keycolid", (Object)batModifyPrice.getLong("keycolid.id"), curIndex);
            this.getModel().setValue("entrystorageorg", (Object)batModifyPrice.getLong("storageorg.id"), curIndex);
            Long costTypeId = batModifyPrice.getLong("costtype.id");
            if (CadEmptyUtils.isEmpty((Long)costTypeId)) {
                if (isOrgEnableMultiFactory) {
                    DynamicObject storage = batModifyPrice.getDynamicObject("storageorg");
                    if (storage != null) {
                        this.getModel().setValue("costtype", (Object)orgAndCostTypes.get(storage.getLong("id")), curIndex);
                    }
                } else {
                    this.getModel().setValue("costtype", (Object)orgAndCostTypes.get(org.getLong("id")), curIndex);
                }
            } else {
                this.getModel().setValue("costtype", (Object)costTypeId, curIndex);
            }
            this.getView().setEnable(Boolean.valueOf(false), curIndex, new String[]{"element", "subelement", "oldprice", "price"});
            DynamicObjectCollection batModifyEntrys = batModifyPrice.getDynamicObjectCollection("entryentity");
            BigDecimal sumOldPrice = BigDecimal.ZERO;
            BigDecimal sumPrice = BigDecimal.ZERO;
            for (DynamicObject batModifyEntry : batModifyEntrys) {
                String key;
                BigDecimal oldPrice;
                int subIndex = this.getModel().insertEntryRow("treeentryentity", curIndex);
                this.getView().setEnable(Boolean.valueOf(false), subIndex, new String[]{"material", "configuredcode", "tracknumber", "entrystorageorg", "costtype", "oldprice"});
                this.getModel().setValue("element", (Object)batModifyEntry.getLong("element.id"), subIndex);
                this.getModel().setValue("subelement", (Object)batModifyEntry.getLong("subelement.id"), subIndex);
                String keyCostTypeId = null;
                Long orgOrStorageOrg = 0L;
                if (isOrgEnableMultiFactory) {
                    DynamicObject storageOrg = batModifyPrice.getDynamicObject("storageorg");
                    if (storageOrg != null) {
                        orgOrStorageOrg = storageOrg.getLong("id");
                    }
                } else {
                    orgOrStorageOrg = org.getLong("id");
                }
                Long tarCostTypeId = orgTargetCostTypes.get(orgOrStorageOrg);
                if (!CadEmptyUtils.isEmpty((Long)tarCostTypeId)) {
                    keyCostTypeId = String.valueOf(tarCostTypeId);
                }
                if ((oldPrice = oldPrices.get(key = keyCostTypeId + "@" + batModifyPrice.getString("keycolid.id") + "@" + batModifyEntry.getString("subelement.id"))) != null) {
                    sumOldPrice = sumOldPrice.add(oldPrice);
                    this.getModel().setValue("oldprice", (Object)oldPrice, subIndex);
                }
                BigDecimal price = batModifyEntry.getBigDecimal("price");
                sumPrice = sumPrice.add(price);
                this.getModel().setValue("price", (Object)price, subIndex);
            }
            this.getModel().setValue("oldprice", (Object)sumOldPrice, curIndex);
            this.getModel().setValue("price", (Object)sumPrice, curIndex);
        }
        this.getModel().endInit();
        this.getView().updateView("treeentryentity");
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap", "toolbarap"});
    }

    private Map<String, BigDecimal> getOldPrices(List<Long> targetCostTypeIds) {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(16);
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "in", targetCostTypeIds), new QFilter("effectdate", "<=", (Object)new Date()), new QFilter("expdate", ">", (Object)new Date())};
        String selectFields = "costtype,keycolid,entryentity.subelement subelement,entryentity.standardcost standardcost";
        DynamicObjectCollection matCostInfos = QueryServiceHelper.query((String)"cad_matcostinfo", (String)selectFields, (QFilter[])filters, null);
        for (DynamicObject matCostInfo : matCostInfos) {
            result.put(matCostInfo.getString("costtype") + "@" + matCostInfo.getString("keycolid") + "@" + matCostInfo.getString("subelement"), matCostInfo.getBigDecimal("standardcost"));
        }
        return result;
    }

    private void initEntryStorageOrg() {
        Long storageOrgId = this.getEntryStorageOrg();
        this.getView().setVisible(Boolean.valueOf(storageOrgId == null), new String[]{"entrystorageorg"});
    }

    private Long getTargetCostTypeId(Long storageOrgId) {
        Long result = 0L;
        if (CadEmptyUtils.isEmpty((Long)storageOrgId)) {
            return result;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return result;
        }
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            return result;
        }
        boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
        Date date = TimeServiceHelper.now();
        if (isOrgEnableMultiFactory) {
            QFilter[] filters = new QFilter[]{new QFilter("costaccount", "=", (Object)costAccount.getLong("id")), new QFilter("storageorgunit", "=", (Object)storageOrgId), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
            DataSet orgCostTypes = QueryServiceHelper.queryDataSet((String)"getTargetCostTypes", (String)"cal_bd_costtypeorg", (String)"costtype", (QFilter[])filters, null);
            for (Row row : orgCostTypes) {
                result = row.getLong("costtype");
            }
        } else {
            QFilter[] filters = new QFilter[]{new QFilter("costaccount", "=", (Object)costAccount.getLong("id")), new QFilter("calorg", "=", (Object)org.getLong("id")), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
            DataSet orgCostTypes = QueryServiceHelper.queryDataSet((String)"getTargetCostTypes", (String)"cal_bd_costtypeorg", (String)"costtype", (QFilter[])filters, null);
            for (Row row : orgCostTypes) {
                result = row.getLong("costtype");
            }
        }
        return result;
    }

    private Map<Long, Long> getTargetCostTypeIds(DynamicObject[] batModifyPrices) {
        HashMap<Long, Long> result = new HashMap<Long, Long>(batModifyPrices.length);
        if (CadEmptyUtils.isEmpty((Object[])batModifyPrices)) {
            return result;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return result;
        }
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            return result;
        }
        boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
        Date date = TimeServiceHelper.now();
        if (isOrgEnableMultiFactory) {
            HashSet<Long> storageOrgIds = new HashSet<Long>(16);
            for (DynamicObject batModifyPrice : batModifyPrices) {
                DynamicObject storageOrg = batModifyPrice.getDynamicObject("storageorg");
                if (storageOrg == null) continue;
                storageOrgIds.add(storageOrg.getLong("id"));
            }
            if (CadEmptyUtils.isEmpty(storageOrgIds)) {
                return result;
            }
            QFilter[] filters = new QFilter[]{new QFilter("costaccount", "=", (Object)costAccount.getLong("id")), new QFilter("storageorgunit", "in", storageOrgIds), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
            DataSet orgCostTypes = QueryServiceHelper.queryDataSet((String)"getTargetCostTypes", (String)"cal_bd_costtypeorg", (String)"storageorgunit,costtype", (QFilter[])filters, null);
            for (Row row : orgCostTypes) {
                result.put(row.getLong("storageorgunit"), row.getLong("costtype"));
            }
        } else {
            QFilter[] filters = new QFilter[]{new QFilter("costaccount", "=", (Object)costAccount.getLong("id")), new QFilter("calorg", "=", (Object)org.getLong("id")), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
            DataSet orgCostTypes = QueryServiceHelper.queryDataSet((String)"getTargetCostTypes", (String)"cal_bd_costtypeorg", (String)"calorg,costtype", (QFilter[])filters, null);
            for (Row row : orgCostTypes) {
                result.put(row.getLong("calorg"), row.getLong("costtype"));
            }
        }
        return result;
    }

    private Map<Long, Long> getSrcCostTypes() {
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return result;
        }
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            return result;
        }
        boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
        if (isOrgEnableMultiFactory) {
            HashSet<Long> storageOrgIds = new HashSet<Long>(16);
            List storeOrgIds = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)org.getLong("id"), (boolean)false);
            storageOrgIds.addAll(storeOrgIds);
            DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : entrys) {
                DynamicObject storageOrg = entry.getDynamicObject("entrystorageorg");
                if (storageOrg == null) continue;
                storageOrgIds.add(storageOrg.getLong("id"));
            }
            if (CadEmptyUtils.isEmpty(storageOrgIds)) {
                return result;
            }
            Date date = TimeServiceHelper.now();
            QFilter[] filters = new QFilter[]{new QFilter("costaccount", "=", (Object)costAccount.getLong("id")), new QFilter("storageorgunit", "in", storageOrgIds), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
            DataSet orgCostTypes = QueryServiceHelper.queryDataSet((String)"getSrcCostTypes", (String)"cal_bd_costtypeorg", (String)"storageorgunit,costtype targetcosttypeid", (QFilter[])filters, null);
            DataSet newOrgCostTypes = orgCostTypes.copy();
            ArrayList<Long> tarCostTypeIds = new ArrayList<Long>(16);
            for (Row row : newOrgCostTypes) {
                tarCostTypeIds.add(row.getLong("targetcosttypeid"));
            }
            if (CadEmptyUtils.isEmpty(tarCostTypeIds)) {
                return result;
            }
            filters = new QFilter[]{new QFilter("id", "in", tarCostTypeIds), new QFilter("costtypeentry.costtypeattr", "=", (Object)"1")};
            DataSet costTypes = QueryServiceHelper.queryDataSet((String)"getTarCostType", (String)"cad_costtype", (String)"id targetcosttypeid,costtypeentry.costtype srccosttypeid", (QFilter[])filters, null);
            DataSet allData = orgCostTypes.leftJoin(costTypes).on("targetcosttypeid", "targetcosttypeid").select(orgCostTypes.getRowMeta().getFieldNames(), new String[]{"srccosttypeid"}).finish();
            for (Row row : allData) {
                result.put(row.getLong("storageorgunit"), row.getLong("srccosttypeid"));
            }
            return result;
        }
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costaccount", "=", (Object)costAccount.getLong("id")), new QFilter("calorg", "=", (Object)org.getLong("id")), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
        DataSet orgCostTypes = QueryServiceHelper.queryDataSet((String)"getTargetCostTypes", (String)"cal_bd_costtypeorg", (String)"costtype targetcosttypeid", (QFilter[])filters, null);
        ArrayList<Long> tarCostTypeIds = new ArrayList<Long>(16);
        for (Row row : orgCostTypes) {
            tarCostTypeIds.add(row.getLong("targetcosttypeid"));
        }
        if (CadEmptyUtils.isEmpty(tarCostTypeIds)) {
            return result;
        }
        filters = new QFilter[]{new QFilter("id", "in", tarCostTypeIds), new QFilter("costtypeentry.costtypeattr", "=", (Object)"1")};
        DataSet costTypes = QueryServiceHelper.queryDataSet((String)"getTarCostType", (String)"cad_costtype", (String)"id targetcosttypeid,costtypeentry.costtype srccosttypeid", (QFilter[])filters, null);
        for (Row row : costTypes) {
            result.put(org.getLong("id"), row.getLong("srccosttypeid"));
        }
        return result;
    }

    private Long getEntryStorageOrg() {
        boolean isOrgEnableMultiFactory;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return null;
        }
        DynamicObjectCollection storageOrgs = (DynamicObjectCollection)this.getModel().getValue("storageorg");
        ArrayList storageOrgIds = new ArrayList(1);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)storageOrgs)) {
            storageOrgs.forEach(p -> storageOrgIds.add(p.getDynamicObject("fbasedataid").getLong("id")));
        }
        if (isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"))) {
            if (storageOrgIds.size() == 1) {
                return (Long)storageOrgIds.get(0);
            }
            return null;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(Long periodId, boolean isUpdateWizard) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entrys)) {
            return;
        }
        this.deleteSubEntryEmptyRows();
        String repeatMsg = this.volidate();
        if (!CadEmptyUtils.isEmpty((String)repeatMsg)) {
            this.getView().showMessage(repeatMsg);
            return;
        }
        String msg = this.checkData();
        if (!CadEmptyUtils.isEmpty((String)msg)) {
            this.getView().showMessage(msg);
            return;
        }
        this.saveDataToBill();
        ArrayList<Long> updateBillIds = new ArrayList<Long>(10);
        QFilter filter = this.getCurDataFilter();
        try {
            Set<Long> tarCostTypeIds = this.getTarCostTypeIds(filter);
            String lockErr = CalcMutexHelper.checkXMutex((String)"update", tarCostTypeIds);
            if (kd.bos.util.StringUtils.isNotEmpty((String)lockErr)) {
                this.getView().showErrorNotification(lockErr);
                return;
            }
            BatModifyCostUpdateService batModifyCostUpdateService = new BatModifyCostUpdateService();
            batModifyCostUpdateService.doUpdateByModifyCost((IFormView)this.getView(), filter, periodId, isUpdateWizard);
            this.reloadEntryData();
        }
        catch (Exception e) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff1a%s\u3002", (String)"BatModifyCostEditPlugin_20", (String)"macc-cad-formplugin", (Object[])new Object[0]), e.getMessage()));
            this.logger.error((Throwable)e);
        }
        finally {
            if (!isUpdateWizard) {
                String updateFailBillMsg = this.getUpdateFailBillMsg(updateBillIds);
                if (!CadEmptyUtils.isEmpty((String)updateFailBillMsg)) {
                    this.getView().showTipNotification(updateFailBillMsg);
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f\u3002", (String)"BatModifyCostEditPlugin_21", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private Set<Long> getTarCostTypeIds(QFilter filter) {
        QFilter[] filters = new QFilter[]{filter};
        DataSet batModifyPriceDataSet = QueryServiceHelper.queryDataSet((String)"BatModifyCostEditPlugin.getTarCostTypeIds", (String)"cad_batmodifyprice", (String)"org,costaccount,storageorg", (QFilter[])filters, null);
        Date date = TimeServiceHelper.now();
        filters = new QFilter[]{new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
        DataSet orgCostTypeDataSet = QueryServiceHelper.queryDataSet((String)"BatModifyCostEditPlugin.getTarCostTypeIds", (String)"cal_bd_costtypeorg", (String)"calorg,costaccount,storageorgunit,costtype", (QFilter[])filters, null);
        DataSet data = batModifyPriceDataSet.leftJoin(orgCostTypeDataSet).on("org", "calorg").on("costaccount", "costaccount").on("storageorg", "storageorgunit").select(batModifyPriceDataSet.getRowMeta().getFieldNames(), new String[]{"costtype targetcosttype"}).finish();
        data = data.filter("targetcosttype != 0L");
        HashSet<Long> tarCostTypeIds = new HashSet<Long>(10);
        while (data.hasNext()) {
            Row row = data.next();
            Long targetCostType = row.getLong("targetcosttype");
            tarCostTypeIds.add(targetCostType);
        }
        return tarCostTypeIds;
    }

    private String getUpdateFailBillMsg(List<Long> updateBillIds) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"doUpdateByModifyCost", (String)"cad_costupdatenew", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "in", updateBillIds), new QFilter("updatestatus", "=", (Object)"N")}, null);
        String billNoStr = "";
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String billno = row.getString("billno");
            if (CadEmptyUtils.isEmpty((String)billno)) continue;
            if (CadEmptyUtils.isEmpty((String)billNoStr)) {
                billNoStr = billno;
                continue;
            }
            billNoStr = billNoStr + "\u3001" + billno;
        }
        if (CadEmptyUtils.isEmpty((String)billNoStr)) {
            return "";
        }
        String msg = ResManager.loadKDString((String)"\u66f4\u65b0\u7533\u8bf7\u5355\u201c%s\u201d\u672a\u5b8c\u6210\u66f4\u65b0\uff0c\u8bf7\u67e5\u770b\u66f4\u65b0\u62a5\u544a\u3002", (String)"BatModifyCostEditPlugin_22", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        return String.format(msg, billNoStr);
    }

    private long getElement(Long subElementId) {
        QFilter filter = new QFilter("subelement", "=", (Object)subElementId);
        DynamicObject dySubElement = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{filter});
        return dySubElement != null ? dySubElement.getLong("element.id") : 0L;
    }

    private Long[] getSubElementIdbyMaterial(Long materialId, Long orgId) {
        HashSet<Long> matIds = new HashSet<Long>();
        matIds.add(materialId);
        Map matToSubEleMap = ElementHelper.getDefSubEles((Long)orgId, matIds);
        return (Long[])matToSubEleMap.get(materialId);
    }

    private void dealImportData() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)org.getLong("id")), new QFilter("costaccount", "=", (Object)costAccount.getLong("id")), new QFilter("isupdate", "=", (Object)"0"), new QFilter("source", "=", (Object)"A")};
        DynamicObject[] batModifyPrices = BusinessDataServiceHelper.load((String)"cad_batmodifyprice", (String)"org,storageorg,costtype,costaccount,currency,material,configuredcode,tracknumber,amount,keycol,keycolid,entryentity.element,entryentity.subelement,entryentity.price", (QFilter[])filters);
        if (batModifyPrices.length == 0) {
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        Long currencyId = CalcRptHelper.getCurrency((DynamicObject)costAccount);
        Long storageOrgId = this.getEntryStorageOrg();
        List storeOrgIds = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)orgId, (boolean)false);
        Map mapStorageOrgs = null;
        if (!CadEmptyUtils.isEmpty((List)storeOrgIds)) {
            mapStorageOrgs = BusinessDataServiceHelper.loadFromCache((Object[])storeOrgIds.toArray(), (String)"bos_org");
        }
        ArrayList<Long> delEntryIds = new ArrayList<Long>(16);
        boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
        Map<Long, Long> orgAndCostTypes = this.getSrcCostTypes();
        for (DynamicObject batModifyPrice : batModifyPrices) {
            batModifyPrice.set("org", (Object)orgId);
            batModifyPrice.set("costaccount", (Object)costAccountId);
            batModifyPrice.set("currency", (Object)currencyId);
            DynamicObject storageOrg = batModifyPrice.getDynamicObject("storageorg");
            if (storageOrg == null) {
                if (storageOrgId == null) {
                    if (mapStorageOrgs != null) {
                        Collection mapStorages = mapStorageOrgs.values();
                        for (DynamicObject mapStorage : mapStorages) {
                            batModifyPrice.set("storageorg", (Object)mapStorage.getLong("id"));
                        }
                    }
                } else if (storageOrgId != 0L && storageOrgId > 0L) {
                    batModifyPrice.set("storageorg", (Object)storageOrgId);
                }
            }
            if (isOrgEnableMultiFactory) {
                if (batModifyPrice.get("storageorg") instanceof DynamicObject) {
                    DynamicObject storage = batModifyPrice.getDynamicObject("storageorg");
                    if (storage != null) {
                        batModifyPrice.set("costtype", (Object)orgAndCostTypes.get(storage.getLong("id")));
                    }
                } else if (batModifyPrice.get("storageorg") instanceof Long) {
                    batModifyPrice.set("costtype", (Object)orgAndCostTypes.get(batModifyPrice.getLong("storageorg")));
                }
            } else {
                batModifyPrice.set("costtype", (Object)orgAndCostTypes.get(org.getLong("id")));
            }
            HashMap<String, Long> values = new HashMap<String, Long>(7);
            values.put("material", batModifyPrice.getLong("material.id"));
            values.put("configuredcode", batModifyPrice.getLong("configuredcode.id"));
            values.put("tracknumber", batModifyPrice.getLong("tracknumber.id"));
            Keycol keyCol = CalcKeyHelper.getCalcKey(values, new ArrayList(1), (boolean)true);
            batModifyPrice.set("keycol", (Object)keyCol.getKeycol());
            batModifyPrice.set("keycolid", (Object)keyCol.getId());
            batModifyPrice.set("keycolid_id", (Object)keyCol.getId());
            DynamicObjectCollection entrys = batModifyPrice.getDynamicObjectCollection("entryentity");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entrys)) {
                DynamicObject entry = entrys.addNew();
                Object[] eleArr = this.getSubElementIdbyMaterial(batModifyPrice.getLong("material.id"), orgId);
                if (!CadEmptyUtils.isEmpty((Object[])eleArr)) {
                    entry.set("subelement", eleArr[1]);
                    entry.set("element", eleArr[0]);
                }
                batModifyPrice.set("amount", (Object)BigDecimal.ZERO);
                continue;
            }
            BigDecimal sumAmount = BigDecimal.ZERO;
            for (DynamicObject entry : entrys) {
                if (CadEmptyUtils.isEmpty((Long)entry.getLong("subelement.id"))) {
                    delEntryIds.add(entry.getLong("id"));
                    continue;
                }
                long subelement = entry.getLong("subelement.id");
                Long elementId = this.getElement(subelement);
                if (CadEmptyUtils.isEmpty((Long)elementId)) {
                    entry.set("element", null);
                } else {
                    entry.set("element", (Object)elementId);
                }
                BigDecimal price = entry.getBigDecimal("price");
                sumAmount = sumAmount.add(price);
            }
            batModifyPrice.set("amount", (Object)sumAmount);
        }
        try {
            SaveServiceHelper.update((DynamicObject[])batModifyPrices);
            if (!CadEmptyUtils.isEmpty(delEntryIds)) {
                ArrayList<Object[]> params = new ArrayList<Object[]>(16);
                String sql = "DELETE FROM T_CAD_BATMODIFYPRICEENTRY WHERE FENTRYID = ?";
                for (Long delEntryId : delEntryIds) {
                    Object[] param = new Object[]{new SqlParameter(":FENTRYID", -5, (Object)delEntryId)};
                    params.add(param);
                }
                if (!params.isEmpty()) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)sql, params);
                }
            }
            this.reloadEntryData();
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f15\u5165\u540e\u5904\u7406\u6570\u636e\u5b58\u5728\u5f02\u5e38\u3002", (String)"BatModifyCostEditPlugin_23", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            this.logger.info("\u5f15\u5165\u540e\u5904\u7406\u6570\u636e\u5b58\u5728\u5f02\u5e38\uff1a{}", (Object)ex.getMessage());
        }
    }

    private void doUpdate(ClosedCallBackEvent closedCallBackEvent) {
        Map returns = (Map)closedCallBackEvent.getReturnData();
        if (CadEmptyUtils.isEmpty((Map)returns)) {
            return;
        }
        Long periodId = (Long)returns.get("periodid");
        boolean isUpdateWizard = true;
        String way = (String)returns.get("operatekey");
        if (!"updatewizard".equals(way) && "directupdate".equals(way)) {
            isUpdateWizard = false;
        }
        this.doUpdate(periodId, isUpdateWizard);
    }

    private void clear() {
        QFilter filter = this.getCurDataFilter();
        if (filter != null) {
            DeleteServiceHelper.delete((String)"cad_batmodifyprice", (QFilter[])new QFilter[]{filter});
        }
        this.getModel().deleteEntryData("treeentryentity");
        this.getView().updateView("treeentryentity");
    }

    private void showFormByPeriod(String operateKey, BeforeDoOperationEventArgs args) {
        boolean flag = CostUpdateHelper.hasUpdatePerm((String)"cad_batmodifypricerpt");
        if (!flag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u8be5\u529f\u80fd\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BatModifyCostEditPlugin_24", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            args.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"BatModifyCostEditPlugin_25", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            args.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"BatModifyCostEditPlugin_26", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            args.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entrys)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6570\u636e\u3002", (String)"BatModifyCostEditPlugin_27", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            args.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        for (DynamicObject entry : entrys) {
            long material = entry.getLong("material.id");
            long costtype = entry.getLong("costtype.id");
            if (CadEmptyUtils.isEmpty((Long)material) || !CadEmptyUtils.isEmpty((Long)costtype)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"BatModifyCostEditPlugin_28", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            args.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        String tipMsg = this.haveUpdateBill();
        if (!CadEmptyUtils.isEmpty((String)tipMsg)) {
            this.getView().showMessage(tipMsg);
            args.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        String repeatMsg = this.volidate();
        if (!CadEmptyUtils.isEmpty((String)repeatMsg)) {
            this.getView().showMessage(repeatMsg);
            args.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        Boolean updateByPeriod = CostUpdateHelper.isUpdateByPeriod((Long)org.getLong("id"), (Long)costAccount.getLong("id"));
        if (updateByPeriod.booleanValue()) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("cad_batmodifyperiod");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("operatekey", (Object)operateKey);
            formShowParameter.setCustomParam("org", (Object)org.getLong("id"));
            formShowParameter.setCustomParam("costaccount", (Object)costAccount.getLong("id"));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batmodifyprice_period"));
            this.getView().showForm(formShowParameter);
        } else {
            boolean isUpdateWizard = "updatewizard".equals(operateKey);
            this.doUpdate(0L, isUpdateWizard);
        }
    }

    private String haveUpdateBill() {
        QFilter filter = this.getCurDataFilter();
        DynamicObjectCollection batModifys = QueryServiceHelper.query((String)"cad_batmodifyprice", (String)"id", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)batModifys)) {
            return null;
        }
        HashSet<Long> costTypes = new HashSet<Long>(10);
        HashSet<Long> keycolIds = new HashSet<Long>(10);
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        for (DynamicObject entry : entrys) {
            long keycolid;
            long costtype = entry.getLong("costtype.id");
            if (!CadEmptyUtils.isEmpty((Long)costtype)) {
                costTypes.add(costtype);
            }
            if (CadEmptyUtils.isEmpty((Long)(keycolid = entry.getLong("keycolid.id")))) continue;
            keycolIds.add(keycolid);
        }
        QFilter[] filters = new QFilter[]{new QFilter("srccosttype", "in", costTypes), new QFilter("updatestatus", "=", (Object)"N")};
        DynamicObjectCollection updateBills = QueryServiceHelper.query((String)"cad_costupdatenew", (String)"billno,targetcosttype,entryentity.material material,entryentity.matversion matversion,entryentity.auxprop auxprop,entryentity.project project,entryentity.configuredcode configuredcode,entryentity.tracknumber tracknumber,entryentity.lot lot", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)updateBills)) {
            return null;
        }
        HashMap<String, Object> values = new HashMap<String, Object>(7);
        HashSet<Long> targetCostTypeIds = new HashSet<Long>(16);
        HashSet<String> billNos = new HashSet<String>(16);
        for (DynamicObject updateBill : updateBills) {
            Long matId = updateBill.getLong("material");
            if (CadEmptyUtils.isEmpty((Long)matId)) continue;
            values.clear();
            values.put("material", updateBill.getLong("material"));
            values.put("matvers", updateBill.getLong("matversion"));
            values.put("auxproperty", updateBill.getLong("auxprop"));
            values.put("project", updateBill.getLong("project"));
            values.put("tracknumber", updateBill.getLong("tracknumber"));
            values.put("configuredcode", updateBill.getLong("configuredcode"));
            values.put("lot", updateBill.getString("lot"));
            Long keyColId = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)Boolean.FALSE).getId();
            if (!keycolIds.contains(keyColId)) continue;
            targetCostTypeIds.add(updateBill.getLong("targetcosttype"));
            billNos.add(updateBill.getString("billno"));
        }
        if (!CadEmptyUtils.isEmpty(targetCostTypeIds)) {
            filters = new QFilter[]{new QFilter("targetcosttype", "in", targetCostTypeIds), new QFilter("iscalccurlevel", "=", (Object)Boolean.FALSE), new QFilter("updatestatus", "=", (Object)Character.valueOf('N'))};
            updateBills = QueryServiceHelper.query((String)"cad_costupdatenew", (String)"billno", (QFilter[])filters);
            for (DynamicObject updateBill : updateBills) {
                billNos.add(updateBill.getString("billno"));
            }
        }
        if (CadEmptyUtils.isEmpty(billNos)) {
            return null;
        }
        return String.format(ResManager.loadKDString((String)"\u672c\u6b21\u66f4\u65b0\u4e2d\u5b58\u5728\u672a\u5b8c\u6210\u7684\u66f4\u65b0\u7533\u8bf7\u5355\uff1a%s\uff0c\u8bf7\u5220\u9664\u540e\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BatModifyCostEditPlugin_29", (String)"macc-cad-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", billNos));
    }

    private void showUpdateReport() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"BatModifyCostEditPlugin_25", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"BatModifyCostEditPlugin_26", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
        ArrayList<Long> targetCostTypeIds = new ArrayList<Long>(16);
        Date date = TimeServiceHelper.now();
        if (isOrgEnableMultiFactory) {
            DynamicObjectCollection storageOrgs = (DynamicObjectCollection)this.getModel().getValue("storageorg");
            ArrayList storageOrgIds = new ArrayList(storageOrgs.size());
            storageOrgs.forEach(p -> storageOrgIds.add(p.getDynamicObject("fbasedataid").getLong("id")));
            QFilter[] filters = new QFilter[]{new QFilter("costaccount", "=", (Object)costAccount.getLong("id")), CadEmptyUtils.isEmpty(storageOrgIds) ? null : new QFilter("storageorgunit", "in", storageOrgIds), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
            DataSet orgCostTypes = QueryServiceHelper.queryDataSet((String)"getTargetCostTypes", (String)"cal_bd_costtypeorg", (String)"costtype", (QFilter[])filters, null);
            for (Row row : orgCostTypes) {
                targetCostTypeIds.add(row.getLong("costtype"));
            }
        } else {
            QFilter[] filters = new QFilter[]{new QFilter("costaccount", "=", (Object)costAccount.getLong("id")), new QFilter("calorg", "=", (Object)org.getLong("id")), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
            DataSet orgCostTypes = QueryServiceHelper.queryDataSet((String)"getTargetCostTypes", (String)"cal_bd_costtypeorg", (String)"costtype", (QFilter[])filters, null);
            for (Row row : orgCostTypes) {
                targetCostTypeIds.add(row.getLong("costtype"));
            }
        }
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_list");
        param.setBillFormId("cad_calctaskrecord");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("source", (Object)"update");
        param.setCustomParam("userid", (Object)RequestContext.getOrCreate().getCurrUserId());
        param.setCustomParam("targetcosttypeids", targetCostTypeIds);
        param.setCaption(ResManager.loadKDString((String)"\u66f4\u65b0\u62a5\u544a", (String)"BatModifyCostEditPlugin_30", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        param.setHasRight(true);
        this.getView().showForm((FormShowParameter)param);
    }

    public static ExportWriterFormat getExportWriterFormatAndWriteHead(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, String routeAppId, Object formId, Object template, Object extendData) {
        ExportWriterFormat format = null;
        String exportJSon = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)routeAppId, (String)"MetadataService", (String)"getExportWriter", (Object[])new Object[]{formId, template, "", extendData});
        if (!StringUtils.isEmpty((CharSequence)exportJSon) && exportJSon.startsWith("[")) {
            List formatArr = JSONArray.parseArray((String)exportJSon, ExportWriterFormat.class);
            if (formatArr != null && formatArr.size() > 0) {
                format = (ExportWriterFormat)formatArr.get(0);
            }
        } else {
            format = (ExportWriterFormat)JSONObject.parseObject((String)exportJSon, ExportWriterFormat.class);
        }
        ExportWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (ExportWriterFormat)format);
        return format;
    }

    private void setEntryDynamicObjValue(DynamicObject rowData, DynamicObject exportRow, String rowProp, String rowNameProp, String entityName, String setProp, Map<String, DynamicObject> cacheMap) {
        String rowPropValue = rowData.getString(rowProp);
        if (StringUtils.isEmpty((CharSequence)rowPropValue)) {
            return;
        }
        DynamicObject cacheMapValue = cacheMap.get(rowPropValue);
        if (cacheMapValue != null) {
            exportRow.set(setProp, (Object)cacheMapValue);
        } else {
            DynamicObject entityObj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            entityObj.set("number", (Object)rowPropValue);
            if (rowNameProp != null) {
                String rowPropNameValue = rowData.getString(rowNameProp);
                entityObj.set("name", (Object)rowPropNameValue);
            }
            exportRow.set(setProp, (Object)entityObj);
            cacheMap.put(rowPropValue, entityObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(SXSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        String url = "";
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
        return url;
    }

    private String checkData() {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entrys)) {
            return ResManager.loadKDString((String)"\u5206\u5f55\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"BatModifyCostEditPlugin_31", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        }
        int parentIndex = 0;
        int i = 0;
        Long storageOrgId = this.getEntryStorageOrg();
        StringBuilder sb = new StringBuilder();
        for (DynamicObject entry : entrys) {
            BigDecimal price;
            DynamicObject subElement;
            DynamicObject element;
            String trackNumber;
            String configuredCode;
            DynamicObject material;
            ++i;
            Long pid = entry.getLong("pid");
            if (CadEmptyUtils.isEmpty((Long)pid)) {
                BigDecimal price2;
                parentIndex = i - 1;
                material = entry.getDynamicObject("material");
                configuredCode = entry.getString("configuredcode.number");
                trackNumber = entry.getString("tracknumber.number");
                if (material == null) {
                    sb.append(ResManager.loadKDString((String)"\u201c\u7269\u6599\u7f16\u7801\u201d\u672a\u586b\u5199\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BatModifyCostEditPlugin_42", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                }
                DynamicObject entryStorageOrg = entry.getDynamicObject("entrystorageorg");
                if (storageOrgId == null && CadEmptyUtils.isEmpty((DynamicObject)entryStorageOrg)) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u7684\u201c\u5e93\u5b58\u7ec4\u7ec7\u201d\u3002", (String)"BatModifyCostEditPlugin_33", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getMatMsgInfo(entry.getString("material.number"), entry.getString("material.name"), configuredCode, trackNumber)));
                }
                if ((price2 = entry.getBigDecimal("price")) == null || price2.compareTo(BigDecimal.ZERO) >= 0) continue;
                sb.append(String.format(ResManager.loadKDString((String)"%s\u7684\u201c\u65b0\u6807\u51c6\u6210\u672c\u201d\u5c0f\u4e8e0\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"BatModifyCostEditPlugin_34", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getMatMsgInfo(entry.getString("material.number"), entry.getString("material.name"), configuredCode, trackNumber)));
                continue;
            }
            material = (DynamicObject)this.getModel().getValue("material", parentIndex);
            configuredCode = "";
            if (this.getModel().getValue("configuredcode", parentIndex) != null) {
                configuredCode = ((DynamicObject)this.getModel().getValue("configuredcode", parentIndex)).getString("number");
            }
            trackNumber = "";
            if (this.getModel().getValue("tracknumber", parentIndex) != null) {
                trackNumber = ((DynamicObject)this.getModel().getValue("tracknumber", parentIndex)).getString("number");
            }
            if (material == null) {
                sb.append(ResManager.loadKDString((String)"\u201c\u7269\u6599\u7f16\u7801\u201d\u672a\u586b\u5199\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BatModifyCostEditPlugin_42", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
            if ((element = entry.getDynamicObject("element")) == null) {
                sb.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u7684\u201c\u6210\u672c\u8981\u7d20\u7f16\u53f7\u201d\u3002", (String)"BatModifyCostEditPlugin_35", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getMatMsgInfo(material == null ? "" : material.getString("number"), material == null ? "" : material.getString("name"), configuredCode, trackNumber)));
            }
            if ((subElement = entry.getDynamicObject("subelement")) == null) {
                sb.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u7684\u201c\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801\u201d\u3002", (String)"BatModifyCostEditPlugin_43", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getMatMsgInfo(material == null ? "" : material.getString("number"), material == null ? "" : material.getString("name"), configuredCode, trackNumber)));
            }
            if ((price = entry.getBigDecimal("price")) != null) continue;
            sb.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u7684\u201c\u65b0\u6807\u51c6\u6210\u672c\u201d\u3002", (String)"BatModifyCostEditPlugin_37", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getMatMsgInfo(material == null ? "" : material.getString("number"), material == null ? "" : material.getString("name"), configuredCode, trackNumber)));
        }
        return sb.toString();
    }

    private String getMatMsgInfo(String materialNumber, String materialName, String configNumber, String trackNumber) {
        if (CadEmptyUtils.isEmpty((String)materialNumber)) {
            return "";
        }
        if (StringUtils.isNotEmpty((CharSequence)configNumber) && StringUtils.isNotEmpty((CharSequence)trackNumber)) {
            return String.format(ResManager.loadKDString((String)"\u7269\u6599\u3010%1$s/%2$s\u3011\u914d\u7f6e\u53f7\u3010%3$s\u3011\u8ddf\u8e2a\u53f7\u3010%4$s\u3011", (String)"BatModifyCostEditPlugin_38", (String)"macc-cad-formplugin", (Object[])new Object[0]), materialNumber, materialName, configNumber, trackNumber);
        }
        if (StringUtils.isNotEmpty((CharSequence)configNumber)) {
            return String.format(ResManager.loadKDString((String)"\u7269\u6599\u3010%1$s/%2$s\u3011\u914d\u7f6e\u53f7\u3010%3$s\u3011", (String)"BatModifyCostEditPlugin_39", (String)"macc-cad-formplugin", (Object[])new Object[0]), materialNumber, materialName, configNumber);
        }
        if (StringUtils.isNotEmpty((CharSequence)trackNumber)) {
            return String.format(ResManager.loadKDString((String)"\u7269\u6599\u3010%1$s/%2$s\u3011\u8ddf\u8e2a\u53f7\u3010%3$s\u3011", (String)"BatModifyCostEditPlugin_40", (String)"macc-cad-formplugin", (Object[])new Object[0]), materialNumber, materialName, trackNumber);
        }
        return String.format(ResManager.loadKDString((String)"\u7269\u6599\u3010%1$s/%2$s\u3011", (String)"BatModifyCostEditPlugin_41", (String)"macc-cad-formplugin", (Object[])new Object[0]), materialNumber, materialName);
    }

    private int getParentIndex(int rowIndex) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        long pid = ((DynamicObject)entrys.get(rowIndex)).getLong("pid");
        for (int i = 0; i < entrys.size(); ++i) {
            if (pid != ((DynamicObject)entrys.get(i)).getLong("id")) continue;
            return i;
        }
        return -1;
    }

    private int[] getSubRowIndexs(int rowIndex) {
        ArrayList<Integer> subRowIndexs = new ArrayList<Integer>(16);
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        long pid = ((DynamicObject)entrys.get(rowIndex)).getLong("pid");
        if (CadEmptyUtils.isEmpty((Long)pid)) {
            long id = ((DynamicObject)entrys.get(rowIndex)).getLong("id");
            for (int i = 0; i < entrys.size(); ++i) {
                if (id != ((DynamicObject)entrys.get(i)).getLong("pid")) continue;
                subRowIndexs.add(i);
            }
        }
        if (CadEmptyUtils.isEmpty(subRowIndexs)) {
            return null;
        }
        int[] result = new int[subRowIndexs.size()];
        for (int w = 0; w < subRowIndexs.size(); ++w) {
            result[w] = (Integer)subRowIndexs.get(w);
        }
        return result;
    }

    private void fillSubElementInfo(int rowIndex) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        long pid = ((DynamicObject)entrys.get(rowIndex)).getLong("pid");
        if (CadEmptyUtils.isEmpty((Long)pid)) {
            Long parentId = ((DynamicObject)entrys.get(rowIndex)).getLong("id");
            for (int i = 0; i < entrys.size(); ++i) {
                if (parentId.longValue() != ((DynamicObject)entrys.get(i)).getLong("pid")) continue;
                return;
            }
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
            if (material == null) {
                return;
            }
            DynamicObject configuredCode = (DynamicObject)this.getModel().getValue("configuredcode", rowIndex);
            Long configuredCodeId = configuredCode == null ? 0L : configuredCode.getLong("id");
            DynamicObject trackNumber = (DynamicObject)this.getModel().getValue("tracknumber", rowIndex);
            Long trackNumberId = trackNumber == null ? 0L : trackNumber.getLong("id");
            HashMap<String, Long> values = new HashMap<String, Long>(3);
            values.put("material", material.getLong("id"));
            values.put("configuredcode", configuredCodeId);
            values.put("tracknumber", trackNumberId);
            Long keyColId = CalcKeyHelper.getCalcKey(values, new ArrayList(1), (boolean)true).getId();
            DynamicObject storageOrg = (DynamicObject)this.getModel().getValue("entrystorageorg", rowIndex);
            Long storageOrgId = storageOrg == null ? 0L : storageOrg.getLong("id");
            if (CadEmptyUtils.isEmpty((Long)storageOrgId)) {
                return;
            }
            Long targetCostTypeId = this.getTargetCostTypeId(storageOrgId);
            if (CadEmptyUtils.isEmpty((Long)targetCostTypeId)) {
                return;
            }
            ArrayList<Long> targetCostTypeIds = new ArrayList<Long>(1);
            targetCostTypeIds.add(targetCostTypeId);
            Map<String, BigDecimal> subInfos = this.getOldPrices(targetCostTypeIds);
            String key = String.valueOf(targetCostTypeId) + "@" + keyColId + "@";
            for (Map.Entry<String, BigDecimal> subInfo : subInfos.entrySet()) {
                if (!subInfo.getKey().startsWith(key)) continue;
                Long subElementId = Long.valueOf(subInfo.getKey().replace(key, ""));
                int curIndex = this.getModel().insertEntryRow("treeentryentity", rowIndex);
                this.getModel().setValue("subelement", (Object)subElementId, curIndex);
                this.getModel().setValue("oldprice", (Object)subInfo.getValue(), curIndex);
            }
        }
    }

    private void deleteSubEntryRows(int rowIndex) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        long pid = ((DynamicObject)entrys.get(rowIndex)).getLong("pid");
        if (CadEmptyUtils.isEmpty((Long)pid)) {
            Long parentId = ((DynamicObject)entrys.get(rowIndex)).getLong("id");
            ArrayList<Integer> subRowIndexList = new ArrayList<Integer>(10);
            int index = 0;
            for (int i = 0; i < entrys.size(); ++i) {
                if (parentId.longValue() != ((DynamicObject)entrys.get(i)).getLong("pid")) continue;
                subRowIndexList.add(i);
                ++index;
            }
            int[] subRowIndexs = new int[index];
            int index1 = 0;
            for (Integer integer : subRowIndexList) {
                subRowIndexs[index1] = integer;
                ++index1;
            }
            this.getModel().deleteEntryRows("treeentryentity", subRowIndexs);
        }
    }

    private void clearOldPrice(int rowIndex) {
        this.getModel().setValue("oldprice", (Object)BigDecimal.ZERO, rowIndex);
        this.getModel().setValue("price", (Object)BigDecimal.ZERO, rowIndex);
    }

    private void deleteSubEntryEmptyRows() {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        ArrayList<Integer> subRowIndexList = new ArrayList<Integer>(10);
        int index = 0;
        for (int i = 0; i < entrys.size(); ++i) {
            long pid = ((DynamicObject)entrys.get(i)).getLong("pid");
            if (CadEmptyUtils.isEmpty((Long)pid)) {
                if (!CadEmptyUtils.isEmpty((Long)((DynamicObject)entrys.get(i)).getLong("material.id")) || !CadEmptyUtils.isEmpty((Long)((DynamicObject)entrys.get(i)).getLong("keycolid.id"))) continue;
                subRowIndexList.add(i);
                ++index;
                continue;
            }
            if (!CadEmptyUtils.isEmpty((Long)((DynamicObject)entrys.get(i)).getLong("element.id")) || !CadEmptyUtils.isEmpty((Long)((DynamicObject)entrys.get(i)).getLong("subelement.id"))) continue;
            subRowIndexList.add(i);
            ++index;
        }
        int[] subRowIndexs = new int[index];
        int index1 = 0;
        for (Integer integer : subRowIndexList) {
            subRowIndexs[index1] = integer;
            ++index1;
        }
        this.getModel().deleteEntryRows("treeentryentity", subRowIndexs);
    }
}

