/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.price;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.helper.ConfigTrackHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.PriceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.common.Util;
import kd.macc.cad.formplugin.price.PriceCommon;

public class OutSourcePriceEditPlugin
extends AbstractBillPlugIn {
    private static final String TYPE = "005";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costTypeCtrl = (BasedataEdit)this.getControl("costtype");
        costTypeCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("type", "not in", (Object)"1"));
        });
        BasedataEdit materialCtrl = (BasedataEdit)this.getControl("material");
        materialCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Set materialBySalOrder;
            ListShowParameter fParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            fParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
            ListFilterParameter filterParameter = fParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            qList.add(new QFilter("enableoutsource", "=", (Object)true));
            DynamicObject dyCostType = (DynamicObject)this.getModel().getValue("costtype");
            if (dyCostType == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"OutSourcePriceEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            Long orgId = dyCostType.getDynamicObject("createorg").getLong("id");
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)orgId);
            if (baseDataFilter != null) {
                qList.add(baseDataFilter);
            }
            DynamicObject configuredcode = (DynamicObject)this.getModel().getValue("configuredcode");
            DynamicObject tracknumber = (DynamicObject)this.getModel().getValue("tracknumber");
            if (!(configuredcode == null && tracknumber == null || CadEmptyUtils.isEmpty((Set)(materialBySalOrder = ConfigTrackHelper.getMaterialBySalOrder((Long)(configuredcode == null ? 0L : configuredcode.getLong("id")), (Long)(tracknumber == null ? 0L : tracknumber.getLong("id"))))))) {
                qList.add(new QFilter("id", "in", (Object)materialBySalOrder));
            }
        });
        BasedataEdit matVersion = (BasedataEdit)this.getControl("matversion");
        matVersion.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject mat = (DynamicObject)this.getModel().getValue("material");
            if (mat != null) {
                ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter filterParameter = parameter.getListFilterParameter();
                List qList = filterParameter.getQFilters();
                qList.add(new QFilter("material", "=", mat.getPkValue()));
            }
        });
        BasedataEdit configuredCode = (BasedataEdit)this.getControl("configuredcode");
        configuredCode.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List configCodeIds;
            ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = parameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject mat = (DynamicObject)this.getModel().getValue("material");
            if (mat != null && !CadEmptyUtils.isEmpty((List)(configCodeIds = ConfigTrackHelper.getConfigCodeIdsByMaterial(Collections.singleton(mat.getLong("id")))))) {
                qList.add(new QFilter("id", "in", (Object)configCodeIds));
            }
        });
        BasedataEdit elementCtrl = (BasedataEdit)this.getControl("element");
        elementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter fParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = fParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            qList.add(new QFilter("type", "=", (Object)TYPE));
        });
        BasedataEdit subElementCtrl = (BasedataEdit)this.getControl("subelement");
        subElementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject element = (DynamicObject)this.getModel().getValue("element", beforeF7SelectEvent.getRow());
            if (element == null) {
                showParameter.getListFilterParameter().setFilter(new QFilter("type", "=", (Object)TYPE));
            } else {
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", this.getSubElement(element.getLong("id"))));
            }
        });
        BasedataEdit extSubElement = (BasedataEdit)this.getControl("extsubelement");
        extSubElement.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("type", "in", (Object)new String[]{"002", "003", "004"}));
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            Set extSubElementIds = entryEntity.stream().map(s -> s.getLong("extsubelement.id")).collect(Collectors.toSet());
            if (!CadEmptyUtils.isEmpty(extSubElementIds)) {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", extSubElementIds));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("pricerule", (Object)PriceRuleConstants.OUTPRI_MANUALLY_ID);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)status)) {
            long id = this.getModel().getDataEntity().getLong("pricerule.id");
            if (id == PriceRuleConstants.OUTPRI_MANUALLY_ID) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"supplierinfo"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"supplierinfo"});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"pricerule"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"supplierinfo"});
        }
        this.effectDateEnable();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getOperationKey().toUpperCase()) {
            case "COPY": {
                DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
                if (priceRule == null) {
                    return;
                }
                PriceCommon.copyCheck(this.getView(), evt, priceRule.getLong("id"));
                break;
            }
        }
    }

    private void effectDateEnable() {
        PriceHelper.effectDateEnable((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"cad_outsourceprice");
    }

    private void setExtElement(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            DynamicObject row = changeData.getDataEntity();
            DynamicObject extSubElement = row.getDynamicObject("extsubelement");
            int seq = row.getInt("seq");
            int rowIndex = seq - 1;
            if (extSubElement == null) {
                this.getModel().setValue("extelement", null, rowIndex);
                return;
            }
            QFilter subIdFilter = new QFilter("subelement", "=", (Object)extSubElement.getLong("id"));
            DynamicObject elementDetail = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element.id", (QFilter[])new QFilter[]{subIdFilter});
            if (elementDetail != null) {
                this.getModel().setValue("extelement", (Object)elementDetail.getLong("element.id"), rowIndex);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            this.getView().updateView("keycol");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName().toUpperCase();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "COSTTYPE": {
                this.bindCurrency();
                break;
            }
            case "MATERIAL": {
                Util.ctrlVerAndAuxpty(this.getView());
                this.setEableOutSource();
                DynamicObject costtype = (DynamicObject)this.getModel().getValue("costtype");
                if (!CostTypeHelper.isUseMatVersion((Long)(CadEmptyUtils.isEmpty((DynamicObject)costtype) ? 0L : costtype.getLong("id")))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"matversion"});
                }
                this.effectDateEnable();
                if (newValue != null) break;
                this.getModel().setValue("configuredcode", null);
                this.getModel().setValue("tracknumber", null);
                break;
            }
            case "ELEMENT": {
                this.setDefaultSubElement(e);
                break;
            }
            case "SUBELEMENT": {
                this.setElement(e);
                break;
            }
            case "EXTSUBELEMENT": {
                this.setExtElement(e);
                break;
            }
            case "CONFIGUREDCODE": {
                ConfigTrackHelper.setMaterialValueByConfig((IFormView)this.getView(), (IDataModel)this.getModel(), null);
                ConfigTrackHelper.setTrackValueByConfig((IFormView)this.getView(), (IDataModel)this.getModel(), null);
                this.effectDateEnable();
                break;
            }
            case "TRACKNUMBER": {
                ConfigTrackHelper.setConfigValueByTrack((IFormView)this.getView(), (IDataModel)this.getModel(), null);
                this.effectDateEnable();
                break;
            }
            case "LOT": 
            case "PROJECT": 
            case "AUXPTY": {
                this.effectDateEnable();
                break;
            }
            case "PRICEEFFECTDATE": {
                this.getModel().setValue("effectdate", (Object)this.getModel().getDataEntity().getDate("priceeffectdate"));
                break;
            }
            default: {
                return;
            }
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject costTypeDy;
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object costType = fsp.getCustomParam("CostType");
        if (costType != null) {
            this.getModel().setValue("costtype", costType);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"costtype"});
            this.bindCurrency();
            this.setEableOutSource();
            this.getModel().setDataChanged(false);
        }
        Util.ctrlVerAndAuxpty(this.getView());
        if (PriceCommon.isCalcCostType((String)costType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_new", "bar_del", "bar_save", "bar_modify", "bar_submit", "bar_audit", "bar_submitandnew"});
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)(costTypeDy = (DynamicObject)this.getModel().getValue("costtype"))) && !CostTypeHelper.isUseMatVersion((Long)costTypeDy.getLong("id"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"matversion"});
            BasedataEdit matversion = (BasedataEdit)this.getView().getControl("matversion");
            matversion.setMustInput(false);
        }
        this.setDefaultElement();
        PriceHelper.setVisibleField((long)this.getModel().getDataEntity().getLong("costtype.id"), (IFormView)this.getView());
    }

    private void setDefaultElement() {
        QFilter qFilter = new QFilter("type", "=", (Object)TYPE);
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        List elementIds = QueryServiceHelper.queryPrimaryKeys((String)"cad_element", (QFilter[])qFilter.toArray(), null, (int)-1);
        if (!CadEmptyUtils.isEmpty((List)elementIds) && elementIds.size() == 1) {
            this.getModel().setValue("element", elementIds.get(0));
        }
    }

    private void setDefaultSubElement(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject ele = (DynamicObject)this.getView().getModel().getValue("element", rowIndex);
        if (ele == null) {
            return;
        }
        long elementId = ele.getLong("id");
        QFilter qfElement = new QFilter("id", "=", (Object)elementId);
        DynamicObject dyElement = QueryServiceHelper.queryOne((String)"cad_element", (String)"elementtype.id", (QFilter[])new QFilter[]{qfElement});
        long elementTypeId = dyElement.getLong("elementtype.id");
        qfElement = new QFilter("element", "=", (Object)elementId);
        QFilter qfElementType = new QFilter("elementtype", "=", (Object)elementTypeId);
        DynamicObjectCollection dyElementRelation = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement", (QFilter[])new QFilter[]{qfElement, qfElementType});
        if (dyElementRelation == null) {
            return;
        }
        HashSet<Long> eleIds = new HashSet<Long>();
        for (DynamicObject subElement : dyElementRelation) {
            eleIds.add(subElement.getLong("subelement"));
        }
        QFilter qfDefault = new QFilter("defaultvalue", "=", (Object)true);
        QFilter qfSubElement = new QFilter("id", "in", eleIds);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{qfSubElement, qfDefault});
        if (dySubElement != null) {
            this.getView().getModel().setValue("subelement", (Object)dySubElement.getLong("id"), rowIndex);
        }
    }

    private void setElement(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject subEle = (DynamicObject)this.getView().getModel().getValue("subelement", rowIndex);
        if (subEle == null) {
            return;
        }
        long subElementId = subEle.getLong("id");
        QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
        if (dySubElement != null) {
            this.getView().getModel().setValue("element", (Object)dySubElement.getLong("element"), rowIndex);
        }
    }

    private void bindCurrency() {
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        if (costType == null) {
            return;
        }
        this.getModel().setValue("currency", (Object)costType.getLong("currency.id"));
    }

    private void setEableOutSource() {
        Boolean enableOut = false;
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material != null) {
            enableOut = material.getBoolean("enableoutsource");
        }
        this.getModel().setValue("businessctrl", enableOut != false ? ResManager.loadKDString((String)"\u53ef\u59d4\u5916", (String)"OutSourcePriceEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]) : null);
    }

    private Set<Long> getSubElement(long elementId) {
        HashSet<Long> subElementIds = new HashSet<Long>();
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        if (costType == null) {
            return subElementIds;
        }
        Long costTypeId = costType.getLong("id");
        QFilter qfCostTypeId = new QFilter("id", "=", (Object)costTypeId);
        DynamicObject dyCostType = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"elementtype.id", (QFilter[])new QFilter[]{qfCostTypeId});
        if (dyCostType == null) {
            return subElementIds;
        }
        long elementTypeId = dyCostType.getLong("elementtype.id");
        QFilter qfElement = new QFilter("element", "=", (Object)elementId);
        QFilter qfElementType = new QFilter("elementtype", "=", (Object)elementTypeId);
        DynamicObjectCollection elementDetail = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement.id", (QFilter[])new QFilter[]{qfElement, qfElementType});
        if (elementDetail.size() == 0) {
            return subElementIds;
        }
        for (DynamicObject ele : elementDetail) {
            subElementIds.add(ele.getLong("subelement.id"));
        }
        return subElementIds;
    }
}

