/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.price;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.helper.PriceHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.common.Util;
import kd.macc.cad.formplugin.price.PriceCommon;

public class OutSourcePriceListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(OutSourcePriceListPlugin.class);
    private static final String closeBack_doPricing = "closeBack_doPricing";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"bar_new"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey().toUpperCase()) {
            case "TBLNEW": 
            case "TBLDEL": 
            case "TBLSUBMIT": 
            case "TBLUNSUBMIT": 
            case "TBLCHECK": 
            case "TBLUNAUDIT": 
            case "COPY": {
                String tip = ResManager.loadKDString((String)"\u4ea7\u54c1\u59d4\u5916\u6807\u51c6\u4ef7\u76ee\u8868", (String)"OutSourcePriceListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                PriceCommon.checkType(this.getView(), evt, this.getCacheCostType(), tip);
                break;
            }
            case "SYNCOSTTYPE": {
                break;
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String costTypeId = PriceCommon.getCostTypeId(e.getParameter().getFormId(), e.getParameter().getPkId());
        if (StringUtils.isEmpty((String)costTypeId)) {
            costTypeId = this.getCacheCostType();
        }
        e.getParameter().setCustomParam("CostType", (Object)costTypeId);
        if (!PriceCommon.isSimulatedCostType(costTypeId)) {
            e.getParameter().setStatus(OperationStatus.VIEW);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String pageCacheCosttype = this.getPageCache().get("CostType");
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("costtype.")) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            List<ComboItem> costTypes = PriceCommon.getCostTypeComboItemList(this.getView().getFormShowParameter().getAppId());
            if (costTypes == null || costTypes.isEmpty()) break;
            commonFilterColumn.setComboItems(costTypes);
            ComboItem item = costTypes.get(0);
            commonFilterColumn.setDefaultValue(item.getValue());
            commonFilterColumn.setMustInput(true);
            if (!CadEmptyUtils.isEmpty((String)pageCacheCosttype)) break;
            pageCacheCosttype = item.getValue();
            break;
        }
        if (pageCacheCosttype != null) {
            this.getPageCache().put("CostType", pageCacheCosttype);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        String field = e.getFieldName();
        if ("costtype.id".equals(field) || "costtype.name".equals(field)) {
            e.addCustomQFilter(CostTypeHelper.getCostTypeByAppNum((IFormView)this.getView()));
            QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
            if (baseDataFilter != null) {
                e.getQfilters().add(baseDataFilter);
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        if (filterValues.containsKey("customfilter") || filterValues.containsKey("schemefilter")) {
            List customfilter = (List)filterValues.get("customfilter");
            List list = customfilter = customfilter != null ? customfilter : (List)filterValues.get("schemefilter");
            if (customfilter == null || customfilter.isEmpty()) {
                return;
            }
            String pageCacheCosttype = null;
            for (int i = 0; i < customfilter.size(); ++i) {
                Map map = (Map)customfilter.get(i);
                List listFieldName = (List)map.get("FieldName");
                for (int j = 0; j < listFieldName.size(); ++j) {
                    if (listFieldName.get(j).equals("costtype.id")) {
                        List listValue = (List)map.get("Value");
                        pageCacheCosttype = (String)listValue.get(j);
                        continue;
                    }
                    if (!listFieldName.get(j).equals("costtype.name")) continue;
                    List ids = (List)map.get("Id");
                    List list2 = ids = ids == null ? (List)map.get("id") : ids;
                    if (CadEmptyUtils.isEmpty((List)ids)) continue;
                    pageCacheCosttype = ids.get(0).toString();
                }
            }
            if (pageCacheCosttype != null) {
                this.getPageCache().put("CostType", pageCacheCosttype);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            e.getQFilters().add(new QFilter("costtype.type", "=", (Object)"1"));
        }
        List filters = e.getQFilters();
        PriceHelper.filterExpDate((List)filters);
        e.setOrderBy("billno asc,costtype.name asc,entryentity.extelement.number asc,entryentity.extsubelement.number asc");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBusinessCtrl();
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"quickupdate"});
        }
        PriceHelper.updateDate((BillList)((BillList)this.getControl("billlistap")), (String)this.getPageCache().get("CostType"), (String)"cad_outsourceprice");
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        List listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            switch (column.toString()) {
                case "costtype.name": {
                    column.setFixed(true);
                    break;
                }
                case "billno": {
                    column.setFixed(true);
                    break;
                }
                case "material.number": {
                    column.setFixed(true);
                    break;
                }
                case "material.name": {
                    column.setFixed(true);
                    break;
                }
                case "businessctrl": {
                    column.setVisible(0);
                    break;
                }
                case "matversion.name": {
                    column.setVisible(0);
                    break;
                }
                case "auxpty": {
                    column.setVisible(0);
                    break;
                }
                case "remark": {
                    column.setVisible(0);
                    break;
                }
            }
        }
        PriceHelper.hideDate((String)this.getPageCache().get("CostType"), (BeforeCreateListColumnsArgs)o);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "syncosttype": {
                if (!PriceCommon.isPermItemPermission(RequestContext.get().getCurrUserId(), "cad_outsourceprice", "47156aff000000ac")) {
                    return;
                }
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection rows = billList.getSelectedRows();
                Util.openSyncCostTypeView(this.getView(), "cad_outsourceprice", rows);
                break;
            }
            case "autoprice": {
                this.doAutoPrice();
                break;
            }
            case "quickupdate": {
                this.showQuickUpdateApply();
                break;
            }
        }
    }

    private String getCacheCostType() {
        String id = this.getPageCache().get("CostType");
        if (StringUtils.isEmpty((String)id) && StringUtils.isNotEmpty((String)(id = this.getDefualtSelectCostType()))) {
            this.getPageCache().put("CostType", id);
        }
        return id;
    }

    private String getDefualtSelectCostType() {
        DynamicObject[] costTypes;
        Boolean isAca = "aca".equals(this.getView().getFormShowParameter().getAppId());
        DynamicObject[] dynamicObjectArray = costTypes = isAca != false ? ElementRelationHelper.getModeCostTypes() : ElementRelationHelper.getCostTypes();
        if (costTypes == null || costTypes.length < 1) {
            return null;
        }
        return String.valueOf(costTypes[0].getLong("id"));
    }

    private void setBusinessCtrl() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        Map<Object, String> busCtrl = this.getBusinessCtrl(rows);
        if (busCtrl == null) {
            return;
        }
        int i = 0;
        for (ListSelectedRow row : rows) {
            String id = row.getPrimaryKeyValue().toString();
            if (StringUtils.isNotEmpty((String)id) && busCtrl.containsKey(id)) {
                billList.setCellFieldValue("businessctrl", i, (Object)busCtrl.get(id));
            }
            ++i;
        }
    }

    private Map<Object, String> getBusinessCtrl(ListSelectedRowCollection rows) {
        if (rows == null || rows.isEmpty()) {
            return null;
        }
        ArrayList<Object> ids = new ArrayList<Object>();
        for (ListSelectedRow row : rows) {
            ids.add(row.getPrimaryKeyValue());
        }
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection outSourcePrice = QueryServiceHelper.query((String)"cad_outsourceprice", (String)"id,material.enableoutsource enableoutsource", (QFilter[])new QFilter[]{filter});
        HashMap<Object, String> map = new HashMap<Object, String>();
        String val = ResManager.loadKDString((String)"\u53ef\u59d4\u5916", (String)"OutSourcePriceListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        for (DynamicObject source : outSourcePrice) {
            if (source == null || !source.getBoolean("enableoutsource")) continue;
            map.put(source.getString("id"), val);
        }
        return map;
    }

    private void doAutoPrice() {
        String costtypeId = this.getPageCache().get("CostType");
        if (costtypeId != null) {
            long costType = Long.parseLong(costtypeId);
            DynamicObject object = CostTypeHelper.getCostType((Long)costType, (String)"type,name");
            if ("0".equals(object.getString("type"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u7c7b\u578b\u4e3a\u6838\u7b97\u6210\u672c\uff0c\u4e0d\u80fd\u8fdb\u884c\u81ea\u52a8\u53d6\u4ef7\u3002", (String)"OutSourcePriceListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            DLock lock = DLock.create((String)("AutoPricing_cad_outsourceprice_" + costType), (String)ResManager.loadKDString((String)"\u4ea7\u54c1\u59d4\u5916\u6807\u51c6\u4ef7\u76ee\u8868\u53d6\u4ef7\u9501", (String)"OutSourcePriceListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            boolean isLocked = lock.tryLock();
            if (!isLocked) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u3010%s\u3011\u6b63\u5728\u8fdb\u884c\u91c7\u8d2d\u53d6\u4ef7\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"OutSourcePriceListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]), object.getString("name")));
                return;
            }
            List orgList = CostTypeHelper.getOrgByCostType((Long)costType);
            ArrayList accountList = new ArrayList(5);
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u53d6\u4ef7", (String)"OutSourcePriceListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                Map result = new HashMap(16);
                try {
                    result = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"AutoPricingService", (String)"execute", (Object[])new Object[]{"cad_outsourceprice", orgList, accountList, RequestContext.get().getCurrUserId(), costType, this.getView().getFormShowParameter().getAppId(), progressId});
                }
                catch (Exception e) {
                    logger.error("\u8c03\u7528\u5fae\u670d\u52a1-\u53d6\u4ef7\u62a5\u9519\uff1a", (Throwable)e);
                }
                finally {
                    if (lock != null) {
                        lock.close();
                    }
                }
                logger.info("\u53d6\u4ef7\uff0ccount\uff1a{}", result.get("count"));
                this.getPageCache().put("responseInfo", SerializationUtils.toJsonString(result));
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_doPricing));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "updatestandcost": 
            case "updateeffdate": {
                if (!PriceHelper.checkOperation((BeforeDoOperationEventArgs)e, (IFormView)this.getView(), (String)"cad_outsourceprice", (String)this.getPageCache().get("CostType"), (String)operateKey)) break;
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("updatestandcost".equals(operateKey) ? "cad_updatestandcost" : "cad_seteffectdate");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("costtype", this.getPageCache().get("CostType"));
                map.put("entityNum", "cad_outsourceprice");
                map.put("ids", PriceHelper.getSelectIds((BeforeDoOperationEventArgs)e));
                parameter.setCustomParams(map);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "updatestandcost".equals(operateKey) ? "updateStandCostBack" : "updateEffDateBack"));
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "updateStandCostBack": 
            case "updateEffDateBack": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "closeBack_doPricing": {
                this.getView().hideLoading();
                BillList billList = (BillList)this.getControl("billlistap");
                String responseInfo = this.getPageCache().get("responseInfo");
                logger.info("\u53d6\u4ef7\uff0c\u53d6\u4ef7\u7ed3\u679c\u4fe1\u606f\uff1a{}", (Object)responseInfo);
                if (CadEmptyUtils.isEmpty((String)responseInfo)) {
                    return;
                }
                Map resultMap = (Map)SerializationUtils.fromJsonString((String)responseInfo, Map.class);
                boolean status = (Boolean)resultMap.get("status");
                boolean existFailedCalcRule = (Boolean)resultMap.get("existFailedCalcRule");
                if (!status) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u53d6\u4ef7\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\uff1a%s\u3002", (String)"OutSourcePriceListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]), resultMap.get("errMsg")));
                } else {
                    int count;
                    int n = count = resultMap.get("count") == null ? 0 : (Integer)resultMap.get("count");
                    if (count == 0) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"OutSourcePriceListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    } else {
                        String tips = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5f15\u5165%1$s\u6761\u6570\u636e\u3002", (String)"OutSourcePriceListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]), count);
                        this.getView().showSuccessNotification(tips);
                    }
                    if (existFailedCalcRule) {
                        this.getView().showErrorNotification(resultMap.get("failedCalcRuleTips").toString());
                    }
                }
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void showQuickUpdateApply() {
        String costtypeId = this.getPageCache().get("CostType");
        DynamicObject costType = CostTypeHelper.getCostType((Long)Long.parseLong(costtypeId), (String)"type");
        if ("0".equals(costType.getString("type"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u7c7b\u578b\u4e3a\u6838\u7b97\u6210\u672c\uff0c\u4e0d\u80fd\u8fdb\u884c\u5feb\u901f\u66f4\u65b0\u3002", (String)"OutSourcePriceListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.isEmpty()) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (ListSelectedRow row : rows) {
            ids.add((Long)row.getPrimaryKeyValue());
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("billstatus", "=", (Object)"C")};
        HashSet newIds = new HashSet(ids);
        DynamicObjectCollection purPrices = QueryServiceHelper.query((String)"cad_outsourceprice", (String)"costtype,material,tracknumber", (QFilter[])filters);
        if (purPrices.size() != newIds.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5feb\u901f\u66f4\u65b0\u5931\u8d25\uff0c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u4ea7\u54c1\u59d4\u5916\u6807\u51c6\u4ef7\u76ee\u8868\u3002", (String)"OutSourcePriceListPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        String matInfo = this.getMulPriceRule(ids);
        if (!CadEmptyUtils.isEmpty((String)matInfo)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5feb\u901f\u66f4\u65b0\u5931\u8d25\uff0c\u201c%s\u201d\u6307\u5b9a\u4e86\u591a\u79cd\u53d6\u4ef7\u89c4\u5219\u3002", (String)"OutSourcePriceListPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]), matInfo));
            return;
        }
        String mulMatKcInfo = this.getMulMatKcInfo(ids);
        if (!CadEmptyUtils.isEmpty((String)mulMatKcInfo)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5feb\u901f\u66f4\u65b0\u5931\u8d25\uff0c\u201c%s\u201d\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7ec4\u5408\u201c\u7269\u6599+\u8f85\u52a9\u5c5e\u6027+\u914d\u7f6e\u53f7+\u8ddf\u8e2a\u53f7\u201d\u3002", (String)"OutSourcePriceListPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]), mulMatKcInfo));
            return;
        }
        String isAttTargetCostType = CadBgParamUtils.getCadBgParamForString((String)"isAttTargetCostType", (String)"0");
        if ("1".equals(isAttTargetCostType)) {
            QFilter idFilter = new QFilter("id", "in", ids);
            QFilter trcakFilter = new QFilter("tracknumber", ">", (Object)0L);
            DynamicObjectCollection purPriceObjs = QueryServiceHelper.query((String)"cad_outsourceprice", (String)"id", (QFilter[])new QFilter[]{idFilter, trcakFilter});
            List trackPriceIds = DynamicObjectHelper.getIdList((DynamicObjectCollection)purPriceObjs, (String)"id");
            ids.removeAll(trackPriceIds);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("cad_quickapplyupdate");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("costtype", (Object)((DynamicObject)purPrices.get(0)).getString("costtype"));
            formShowParameter.setCustomParam("sourcePage", (Object)"outSource");
            formShowParameter.setCustomParam("ids", ids);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm(formShowParameter);
            formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("cad_quickapplyupdate");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("costtype", (Object)((DynamicObject)purPrices.get(0)).getString("costtype"));
            formShowParameter.setCustomParam("sourcePage", (Object)"outSource");
            formShowParameter.setCustomParam("ids", (Object)trackPriceIds);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm(formShowParameter);
        } else {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("cad_quickapplyupdate");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("costtype", (Object)((DynamicObject)purPrices.get(0)).getString("costtype"));
            formShowParameter.setCustomParam("sourcePage", (Object)"outSource");
            formShowParameter.setCustomParam("ids", ids);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm(formShowParameter);
        }
    }

    private String getMulPriceRule(List<Long> ids) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObjectCollection outSources = QueryServiceHelper.query((String)"cad_outsourceprice", (String)"keycolid,material.number materialnumber,material.name materialname,pricerule", (QFilter[])filters);
        if (outSources.isEmpty()) {
            return null;
        }
        HashMap<Long, List> groups = new HashMap<Long, List>(outSources.size());
        for (DynamicObject outSource : outSources) {
            groups.computeIfAbsent(outSource.getLong("keycolid"), p -> new ArrayList()).add(outSource);
        }
        for (Map.Entry group : groups.entrySet()) {
            if (CadEmptyUtils.isEmpty((List)((List)group.getValue())) || ((List)group.getValue()).size() < 2) continue;
            HashSet<Long> ruleIds = new HashSet<Long>(((List)group.getValue()).size());
            for (DynamicObject value : (List)group.getValue()) {
                ruleIds.add(value.getLong("pricerule"));
                if (ruleIds.size() <= 1) continue;
                return value.getString("materialnumber") + "/" + value.getString("materialname");
            }
        }
        return null;
    }

    private String getMulMatKcInfo(List<Long> ids) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObjectCollection purPrices = QueryServiceHelper.query((String)"cad_outsourceprice", (String)"keycol,material.number materialnumber,material.name materialname,pricerule", (QFilter[])filters);
        if (purPrices.isEmpty()) {
            return null;
        }
        HashSet<String> existKeycols = new HashSet<String>(10);
        String msg = "";
        for (DynamicObject purPrice : purPrices) {
            String keycol = purPrice.getString("keycol");
            if (existKeycols.add(keycol) || msg.contains(purPrice.getString("materialnumber"))) continue;
            if (CadEmptyUtils.isEmpty((String)msg)) {
                msg = purPrice.getString("materialnumber") + "/" + purPrice.getString("materialname");
                continue;
            }
            msg = msg + "\u3001" + purPrice.getString("materialnumber") + "/" + purPrice.getString("materialname");
        }
        return msg;
    }
}

