/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.price;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.constants.CommonConstant;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.PermissionHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PriceCommon {
    public static DynamicObjectCollection getCostTypes(String appNum) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        qfilters.add(CostTypeHelper.getScaCostType());
        qfilters.add(new QFilter("enable", "=", (Object)true));
        qfilters.add(new QFilter("status", "=", (Object)"C"));
        if ("aca".equals(appNum)) {
            qfilters.add(new QFilter("type", "=", (Object)"1"));
        } else {
            qfilters.add(new QFilter("type", "in", (Object)new String[]{"0", "1"}));
        }
        QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
        if (baseDataFilter != null) {
            qfilters.add(baseDataFilter);
        }
        return QueryServiceHelper.query((String)"cad_costtype", (String)"number,name,id,type", (QFilter[])qfilters.toArray(new QFilter[0]), (String)"type desc");
    }

    public static List<ComboItem> getCostTypeComboItemList(String appNum) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        DynamicObjectCollection costTypes = PriceCommon.getCostTypes(appNum);
        if (costTypes != null && costTypes.size() > 0) {
            CostTypeHelper.sortByType((List)costTypes);
            for (DynamicObject costType : costTypes) {
                if ("sca".equals(appNum) && CommonConstant.ACA_COST_TYPE_ID.equals(costType.getLong("id"))) continue;
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(costType.getString("name")));
                item.setValue(costType.getString("id"));
                if (items.contains(item)) continue;
                items.add(item);
            }
        }
        return items;
    }

    public static void checkType(IFormView view, BeforeItemClickEvent evt, String costTypeId) {
        QFilter qfId = new QFilter("id", "=", (Object)Long.valueOf(costTypeId));
        DynamicObject costType = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"type", (QFilter[])new QFilter[]{qfId});
        if (costType != null && CostTypePtyEnum.CALCULATING.getValue().equals(costType.getString("type"))) {
            evt.setCancel(true);
            view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6210\u672c\u7c7b\u578b\u5c5e\u6027\u4e3a\u6a21\u62df\u6210\u672c\uff0c\u624d\u5141\u8bb8\u624b\u5de5\u65b0\u589e\u3002", (String)"PriceCommon_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }

    public static void checkType(IFormView view, BeforeItemClickEvent evt, String costTypeId, String tip) {
        if (CadEmptyUtils.isEmpty((String)costTypeId)) {
            evt.setCancel(true);
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u53ef\u4f7f\u7528\u7684\u6210\u672c\u7c7b\u578b\u3002", (String)"PriceCommon_4", (String)"macc-cad-formplugin", (Object[])new Object[0]), tip));
            return;
        }
        QFilter qfId = new QFilter("id", "=", (Object)Long.valueOf(costTypeId));
        DynamicObject costType = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"type", (QFilter[])new QFilter[]{qfId});
        if (costType != null && CostTypePtyEnum.CALCULATING.getValue().equals(costType.getString("type"))) {
            evt.setCancel(true);
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u5c5e\u6027\u7684\u6210\u672c\u7c7b\u578b\u4e0d\u652f\u6301\u624b\u5de5\u7f16\u8f91\u3002\u8bf7\u901a\u8fc7\u6210\u672c\u66f4\u65b0\u64cd\u4f5c\u66f4\u65b0%s\u3002", (String)"PriceCommon_3", (String)"macc-cad-formplugin", (Object[])new Object[0]), tip));
            return;
        }
        if ("copy".equals(evt.getOperationKey())) {
            BillList billList = (BillList)view.getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            Object[] primaryKeyValues = rows.getPrimaryKeyValues();
            qfId = new QFilter("id", "in", (Object)primaryKeyValues);
            String entity = ((IListView)view).getListModel().getDataEntityType().getName();
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entity, (String)"pricerule", (QFilter[])new QFilter[]{qfId});
            if (dynamicObject == null) {
                return;
            }
            PriceCommon.copyCheck(view, evt, dynamicObject.getLong("pricerule"));
        }
    }

    public static void copyCheck(IFormView view, BeforeItemClickEvent evt, Long priceRule) {
        if (!(PriceRuleConstants.PUR_MANUALLY_ID.equals(priceRule) || PriceRuleConstants.SELFRES_MANUALLY_ID.equals(priceRule) || PriceRuleConstants.OUTRES_MANUALLY_ID.equals(priceRule) || PriceRuleConstants.OUTPRI_MANUALLY_ID.equals(priceRule))) {
            evt.setCancel(true);
            view.showTipNotification(ResManager.loadKDString((String)"\u53d6\u4ef7\u89c4\u5219\u4e3a\u975e\u624b\u5de5\u6307\u5b9a\u7684\u4ef7\u76ee\u8868\uff0c\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"PriceCommon_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }

    public static boolean isSimulatedCostType(String costTypeId) {
        QFilter qfId = new QFilter("id", "=", (Object)Long.parseLong(costTypeId));
        QFilter qfType = new QFilter("type", "=", (Object)CostTypePtyEnum.SIMULATED.getValue());
        return QueryServiceHelper.exists((String)"cad_costtype", (QFilter[])new QFilter[]{qfId, qfType});
    }

    public static boolean isCalcCostType(String costTypeId) {
        QFilter qfId = new QFilter("id", "=", (Object)Long.parseLong(costTypeId));
        QFilter qfType = new QFilter("type", "=", (Object)CostTypePtyEnum.CALCULATING.getValue());
        return QueryServiceHelper.exists((String)"cad_costtype", (QFilter[])new QFilter[]{qfId, qfType});
    }

    public static void isSynCostPermission(IFormView view, BeforeItemClickEvent evt, Long userId, Long orgId, String entityName) {
        List orgPermission = PermissionHelper.getUserPermOrgs((Long)userId, (String)entityName, (String)"4730fc9f000031ae");
        if (orgPermission == null) {
            return;
        }
        if (orgPermission.size() == 0) {
            evt.setCancel(true);
            view.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u540c\u6b65\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PriceCommon_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }

    public static boolean isPermItemPermission(Long userId, String entityName, String permItem) {
        List orgPermission = PermissionHelper.getUserPermOrgs((Long)userId, (String)entityName, (String)permItem);
        if (orgPermission == null) {
            return true;
        }
        return orgPermission.size() != 0;
    }

    public static String getCostTypeId(String entityName, Object pkId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", pkId)};
        DynamicObject dy = QueryServiceHelper.queryOne((String)entityName, (String)"costtype.id id", (QFilter[])filters);
        return dy != null ? dy.getString("id") : null;
    }
}

